/*
 * Decompiled with CFR 0.152.
 */
package versys;

import org.eclipse.swt.widgets.Canvas;
import versys.RunLog;
import versys.Versys;
import versys.dialogs.ErrorDialog;
import versys.petrinet.PNState;
import versys.petrinet.PetriNet;

public class AutoSimulation
implements Runnable {
    private Canvas m_canvas;
    private RunLog m_runLog;
    private String m_tID;
    private PetriNet m_petriNet;
    private int m_n;
    private int m_num;
    private int m_delay;
    private Versys m_versys;
    private int m_id;

    public AutoSimulation(Canvas canvas, RunLog runLog, PetriNet pn, int num, int delay, Versys versys, int id) {
        this.m_canvas = canvas;
        this.m_runLog = runLog;
        this.m_petriNet = pn;
        this.m_num = num;
        this.m_delay = delay;
        this.m_versys = versys;
        this.m_id = id;
        this.m_n = 0;
    }

    @Override
    public void run() {
        while (this.m_petriNet.getState() == PNState.PN_STATE_AUTO_SIM) {
            this.m_tID = null;
            try {
                if (this.m_n < this.m_num) {
                    this.m_tID = this.m_petriNet.fireRandomTransition();
                    if (this.m_tID != null) {
                        ++this.m_n;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                new ErrorDialog(this.m_canvas.getShell(), e.getMessage(), e);
            }
            this.m_canvas.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AutoSimulation.this.m_versys.updateProgressBar(AutoSimulation.this.m_id, AutoSimulation.this.m_n, AutoSimulation.this.m_num);
                    if (AutoSimulation.this.m_tID != null && AutoSimulation.this.m_runLog != null) {
                        AutoSimulation.this.m_runLog.log(AutoSimulation.this.m_tID);
                    }
                    AutoSimulation.this.m_canvas.redraw();
                }
            });
            try {
                Thread.sleep(this.m_delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

