/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.swt.widgets.baseline;

import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.widgets.baseline.CarbonBaseline;
import org.eclipse.wb.swt.widgets.baseline.CocoaBaseline;
import org.eclipse.wb.swt.widgets.baseline.DefaultBaseline;
import org.eclipse.wb.swt.widgets.baseline.GtkBaseline;
import org.eclipse.wb.swt.widgets.baseline.WindowsBaseline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Baseline {
    protected static Class<?> spinnerClass = null;
    protected static Class<?> datetimeClass = null;
    public static final int NO_BASELINE = -1;
    public static final int BRB_NONE = 0;
    public static final int BRB_CONSTANT_ASCENT = 1;
    public static final int BRB_CONSTANT_DESCENT = 2;
    public static final int BRB_CENTER_OFFSET = 3;
    public static final int BRB_OTHER = 4;
    private static Baseline m_instance;

    static {
        try {
            spinnerClass = Class.forName("org.eclipse.swt.widgets.Spinner");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            datetimeClass = Class.forName("org.eclipse.swt.widgets.DateTime");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected Baseline() {
    }

    protected boolean topAlignedText(Class<?> clazz, int style) {
        return false;
    }

    protected boolean centerAlignedText(Class<?> clazz, int style) {
        return true;
    }

    protected int adjustBaseline(Control control, int baseline) {
        return baseline;
    }

    private static Baseline getInstance() {
        if (m_instance == null) {
            String platform = SWT.getPlatform();
            m_instance = "win32".equalsIgnoreCase(platform) ? new WindowsBaseline() : ("gtk".equalsIgnoreCase(platform) ? new GtkBaseline() : ("carbon".equalsIgnoreCase(platform) ? new CarbonBaseline() : ("cocoa".equalsIgnoreCase(platform) ? new CocoaBaseline() : new DefaultBaseline())));
        }
        return m_instance;
    }

    public static int getBaseline(Control control) {
        if (control == null || control.isDisposed()) {
            return -1;
        }
        Rectangle controlBounds = control.getBounds();
        return Baseline.getBaseline(control, controlBounds.width, controlBounds.height);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getBaseline(Control control, int width, int height) {
        if (control == null || control.isDisposed()) {
            return -1;
        }
        try {
            int baseline;
            Method baselineMethod = control.getClass().getMethod("getBaseline", new Class[0]);
            if (baselineMethod == null || (baseline = ((Integer)baselineMethod.invoke((Object)control, new Object[0])).intValue()) == -1) return Baseline.getInstance().fetchBaseline(control, width, height);
            return baseline;
        }
        catch (Throwable baselineMethod) {
            try {
                return Baseline.getInstance().fetchBaseline(control, width, height);
            }
            catch (Throwable e) {
                return -1;
            }
        }
    }

    int fetchBaseline(Control control, int width, int height) {
        int baseline = -1;
        GC gc = new GC((Drawable)control);
        Font font = control.getFont();
        gc.setFont(font);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int fontAscent = fontMetrics.getAscent() + fontMetrics.getLeading();
        int fontHeight = fontMetrics.getHeight();
        if (this.topAlignedText(control.getClass(), control.getStyle())) {
            baseline = fontAscent;
        }
        if (this.centerAlignedText(control.getClass(), control.getStyle())) {
            baseline = height / 2 - fontHeight / 2 + fontAscent;
        }
        baseline = this.adjustBaseline(control, baseline);
        return baseline;
    }

    public static int getBaselineResizeBehavior(Control control) {
        if (control instanceof Text && (control.getStyle() & 0x200) != 0) {
            return 1;
        }
        return 4;
    }

    public static int[] getInsets(Control control) {
        int[] is = new int[4];
        if (control instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)control;
            Rectangle bounds = scrollable.getBounds();
            Rectangle clientArea = scrollable.getClientArea();
            Point clientAreaInDisplay = scrollable.toDisplay(new Point(clientArea.x, clientArea.y));
            Composite parent = scrollable.getParent();
            Point boundsInDisplay = parent == null ? new Point(bounds.x, bounds.y) : parent.toDisplay(new Point(bounds.x, bounds.y));
            clientArea.x = clientAreaInDisplay.x;
            clientArea.y = clientAreaInDisplay.y;
            is[0] = clientArea.x - boundsInDisplay.x;
            is[1] = clientArea.y - boundsInDisplay.y;
            is[2] = boundsInDisplay.x + bounds.width - clientArea.x - clientArea.width;
            is[3] = boundsInDisplay.y + bounds.height - clientArea.y - clientArea.height;
        }
        return is;
    }
}

