//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2003, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------

/**
 * @file Poisson.h
 * @date Feb 22, 2009
 * @author Ronald Kluth
 * @brief Declaration of odemx::random::Poisson
 */

#ifndef ODEMX_RANDOM_POISSON_INCLUDED
#define ODEMX_RANDOM_POISSON_INCLUDED

#include <odemx/random/DiscreteDist.h>

namespace odemx {
namespace random {

/** \class Poisson

	\ingroup idist

	\author Ralf Gerstenberger

	\brief %Poisson distributed discrete random numbers

	\note Poisson from ODEM

	\note supports Report

	Poisson provides a series of Poisson-distributed
	discrete random numbers. The parameter \c pa
	divergence is set in the constructor.

	\since 1.0
*/
class Poisson
:	public DiscreteDist
{
public:

	/**
		\brief Construction for user-defined DistContext (i.e. Simulation)
		\param title
			Label of the generator
		\param c
			pointer to DistContext object
		\param pa
			mean value

		The parameter pa defines the mean value
		of the Poisson-distribution generated by
		this random number generator.
	*/
	Poisson(  base::Simulation& sim, const data::Label& label, double mean );

	/// Destruction
	virtual ~Poisson();

	/// Get next random number
	virtual int sample();

	/// Get parameter pa
	double getMean();

protected:
	double mean_;
};

} } // namespace odemx::random


#endif /* ODEMX_RANDOM_POISSON_INCLUDED */
