//------------------------------------------------------------------------------
//	Copyright (C) 2009, 2010 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/**
 * @file XmlReport.h
 * @author Ronald Kluth
 * @date created at 2009/04/05
 * @brief Declaration of class odemx::data::output::XmlReport
 * @sa XmlReport.cpp
 * @since 3.0
 */

#ifndef ODEMX_DATA_OUTPUT_XMLREPORT_INCLUDED
#define ODEMX_DATA_OUTPUT_XMLREPORT_INCLUDED

#include <odemx/data/Report.h>
#include <fstream>
#include <string>
#include <memory>

//----------------------------------------------------------forward declarations

namespace Poco { namespace XML { class XMLWriter; } }

namespace odemx {
namespace data {
namespace output {

//-----------------------------------------------------------header declarations

/**
 * @brief Report implementation for printing statistics tables to an XML file
 * @ingroup data
 * @author Ronald Kluth
 * @since 3.0
 * @see odemx::data::Report odemx::data::ReportProducer odemx::data::output::OStreamReport
 *
 * ODEMx can collect statistical data in accumulated form. This is either
 * done by statistics computing components provided by module statistics,
 * or with the help of the log consumer odemx::data::buffer::StatisticsBuffer
 * that collects data from channel statistics. The class XmlReport can be
 * used to write such accumulated statistical to XML files.
 *
 * @note The schema for the XML output can be found in the file XmlReport.xsd.
 */
class XmlReport
:	public Report
{
public:
	/// Construction with file name
	XmlReport( const std::string& fileName );
	/// Destruction
	virtual ~XmlReport();

protected:
	/// Initializes a Poco::XML::XMLWriter and starts the XML document
	virtual void startProcessing();
	/// Prints formatted tables from ReportProducers to the XML file
	virtual void processTables();
	/// Finishes the document and closes the file properly
	virtual void endProcessing();

private:
	/// File output stream to receive XML data
	std::ofstream fileStream_;
	/// Managed XMLWriter
	std::auto_ptr< Poco::XML::XMLWriter > xmlWriter_;
};

} } } // namespace odemx::data::output

#endif /* ODEMX_DATA_OUTPUT_XMLREPORT_INCLUDED */
