//
// HTTPSessionInstantiator.h
//
// $Id: //poco/svn/Net/include/Poco/Net/HTTPSessionInstantiator.h#2 $
//
// Library: Net
// Package: HTTPClient
// Module:  HTTPSessionInstantiator
//
// Definition of the HTTPSessionInstantiator class.
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Net_HTTPSessionInstantiator_INCLUDED
#define Net_HTTPSessionInstantiator_INCLUDED


#include "Poco/Net/Net.h"
#include "Poco/Net/HTTPSession.h"
#include "Poco/URI.h"


namespace Poco {
namespace Net {


class HTTPClientSession;


class Net_API HTTPSessionInstantiator
	/// A factory for HTTPClientSession objects.
	///
	/// Creates a HTTP session for a given URI.
	/// A HTTPSessionInstantiator is not used directly.
	/// Instances are registered with a HTTPSessionFactory,
	/// and used through it.
{
public:
	HTTPSessionInstantiator();
		/// Creates the HTTPSessionInstantiator.

	virtual ~HTTPSessionInstantiator();
		/// Destroys the HTTPSessionInstantiator.

	virtual HTTPClientSession* createClientSession(const Poco::URI& uri);
		/// Creates a HTTPClientSession for the given URI.

	static void registerInstantiator();
		/// Registers the instantiator with the global HTTPSessionFactory.

	static void unregisterInstantiator();
		/// Unregisters the factory with the global HTTPSessionFactory.

protected:
	void setProxy(const std::string& host, Poco::UInt16 port);
		/// Sets the proxy host and port.
		/// Called by HTTPSessionFactory.
			
	const std::string& proxyHost() const;
		/// Returns the proxy post.

	Poco::UInt16 proxyPort() const;
		/// Returns the proxy port.

private:
	std::string  _proxyHost;
	Poco::UInt16 _proxyPort;
	
	friend class HTTPSessionFactory;
};


//
// inlines
//
inline const std::string& HTTPSessionInstantiator::proxyHost() const
{
	return _proxyHost;
}


inline Poco::UInt16 HTTPSessionInstantiator::proxyPort() const
{
	return _proxyPort;
}


} } // namespace Poco::Net


#endif // Net_HTTPSessionInstantiator_INCLUDED
