<?xml version="1.0" encoding="utf-8"?>

<!--

Copyright (C) 2009 Humboldt-Universitaet zu Berlin

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * @file XmlReport.xsl
 * @author Ronald Kluth
 * @date created at 2009/04/05
 * @brief XSL stylesheet for direct viewing of XmlReport files in browsers
 *
 * This stylesheet is used by modern browsers to transform XML files created
 * by odemx::data::output::XmlReport into HTML pages displaying the generated
 * ODEMx statistics tables.
 *
 * @sa XmlReport.h, XmlReport.cpp
 * @since 3.0
 */
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html"
encoding="utf-8"
doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

<!--
This is the main template for the XML document. It creates the page with header
info, CSS style, and some odemx simulation details. After that, the rest of the
page will be filled by the objectstats template.
-->

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
<style>

body {
	background-color: firebrick;
	}

#caption {
	color: white;
	margin-bottom: 1em;
	text-align:center;
	}

.reporttable {
	background-color: khaki;
	border: 1px solid khaki;
	color: black;
	margin-bottom: 1em;
	width: 100%;
	}

caption {
	background-color: khaki;
	font-size: 110%;
	font-weight: bold;
	margin: 0;
	padding: 0.2em;
	}

.reporttable th {
	background-color: white;
	border: 1px solid khaki;
	font-style: italic;
	padding: 0.5em;
	}

.reporttable td {
	border: 1px solid khaki;
	padding: 0.2em 1em 0.2em 1em;
	}

.bar {
	background-color: firebrick;
	height: 1em;
	}

.right-aligned {
	text-align: right;
	}

.left-aligned {
	text-align: left;
	}

.odd {
	background-color: #FFFFC0;
	}

.even {
	background-color: #FFFF90;
	}

#pagecaption {
	color: white;
	margin-bottom: 1em;
	text-align:center;
	}

.tablecaption {
	background-color: khaki;
	font-size: 110%;
	font-weight: bold;
	margin: 0;
	padding: 0.2em;
	}

.pcwraptable {
	width: 100%;
	}

.pcwraptable td {
	vertical-align: top;
	}

.pcwraptable caption {
	background-color: #FFFF90;
	font-size: 110%;
	font-weight: bold;
	margin: 0;
	padding: 0.2em;
	}

.pcwrapspacer {
	width: 1px;
}

.pcupdatespacer {
	height: 1px;
	width: 100%;
}

.statstable {
	background-color: khaki;
	color: black;
	width:100%;
	}

.statstable caption {
	background-color: #FFFF90;
	border: 1px solid khaki;
	font-size: 110%;
	font-weight: bold;
	margin: 0;
	padding: 0.2em;
	}

.statstable th {
	background-color: white;
	border: 1px solid khaki;
	font-style: italic;
	padding: 0.2em;
	}

.statstable td {
	background-color: #FFFFC0;
	border: 1px solid khaki;
	padding: 0.2em 1em 0.2em 1em;
	text-align: right;
	vertical-align: center;
	}

.objectstatsbox {
	background-color: firebrick;
	border: 2px solid khaki;
	margin-bottom: 1em;
	}

.objectdescriptionbox {
	background-color: khaki;
	padding: 0.1em;
	text-align: center;
	}

.senderlabel {
	color: black;
	font-size: 120%;
	font-weight: bold;
	}

.senderscope {
	font-style: italic;
	}

.tablebox {
	color: white;
	}

</style>
</head>

<body>

<div id='pagecaption'>
	<h2>ODEMx XML Report</h2>
<!--	<div>
		<xsl:value-of select="@simulation" />
	</div>
	<div>
		ODEMx Version: <xsl:value-of select="@odemxversion" />
	</div> -->
</div>

<div>
	<xsl:apply-templates select="odemxreport/table" />
</div>

</body>
</html>
</xsl:template> <!-- match root -->

<!--
The following template transforms all kinds of odemx-generated tables into HTML.
-->
<xsl:template match="odemxreport/table">

<!--
variables to remember all columns which represent certain data types
-->
<xsl:variable name="bar" select="column[@type='BAR']" />
<xsl:variable name="string" select="column[@type='STRING']" />

<!--
start a new HTML table to display the data
-->
	<table class="reporttable" border="0" cellpadding="0" cellspacing="0">

<!--
	table caption is set to the table label given in odemx
-->
	<caption>
		<xsl:value-of select="@label" />
	</caption>

<!--
    write column heads as specified by odemx ReportProducers
-->
    <tr>
    <xsl:for-each select="column">
    	<th><xsl:value-of select="@label" /></th>
	</xsl:for-each>
	</tr>

<!--
	iterate over all <line> tags in the table
-->
	<xsl:for-each select="line">
		<tr>

<!--
		iterate over all <cell> tags per line
-->
		<xsl:for-each select="cell">

<!--
		variable to remember the current column number
-->
		<xsl:variable name="currentCol" select="@col" />
		<xsl:variable name="currentValue" select="text()" />

<!--
			start HTML table data cell
-->
			<td>
			<xsl:choose>
				<xsl:when test="$currentCol mod 2 > 0">
					<xsl:attribute name="class">
						odd
					</xsl:attribute>
				</xsl:when>

				<xsl:otherwise>
					<xsl:attribute name="class">
						even
					</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>

<!--
			compare current column index with those of type BAR
			which are displayed differently than STRING, INTEGER,
			and REAL columns generated by odemx
-->
			<xsl:choose>
				<xsl:when test="$bar[@number = $currentCol]">
					<xsl:attribute name="width">
  						500
					</xsl:attribute>
					<div class="bar" style="width:{$currentValue}%	;"> </div>
				</xsl:when>

				<xsl:otherwise>
					<xsl:attribute name="style">
  						text-align: center;
					</xsl:attribute>
					<xsl:value-of select="text()"/>
				</xsl:otherwise>
			</xsl:choose>

			</td>
		</xsl:for-each> <!-- cell -->

		</tr>
	</xsl:for-each> <!-- line -->

	</table>
</xsl:template> <!-- tables -->

</xsl:stylesheet>
