//------------------------------------------------------------------------------
//	Copyright (C) 2009 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/**
 * @file LibraryPath.h
 * @author Ronald Kluth
 * @date created at 2009/03/29
 * @brief Declaration and implementation of odemx::getLibraryPath()
 * @since 3.0
 */

#ifndef ODEMX_UTIL_LIBRARYPATH_INCLUDED
#define ODEMX_UTIL_LIBRARYPATH_INCLUDED

#if defined(__GNUC__) /* GNU Compiler */

	// we assume make generated ODEMxPath.h
	#include <odemx/util/ODEMxPath.h>

#endif

#include <string>

namespace odemx {

inline std::string getLibraryPath()
{
#if defined(_MSC_VER)

	// not using 'make' means we have to get the library location
	// using other means...

	// get full path of this file, includes the location of util dir
	std::string fullPath( __FILE__ );
	// cut off the substring containing this file's name
	int end = fullPath.find( "util\\librarypath.h" );
	std::string odemxPath = fullPath.substr( 0, end );

	return odemxPath;

#elif defined(__MINGW32__)

	std::string msysPath = getOdemxPath();
	char driveLetter = msysPath[1];
	msysPath[0] = driveLetter;
	msysPath[1] = ':';
	return msysPath;

#else

	return getOdemxPath();

#endif
}

} // namespace odemx

#endif /* ODEMX_UTIL_LIBRARYPATH_INCLUDED */
