package betriebpraktikanten;
/**
 * Reprsentiert einen Ausdruck. Dies kann z.B. die Definition einer Variablen inklusive Domain sein.
 * 
 * @author lars
 *
 */
public class Ausdruck {
	private String expression;

	/**
	 * Erstellt einen Ausdruck. ARCSIN, ARCCOS, ARCTAN, SIN, COS, TAN, ABS, SQRT, POW, EXP und PI
	 * werden durch ihr Pendant in java.lang.Math.* ersetzt. 
	 * @param line Original Ausdruck
	 */
	public Ausdruck (String line) {
		this.expression = Constraint.replaceMathExp(line);
	}

	/**
	 * Liefert den bearbeiteten Ausdruck zurck
	 * @return Der bearbeiteten Ausdruck
	 */
	public String getExpression() {
		return expression;
	}
	
	public String toString() {
		return getExpression();
	}
}
