#include "constraint.h"
#include "csp.h"
#include "constants.h"

#include <cmath>
#include <iostream>
using namespace std;

Constraint::Constraint(double d,double xPos, double yPos, CSP* csp) {
	this->d = d;
	this->xPos = xPos;
	this->yPos = yPos;
	this->csp = csp;
}

Constraint::Constraint() {}
Constraint::~Constraint() {}

// Intervallschachtelung durch Anwendung eines Constraints
void Constraint::Propagate() {
	double xp;	
	double yp;
	double* x;
	double* y;

	/* Wir suchen in den aktuellen Intervallen jene Werte fr xp und yp,
	   die so nah wie mglich an xPos bzw. yPos des betrachteten Objektes
	   liegen. */
	if((csp->X[MIN] <= xPos) && (csp->X[MAX] >= xPos)) {
		xp = xPos;
	} else {
		double xl = abs(xPos - csp->X[MIN]);
		double xr = abs(xPos - csp->X[MAX]);
		xp = (xl < xr ? csp->X[MIN] : csp->X[MAX]); 
	}

	if((csp->Y[MIN] <= yPos) && (csp->Y[MAX] >= yPos)) {
		yp = yPos;
	} else {
		double yl = abs(yPos - csp->Y[MIN]);
		double yr = abs(yPos - csp->Y[MAX]);
		yp = (yl < yr ? csp->Y[MIN] : csp->Y[MAX]); 
	}
	
	/* Die Constraintgleichung liefert mit den Werten yp bzw. xp die maximal konsistente
	   Lsung im Rahmen der aktuellen Parameter */
	x = CirlceCoordinateX(yp);
	y = CirlceCoordinateY(xp);
	
	csp->XDif[MIN] = csp->XDif[MAX] = csp->YDif[MIN] = csp->YDif[MAX] = 0;
	x[MIN] = floor(x[MIN]);
	y[MIN] = floor(y[MIN]);
	x[MAX] = ceil(x[MAX]);
	y[MAX] = ceil(y[MAX]);
	
	// Intervalle aktualisieren
	if(x[MIN] > csp->X[MIN] && x[MIN] <= csp->X[MAX]) {
		csp->XDif[MIN] = abs(csp->X[MIN] - x[MIN]);
		csp->X[MIN] = x[MIN];
	}
	if(x[MAX] < csp->X[MAX] && x[MAX] >= csp->X[MIN]) {
		csp->XDif[MAX] = abs(csp->X[MAX] - x[MAX]);
		csp->X[MAX] = x[MAX];
	}
	if(y[MIN] > csp->Y[MIN] && y[MIN] <= csp->Y[MAX]) {
		csp->YDif[MIN] = abs(csp->Y[MIN] - y[MIN]);
		csp->Y[MIN] = y[MIN];
	}
	if(y[MAX] < csp->Y[MAX] && y[MAX] >= csp->Y[MIN]) {
		csp->YDif[MAX] = abs(csp->Y[MAX] - y[MAX]);
		csp->Y[MAX] = y[MAX];
	}
	
}

// Berechnet die Lsungen fr x der Gleichung (x - xPos) + (y - yPos) = d
double* Constraint::CirlceCoordinateX(double y) {
	double* x = new double[2];
	double r = -(y * y) + (2 * y * yPos) - (yPos * yPos) + (d * d);
	x[MIN] = xPos - sqrt(r);
	x[MAX] = xPos + sqrt(r);
	return x;
	
}

// Berechnet die Lsungen fr y der Gleichung (x - xPos) + (y - yPos) = d
double* Constraint::CirlceCoordinateY(double x) {
	double* y = new double[2];
	double r = -(x * x) + (2 * x * xPos) - (xPos * xPos) + (d * d);
	y[MIN] = yPos - sqrt(r);
	y[MAX] = yPos + sqrt(r);
	return y;
}

