using System;
using System.Collections.Generic;
using System.Text;

namespace ConstrainPropagierung
{
    class DefRange
    {
        /*
         * DefRange stellt als Klasse eine einzelne Variable da deren
         * Definitionsbereich mit LeftEnd bis RightEnd gekennzeichnet ist.
         * Left-----------viele Werte---------Right
         * bei einem Bereich von -100 bis 200 wre also
         * left = -100 und right 200.
         * 
         * Wichtig: LeftEnd < RightEnd
         */

        public String Name = "";
        public Double LeftEnd;
        public Double RightEnd;

        public DefRange(String AName, Double ALeftEnd, Double ARightEnd)
        {
            Name     = AName;
            LeftEnd  = ALeftEnd;
            RightEnd = ARightEnd;
        }

        public Boolean valide()
        {
            return (LeftEnd < RightEnd);
        }

        public new String ToString()
        {
            return String.Format("[{0} bis {1}]", LeftEnd, RightEnd);
        }
    }
}
