#ifndef GEOMET_H
#define GEOMET_H

#include <list>

/* geometrische basis klassen fr das roboterproblem */
#define X_MIN -3000
#define X_MAX 3000
#define Y_MIN -2000
#define Y_MAX 2000

/****************************************************************************/
/* Point klasse stellt einen einfachen punkt mit X und Y koordinate dar */
class Point
{
public:
	/* params */
	int X;
	int Y;
	
	/* methods */
	Point() {X=0; Y=0;};
	Point(int x, int y);
	double DistTo(Point &p);
};

/****************************************************************************/
/* DoubleCircle stellt ein Doppelkreis constraint dar, ein punkt muss ausserhalb des inneren
	kreises und innerhalb des aeusseren kreises sein um das constraint zu erfuellen
*/
class DoubleCircle
{
	public:
	/* params */
	Point Center;
	int InnerR;
	int OuterR;
	
	/* methods */
	DoubleCircle() {InnerR=0; OuterR=0;};
	DoubleCircle(Point &c, int inr, int outr);
	bool IsInside(Point &p);
};

/***************************************************************************/
/* other functions */
int FindCommonPoints(std::list<DoubleCircle> &clist, std::list<Point> &plist, Point &averageP);
int AddPointsToList(std::list<DoubleCircle> &clist, std::list<Point> &plist, Point &p_begin, Point &p_end,
	 int &sumx, int &sumy, DoubleCircle &smallestC);

#endif /* GEOMET_H */
