#include <math.h>
#include "geomet.h"

/**********************************************************************/
/* class Point */
/* ctor */
Point::Point(int x, int y) : X(x),Y(y)
{
}

/* DistTo berechnet den abstand des object punktes zum gegebenen punkt p mittels pythagoras */
double Point::DistTo(Point &p)
{
	return( sqrt( (double) ((X-p.X)*(X-p.X) + (Y-p.Y)*(Y-p.Y) )) );
}

/**********************************************************************/
/* class Circle */
/* ctor */
DoubleCircle::DoubleCircle(Point &c, int inr, int outr) : Center(c),InnerR(inr),OuterR(outr)
{
}

/* IsInside gibt true zurueck wenn der punkt im aeusseren und nicht im inneren kreis ist, sonst false */
bool DoubleCircle::IsInside(Point &p)
{
	double dist=Center.DistTo(p);
	if( dist>OuterR || dist<InnerR )
	{
		return(false);
	}
	else
	{
		return(true);
	}
}

/* AddPointsToList geht alle punkte des gegebenen rechtecks durch und fuegt sie der punktliste hinzu, wenn
	sie alle constraints erfuellen
	zusaetzlich werden reflektionen der punkte berechnet um das durchlaufen des gesamten kreisbereichs
	zu beschleunigen
	die anzahl der hinzugefuegten punkte wird zurueck gegeben
	ausserdem werden die X und Y werte aller punkte auf sumx, sumy addiert um daraus am ende den mittleren
	punkt zu berechnen
*/
int AddPointsToList(std::list<DoubleCircle> &clist, std::list<Point> &plist, Point &p_begin, Point &p_end,
	 int &sumx, int &sumy, DoubleCircle &smallestC)
{
	/* gib 0 zurueck wenn der bereich leer ist */
	if(p_begin.X>p_end.X || p_begin.Y>p_end.Y) return 0;

	int count=0; /* anzahl hinzugefuegter punkte */
	Point p[4]; /* aktueller punkt und moegliche reflektionen */
	bool inside[4]; /* ist so lange true wie punkt[i] in allen constraints liegt */
	bool identical[4]; /* ist true wenn ein reflektierter punkt[i] identisch mit p[0] ist */
	identical[0]=false;
	int insideCount; /* die anzahl der punkte die noch in frage kommen */
	int i;
	std::list<DoubleCircle>::iterator curr_it, start_it, end_it;
	start_it=clist.begin();
	end_it=clist.end();
	
	/* gehe durch das rechteck aufgespannt durch p_begin (linke untere ecke) und p_end (rechte obere ecke) */
	for(p[0].X=p_begin.X; p[0].X<=p_end.X; p[0].X++)	
		for(p[0].Y=p_begin.Y; p[0].Y<=p_end.Y; p[0].Y++)
		{
			if(smallestC.IsInside(p[0]))
			{
				/* der punkt erfuellt das kleinste constraint, spiegle ihn nun an der vertikalen und horizontalen
					achse durch den mittelpunkt des kleinen constraint kreises und am mittelpunkt selbst 
					und pruefe dann fuer alle 4 punkte die restlichen constraints (die reflekttionen liegen
					auf jeden fall bereits im kleinsten constraint)
				*/
				/* reset inside counter */
				insideCount=4;
				/* reset identical to false */
				for(i=1; i<4; i++)
				{
					identical[i]=false;
				}
				/* p[1] ist die vertikale reflektion  */
				p[1].X=p[0].X + 2*(smallestC.Center.X-p[0].X);
				p[1].Y=p[0].Y;
				if(p[1].X==p[0].X)
				{
					identical[1]=true;
					insideCount--;
				}
				/* p[2] ist die horizontale reflektion */
				p[2].X=p[0].X;
				p[2].Y=p[0].Y - 2*(p[0].Y-smallestC.Center.Y);
				if(p[2].Y==p[0].Y)
				{
					identical[2]=true;
					insideCount--;
				}
				/* p[3] ist die punkt spiegelung */
				if(identical[1] || identical[2])
				{
					identical[3]=true;
					insideCount--;
				}
				else
				{
					p[3].X=p[1].X;
					p[3].Y=p[2].Y;
				}
				/* reset inside, setze inside false fuer identische punkte damit diese nicht doppelt erscheinen */
				for(i=0; i<4; i++)
				{
					inside[i]=!identical[i];
					if(inside[i] && (p[i].X<X_MIN || p[i].X>X_MAX || p[i].Y<Y_MIN || p[i].Y>Y_MAX) )
					{
						/* setze inside false fuer punkte die ausserhalb der spielfelds sind */
						inside[i]=false;
						insideCount--;
					}
				}
				curr_it=start_it;
				/* gehe nun durch alle constraint doppelkreise bis entweder alle punkt ausserhalb einen constraints sind
					oder alle ueberprueft sind */
				while(curr_it!=end_it && insideCount)			
				{
					/* check alle 4 punkte, wenn sie inside sind */
					for(i=0; i<4; i++)
					{
						if(inside[i])
						{
							if(! (*curr_it).IsInside(p[i]) )
							{
								/* der punkt ist ausserhalb dieses constraints -> inside[i] false */
								inside[i]=false;
								insideCount--;
							}
						}
					}
					/* gehe zum naechsten doppelkreis */
					curr_it++;
				}

				/* wenn ein punkt in allen constraints war, fuege ihn zur liste hinzu */
				for(i=0; i<4; i++)
				{
					if(inside[i])
					{
						sumx+=p[i].X;
						sumy+=p[i].Y;
						count++;
						plist.push_back(p[i]);
					}
				}
			}
		}

	/* debug output */
    /*std::list<Point>::iterator it = plist.begin();
	std::cout<<"debug_start"<<std::endl;
	for(;it!=plist.end();it++)
	{
		std::cout<<(*it).X<<", "<<(*it).Y<<std::endl;
	}
	std::cout<<"debug_end"<<std::endl;*/

	return count;
}

/* FindCommonPoints sucht alle punkte die alle constraints erfuellen die durch die liste clist gegeben sind
	die anzahl der gegebenen punkte wird zurueck gegeben und wenn vorhanden wird der mittlere loesungspunkt
	berechnet und in averageP gespeichert
	plist ist die liste aller gefundenen punkte
*/
int FindCommonPoints(std::list<DoubleCircle> &clist, std::list<Point> &plist, Point &averageP)
{
	int sumx=0; /* summe der x werte aller punkte */
	int sumy=0; /* summe der y werte aller punkte */
	int count=0; /* anzahl gefundener punkte */
	
	/* um die suchzeit zu minimieren, suchen wir nur punkte die in einem bereich knapp um den kleinsten doppelkreis
		liegen, der limit bereich
		dieser bereich entsteht durch das kleinste quadrat um den aeusseren kreis und das groesste quadrat innerhalb
		des inneren kreises des kleinsten constraints
		wir pruefen nur punkte die in diesem bereich sind
		dieser bereich wird jetzt berechnet
	*/
	int outerLimit; /* halbe seitenlaenge des aussen quadrats */
	int innerLimit; /* halbe seitenlaenge des inneren quadrats */
	int limitX,limitY; /* mittelpunkt koordinaten des kleinsten constraint doppelkreises */

	/* finde den kleinsten doppelkreis */
	std::list<DoubleCircle>::iterator curr_it = clist.begin();
	std::list<DoubleCircle>::iterator smallest_it = curr_it;
	outerLimit=(*smallest_it).OuterR;
	for(curr_it++; curr_it!=clist.end(); curr_it++)
	{
		if(outerLimit>(*curr_it).OuterR)
		{
			smallest_it=curr_it;
			outerLimit=(*smallest_it).OuterR;
		}
	}
	
	/* nimm den kleinsten kreis aus der liste, er wird speziell behandelt und soll nicht doppelt geprueft werden */
	DoubleCircle smallestC((*smallest_it));
	clist.erase(smallest_it);

	innerLimit=(int) (smallestC.InnerR/sqrt(2.0));
	limitX=smallestC.Center.X;
	limitY=smallestC.Center.Y;

	/* empty point list, just in case ;) */
	plist.clear();

	/* zusaetzlich suchen wir nur im linken oberen Viertel des limit bereiches
		und reflektieren gefundenen punkte einfach in alle 3 anderen viertel
		daher werden jetzt nur die 2 rechtecke berechnet die das obere viertel des
		limit bereichs ausmachen
	*/

	Point p_begin, p_end; /* anfang und endpunkte des suchbereich rechtecks */

	/* oberes rechteck */
	p_begin.X=limitX-outerLimit;
	p_end.X=limitX;
	p_begin.Y=limitY+innerLimit;
	p_end.Y=limitY+outerLimit;
	
	/* finde alle punkte in diesem rechteck und seinen spiegelungen */
	count+=AddPointsToList(clist, plist, p_begin, p_end, sumx, sumy, smallestC);
	
	/* unteres rechteck */
	p_end.X=limitX-innerLimit;
	p_begin.Y=limitY;
	p_end.Y=limitY+innerLimit-1;
	
	/* finde alle punkte in diesem rechteck und seinen spiegelungen */
	count+=AddPointsToList(clist, plist, p_begin, p_end, sumx, sumy, smallestC);
	
	/* berechne den mittleren loesungs punkt */
	if(count>0)
	{
		averageP.X=(int) (sumx/count + 0.5);
		averageP.Y=(int) (sumy/count + 0.5);
	}

	/* fuege den kleinsten doppelcircle wieder in die liste ein... just in case ;) */
	clist.push_back(smallestC);

	return count;
}
