% Position der Fahnen

fahneRB(-1350,1950).
fahneBR(1350,1950).
fahneRG(-1350,-1950).


/* ############### Distanz Flagge Blau Rot

dmin_* und dmax_* sind die berechneten Radien, welche den Raum aufspannen, in denen die lokal konsistenten Lsungen
existieren mit Einberechnung der Fehlerkonstanten durch fehler(F).

Diese Werte sind fr die Berechnung, dass der Aibo genau im Feldmittelpunkt steht bei X=0 und Y=0 mit dem einberechneten Fehler
von 10%.
*/

dmin_BR(2252).
dmax_BR(2490).

%############# Distanz Flagge Rot Blau

dmin_RB(2252).
dmax_RB(2490).

%############# Distanz Flagge Rot Gruen


dmin_RG(2252).
dmax_RG(2490).


/*#################################

Hier wird schon einmal die zulssigen Werte fr X und Y berechnet, die auf konsistenz geprft werden
Diese Werte ergeben sich daraus, dass die drei Bereichskreise, welche durch den Radius einer jeden Flagge
zum Aibo aufgespannt werden, die valide Lsungsmenge beinhalten.
Dadurch wird die zu suchende Menge erheblich eingeschrnkt. Im worst Case kann es natrlich dennoch passieren,
das jede X-Y-Koordinate im Spielfeld durchsucht wird, wenn der Radius von Flagge und Aibo ein Maximum erreicht hat.
Zur berechnung werden die maximalen Radien mit dem Fehler genommen.


*/

minxy(MinX1,MinY1):- 	dmax_RB(R1), dmax_BR(R2), dmax_RG(R3),
		fahneRB(X1,Y1),fahneBR(X2,Y2),fahneRG(X3,Y3),
		( (MinX is X1+R1, MinX =< X2+R2, MinX =< X3+R3) ;
		  (MinX is X2+R2, MinX =< X1+R1, MinX =< X3+R3) ;
		  (MinX is X3+R3, MinX =< X2+R2, MinX =< X1+R1)
		),
		( (MinY is Y1-R1, MinY =< Y2-R2, MinY =< Y3+R3) ;
		  (MinY is Y2-R2, MinY =< Y1-R1, MinY =< Y3+R3) ;
		  (MinY is Y3+R3, MinY =< Y2-R2, MinY =< Y1-R1)
		), MinX1 is round(MinX) , MinY1 is round(MinY).

maxxy(MaxX1,MaxY1):- 	dmax_RB(R1), dmax_BR(R2), dmax_RG(R3),
		fahneRB(X1,Y1),fahneBR(X2,Y2),fahneRG(X3,Y3),
		( (MaxX is X1-R1, MaxX >= X2-R2, MaxX >= X3-R3) ;
		  (MaxX is X2-R2, MaxX >= X1-R1, MaxX >= X3-R3) ;
		  (MaxX is X3-R3, MaxX >= X2-R2, MaxX >= X1-R1)
		),
		( (MaxY is Y1-R1, MaxY >= Y2-R2, MaxY >= Y3+R3) ;
		  (MaxY is Y2-R2, MaxY >= Y1-R1, MaxY >= Y3+R3) ;
		  (MaxY is Y3+R3, MaxY >= Y2-R2, MaxY >= Y1-R1)
		), MaxX1 is round(MaxX) , MaxY1 is round(MaxY).




/*

Es wird hier eine Wissensdatenbank angelegt der Koordinaten welche das Quadrat der zu durchsiuchenden Werte
aufspannt.

*/

minmax:- minxy(X1,Y1), maxxy(X2,Y2), asserta(startx(X1)),X3 is X2-1,asserta(endx(X3)),asserta(starty(Y2)),Y3 is Y1-1,asserta(endy(Y3)).

% Die gespeicherten Werte des quadrates werden aus der Wissensbasis wieder gelscht

delete:- retract(startx(_)),retract(endx(_)),retract(starty(_)),retract(endy(_)).




/* ###############################

Constraints fuer lokal konsistente Standpunkt-Loesung des Aibos in Bezug auf eine Fahnenstange
mit den Berechneten Fehler. Der Fehler drckt sich in der Distanz des Aibos zu jeder
Fahne aus und es gibt somit eine minimale und eine maximal Distanz.
Die Koordinaten-Gleichung (also XYsq) wird errechnet durch die X-und Y Werte die bergeben wurden.
Wenn der errechnete Wert irgendwo innerhalb vom suplimum und infimum der Distanz liegt, ist die Gleichung
erfllt auf Grund der Fehlerrate.

*/

c_BR(X,Y):- 	dmin_BR(Rmin), dmax_BR(Rmax),
		RminV is Rmin^2, RmaxV is Rmax^2,
                 XYsq is ((X-(-1350))^2) + ((Y-(+1950))^2),
                 RminV =< XYsq, XYsq =< RmaxV.

c_RB(X,Y):- 	dmin_RB(Rmin), dmax_RB(Rmax),
		RminV is Rmin^2, RmaxV is Rmax^2,
		XYsq is ((X-(1350))^2) + ((Y-(1950))^2),
                 RminV =< XYsq, XYsq =< RmaxV.

c_RG(X,Y):- true;( 	dmax_RG(Rmin), dmax_RG(Rmax),
		RminV is Rmin^2, RmaxV is Rmax^2,
		XYsq is ((X-(1350))^2) + ((Y-(1950))^2),
                 RminV =< XYsq, XYsq =< RmaxV).

/*

Rekursiver Abstieg jedes X-Wertes zwischen 3000 und -3000.
Es wird somit fr ein Y-Wert jeder X-Wert getestet ob die Constraints erfllt werdenn.
Ist dies der Fall, so wird der validierte X- und Y Wert als Tupel in einer Liste zurckgegeben.

*/

% Rekursionsanfang wenn X -3001 ist
constX_BR(X,_,[]):- endx(X).

/*

Rekursionsschritt fr den Fall, dass die Constraints erfllt werden.
In diesem Falle wird auch das Tupel als Liste zurckgegeben

*/

constX_BR(X,Y,[(X,Y)|T]):-	 X1 is X-1,
				c_BR(X,Y), c_RB(X,Y), c_RG(X,Y),
                                 constX_BR(X1,Y,T),!.

/*

Rekursionsschritt fr den Fall, dass die Constraints nicht erfllt werden.
Der Abstieg verluft weiter fr den ncshten X-Wert und es wird die existierende Liste ohne Vernderung
weitergegeben

*/

constX_BR(X,Y,T):- X1 is X-1, constX_BR(X1,Y,T),!.


% Rekursionsanfang fr den Abstieg der Y-Werte von 2000 bis -2000
constY_BR(_,Y,[]):- endy(Y).

/*

Der Rekursionsschritt. Hier gibt es keine Ausnahmeregel wie bei den X-Werten, da
die berprfung nach validen Y-Werte schon oben mit bernommen wird.

*/
constY_BR(X,Y,XYListe):- constX_BR(X,Y,T1),
			Y1 is Y-1, constY_BR(X,Y1,T),
                         (T1 \= [], XYListe = [T1|T] ; XYListe = T),!.


globaleLoesung:- minmax,startx(X),starty(Y), constY_BR(X,Y,XYListe),
		write('die global konsistente Menge beinhaltet folgende Lsungen: \n'),
                 write(XYListe),write('\n \n mit folgender Kardinalitt:'),
                 length(XYListe,K), write(K), ausgabe(XYListe), delete,!.



/* Ausgabemenge der validen Punkte in eine Datei mit dem Namen 'globaleloesungen.dat'
   im gleichen Verzeichnisordner von dem der Prologinterpreter gestartet wurde (bei uns zumindest).
*/

ausgabe(L):- tell('globaleloesungen.dat'), write(L), told.