class RobotPosition implements RobotPositionConstants {
	//Flagge links, vorne und hinten
	Flag f1, f2, f3;
	
	//Zugehrige Flaggen-Constraints
	FlagConstraint c1, c2, c3;
	
	//Intervall-Constraints fr X- und Y-Koordinate
	IntervalConstraint c4, c5;
		
	int err = PIXEL_ERROR;
	
	//initiale Grenzen des Wertebereiches
	int maxDown = -2000;
	int maxTop = 2000; 
	int maxLeft = -3000;
	int maxRight = 3000; 
	
	
	RobotPosition() {
		//Flagge auf linkem Bild (Cyan-Pink)
		f1 = new Flag(-1350, -1950, 31, H_BILD_LINKS, c1, "Flagge 1");
		
		//Flagge auf vorderem Bild (Pink-Cyan)
		f2 = new Flag(-1350, 1950, 46, H_BILD_VORNE, c2, "Flagge 2");
		
		//Flagge auf rechtem Bild (Pink-Gelb)
		f3 = new Flag(1350, 1950, 39, H_BILD_RECHTS, c3, "Flagge 3");
		
		//Constraint C1
		c1 = new FlagConstraint(f1, PIXEL_ERROR);
		f1.setFc(c1);
		
		//Constraint C2
		c2 = new FlagConstraint(f2, PIXEL_ERROR);
		f2.setFc(c2);
		
		//Constraint C3
		c3 = new FlagConstraint(f3, PIXEL_ERROR);
		f3.setFc(c3);
		
		//Intervall-Constraint fr die X-Koordinate
		c4 = new IntervalConstraint(maxLeft, maxRight);
		
		//Intervall-Constraint fr die Y-Koordinate
		c5 = new IntervalConstraint(maxDown, maxTop);
				
	}
		
	/*
	 * Diese Methode startet den Propagierungsalgorithmus.
	 * Falls dabei keine global konsistente Loesung gefunden wird, wird der annehmbare
	 * Pixelfehler bei der Vermessung der Hoehe der Landmarken in den einzelnen
	 * Bildern erhoeht um so eine breitere Streuung der minimalen und
	 * maximalen Distanzen zwischen den Flaggen und der Roboterposition zu erhalten.
	 */
	public void search() {
				
		/*
		 * Zuerts wird geprueft ob schon bei der Betrachtung der Verhaeltnisse der Distanzen
		 * der einzelnen Flaggen zur potentiellen Roboterposition nicht eine globale Inkonsistenz
		 * festgestellt werden kann.
		 * Falls ja, dann wird der anzunehmende Pixelfehler erhoeht.
		 */
		while (!(f1.checkDistance(f2)) && !(f1.checkDistance(f3)) && !(f2.checkDistance(f3)))  {
			err++;
			c1 = new FlagConstraint(f1, err);
			f1.setFc(c1);
			c2 = new FlagConstraint(f2, err);
			f2.setFc(c2);
			c3 = new FlagConstraint(f3, err);
			f3.setFc(c3);
			
		}
				
		/*
		 * Hier wird solange der Propagierungsalgorithmus durchgefuehrt 
		 * bis eine global konsistente Loesung gefunden wird (falls in einem Durchlauf 
		 * keine globale Konsistenz festgestellt wird, so werden die einzelnen
		 * lokalen Konsistenz Bereiche der einzelnen Constraint durch das Vergroessern
		 *  des maximalen Pixelfehlers erhoeht) 
		 */		
		if (!propagation()) {
			System.out.println("Keine konsistente golbale Loesung gefunden.");
			System.out.println("Der maximale Pixelfehler in der Hoehe der Landmarken wird erhoeht.");
			err++;
			c1 = new FlagConstraint(f1, err);
			f1.setFc(c1);
			c2 = new FlagConstraint(f2, err);
			f2.setFc(c2);
			c3 = new FlagConstraint(f3, err);
			f3.setFc(c3);
			
			search();
			
		}
		else {
			System.out.println("");
			System.out.println("eine global konsistente Einschraenkung gefunden.");
			System.out.println("Der entgueltige Wertebereich fuer Roboterposition: ("+maxLeft+", "+maxTop+"), ("+maxRight+", "+maxDown+").");
		}
				
	}
	
	/*
	 * Der Propagierungsalgorithmus naehrt sich von 4 Seiten an die potentielle Roboterposition an.
	 * Dabei wird nach der Schnittmenge der lokal konsistenten Wertebereiche der einzelnen Constraints
	 * gesucht um so eine global konsistente Loesung zu bekommen, die durch 2 Punkte 
	 * im vorgegebenen Koordinatensystem dargestellt wird (diese definieren die Diagonale des 
	 * Rechtecks der die Loesung umrandet). 
	 */
	public boolean propagation() {
		
		//Annaehrung von unten
		for (int i = maxDown; i < maxTop; i++) {
			for (int j = maxRight; j > maxLeft; j--) {
				//Ueberpruefung der Uebereinstimmung der jeweiligen Koordinate mit den einzelnen Constraints
				if (c1.validate(j, i) && c2.validate(j, i) && c3.validate(j, i)) {
					maxDown = i;
					newValue();
					
					//Annaehrung von rechts
					for (int k = maxRight; k > maxLeft; k--) {
						for (int l = maxTop; l > maxDown; l--) {
							if (c1.validate(k, l) && c2.validate(k, l) && c3.validate(k, l)) {
								maxRight = k;
								newValue();
								
								//Annaehrung von oben
								for (int r = maxTop; r > maxDown; r--) {
									for (int t = maxLeft; t < maxRight; t++) {
										if (c1.validate(t, r) && c2.validate(t, r) && c3.validate(t, r)) {
											maxTop = r;
											newValue();
											
											//Annaehrung von links
											for (int w = maxLeft; w < maxRight; w++) {
												for (int e = maxDown; e < maxTop; e++) {
													if (c1.validate(w, e) && c2.validate(w, e) && c3.validate(w, e)) {
														maxLeft = w;
														newValue();
														
														return true;
													}	
												}
											}
										}	
									}
								}
							}	
						}
					}
				}
					
			}
		
		}
		
		return false;
	}
	
	public void newValue(){
		 System.out.println("Neue Einschraenkung gefunden!");
		 System.out.println("Der aktuelle Wertebereich fuer Roboterposition: ("+maxLeft+", "+maxTop+"), ("+maxRight+", "+maxDown+").");
		 System.out.println("Suche nach weiteren Einschraenkungen..");
	 }
	
	
	public static void main(String args[]) {
		RobotPosition pos = new RobotPosition();
		pos.search();	
	}
}