class IntervalConstraint {
	//Minimaler Wert des Intervall-Constraints
	int min;
	
	//Maximaler Wert des Intervall-Constraints
	int max;
	
	public IntervalConstraint(int min, int max) {
		this.min = min;
		
		this.max = max;
	}
	
	//prft, ob Wert im Intervall liegt
	public boolean validate(int value) {
		return this.min <= value && value <= this.max;
	}
	
	/**
	 * berechnet den Schnitt mit einem anderen Intervall-Constraint
	 * @param ic Intervall-Constraint, der geschnitten werden soll
	 * @return Schnitt-Intervall oder null, falls der Schnitt leer ist
	 */
	public IntervalConstraint intersection(IntervalConstraint ic) {
		int m1 = Math.max(min, ic.getMin());
		
		int m2 = Math.min(max, ic.getMax());
		
		if (m1 > m2) return null;
		
		return new IntervalConstraint(m1, m2);
	}

	public int getMax() {
		return max;
	}

	public void setMax(int max) {
		this.max = max;
	}

	public int getMin() {
		return min;
	}

	public void setMin(int min) {
		this.min = min;
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + max;
		result = PRIME * result + min;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final IntervalConstraint other = (IntervalConstraint) obj;
		if (max != other.max)
			return false;
		if (min != other.min)
			return false;
		return true;
	}
	
	
	
}