class Flag implements RobotPositionConstants {
	//X-Koordinate (in mm)
	protected int x;
	
	//Y-Koordinate (in mm)
	protected int y;
	
	//Hhe des Bildes in Pixel, auf dem die Flagge zu sehen ist
	protected int bh;
	
	//Hhe der Flagge auf Bild
	protected int h;
	
	//Bezeichnung der Flagge
	protected String id;
	
	//Zugehriges FlaggenConstraint
	protected FlagConstraint fc;
	
	/**
	 * Konstruktor fr eine Flagge
	 * @param x X-Koordinate (in mm)
	 * @param y Y-Koordinate (in mm)
	 * @param h gemessene Bildhhe in Pixel
	 * @param bh Hhe des Bildes, auf dem Flagge zu sehen ist
	 * @param fc Zur Flagge gehriges Flaggen-Constraint
	 * @param id Bezeichnung der Flagge
	 */
	public Flag(int x, int y, int h, int bh, FlagConstraint fc, String id) {
		this.x = x;
		this.y = y;
		this.bh = bh;
		this.h = h;
		this.fc = fc;
		this.id = id;
	}
	
	/**
	 * Berechnet Entfernung zu einer anderen Flagge
	 * @param f Flagge, zur der die Entfernung berechnet werden soll
	 * @return Entfernung zur Flagge f
	 */
	public double getDistance(Flag f) {
		int dx = x - f.getX();
		int dy = y - f.getY();
		return (Math.sqrt(dx*dx+dy*dy));
	}
	
	/**
	 * Prft, ob die maximal mglichen Entfernungen vom Roboter zu dieser und
	 * der Fahne f mglich ist.
	 * Ist der Abstand zwischen den beiden Fahnen grsser als die Summe der maximal
	 * mglichen Entfernungen zum Roboter, gibt es fr diesen keine gltige Position mehr.
	 * @param f Zweite Flagge
	 * @throws InvalidFlagDistanceException, falls Abstand der Flaggen grsser als
	 * Summe der maximal mglichen Entfernungen zum Roboter
	 */
	public boolean checkDistance(Flag f){
		double dist = getDistance(f);
		if (fc.getDmax()+f.getFc().getDmax()<dist) {
			
			return false;
			
		}
		return true;
	}
	
	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public int getBh() {
		return bh;
	}

	public void setBh(int bh) {
		this.bh = bh;
	}

	public int getH() {
		return h;
	}

	public void setH(int h) {
		this.h = h;
	}

	public FlagConstraint getFc() {
		return fc;
	}

	public void setFc(FlagConstraint fc) {
		this.fc = fc;
	}

}