/*
 * Enkhtur Zurgaanjin 199967
 * Ilyas Amin 197399
 * Christian Kaptur 502309
 * 
 * Diese Klasse dient zu Propagierung der Constarints. Es wird eine Art von Brute-Force
 * Algorithmus angewendet, d.h. man wähle z.B. ein festes x* (am Rand der Domäne)
 * und man sucht dann ein y* aus Dom(y), so dass das (x*, y*) lokal konsistent ist und in
 * dem jewleigen Constraint liegt (die Gleichung erfüllt wird). Existiert solch ein y*
 * nicht, kann man x* aus Dom(x) streichen und man wählt das nächst größere bzw. kleinere x
 * und wiederholt.
 * 
 * Wir repraesentieren den Wertebereich der Variablen so, dass wir den linken und rechten 
 * Rand der Menge angebe und alle Elemente dazwischen zum Wertebereich dazu gehoeren.
 */
public class Loesung extends Constraint{
	long min_x;
	long max_x;
	long min_y;
	long max_y;
	
	public Loesung() {
		this.max_x = 3000;
		this.min_x = -3000;
		this.min_y = -2000;
		this.max_y = 2000;
	}
	
	Constraint c = new Constraint();
	
	/*
	 * Hier wird die Gleichung1 von "links" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung1_min_x() {
		long y = this.min_y;

		for (;y<=this.max_y;y++) {
			if (c.gleichung1(this.min_x,y)) {
				// wenn eine Loesung gefunden wurde kann man die Domaene nicht einschraenken
				return false;
			}
		}
		/*
		 * an der Stelle weiss man, das es kein y gibt, so dass fuer das aktuelle x gilt:
		 * (x,y) ist eine lokale Loesung, also kann man dieses x aus der Domäne streichen
		 */ 
		this.min_x = this.min_x+1;
		if (this.min_x <= this.max_x) {
			propagierung1_min_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung1 von "rechts" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung1_max_x() {
		long y = this.min_y;
		
		for (;y<=this.max_y;y++) {
			if (c.gleichung1(this.max_x,y)) {
				// wenn eine Loesung gefunden wurde kann man die Domaene nicht einschraenken
				return false;
			}
		}
		this.max_x = this.max_x-1;
		if (this.min_x <= this.max_x) {
			propagierung1_max_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung2 von "links" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung2_min_x() {
		long y = this.min_y;
		
		for (;y<=this.max_y;y++) {
			if (c.gleichung2(this.min_x,y)) {
//				 wenn eine Loesung gefunden wurde kann man die Domaene nicht einschraenken
				return false;
			}
		}
		this.min_x = this.min_x+1;
		if (this.min_x <= this.max_x) {
			propagierung2_min_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung2 von "rechts" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung2_max_x() {
		long y = this.min_y;
		
		for (;y<=this.max_y;y++) {
			if (c.gleichung2(this.max_x,y)) {
//				 wenn eine Loesung gefunden wurde kann man die Domaene nicht einschraenken
				return false;
			}
		}
		this.max_x = this.max_x-1;
		if (this.min_x <= this.max_x) {
			propagierung2_max_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung3 von "links" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung3_min_x() {
		long y = this.min_y;
		
		for (;y<=this.max_y;y++) {
			if (c.gleichung3(this.min_x,y)) {
//				 wenn eine Loesung gefunden wurde kann man die Domäne nicht einschränken
				return false;
			}
		}
		this.min_x = this.min_x+1;
		if (this.min_x <= this.max_x) {
			propagierung3_min_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung3 von "rechts" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung3_max_x() {
		long y = this.min_y;
		
		for (;y<=this.max_y;y++) {
			if (c.gleichung3(this.max_x,y)) {
//				 wenn eine Loesung gefunden wurde kann man die Domäne nicht einschränken
				return false;
			}
		}
		this.max_x = this.max_x-1;
		if (this.min_x <= this.max_x) {
			propagierung3_max_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung4 von "links" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung4_min_x() {
		long y = this.min_y;
		
		for (;y<=this.max_y;y++) {
			if (c.gleichung4(this.min_x,y)) {
				return false;
			}
		}
		this.min_x = this.min_x+1;
		if (this.min_x <= this.max_x){
			propagierung4_min_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung4 von "rechts" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung4_max_x() {
		long y = this.min_y;
		
		for (;y<=this.max_y;y++) {
			if (c.gleichung4(this.max_x,y)) {
				return false;
			}
		}
		this.max_x = this.max_x-1;
		if (this.min_x <= this.max_x) {
			propagierung4_max_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung5 von "links" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung5_min_x() {
		long y = this.min_y;
		
		for (;y<=this.max_y;y++) {
			if (c.gleichung5(this.min_x,y)) {
				return false;
			}
		}
		this.min_x = this.min_x+1;
		if (this.min_x <= this.max_x) {
			propagierung5_min_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung5 von "rechts" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung5_max_x() {
		long y = this.min_y;
		
		for (;y<=this.max_y;y++) {
			if (c.gleichung5(this.max_x,y)) {
				return false;
			}
		}
		this.max_x = this.max_x-1;
		if (this.min_x <= this.max_x) {
			propagierung5_max_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung6 von "links" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung6_min_x() {
		long y = this.min_y;
		
		for (;y<=this.max_y;y++) {
			if (c.gleichung1(this.min_x,y)) {
				return false;
			}
		}
		this.min_x = this.min_x+1;
		if (this.min_x <= this.max_x) {
			propagierung6_min_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung6 von "rechts" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(x) eingschraenkt werden.
	 */	
	public boolean propagierung6_max_x() {
		long y = this.min_y;
		
		for (;y<=this.max_y;y++) {
			if (c.gleichung6(this.max_x,y)) {
				return false;
			}
		}
		this.max_x = this.max_x-1;
		if (this.min_x <= this.max_x) {
			propagierung6_max_x();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung1 von "unten" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung1_min_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung1(x,this.min_y)) {
				return false;
			}
		}
		this.min_y = this.min_y+1;
		if (this.min_y <= this.max_y) {
			propagierung1_min_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung1 von "oben" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung1_max_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung1(x,this.max_y)) {
				return false;
			}
		}
		this.max_y = this.max_y-1;
		if (this.min_y <= this.max_y) {
			propagierung1_max_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung2 von "unten" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung2_min_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung2(x,this.min_y)) {
				return false;
			}
		}
		this.min_y = this.min_y+1;
		if (this.min_y <= this.max_y) {
			propagierung2_min_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung2 von "oben" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung2_max_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung2(x,this.max_y)) {
				return false;
			}
		}
		this.max_y = this.max_y-1;
		if (this.min_y <= this.max_y) {
			propagierung2_max_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung3 von "unten" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung3_min_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung3(x,this.min_y)) {
				return false;
			}
		}
		this.min_y = this.min_y+1;
		if (this.min_y <= this.max_y) {
			propagierung3_min_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung3 von "oben" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung3_max_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung3(x,this.max_y)) {
				return false;
			}
		}
		this.max_y = this.max_y-1;
		if (this.min_y <= this.max_y) {
			propagierung3_max_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung4 von "unten" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung4_min_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung4(x,this.min_y)) {
				return false;
			}
		}
		this.min_y = this.min_y+1;
		if (this.min_y <= this.max_y) {
			propagierung4_min_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung4 von "oben" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung4_max_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung4(x,this.max_y)) {
				return false;
			}
		}
		this.max_y = this.max_y-1;
		if (this.min_y <= this.max_y) {
			propagierung4_max_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung5 von "unten" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung5_min_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung5(x,this.min_y)) {
				return false;
			}
		}
		this.min_y = this.min_y+1;
		if (this.min_y <= this.max_y) {
			propagierung5_min_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung1 von "oben" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung5_max_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung5(x,this.max_y)) {
				return false;
			}
		}
		this.max_y = this.max_y-1;
		if (this.min_y <= this.max_y) {
			propagierung5_max_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung6 von "unten" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung6_min_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung6(x,this.min_y)) {
				return false;
			}
		}
		this.min_y = this.min_y+1;
		if (this.min_y <= this.max_y) {
			propagierung6_min_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
	
	/*
	 * Hier wird die Gleichung6 von "oben" propagiert und nach einer Loesung gesucht,
	 *  andernfalls kann Dom(y) eingschraenkt werden.
	 */	
	public boolean propagierung6_max_y() {
		long x = this.min_x;
		
		for (;x<=this.max_x;x++) {
			if (c.gleichung6(x,this.max_y)) {
				return false;
			}
		}
		this.max_y = this.max_y-1;
		if (this.min_y <= this.max_y) {
			propagierung6_max_y();
			return true;
		} else {
			System.out.println("Es existiert keine lokale und somit keine global konsistente Loesung");
		}
		return false;
	}
}
