package positionsbestimmung;

/** Stellt einen Winkel bereit.
 * 
 * @author root
 *
 */

public class Winkel {
	private double deg;
	private double rad;
	
	/** Erstellt einen neuen Winkel.
	 * ist <code>deg == true</code> wird der Wert wert als Grad angenommen (-180 - 180),
	 * sonst als Radiant (-<i>pi</i> - <i>pi</i>).
	 * @param wert in rad oder deg
	 * @param deg 0 fr rad, 1 fr deg
	 */
	
	public Winkel(double wert, boolean is_deg) {
		if(is_deg == true) {
			deg = wert;
			rad = (wert * Math.PI)/180;
		} else {
			rad = wert;
			deg = (wert * 180)/Math.PI;
		}
	}
	
	/** Gibt den Wert des Winkels in deg zurck.
	 * 
	 * @return deg
	 */
	
	public double getDeg() {
		return deg;
	}
	
	/** Gibt den Wert des Winkels in rad zurck.
	 * 
	 * @return rad
	 */
	
	public double getRad() {
		return rad;
	}
}
