package a2;

import java.util.Vector;


public class Main {
	
	private static final Vector<Constraint> constraints;
	private static final VariableMap input;
	
	public static void main(String[] args) {
		
		System.out.println("Eingabe: " + input);
		VariableMap vars = new VariableMap(); 
		vars.putAll(input);

		/* Mglicher Bereich fr die Kamera, anfangs das ganze Feld */
		vars.put("K.MinX", Constants.FIELD_MIN_X);
		vars.put("K.MaxX", Constants.FIELD_MAX_X);
		vars.put("K.MinY", Constants.FIELD_MIN_Y);
		vars.put("K.MaxY", Constants.FIELD_MAX_Y);

		/* Einschrnkung des Bereichs durch die Constraints */
		for(Constraint c : constraints) {
			c.apply(vars);
		}
		
		/* Ausgabe */
		System.out.println("Kamerabereich:");
		System.out.println("\tX: [" + vars.get("K.MinX") + " ... " + vars.get("K.MaxX") + "]");
		System.out.println("\tY: [" + vars.get("K.MinY") + " ... " + vars.get("K.MaxY") + "]");
	}

	
	static {
		/* Fr jedes bekannte Objekt ein AreaConstraint */
		constraints = new Vector<Constraint>();
		constraints.add(new AreaConstraint("F1"));
		constraints.add(new AreaConstraint("F2"));
		constraints.add(new AreaConstraint("F3"));
		constraints.add(new AreaConstraint("F4"));
		constraints.add(new AreaConstraint("T1"));
		constraints.add(new AreaConstraint("T2"));
		
		/* Die Eingabewerte */
		input = new VariableMap();
		input.put("F1.PeilungsWinkel", 14.0);
		input.put("F2.PeilungsWinkel", -3.0);
		input.put("F3.PeilungsWinkel", 11.0);
		input.put("F1.Hoehe", 80);
		input.put("F2.Hoehe", 55);
		input.put("F3.Hoehe", 73);
		
	}
}
