package a2;

public class Distance {

	/**
	 * @author Sebastian
	 */

	/**
	 * @param screenObjectLength 	Lnge des Objekts auf dem Bildschirm
	 * @param realObjectLength	Originalbreite oder - Hhe des Objekts
	 * @param screenLength		Breite oder Hhe des Bildschirms
	 * @param cameraAngle		Kameraffnungswinkel horizontal oder vertikal
	 * @param objectAngle		Peilungswinkel zum Objekt
	 * @return 			Entfernung zum Objekt
	 */
	public static double dist (double screenObjectLength, double realObjectLength, double screenLength, double cameraAngle, double objectAngle) {
		
		/* berechne Lnge auf der z-Achse*/
		double zDist = realObjectLength / (Math.tan(cameraAngle/2.) * screenObjectLength / (screenLength/2.));
		
		/* berechne Lnge zum Objekt mit Peilungswinkel*/
		double directDist = zDist / Math.cos(Math.abs(objectAngle) + Constants.MAX_ERROR_ANGLE);
		
		return directDist;
	}
	
	public static void main(String[] args) {
		System.out.println(dist(11,56, ConstantObjects.F1.getHeight(), Constants.KAMERA_VERTIKAL, Math.toRadians(10)));
		System.out.println(dist(4, 100, 1, Math.toRadians(90), Math.toRadians(0)));
		System.out.println(dist(10, 100, 1, Math.toRadians(90), Math.toRadians(0)));
		System.out.println(dist(10, 100, 1, Math.toRadians(90), Math.toRadians(0)));
	}
	
	
}	
