package a2;

/**
 * Schrnkt mglich Bereich der Kamera aufgrund des Abstands (Berechnung aus dem Peilungswinkel)
 * zu bekannten Objekten ein.
 */
public class AreaConstraint extends Constraint {
	
	private ConstantObjects obj;
	
	public AreaConstraint(String objName) {
		obj = Enum.valueOf(ConstantObjects.class, objName);
	}
	
	public void apply(VariableMap vars) {
		
		/* Falls zu wenig Daten ber obj bekannt (nicht im Bild),
		 * keine Einschrnkung mglich */
		if(!vars.keySet().contains(obj.name() + ".PeilungsWinkel")
		|| !vars.keySet().contains(obj.name() + ".Hoehe")) {
			return;
		}
		
		int    hoehePx;  /* Breite im Bild  */
		double peilung;  /* Peilungswinkel in Grad */
		double abstand;  /* Abstand obj <-> Kamera in mm */
		
		hoehePx = (Integer) vars.get(obj.name() + ".Hoehe");
		peilung  = (Double) vars.get(obj.name() + ".PeilungsWinkel");

		abstand = Distance.dist( hoehePx, obj.getHeight(), Constants.IMAGE_HEIGHT_PX,
			Constants.KAMERA_VERTIKAL, Math.toRadians(peilung));
		
		//System.out.println(this + " -> ABSTAND =" + abstand);
		
		/* Einschrnken des Kamera Bereichs */
		int minx, miny, maxx, maxy;
		
		minx = (Integer) vars.get("K.MinX");
		miny = (Integer) vars.get("K.MinY");
		maxx = (Integer) vars.get("K.MaxX");
		maxy = (Integer) vars.get("K.MaxY");
		
		minx = (int) Math.round(Math.max(minx, obj.getPosition().getX() - abstand));
		miny = (int) Math.round(Math.max(miny, obj.getPosition().getY() - abstand));
		maxx = (int) Math.round(Math.min(maxx, obj.getPosition().getX() + abstand));
		maxy = (int) Math.round(Math.min(maxy, obj.getPosition().getY() + abstand));
		
		vars.put("K.MinX", minx);
		vars.put("K.MinY", miny);
		vars.put("K.MaxX", maxx);
		vars.put("K.MaxY", maxy);
	}
	
	public String toString() {
		return "AreaConstraint(" + obj.name() +")";
	}
}
