public class Robot {
	
	// Messwerte
	static double 	
			Picture1Width = 180, 
			Picture1Height = 140,
			Picture1FlagLeft = 72,
			Picture1FlagRight = 83,
			Picture1CornerUpper = 55,
			Picture1CornerLower = 80,
			Picture1Horizon = 5,
			Picture2Width = 182, 
			Picture2Height = 141,
			Picture2FlagLeft = 138,
			Picture2FlagRight = 151,
			Picture2CornerUpper = 7,
			Picture2CornerLower = 35,
			Picture2Horizon = 4.3,
			Picture3Width = 183, 
			Picture3Height = 140,
			Picture3FlagLeft = 108,
			Picture3FlagRight = 123,
			Picture3Horizon = 11.8;
	static Flag
			Picture1Flag = Constants.flag1,
			Picture2Flag = Constants.flag2,
			Picture3Flag = Constants.flag3;
	static Corner
			Picture1Corner = Constants.cornerBottomLeft,
			Picture2Corner = Constants.cornerUpperLeft;
				
	public static void main(String[] args) {
		
		// erzeuge Constraint-Problem
		CSP csp = new CSP();
		
		/* erzeuge Constraints fuer Flaggen in den Bildern auf der Basis der Messwerte */
		csp
		.addFlagConstraints(Picture1Flag, Picture1Width, Picture1Height, Picture1FlagLeft, Picture1FlagRight, Math.toRadians(Picture1Horizon))
		.addFlagConstraints(Picture2Flag, Picture2Width, Picture2Height, Picture2FlagLeft, Picture2FlagRight, Math.toRadians(Picture2Horizon))
		.addFlagConstraints(Picture3Flag, Picture3Width, Picture3Height, Picture3FlagLeft, Picture3FlagRight, Math.toRadians(Picture3Horizon))
		.addCornerConstraints(Picture1Corner, Picture1Width, Picture1Height, Picture1CornerUpper, Picture1CornerLower, Math.toRadians(Picture1Horizon))
		.addCornerConstraints(Picture2Corner, Picture2Width, Picture2Height, Picture2CornerUpper, Picture2CornerLower, Math.toRadians(Picture2Horizon));
		
		Constants.cornerBottomLeft.dist = new Interval(2915,3449);
		
		 // Loesungsversuch starten
		try {
			csp.solve();
			// wenn erfolgreich, Ausgabe der Loesung
			System.out.println("Die Position des Roboters liegt bei:");
			System.out.println("("+csp.x.lower+"mm <= x <= "+csp.x.upper+"mm ; "+csp.y.lower+"mm <= y <= " + csp.y.upper+"mm)");			
		}
		catch (InconsistencyException e) {
			// ansonsten Fehlermeldung
			System.out.println(e);
		}		 	
	}
}
