
/**
 * Wertebereich fr x und y
 * @author Oliver
 *
 */
class Bounds {
	/**
	 * Wertebereich fr X
	 */
	IntervalConstraint xc;
	
	/**
	 * Wertebereich fr Y
	 */
	IntervalConstraint yc;
	
	Bounds(IntervalConstraint xc, IntervalConstraint yc) {
		this.xc = xc;
		this.yc = yc;
	}
	
	Bounds(int x1, int y1, int x2, int y2) {
		xc = new IntervalConstraint(x1, x2);
		
		yc = new IntervalConstraint(y1, y2);
	}
	
	Bounds(Bounds b) {
		this(b.getXc(), b.getYc());
	}
	
	public Bounds intersection(Bounds b) {
		IntervalConstraint xc2 = xc.intersection(b.getXc());
		IntervalConstraint yc2 = yc.intersection(b.getYc());
		if (xc2 == null || yc2 == null) {
			return null;
		}
		
		return new Bounds(xc2, yc2);
	}

	public IntervalConstraint getXc() {
		return xc;
	}

	public void setXc(IntervalConstraint xc) {
		this.xc = xc;
	}

	public IntervalConstraint getYc() {
		return yc;
	}

	public void setYc(IntervalConstraint yc) {
		this.yc = yc;
	}
	
	public int getX1() {
		return xc.getMin();
	}
	
	public int getX2() {
		return xc.getMax();
	}
	
	public int getY1() {
		return yc.getMin();
	}
	
	public int getY2() {
		return yc.getMax();
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((xc == null) ? 0 : xc.hashCode());
		result = PRIME * result + ((yc == null) ? 0 : yc.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final Bounds other = (Bounds) obj;
		if (xc == null) {
			if (other.xc != null)
				return false;
		} else if (!xc.equals(other.xc))
			return false;
		if (yc == null) {
			if (other.yc != null)
				return false;
		} else if (!yc.equals(other.yc))
			return false;
		return true;
	}
	
	public String toString() {
		return "(x,y) E ["+getX1()+", "+getX2()+"]x["+getY1()+", "+getY2()+"]";
	}
	
	public void out() {
		System.out.println(this.toString());
	}
}