#include "geomet.h"
#include <iostream>
#include <math.h>

/* PI Konstante */
#define PI 3.14159265

/************************************************************************************/
/* gemessene Winkel aus den Bilden fr alle 3 Flaggen in Grad
*/
#define FLAG1_ALPHA 9.3
#define FLAG1_BETA  9.3
#define FLAG1_GAMMA 3.5

#define FLAG2_ALPHA 12.7
#define FLAG2_BETA  9.3
#define FLAG2_GAMMA 15

#define FLAG3_ALPHA 10.8
#define FLAG3_BETA  8.8
#define FLAG3_GAMMA 5.6

/************************************************************************************/

/* Flaggen Positionen */
#define FLAG1_POS_X -1350
#define FLAG1_POS_Y -1950

#define FLAG2_POS_X -1350
#define FLAG2_POS_Y 1950

#define FLAG3_POS_X 1350
#define FLAG3_POS_Y 1950

/* Flaggen Mae in mm */
#define FLAG_WIDTH 100
#define FLAG_HEIGHT 400

/* Absoluter Fehler beim Winkelmessen in Grad */

#define ABS_ERR 0.35

/************************************************************************************/
/* berechnet den Abstand zum Flaggenmittelpunkt wie in der txt Datei beschrieben */
int CalcRobotDistToFlag(double alpha, double beta, double gamma)
{
	/* rechne alle winkel im verhaeltnis zu PI um, denn tan rechnet nicht mit Grad */
	alpha=alpha*PI/180;
	beta=beta*PI/180;
	gamma=gamma*PI/180;

	/* berechne den abstand */
	double dx, dy, df;
	
	dx = ( FLAG_HEIGHT * beta ) / ( tan(beta) * alpha );

	dy = tan(gamma) * dx;

	df = sqrt( dx*dx + dy*dy );

	/* wir runden diesen Wert auf nt, da mm uns im Moment genau genug sind */
	return ((int) (df + FLAG_WIDTH/2 + 0.5));
}


/************************************************************************************/
int main()
{
	using namespace std;
	char key;

	/* berechne die minimalen und maximalen Abstaende zu den Flaggen */
	
	int flag1_dist_min = CalcRobotDistToFlag(FLAG1_ALPHA+ABS_ERR,FLAG1_BETA+ABS_ERR,FLAG1_GAMMA-ABS_ERR);
	int flag1_dist_max = CalcRobotDistToFlag(FLAG1_ALPHA-ABS_ERR,FLAG1_BETA-ABS_ERR,FLAG1_GAMMA+ABS_ERR);

	int flag2_dist_min = CalcRobotDistToFlag(FLAG2_ALPHA+ABS_ERR,FLAG2_BETA+ABS_ERR,FLAG2_GAMMA-ABS_ERR);
	int flag2_dist_max = CalcRobotDistToFlag(FLAG2_ALPHA-ABS_ERR,FLAG2_BETA-ABS_ERR,FLAG2_GAMMA+ABS_ERR);

	int flag3_dist_min = CalcRobotDistToFlag(FLAG3_ALPHA+ABS_ERR,FLAG3_BETA+ABS_ERR,FLAG3_GAMMA-ABS_ERR);
	int flag3_dist_max = CalcRobotDistToFlag(FLAG3_ALPHA-ABS_ERR,FLAG3_BETA-ABS_ERR,FLAG3_GAMMA+ABS_ERR);
	
	/* erstelle Flaggenmittelpunkte */
	Point F1(FLAG1_POS_X,FLAG1_POS_Y);
	Point F2(FLAG2_POS_X,FLAG2_POS_Y);
	Point F3(FLAG3_POS_X,FLAG3_POS_Y);
	
	/* erstelle constraint Doppelkreise */
	DoubleCircle C1(F1,flag1_dist_min,flag1_dist_max);
	DoubleCircle C2(F2,flag2_dist_min,flag2_dist_max);
	DoubleCircle C3(F3,flag3_dist_min,flag3_dist_max);
	
	/* erstelle Doppelkreis liste */
	list<DoubleCircle> clist;
	clist.push_back(C1);
	clist.push_back(C2);
	clist.push_back(C3);

	/* erstelle Punktliste */
	list<Point> plist;
	
	/* PR ist der mittlere Positionspunkt, der aus dem arithmetischen Mittel aller gefundenen Punkte gewonnen wird */
	Point PR;
	
	/* starte die suche nach den Loesungspunkten */
	int count = FindCommonPoints(clist,plist,PR);

	/* Ausgabe */
	cout << "Moegliche Roboter Positionen gefunden : " << count << " Punkte" << endl;
	if(count>0)
	{
		cout << "Mittlerer Positionspunkt: (" << PR.X << "," << PR.Y << ")" << endl;
		cout << "alle Punkte ausgeben? [y]/[n] : ";
		cin >> key;	
		if(key=='y' || key=='Y')
		{
			/* alle punkte ausgeben */
			cout<<"anfang"<<endl;
			list<Point>::iterator it = plist.begin();
			for(;it!=plist.end();it++)
			{
				cout<< "(" << (*it).X<<", "<<(*it).Y<< ")" << endl;
			}
			cout<<"ende"<<endl;
		}
	}
	/* for running in window use this to see output */
	/* cin >> key; */
	

	return 0;
}
/************************************************************************************/
