using System;
using System.Collections.Generic;
using System.Text;

namespace ConstrainPropagierung
{
    class Propagator
    {
        public DefRange x = null;
        public DefRange y = null;
        public Double StepSize = 1; //schrittgre ffr bereichseinschrnkung

        public Propagator(DefRange Ax, DefRange Ay)
        {
            x = Ax;
            y = Ay;
        }

        protected void limitx(Constrain456 AConstrainFunction)
        {
            /*
             * Methode bekommt die jeweilige ConstrainFunktion bergeben
             * und luft fr ein festes x alle y werte im 1zer Schritt durch
             * und prft ob das constrain mit diesem festen x fr irgentein y 
             * erfllt ist.
             * wenn nicht wird gibt es kein y fr dieses x wo das constraint erfllt
             * wre und das x kann eingeschrnkt werden, sprich der bereich x
             * wird erkleinert um 1
             */

            Boolean AFinished = false;
            Double yValue = 0;

            //linke grenze des x bereichs einschrnken leftEnd->
            yValue = y.LeftEnd;
            do
            { 
                AFinished = AConstrainFunction(x.LeftEnd, yValue);
                if (!AFinished)
                {
                    if (!(yValue < y.RightEnd))
                    {
                        x.LeftEnd += StepSize;
                        yValue = y.LeftEnd;
                    }
                    else
                        yValue += StepSize;
                }
                
                if (!AFinished)
                    AFinished = x.LeftEnd >= x.RightEnd;
            } while (!AFinished);
            AFinished = false;

            //rechte grenze des x bereichs einschrnken   <-rightEnd
            yValue = y.LeftEnd;
            do
            {
                AFinished = AConstrainFunction(x.RightEnd, yValue);
                if (!AFinished)
                {
                    if (!(yValue < y.RightEnd))
                    {
                        x.RightEnd -= StepSize;
                        yValue = y.LeftEnd;
                    }
                    else
                        yValue += StepSize;
                }

                if (!AFinished)
                    AFinished = x.RightEnd <= x.LeftEnd; 
            } while (!AFinished);

            return;
        }

        protected void limity(Constrain456 AConstrainFunction)
        {
            /*
             * Funktioniert wie limitx blo das jetzt y festgehalten wird und 
             * alle x durchgegangen werden. hier wird der y Bereich eingeschrnkt
             */
            Boolean AFinished = false;
            Double xValue = 0;
            
            //linke grenze des y bereichs einschrnken leftEnd->
            xValue = x.LeftEnd;
            do
            {
                AFinished = AConstrainFunction(xValue, y.LeftEnd);
                if (!AFinished)
                {
                    if (!(xValue < x.RightEnd))
                    {
                        y.LeftEnd += StepSize;
                        xValue = x.LeftEnd;
                    }
                    else
                        xValue += StepSize;
                }

                if (!AFinished)
                    AFinished = y.LeftEnd >= y.RightEnd;
            } while (!AFinished);
            AFinished = false;

            //rechte grenze des y bereichs einschrnken   <-rightEnd
            xValue = x.LeftEnd;
            do
            {
                AFinished = AConstrainFunction(xValue, y.RightEnd);
                if (!AFinished)
                {
                    if (!(xValue < x.RightEnd))
                    {
                        y.RightEnd -= StepSize;
                        xValue = x.LeftEnd;
                    }
                    else
                        xValue += StepSize;
                }

                if (!AFinished)
                    AFinished = y.RightEnd <= y.LeftEnd; 
            } while (!AFinished);
            
            return;
        }

        public void Propagate(Consts AConsts, ConstrainList AConstrains)
        {
            //einschrnken mit Constrain 4
            limitx(AConstrains.Constrain4);
            limity(AConstrains.Constrain4);

            //einschrnken mit Constrain 5
            limitx(AConstrains.Constrain5);
            limity(AConstrains.Constrain5);

            //einschrnken mit Constrain 6
            limitx(AConstrains.Constrain6);
            limity(AConstrains.Constrain6);
        }
    }

    class Program
    {
        public static Consts CConstants = new Consts();
        public static ConstrainList CConstrains = new ConstrainList(CConstants);

        static void Main(string[] args)
        {
            //Initial Werte aus Constrain C1
            DefRange x = new DefRange("x", -1350, 1350);
            x.LeftEnd = -CConstants.SpaceToMiddleline();
            x.RightEnd = CConstants.SpaceToMiddleline();
            //Initial Werte aus Constrain C2
            DefRange y = new DefRange("y", -1800, 1800);
            Propagator algo = new Propagator(x, y);

            System.Console.WriteLine("Constraint Propagierung");
            System.Console.WriteLine("von 197790 ; 624730 ; 501747");
            System.Console.WriteLine("");
            System.Console.WriteLine("Entfernungen zur i-ten Fahne");
            System.Console.WriteLine("d1= " + CConstants.DistanceToF1() + 
                                     " ; d2 = " + CConstants.DistanceToF2() + 
                                     " ; d3 = " + CConstants.DistanceToF3());
            System.Console.WriteLine("");
            System.Console.WriteLine("Start-Bereiche:");
            System.Console.WriteLine("X = " + x.ToString() + " ; y = " + y.ToString());
            System.Console.WriteLine("");
            System.Console.WriteLine("Berechnung Luft..");
            algo.Propagate(CConstants, CConstrains);
            System.Console.WriteLine("");
            System.Console.WriteLine("Ergebnis:");
            if (x.valide() && y.valide())
            {
                System.Console.WriteLine("X-Achsen Bereich = " + x.ToString());
                System.Console.WriteLine("Y-Achsen Bereich = " + y.ToString());
            } 
            else
                System.Console.WriteLine("kein Ergebnis gefunden, global inkonsistent!");

            System.Console.WriteLine("");
            System.Console.WriteLine("Zum Beenden beliebige Taste drcken!");
            System.Console.ReadKey();
        }
    }
}
