using System;
using System.Collections.Generic;
using System.Text;

namespace ConstrainPropagierung
{
    /*
     * Constrains werden als Funktion dargestellt mit einem boolischen Rckgabewert.
     * Daher wenn eine Belegung x,y der Funktion gegeben wird sagt die Funktion, ja(true) wenn die
     * Belegung gltig ist fr das Constrain sonst nein (false).
     * 
     * Es werden nur 3 Constrains als Funktionen implementiert die aufgestellt wurden,
     * weil die ersten 3 Constraiins sich nur auf eine Variable beziehen und somit sofort
     * in den Wertebereich (Definitionsbereich DOM) einbezogen werden.
     */

    public delegate Boolean Constrain456(Double x, Double y);
    
    class ConstrainList
    {
        protected Consts CConstants;

        public ConstrainList(Consts AConsts)
        {
            CConstants = AConsts;
        }

        public Boolean Constrain4(Double x, Double y)
        {
            //Constrain {x,y | d1-e < sqrt((x1-x)^2 + (y1-y)^2) < d1+e}
            Double AResult = Math.Sqrt(Math.Pow(CConstants.F1.x - x, 2) + Math.Pow(CConstants.F1.y - y, 2));
            return (CConstants.DistanceToF1() - CConstants.DistanceEpsilon < AResult) &&
                   (CConstants.DistanceToF1() + CConstants.DistanceEpsilon > AResult);
        }

        public Boolean Constrain5(Double x, Double y)
        {
            //Constrain {x,y | d2-e < sqrt((x2-x)^2 + (y2-y)^2) < d2+e}
            Double AResult = Math.Sqrt(Math.Pow(CConstants.F2.x - x, 2) + Math.Pow(CConstants.F2.y - y, 2));
            return (CConstants.DistanceToF2() - CConstants.DistanceEpsilon < AResult) &&
                   (CConstants.DistanceToF2() + CConstants.DistanceEpsilon > AResult);
        }

        public Boolean Constrain6(Double x, Double y)
        {
            //Constrain {x,y | d3-e < sqrt((x3-x)^2 + (y3-y)^2) < d3+e}
            Double AResult = Math.Sqrt(Math.Pow(CConstants.F3.x - x, 2) + Math.Pow(CConstants.F3.y - y, 2));
            return (CConstants.DistanceToF3() - CConstants.DistanceEpsilon < AResult) &&
                   (CConstants.DistanceToF3() + CConstants.DistanceEpsilon > AResult);
        }
    }
}
