#!/usr/bin/env python
# encoding: utf-8
"""
PCP.py
    (Positionsfindung via Constraint Propagation)

Stefan Herkt            185873
Sebastian Jänisch       


Das Programm arbeitet auf Grundlage des AC-3 Algorithmus.

        Für eine allgemein-gültige Version, siehe: http://aima.cs.berkeley.edu/python/csp.html
"""

import sys
import os

class Config(object):
    """
    verwaltet Daten des Programms
    """
    def __init__(self):
        pass

# wir wollen via Flaggenfarbe aufs Flaggenarray zugreifen
rot_blau = 0
rot_gelb = 1
blau_rot = 2

"""
Initialisierung der Variablen und Konstanten
"""
def engage(data):
    # Flagge 1 - rot, blau(, weiß)          ...  50px
    # Flagge 2 - rot, gelb                  ...  43px
    # Flagge 3 - blau, rot                  ...  33px
#    data.Flaggen_Distanz = [1950, 3330, 1950]          # mitte der strecke von 1 und 3
#    data.Flaggen_Distanz = [2370, 2370, 2370]          # Mittelpunkt # 0,0
    data.Flaggen_Distanz = [1776, 2053, 2652]          # Daten aus Aufgabe 2

    x = 1350
    y = 1950
    data.Flaggen_Position = [{"x":-x, "y":y}, {"x":x, "y":y}, {"x":-x, "y":-y}]
    
    data.Fehler = 0.05
    # berechnen der möglichen Distanz unter Berücksichtigung des Fehlers
    data.Flaggen_Distanz_max = [int(distanz * (1 + data.Fehler)) for distanz in data.Flaggen_Distanz]
    data.Flaggen_Distanz_min = [int(distanz * (1 - data.Fehler)) for distanz in data.Flaggen_Distanz]
    
    data.Dom = {"x":range(-3000,3000+1) , "y":range(-2000,2000+1), "position":[]}


def isReachable(wert, achse):
    reachable = [False, False, False]
    for flagge in range(3):
        if (wert <= (data.Flaggen_Position[flagge][achse] + data.Flaggen_Distanz_max[flagge])) \
            and (wert >= (data.Flaggen_Position[flagge][achse] - data.Flaggen_Distanz_max[flagge])):
            reachable[flagge] = True
        else:
            # lazy evaluation ... wenn es von einer Flagge aus nicht erreichbar ist, ist es uninteressant
            break
    # muss von allen Flaggen aus erreichbar sein
    return reachable == [True, True, True]


def isPointReachable(x,y):
    reachable = [False, False, False]
    # für jede der 3 Flaggen
    for flagge in range(3):
        ## berechne Abstand Punkt zu Flagge
        Abstand = int(((x - data.Flaggen_Position[flagge]["x"])**2 + (y - data.Flaggen_Position[flagge]["y"])**2)**0.5)
#        print "(x,y) =>", x, y, " Abstand:", Abstand
        if (Abstand >= data.Flaggen_Distanz_min[flagge]) and (Abstand <= data.Flaggen_Distanz_max[flagge]):
            reachable[flagge] = True
        else:
            # lazy evaluation ... wenn es von einer Flagge aus nicht erreichbar ist, ist es uninteressant
            break
    # Punkt muss von allen Flaggen aus erreichbar sein
#    if y == 0: print x,y, " => ", reachable
    return reachable == [True, True, True]
    


def findLikelyPositions(data):
    # Extraconstraints, damit das Programm schneller läuft - x & y Werte auslöschen
    for Var in data.Dom.keys():
        # noch brauchen wir Position nicht evaluieren
        if Var == "position":
            continue
        newDom = []
        for elem in data.Dom[Var]:
            if isReachable(elem, Var):
                newDom.append(elem)
        data.Dom[Var] = newDom
    
    #ab hier wird die Position interessant
    # iteriere über alle verbliebenen Punkte
    for x in data.Dom["x"]:
        for y in data.Dom["y"]:
            if isPointReachable(x, y):
                data.Dom["position"].append((x,y))



"""
Ausgabe der möglichen Positionen des Roboters
"""
def prettyPrint(data):
    print data.Dom["position"]
    print
#    print "x:", len(data.Dom["x"]), "- y:", len(data.Dom["y"])
    print len(data.Dom["position"]), "Möglichkeiten"

data = Config()
engage(data)
findLikelyPositions(data)
prettyPrint(data)
