/* enthaelt die Daten eines Referenzpunktes, d.h. seine Position auf dem Feld und die gemessene Entfernung des Roboters zum Punkt (als Intervall) */
public class ReferencePoint extends P2D {
	public Interval dist;

	// Konstruktor, klar
	public ReferencePoint(int x, int y) {
		super(x, y);
		this.dist = null;
	}
	
	// Ausgabe als String
	public String toString() {
		return "(" + x + "," + y + ":" + dist+")";	
	}
	
	/* Methoden, die die Eckpunkte eines durch die gemessene Distanz beschraenkenden Rechtecks um den Referenzpunkt zurueckgeben */
	public int minX() {
		return x-dist.upper;
	}
	
	public int maxX() {
		return x+dist.upper;
	}
	
	public int maxY() {
		return y+dist.upper;
	}
	
	public int minY() {
		return y-dist.upper;
	}
}