/*
 * main.cpp
 *
 *  Created on: 15.05.2009
 *      Author: ingmar
 */
#include <odemx/odemx.h>
#include <iostream>

class Message : public odemx::sync::PortData {

};

class Sender : public odemx::base::Process {
	odemx::sync::PortHead::Ptr _port;

public:
	Sender(odemx::base::Simulation& sim, odemx::sync::PortHead::Ptr& port):
		odemx::base::Process(sim, "sender"), _port(port) {
	}

	int main () {
		while (true) {
			holdFor(3);
			_port->getTail()->put(new Message());
			holdFor(5);
			_port->getTail()->put(new Message());
			holdFor(3);
			_port->getTail()->put(new Message());
		}
		return 0;
	}
};

class Receiver : public odemx::base::Process {
	odemx::sync::PortHead::Ptr _port;
	odemx::sync::Timer* _timer;

	int _timeout;

public:
	Receiver(odemx::base::Simulation& sim, odemx::sync::PortHead::Ptr& port, int timeout):
		odemx::base::Process(sim, "receiver"), _port(port), _timeout(timeout) {
		_timer = new odemx::sync::Timer(sim, "timer");
	}

	int main () {
		while (true) {
			_timer->setIn(_timeout);
			odemx::sync::IMemory* who = wait(_timer, _port.get() );
			if (who == _timer) {
				std::cout << getSimulation().getTime() << ": timeout" << std::endl;
			} else if ( who == _port.get()) {
				std::auto_ptr< odemx::sync::PortData* > data = _port->get();
				std::cout << getSimulation().getTime() << ": received message" << std::endl;
			}
		}
		return 0;
	}

};

class MySimulation : public odemx::base::Simulation {

	int _timeout;

public:

	MySimulation (int timeout): odemx::base::Simulation(), _timeout(timeout) {

	}

	void initSimulation() {
		odemx::sync::PortHead::Ptr port = odemx::sync::PortHead::create(*this, "port");
		Sender* sender = new Sender(*this, port);
		Receiver* receiver = new Receiver(*this, port, _timeout);

		sender->activate();
		receiver->activate();
	}

};

int main( int argc, char* argv[] )
{

	MySimulation* mySim = new MySimulation(4);
	mySim->runUntil( 20 );

	MySimulation* mySim2 = new MySimulation(2);
	mySim2->runUntil( 20 );

	return 0;
}
