/*
 * main.cpp
 *
 *  Created on: 15.05.2009
 *      Author: ingmar
 */

#include "odemx/odemx.h"

class Runner : public odemx::base::Process {

	odemx::random::ContinuousDist * random_sleep;
	odemx::statistics::Count * counter;
	odemx::statistics::Tally * sleep_statistic;

public:
	Runner (odemx::base::Simulation& sim,
			odemx::random::ContinuousDist * random_sleep,
			odemx::statistics::Count * counter,
			odemx::statistics::Tally * sleep_statistic):
		odemx::base::Process(sim, "Runner"), random_sleep(random_sleep), counter(counter), sleep_statistic(sleep_statistic) {

	}

	int main () {
		while (1) {
			debug << log("going to sleep for some random time");
			counter->update(1);
			double sleep_time = random_sleep->sample();
			sleep_statistic->update(sleep_time);
			holdFor(sleep_time);
		}
		return 0;
	}
};

class CustomSimulation : public odemx::base::Simulation {

	//THE process
	Runner* runner;

	//random number generator
	odemx::random::ContinuousDist * random_sleep;

	//statistic
	odemx::statistics::Count * counter;
	odemx::statistics::Tally * sleep_statistic;

	//statistic buffer
	odemx::data::buffer::StatisticsBufferPtr statisticsbuffer;

public:
	void initSimulation () {

		//some random generator
		random_sleep = new odemx::random::Normal(*this, "random_sleep", 0.5, 0.2);

		//some statistics object
		counter = new odemx::statistics::Count(*this, "counter");
		sleep_statistic = new odemx::statistics::Tally(*this, "sleep_statistic");

		runner = new Runner(*this, random_sleep, counter, sleep_statistic);
		runner->activate();

		//record everything in an xml file
		enableDefaultLogging(odemx::data::output::XML, "default_logging");

		//save the trace in another xml file
		odemx::data::output::XmlWriterPtr xmlwriter = odemx::data::output::XmlWriter::create("xmlwriter");
		addConsumer(odemx::data::channel_id::trace, xmlwriter);

		//print custom debug messages on std::cout
		odemx::data::output::OStreamWriterPtr debugwriter = odemx::data::output::OStreamWriter::create(std::cout);
		addConsumer(odemx::data::channel_id::debug, debugwriter);

		//record all statistics for later report generation
		statisticsbuffer = odemx::data::buffer::StatisticsBuffer::create (*this, "statisticsbuffer", true);
		this->addConsumer (odemx::data::channel_id::statistics, statisticsbuffer);
	};

	~CustomSimulation() {
		//generate report
		odemx::data::output::XmlReport xmlReport("report.xml");
		//directly from report generators
		xmlReport.addReportProducer (*counter);
		xmlReport.addReportProducer (*sleep_statistic);
		//everything else from the statistics buffer
		xmlReport.addReportProducer(*statisticsbuffer);
		//write everything
		xmlReport.generateReport ();

		//delete process, resources and random number generator
		delete runner;
		delete random_sleep;
	}
};

int main( int argc, char* argv[] )
{
	CustomSimulation* sim = new CustomSimulation();
	sim->runUntil(30);

	delete sim;

	return 0;
}
