%====================================================%
%  SIMULATION EINES BioLoid                          %
%  (C) 16.12.2005                                    %
%  Heinrich Mellmann                                 %
%====================================================%
% init: beschreibt die Anfangsbedingungen fr die    %
%       Simulation des BioLoiden                     %
%====================================================%
function [x_0] = init()

%--------------------------------------------------------------------------
% Anfangsbedingungen
% [alpha(t), beta(t), gamma(t), l(t),alpha'(t), beta'(t), gamma'(t), l'(t)]
% Bem.: die Parameter  alpha'(t), beta'(t), gamma'(t), l'(t) beschreiben
% die Anfangsgeschwindigkeiten der jeweiligen Gelenke;
%--------------------------------------------------------------------------
x_0=[   pi/4, % alpha(t)
        pi/6, % beta(t)
        pi/6, % gamma(t)
        1,    % l(t)
        0,    % alpha'(t)
        0,    % beta'(t)
        0,    % gamma'(t)
        0     % l'(t)
    ];
