/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.OptionArgumentsSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.ValidationErrorBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ValidationErrorBuilderImpl
implements ValidationErrorBuilder {
    private final List<ArgumentValidationException.ValidationError> m_validationException = new ArrayList<ArgumentValidationException.ValidationError>();

    ValidationErrorBuilderImpl() {
    }

    @Override
    public void missingValue(OptionArgumentsSpecification optionSpecification) {
        this.m_validationException.add(ArgumentValidationException.createMissingValueError(optionSpecification));
    }

    @Override
    public void unexpectedAdditionalValues(OptionArgumentsSpecification optionSpecification) {
        this.m_validationException.add(ArgumentValidationException.createAdditionalValuesError(optionSpecification));
    }

    @Override
    public void unexpectedOption(String name) {
        this.m_validationException.add(ArgumentValidationException.createUnexpectedOptionError(name));
    }

    @Override
    public void unexpectedValue(OptionArgumentsSpecification optionSpecification) {
        this.m_validationException.add(ArgumentValidationException.createUnexpectedValueError(optionSpecification));
    }

    @Override
    public void missingOption(OptionArgumentsSpecification optionSpecification) {
        this.m_validationException.add(ArgumentValidationException.createMissingOptionError(optionSpecification));
    }

    @Override
    public void invalidValueForType(OptionArgumentsSpecification optionSpecification, String message) {
        this.m_validationException.add(ArgumentValidationException.createInvalidValueForType(optionSpecification, message));
    }

    @Override
    public void unableToConstructType(OptionArgumentsSpecification optionSpecification, String message) {
        this.m_validationException.add(ArgumentValidationException.createUnableToConstructType(optionSpecification, message));
    }

    @Override
    public void patternMismatch(OptionArgumentsSpecification optionSpecification, String value2) {
        this.m_validationException.add(ArgumentValidationException.createPatternMismatch(optionSpecification, value2));
    }

    @Override
    public void helpRequested(OptionsSpecification<?> specification) {
        this.m_validationException.add(ArgumentValidationException.createhelpRequested(specification));
    }

    @Override
    public void validate() throws ArgumentValidationException {
        if (this.m_validationException.size() > 0) {
            for (ArgumentValidationException.ValidationError error : this.m_validationException) {
                if (!ArgumentValidationException.ValidationError.ErrorType.HelpRequested.equals((Object)error.getErrorType())) continue;
                throw new ArgumentValidationException(Arrays.asList(error));
            }
            throw new ArgumentValidationException(this.m_validationException);
        }
    }
}

