/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.co.flamingpenguin.jewel.cli.ArgumentCollection;
import uk.co.flamingpenguin.jewel.cli.ArgumentCollectionImpl;
import uk.co.flamingpenguin.jewel.cli.ArgumentParser;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;

class ParsedArgumentsBuilder
implements ArgumentParser {
    private final Map<String, List<String>> m_arguments = new LinkedHashMap<String, List<String>>();
    private final List<String> m_unparsed = new ArrayList<String>();
    private ParsingState m_state = ParsingState.Initial;
    private List<String> m_currentValues;

    ParsedArgumentsBuilder() {
    }

    public ArgumentCollection parseArguments(String ... arguments) throws ArgumentValidationException {
        for (String argument : arguments) {
            this.add(argument);
        }
        return this.getParsedArguments();
    }

    void add(String argument) throws ArgumentValidationException {
        if (this.startsWithDash(argument) && !this.m_state.equals((Object)ParsingState.Unparsed)) {
            if (this.startsWithDoubleDash(argument)) {
                if (argument.length() > 2) {
                    this.addOptionAndValue(argument);
                } else {
                    this.changeToUnparsedState();
                }
            } else {
                this.addConjoinedOptions(argument.substring(1));
            }
        } else {
            this.addValue(argument);
        }
    }

    private void addConjoinedOptions(String options) throws ArgumentValidationException {
        for (int i = 0; i < options.length(); ++i) {
            this.addOption(options.substring(i, i + 1));
        }
    }

    private void addOptionAndValue(String argument) throws ArgumentValidationException {
        if (argument.contains("=")) {
            int separatorIndex = argument.indexOf("=");
            this.addOption(argument.substring(2, separatorIndex).trim());
            if (argument.length() > separatorIndex + 1) {
                this.addValue(argument.substring(separatorIndex + 1).trim());
            }
        } else {
            this.addOption(argument.substring(2, argument.length()).trim());
        }
    }

    private void addValue(String value2) {
        switch (this.m_state) {
            case Initial: {
                this.m_state = ParsingState.NoOptions;
            }
            case NoOptions: 
            case Unparsed: {
                this.m_unparsed.add(value2);
                break;
            }
            case OptionOrValue: {
                this.m_currentValues.add(value2);
            }
        }
    }

    private void addOption(final String option) throws ArgumentValidationException {
        switch (this.m_state) {
            case Initial: 
            case OptionOrValue: {
                this.m_state = ParsingState.OptionOrValue;
                this.m_currentValues = new ArrayList<String>();
                this.m_arguments.put(option, this.m_currentValues);
                break;
            }
            case NoOptions: 
            case Unparsed: {
                throw new ArgumentValidationException(new ArgumentValidationException.ValidationError(){

                    public ArgumentValidationException.ValidationError.ErrorType getErrorType() {
                        return ArgumentValidationException.ValidationError.ErrorType.MisplacedOption;
                    }

                    public String getMessage() {
                        return option;
                    }

                    public String toString() {
                        return String.format("Option not expected in this position: %s", this.getMessage());
                    }
                });
            }
        }
    }

    ArgumentCollection getParsedArguments() {
        LinkedHashMap<String, List<String>> finalArguments = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.m_arguments.entrySet()) {
            finalArguments.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return new ArgumentCollectionImpl(finalArguments, new ArrayList<String>(this.m_unparsed));
    }

    private void changeToUnparsedState() {
        this.m_currentValues = null;
        this.m_state = ParsingState.Unparsed;
    }

    private boolean startsWithDash(String argument) {
        return argument.length() > 1 && argument.startsWith("-");
    }

    private boolean startsWithDoubleDash(String argument) {
        return argument.startsWith("--");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParsingState {
        Initial,
        OptionOrValue,
        NoOptions,
        Unparsed;

    }
}

