/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import uk.co.flamingpenguin.jewel.cli.ArgumentMethodSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionMethodSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionNotPresentException;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.TypedArguments;
import uk.co.flamingpenguin.jewel.cli.Unparsed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArgumentInvocationHandler<O>
implements InvocationHandler {
    private final OptionsSpecification<O> m_specification;
    private final Class<O> m_klass;
    private final TypedArguments m_arguments;

    ArgumentInvocationHandler(Class<O> klass, OptionsSpecification<O> specification, TypedArguments arguments) {
        this.m_klass = klass;
        this.m_specification = specification;
        this.m_arguments = arguments;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args == null) {
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("toString")) {
                return this.toString();
            }
        }
        if (args != null && args.length == 1 && method.getName().equals("equals")) {
            Object that = args[0];
            return Proxy.isProxyClass(that.getClass()) && Proxy.getInvocationHandler(that).equals(this);
        }
        if (args != null && args.length != 0) {
            throw new UnsupportedOperationException(String.format("Method (%s) with arguments not supported for reading argument values", method.toGenericString()));
        }
        if (method.isAnnotationPresent(Unparsed.class)) {
            return this.m_arguments.getUnparsedValue();
        }
        if (this.m_specification.hasUnparsedSpecification() && this.m_specification.getUnparsedSpecification().isOptional() && this.m_specification.getUnparsedSpecification().getOptionalityMethod().equals(method)) {
            return this.m_arguments.hasUnparsedValue();
        }
        if (!this.m_specification.isSpecified(method)) {
            throw new UnsupportedOperationException(String.format("Method (%s) is not annotated for option specification", method.toGenericString()));
        }
        OptionMethodSpecification specification = this.m_specification.getSpecification(method);
        if (this.m_specification.isExistenceChecker(method) || !specification.hasValue()) {
            return this.optionPresent(this.m_arguments, specification);
        }
        return this.getValue(this.m_arguments, method, specification);
    }

    private Object optionPresent(TypedArguments arguments, ArgumentMethodSpecification specification) {
        return arguments.contains(specification);
    }

    private Object getValue(TypedArguments arguments, Method method, ArgumentMethodSpecification specification) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object value2 = arguments.getValue(specification);
        if (value2 == null) {
            throw new OptionNotPresentException(specification);
        }
        return value2;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("Option values for ").append(this.m_klass.getCanonicalName()).append(":");
        ArrayList<String> values2 = new ArrayList<String>();
        for (OptionMethodSpecification methodSpecification : this.m_specification) {
            if (methodSpecification.isHelpOption() || !this.m_arguments.contains(methodSpecification)) continue;
            StringBuilder valueString = new StringBuilder();
            valueString.append("--").append(methodSpecification.getLongName());
            if (methodSpecification.hasValue()) {
                Object value2 = this.m_arguments.getValue(methodSpecification);
                valueString.append(" ");
                valueString.append(this.formatValue(value2));
            }
            values2.add(valueString.toString());
        }
        if (this.m_specification.hasUnparsedSpecification() && this.m_arguments.hasUnparsedValue()) {
            values2.add(this.formatValue(this.m_arguments.getUnparsedValue()));
        }
        if (!values2.isEmpty()) {
            result2.append(" ").append(this.join(values2));
        }
        return result2.toString();
    }

    private String formatValue(Object value2) {
        if (value2 instanceof Iterable) {
            Iterable valueIterable = (Iterable)value2;
            return this.join(valueIterable);
        }
        return "" + value2;
    }

    private String join(Iterable<?> valueIterable) {
        StringBuilder result2 = new StringBuilder();
        String seperator = "";
        for (Object object : valueIterable) {
            result2.append(seperator).append(object);
            seperator = " ";
        }
        return result2.toString();
    }
}

