/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.NameToStructureConfig;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.WordRule;
import uk.ac.cam.ch.wwmm.opsin.WordType;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WordRules {
    private final List<WordRuleDescription> wordRuleList = new ArrayList<WordRuleDescription>();

    WordRules(ResourceGetter resourceGetter) throws IOException {
        Element wordRules = resourceGetter.getXMLDocument("wordRules.xml").getRootElement();
        Elements rules = wordRules.getChildElements("wordRule");
        for (int i = 0; i < rules.size(); ++i) {
            this.wordRuleList.add(new WordRuleDescription(rules.get(i)));
        }
    }

    void groupWordsIntoWordRules(NameToStructureConfig n2sConfig, Element moleculeEl, boolean allowSpaceRemoval) throws ParsingException {
        List<Element> wordEls = XOMTools.getChildElementsWithTagName(moleculeEl, "word");
        for (int i = 0; i < wordEls.size(); ++i) {
            if (!this.matchWordRule(n2sConfig, wordEls, i, allowSpaceRemoval)) continue;
            i = -1;
        }
        Elements wordRuleEls = moleculeEl.getChildElements();
        for (int i = 0; i < wordRuleEls.size(); ++i) {
            Element wordRuleEl = wordRuleEls.get(i);
            if (wordRuleEl.getLocalName().equals("wordRule")) continue;
            throw new ParsingException("Unable to assign wordRule to: " + wordRuleEl.getValue());
        }
    }

    private boolean matchWordRule(NameToStructureConfig n2sConfig, List<Element> wordEls, int indexOfFirstWord, boolean allowSpaceRemoval) throws ParsingException {
        Iterator<WordRuleDescription> i$ = this.wordRuleList.iterator();
        block0: while (i$.hasNext()) {
            Element possibleElementaryAtom;
            List<Element> elementaryAtoms;
            int i = indexOfFirstWord;
            WordRuleDescription wordRuleDesc = i$.next();
            int wordsInWordRule = wordRuleDesc.wordDescriptions.size();
            if (i + wordsInWordRule - 1 >= wordEls.size()) continue;
            for (int j = 0; j < wordsInWordRule; ++j) {
                Element lastGroupInWordRule;
                Element wordEl = wordEls.get(i + j);
                WordDescription wd = (WordDescription)wordRuleDesc.wordDescriptions.get(j);
                if (!wd.type.toString().equals(wordEl.getAttributeValue("type")) || wd.getValue() != null && !wordEl.getAttributeValue("value").toLowerCase().equals(wd.getValue())) continue block0;
                if (wd.functionalGroupType != null && WordType.functionalTerm.toString().equals(wordEl.getAttributeValue("type"))) {
                    Elements children2 = wordEl.getChildElements();
                    Element lastChild = children2.get(children2.size() - 1);
                    while (lastChild.getChildElements().size() != 0) {
                        children2 = lastChild.getChildElements();
                        lastChild = children2.get(children2.size() - 1);
                    }
                    if (lastChild.getLocalName().equals("closebracket")) {
                        lastChild = (Element)XOMTools.getPreviousSibling(lastChild);
                    }
                    if (lastChild == null) {
                        throw new ParsingException("OPSIN Bug: Cannot find the functional element in a functionalTerm");
                    }
                    if (!wd.getFunctionalGroupType().equals(lastChild.getAttributeValue("type"))) continue block0;
                }
                if (wd.endsWithPattern != null && !wd.endsWithPattern.matcher(wordEl.getAttributeValue("value")).find() || wd.endsWithGroupValueAtr != null && ((lastGroupInWordRule = this.getLastGroupInWordRule(wordEl)) == null || !wd.endsWithGroupValueAtr.equals(lastGroupInWordRule.getAttributeValue("value"))) || wd.endsWithGroupType != null && ((lastGroupInWordRule = this.getLastGroupInWordRule(wordEl)) == null || !wd.endsWithGroupType.equals(lastGroupInWordRule.getAttributeValue("type"))) || wd.endsWithGroupSubType != null && ((lastGroupInWordRule = this.getLastGroupInWordRule(wordEl)) == null || !wd.endsWithGroupSubType.equals(lastGroupInWordRule.getAttributeValue("subType")))) continue block0;
            }
            Element wordRuleEl = new Element("wordRule");
            wordRuleEl.addAttribute(new Attribute("type", wordRuleDesc.getRuleType().toString()));
            wordRuleEl.addAttribute(new Attribute("wordRule", wordRuleDesc.getRuleName().toString()));
            WordRule wordRule = wordRuleDesc.getRuleName();
            if (wordRule == WordRule.functionGroupAsGroup) {
                Element functionalWord = wordEls.get(i + wordsInWordRule - 1);
                if (!functionalWord.getAttributeValue("type").equals("functionalTerm") || wordsInWordRule > 2) {
                    throw new ParsingException("OPSIN bug: Problem with functionGroupAsGroup wordRule");
                }
                this.convertFunctionalGroupIntoGroup(functionalWord);
                if (wordsInWordRule == 2) {
                    this.joinWords(wordEls, i, wordEls.get(i), functionalWord);
                    wordsInWordRule = 1;
                }
                wordRuleEl.getAttribute("wordRule").setValue(WordRule.simple.toString());
            } else if (wordRule == WordRule.carbonylDerivative || wordRule == WordRule.amide) {
                if (wordsInWordRule == 3) {
                    this.joinWords(wordEls, i + 1, wordEls.get(i + 1), wordEls.get(i + 2));
                    --wordsInWordRule;
                    List<Element> functionalTerm = XOMTools.getDescendantElementsWithTagName(wordEls.get(i + 1), "functionalTerm");
                    if (functionalTerm.size() != 1) {
                        throw new ParsingException("OPSIN bug: Problem with " + (Object)((Object)wordRule) + " wordRule");
                    }
                    functionalTerm.get(0).setLocalName("root");
                    List<Element> functionalGroups = XOMTools.getDescendantElementsWithTagName(functionalTerm.get(0), "functionalGroup");
                    if (functionalGroups.size() != 1) {
                        throw new ParsingException("OPSIN bug: Problem with " + (Object)((Object)wordRule) + " wordRule");
                    }
                    functionalGroups.get(0).setLocalName("group");
                    wordEls.get(i + 1).getAttribute("type").setValue(WordType.full.toString());
                }
            } else if ((wordRule == WordRule.additionCompound || wordRule == WordRule.oxide) && (elementaryAtoms = XOMTools.getDescendantElementsWithTagNameAndAttribute(possibleElementaryAtom = wordEls.get(i), "group", "subType", "elementaryAtom")).size() == 1) {
                for (int j = 1; j < wordsInWordRule; ++j) {
                    if (this.bondWillBeIonic(elementaryAtoms.get(0), wordEls.get(i + j))) continue block0;
                }
            }
            ArrayList<String> wordValues = new ArrayList<String>();
            Element parentEl = (Element)wordEls.get(i).getParent();
            int indexToInsertAt = parentEl.indexOf(wordEls.get(i));
            for (int j = 0; j < wordsInWordRule; ++j) {
                Element wordEl = wordEls.remove(i);
                wordEl.detach();
                wordRuleEl.appendChild(wordEl);
                wordValues.add(wordEl.getAttributeValue("value"));
            }
            wordRuleEl.addAttribute(new Attribute("value", StringTools.stringListToString(wordValues, " ")));
            parentEl.insertChild(wordRuleEl, indexToInsertAt);
            wordEls.add(i, wordRuleEl);
            return true;
        }
        Element firstWord = wordEls.get(indexOfFirstWord);
        if (firstWord.getLocalName().equals("word") && WordType.full.toString().equals(firstWord.getAttributeValue("type"))) {
            this.applySimpleWordRule(wordEls, indexOfFirstWord, firstWord);
            return false;
        }
        if (allowSpaceRemoval && WordType.substituent.toString().equals(firstWord.getAttributeValue("type")) && indexOfFirstWord + 1 < wordEls.size()) {
            Element wordToPotentiallyCombineWith = wordEls.get(indexOfFirstWord + 1);
            if (WordType.full.toString().equals(wordToPotentiallyCombineWith.getAttributeValue("type")) || WordType.substituent.toString().equals(wordToPotentiallyCombineWith.getAttributeValue("type"))) {
                this.joinWords(wordEls, indexOfFirstWord, firstWord, wordToPotentiallyCombineWith);
                return true;
            }
        }
        if (n2sConfig.isAllowRadicals() && wordEls.size() == 1 && indexOfFirstWord == 0 && firstWord.getLocalName().equals("word") && WordType.substituent.toString().equals(firstWord.getAttributeValue("type"))) {
            this.applySubstituentWordRule(wordEls, indexOfFirstWord, firstWord);
        }
        return false;
    }

    private Element getLastGroupInWordRule(Element wordEl) {
        Elements children2 = wordEl.getChildElements();
        Element lastChild = children2.get(children2.size() - 1);
        while (lastChild.getChildElements().size() != 0) {
            children2 = lastChild.getChildElements();
            lastChild = children2.get(children2.size() - 1);
        }
        if (lastChild.getLocalName().equals("group")) {
            return lastChild;
        }
        Elements groups = ((Element)lastChild.getParent()).getChildElements("group");
        if (groups.size() > 0) {
            return groups.get(groups.size() - 1);
        }
        return null;
    }

    private void applySimpleWordRule(List<Element> wordEls, int indexOfFirstWord, Element firstWord) {
        Element parentEl = (Element)firstWord.getParent();
        int indexToInsertAt = parentEl.indexOf(firstWord);
        Element wordRuleEl = new Element("wordRule");
        wordRuleEl.addAttribute(new Attribute("wordRule", WordRule.simple.toString()));
        wordRuleEl.addAttribute(new Attribute("type", WordType.full.toString()));
        wordRuleEl.addAttribute(new Attribute("value", firstWord.getAttributeValue("value")));
        firstWord.detach();
        wordRuleEl.appendChild(firstWord);
        wordEls.set(indexOfFirstWord, wordRuleEl);
        parentEl.insertChild(wordRuleEl, indexToInsertAt);
    }

    private void applySubstituentWordRule(List<Element> wordEls, int indexOfFirstWord, Element firstWord) {
        Element parentEl = (Element)firstWord.getParent();
        int indexToInsertAt = parentEl.indexOf(firstWord);
        Element wordRuleEl = new Element("wordRule");
        wordRuleEl.addAttribute(new Attribute("wordRule", WordRule.substituent.toString()));
        wordRuleEl.addAttribute(new Attribute("type", WordType.full.toString()));
        wordRuleEl.addAttribute(new Attribute("value", firstWord.getAttributeValue("value")));
        firstWord.detach();
        wordRuleEl.appendChild(firstWord);
        wordEls.set(indexOfFirstWord, wordRuleEl);
        parentEl.insertChild(wordRuleEl, indexToInsertAt);
    }

    private void joinWords(List<Element> wordEls, int indexOfFirstWord, Element firstWord, Element wordToPotentiallyCombineWith) throws ParsingException {
        wordEls.remove(indexOfFirstWord + 1);
        wordToPotentiallyCombineWith.detach();
        Elements substituentEls = firstWord.getChildElements("substituent");
        if (substituentEls.size() == 0) {
            throw new ParsingException("OPSIN Bug: Substituent element not found where substituent element expected");
        }
        Element finalSubstituent = substituentEls.get(substituentEls.size() - 1);
        Elements finalSubstituentChildren = finalSubstituent.getChildElements();
        if (!finalSubstituentChildren.get(finalSubstituentChildren.size() - 1).getLocalName().equals("hyphen")) {
            Element implicitHyphen = new Element("hyphen");
            implicitHyphen.appendChild("-");
            finalSubstituent.appendChild(implicitHyphen);
        }
        Elements elementsToMergeIntoSubstituent = wordToPotentiallyCombineWith.getChildElements();
        for (int j = elementsToMergeIntoSubstituent.size() - 1; j >= 0; --j) {
            Element el = elementsToMergeIntoSubstituent.get(j);
            el.detach();
            XOMTools.insertAfter(finalSubstituent, el);
        }
        if (WordType.full.toString().equals(wordToPotentiallyCombineWith.getAttributeValue("type"))) {
            firstWord.getAttribute("type").setValue(WordType.full.toString());
        }
        firstWord.getAttribute("value").setValue(firstWord.getAttributeValue("value") + wordToPotentiallyCombineWith.getAttributeValue("value"));
    }

    private void convertFunctionalGroupIntoGroup(Element word) throws ParsingException {
        word.getAttribute("type").setValue(WordType.full.toString());
        List<Element> functionalTerms = XOMTools.getDescendantElementsWithTagName(word, "functionalTerm");
        if (functionalTerms.size() != 1) {
            throw new ParsingException("OPSIN Bug: Exactly 1 functionalTerm expected in functionalGroupAsGroup wordRule");
        }
        functionalTerms.get(0).setLocalName("root");
        Elements functionalGroups = functionalTerms.get(0).getChildElements("functionalGroup");
        if (functionalGroups.size() != 1) {
            throw new ParsingException("OPSIN Bug: Exactly 1 functionalGroup expected in functionalGroupAsGroup wordRule");
        }
        functionalGroups.get(0).setLocalName("group");
        functionalGroups.get(0).getAttribute("type").setValue("simpleGroup");
        functionalGroups.get(0).addAttribute(new Attribute("subType", "simpleGroup"));
    }

    private boolean bondWillBeIonic(Element elementaryAtomEl, Element functionalWord) throws ParsingException {
        List<Element> functionalGroups;
        String element1 = elementaryAtomEl.getAttributeValue("value");
        if (element1.startsWith("[")) {
            element1 = element1.substring(1, element1.length() - 1);
        }
        if ((functionalGroups = XOMTools.getDescendantElementsWithTagName(functionalWord, "functionalGroup")).size() != 1) {
            throw new ParsingException("OPSIN bug: Unable to find functional group in oxide or addition compound rule");
        }
        String smiles = functionalGroups.get(0).getAttributeValue("value");
        String element2 = "";
        for (int i = 0; i < smiles.length(); ++i) {
            if (!Character.isUpperCase(smiles.charAt(i))) continue;
            element2 = element2 + smiles.charAt(i);
            if (i + 1 >= smiles.length() || !Character.isLowerCase(smiles.charAt(i + 1))) break;
            element2 = element2 + smiles.charAt(i + 1);
            break;
        }
        return !FragmentTools.isCovalent(element1, element2);
    }

    static class WordRuleDescription {
        private final List<WordDescription> wordDescriptions = new ArrayList<WordDescription>();
        private final WordRule ruleName;
        private final WordType ruleType;

        WordRule getRuleName() {
            return this.ruleName;
        }

        WordType getRuleType() {
            return this.ruleType;
        }

        WordRuleDescription(Element wordRuleEl) {
            this.ruleName = WordRule.valueOf(wordRuleEl.getAttributeValue("name"));
            this.ruleType = WordType.valueOf(wordRuleEl.getAttributeValue("type"));
            Elements words = wordRuleEl.getChildElements();
            for (int i = 0; i < words.size(); ++i) {
                Element word = words.get(i);
                WordDescription wd = new WordDescription(WordType.valueOf(word.getAttributeValue("type")));
                if (word.getAttribute("value") != null) {
                    wd.setValue(word.getAttributeValue("value"));
                }
                if (word.getAttribute("functionalGroupType") != null) {
                    wd.setFunctionalGroupType(word.getAttributeValue("functionalGroupType"));
                }
                if (word.getAttribute("endsWithRegex") != null) {
                    wd.setEndsWithPattern(Pattern.compile(word.getAttributeValue("endsWithRegex") + "$", 2));
                }
                if (word.getAttribute("endsWithGroupValueAtr") != null) {
                    wd.setEndsWithGroupValueAtr(word.getAttributeValue("endsWithGroupValueAtr"));
                }
                if (word.getAttribute("endsWithGroupType") != null) {
                    wd.setEndsWithGroupType(word.getAttributeValue("endsWithGroupType"));
                }
                if (word.getAttribute("endsWithGroupSubType") != null) {
                    wd.setEndsWithGroupSubType(word.getAttributeValue("endsWithGroupSubType"));
                }
                this.wordDescriptions.add(wd);
            }
        }
    }

    static class WordDescription {
        private final WordType type;
        private Pattern endsWithPattern = null;
        private String value = null;
        private String functionalGroupType = null;
        private String endsWithGroupValueAtr = null;
        private String endsWithGroupType = null;
        private String endsWithGroupSubType = null;

        WordType getType() {
            return this.type;
        }

        Pattern getEndsWithPattern() {
            return this.endsWithPattern;
        }

        void setEndsWithPattern(Pattern endsWithPattern) {
            this.endsWithPattern = endsWithPattern;
        }

        String getValue() {
            return this.value;
        }

        void setValue(String value2) {
            this.value = value2.toLowerCase();
        }

        String getFunctionalGroupType() {
            return this.functionalGroupType;
        }

        void setFunctionalGroupType(String functionalGroupType) {
            this.functionalGroupType = functionalGroupType;
        }

        String getEndsWithGroupValueAtr() {
            return this.endsWithGroupValueAtr;
        }

        void setEndsWithGroupValueAtr(String endsWithElementValueAtr) {
            this.endsWithGroupValueAtr = endsWithElementValueAtr;
        }

        String getEndsWithGroupType() {
            return this.endsWithGroupType;
        }

        void setEndsWithGroupType(String endsWithElementType) {
            this.endsWithGroupType = endsWithElementType;
        }

        String getEndsWithGroupSubType() {
            return this.endsWithGroupSubType;
        }

        void setEndsWithGroupSubType(String endsWithElementSubType) {
            this.endsWithGroupSubType = endsWithElementSubType;
        }

        WordDescription(WordType wordType) {
            this.type = wordType;
        }
    }
}

