/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.HashMap;
import java.util.Map;
import uk.ac.cam.ch.wwmm.opsin.Atom;

class ValencyChecker {
    private static final Map<String, Integer> expectedDefaultValency = new HashMap<String, Integer>();
    private static final Map<String, Integer> valencyInHW;
    private static final Map<String, HashMap<Integer, Integer[]>> possibleStableValencies;

    ValencyChecker() {
    }

    static Integer getMaximumValency(String symbol, int charge) {
        if (possibleStableValencies.get(symbol) != null && possibleStableValencies.get(symbol).get(charge) != null) {
            return possibleStableValencies.get(symbol).get(charge)[possibleStableValencies.get(symbol).get(charge).length - 1];
        }
        return null;
    }

    static boolean checkValency(Atom a) {
        Integer maxVal;
        int valency = a.getIncomingValency() + a.getOutValency();
        if (a.getLambdaConventionValency() != null) {
            maxVal = a.getLambdaConventionValency() + a.getProtonsExplicitlyAddedOrRemoved();
        } else {
            int charge;
            String symbol = a.getElement();
            maxVal = ValencyChecker.getMaximumValency(symbol, charge = a.getCharge());
            if (maxVal == null) {
                return true;
            }
        }
        return valency <= maxVal;
    }

    static boolean checkValencyAvailableForBond(Atom a, int bondOrder) {
        Integer maxVal;
        int valency = a.getIncomingValency() + bondOrder;
        if (a.getLambdaConventionValency() != null) {
            maxVal = a.getLambdaConventionValency() + a.getProtonsExplicitlyAddedOrRemoved();
        } else {
            int charge;
            String symbol = a.getElement();
            maxVal = ValencyChecker.getMaximumValency(symbol, charge = a.getCharge());
            if (maxVal == null) {
                return true;
            }
        }
        return valency <= maxVal;
    }

    static boolean checkValencyAvailableForReplacementByHeteroatom(Atom a, Atom heteroatom) {
        int valency = a.getIncomingValency();
        valency += a.hasSpareValency() ? 1 : 0;
        Integer maxValOfHeteroAtom = ValencyChecker.getMaximumValency(heteroatom.getElement(), heteroatom.getCharge());
        return maxValOfHeteroAtom == null || (valency += a.getOutValency()) <= maxValOfHeteroAtom;
    }

    static Integer getDefaultValency(String element) {
        return expectedDefaultValency.get(element);
    }

    static Integer getHWValency(String element) {
        return valencyInHW.get(element);
    }

    static Integer[] getPossibleValencies(String element, int charge) {
        if (possibleStableValencies.get(element) == null) {
            return null;
        }
        return possibleStableValencies.get(element).get(charge);
    }

    static {
        expectedDefaultValency.put("B", 3);
        expectedDefaultValency.put("Al", 3);
        expectedDefaultValency.put("In", 3);
        expectedDefaultValency.put("Ga", 3);
        expectedDefaultValency.put("Tl", 3);
        expectedDefaultValency.put("C", 4);
        expectedDefaultValency.put("Si", 4);
        expectedDefaultValency.put("Ge", 4);
        expectedDefaultValency.put("Sn", 4);
        expectedDefaultValency.put("Pb", 4);
        expectedDefaultValency.put("N", 3);
        expectedDefaultValency.put("P", 3);
        expectedDefaultValency.put("As", 3);
        expectedDefaultValency.put("Sb", 3);
        expectedDefaultValency.put("Bi", 3);
        expectedDefaultValency.put("O", 2);
        expectedDefaultValency.put("S", 2);
        expectedDefaultValency.put("Se", 2);
        expectedDefaultValency.put("Te", 2);
        expectedDefaultValency.put("Po", 2);
        expectedDefaultValency.put("F", 1);
        expectedDefaultValency.put("Cl", 1);
        expectedDefaultValency.put("Br", 1);
        expectedDefaultValency.put("I", 1);
        expectedDefaultValency.put("At", 1);
        valencyInHW = new HashMap<String, Integer>();
        valencyInHW.put("F", 1);
        valencyInHW.put("Cl", 1);
        valencyInHW.put("Br", 1);
        valencyInHW.put("I", 1);
        valencyInHW.put("O", 2);
        valencyInHW.put("S", 2);
        valencyInHW.put("Se", 2);
        valencyInHW.put("Te", 2);
        valencyInHW.put("N", 3);
        valencyInHW.put("P", 3);
        valencyInHW.put("As", 3);
        valencyInHW.put("Sb", 3);
        valencyInHW.put("Bi", 3);
        valencyInHW.put("Si", 4);
        valencyInHW.put("Ge", 4);
        valencyInHW.put("Sn", 4);
        valencyInHW.put("Pb", 4);
        valencyInHW.put("B", 3);
        valencyInHW.put("Al", 3);
        valencyInHW.put("Ga", 3);
        valencyInHW.put("In", 3);
        valencyInHW.put("Tl", 3);
        valencyInHW.put("Hg", 2);
        possibleStableValencies = new HashMap<String, HashMap<Integer, Integer[]>>();
        possibleStableValencies.put("H", new HashMap());
        possibleStableValencies.put("He", new HashMap());
        possibleStableValencies.put("Li", new HashMap());
        possibleStableValencies.put("Be", new HashMap());
        possibleStableValencies.put("B", new HashMap());
        possibleStableValencies.put("C", new HashMap());
        possibleStableValencies.put("N", new HashMap());
        possibleStableValencies.put("O", new HashMap());
        possibleStableValencies.put("F", new HashMap());
        possibleStableValencies.put("Ne", new HashMap());
        possibleStableValencies.put("Na", new HashMap());
        possibleStableValencies.put("Mg", new HashMap());
        possibleStableValencies.put("Al", new HashMap());
        possibleStableValencies.put("Si", new HashMap());
        possibleStableValencies.put("P", new HashMap());
        possibleStableValencies.put("S", new HashMap());
        possibleStableValencies.put("Cl", new HashMap());
        possibleStableValencies.put("Ar", new HashMap());
        possibleStableValencies.put("K", new HashMap());
        possibleStableValencies.put("Ca", new HashMap());
        possibleStableValencies.put("Ga", new HashMap());
        possibleStableValencies.put("Ge", new HashMap());
        possibleStableValencies.put("As", new HashMap());
        possibleStableValencies.put("Se", new HashMap());
        possibleStableValencies.put("Br", new HashMap());
        possibleStableValencies.put("Kr", new HashMap());
        possibleStableValencies.put("Rb", new HashMap());
        possibleStableValencies.put("Sr", new HashMap());
        possibleStableValencies.put("In", new HashMap());
        possibleStableValencies.put("Sn", new HashMap());
        possibleStableValencies.put("Sb", new HashMap());
        possibleStableValencies.put("Te", new HashMap());
        possibleStableValencies.put("I", new HashMap());
        possibleStableValencies.put("Xe", new HashMap());
        possibleStableValencies.put("Cs", new HashMap());
        possibleStableValencies.put("Ba", new HashMap());
        possibleStableValencies.put("Tl", new HashMap());
        possibleStableValencies.put("Pb", new HashMap());
        possibleStableValencies.put("Bi", new HashMap());
        possibleStableValencies.put("Po", new HashMap());
        possibleStableValencies.put("At", new HashMap());
        possibleStableValencies.put("Rn", new HashMap());
        possibleStableValencies.put("Fr", new HashMap());
        possibleStableValencies.put("Ra", new HashMap());
        possibleStableValencies.get("H").put(0, new Integer[]{1});
        possibleStableValencies.get("He").put(0, new Integer[]{0});
        possibleStableValencies.get("Li").put(0, new Integer[]{1});
        possibleStableValencies.get("Be").put(0, new Integer[]{2});
        possibleStableValencies.get("B").put(0, new Integer[]{3});
        possibleStableValencies.get("C").put(0, new Integer[]{4});
        possibleStableValencies.get("N").put(0, new Integer[]{3});
        possibleStableValencies.get("O").put(0, new Integer[]{2});
        possibleStableValencies.get("F").put(0, new Integer[]{1});
        possibleStableValencies.get("Ne").put(0, new Integer[]{0});
        possibleStableValencies.get("Na").put(0, new Integer[]{1});
        possibleStableValencies.get("Mg").put(0, new Integer[]{2});
        possibleStableValencies.get("Al").put(0, new Integer[]{3});
        possibleStableValencies.get("Si").put(0, new Integer[]{4});
        possibleStableValencies.get("P").put(0, new Integer[]{3, 5});
        possibleStableValencies.get("S").put(0, new Integer[]{2, 4, 6});
        possibleStableValencies.get("Cl").put(0, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get("Ar").put(0, new Integer[]{0});
        possibleStableValencies.get("K").put(0, new Integer[]{1});
        possibleStableValencies.get("Ca").put(0, new Integer[]{2});
        possibleStableValencies.get("Ga").put(0, new Integer[]{3});
        possibleStableValencies.get("Ge").put(0, new Integer[]{4});
        possibleStableValencies.get("As").put(0, new Integer[]{3, 5});
        possibleStableValencies.get("Se").put(0, new Integer[]{2, 4, 6});
        possibleStableValencies.get("Br").put(0, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get("Kr").put(0, new Integer[]{0, 2});
        possibleStableValencies.get("Rb").put(0, new Integer[]{1});
        possibleStableValencies.get("Sr").put(0, new Integer[]{2});
        possibleStableValencies.get("In").put(0, new Integer[]{3});
        possibleStableValencies.get("Sn").put(0, new Integer[]{2, 4});
        possibleStableValencies.get("Sb").put(0, new Integer[]{3, 5});
        possibleStableValencies.get("Te").put(0, new Integer[]{2, 4, 6});
        possibleStableValencies.get("I").put(0, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get("Xe").put(0, new Integer[]{0, 2, 4, 6, 8});
        possibleStableValencies.get("Cs").put(0, new Integer[]{1});
        possibleStableValencies.get("Ba").put(0, new Integer[]{2});
        possibleStableValencies.get("Tl").put(0, new Integer[]{1, 3});
        possibleStableValencies.get("Pb").put(0, new Integer[]{2, 4});
        possibleStableValencies.get("Bi").put(0, new Integer[]{3, 5});
        possibleStableValencies.get("Po").put(0, new Integer[]{2, 4, 6});
        possibleStableValencies.get("At").put(0, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get("Rn").put(0, new Integer[]{0, 2, 4, 6, 8});
        possibleStableValencies.get("Fr").put(0, new Integer[]{1});
        possibleStableValencies.get("Ra").put(0, new Integer[]{2});
        possibleStableValencies.get("H").put(1, new Integer[]{0});
        possibleStableValencies.get("Li").put(1, new Integer[]{0});
        possibleStableValencies.get("Be").put(1, new Integer[]{1});
        possibleStableValencies.get("Be").put(2, new Integer[]{0});
        possibleStableValencies.get("B").put(2, new Integer[]{1});
        possibleStableValencies.get("B").put(1, new Integer[]{2});
        possibleStableValencies.get("B").put(-1, new Integer[]{4});
        possibleStableValencies.get("B").put(-2, new Integer[]{3});
        possibleStableValencies.get("C").put(2, new Integer[]{2});
        possibleStableValencies.get("C").put(1, new Integer[]{3});
        possibleStableValencies.get("C").put(-1, new Integer[]{3});
        possibleStableValencies.get("C").put(-2, new Integer[]{2});
        possibleStableValencies.get("N").put(2, new Integer[]{3});
        possibleStableValencies.get("N").put(1, new Integer[]{4});
        possibleStableValencies.get("N").put(-1, new Integer[]{2});
        possibleStableValencies.get("N").put(-2, new Integer[]{1});
        possibleStableValencies.get("O").put(1, new Integer[]{4});
        possibleStableValencies.get("O").put(1, new Integer[]{3, 5});
        possibleStableValencies.get("O").put(-1, new Integer[]{1});
        possibleStableValencies.get("O").put(-2, new Integer[]{0});
        possibleStableValencies.get("F").put(2, new Integer[]{3, 5});
        possibleStableValencies.get("F").put(1, new Integer[]{2});
        possibleStableValencies.get("F").put(-1, new Integer[]{0});
        possibleStableValencies.get("Na").put(1, new Integer[]{0});
        possibleStableValencies.get("Na").put(-1, new Integer[]{0});
        possibleStableValencies.get("Mg").put(2, new Integer[]{0});
        possibleStableValencies.get("Al").put(3, new Integer[]{0});
        possibleStableValencies.get("Al").put(2, new Integer[]{1});
        possibleStableValencies.get("Al").put(1, new Integer[]{2});
        possibleStableValencies.get("Al").put(-1, new Integer[]{4});
        possibleStableValencies.get("Al").put(-2, new Integer[]{3, 5});
        possibleStableValencies.get("Si").put(2, new Integer[]{2});
        possibleStableValencies.get("Si").put(1, new Integer[]{3});
        possibleStableValencies.get("Si").put(-1, new Integer[]{3, 5});
        possibleStableValencies.get("Si").put(-2, new Integer[]{2});
        possibleStableValencies.get("P").put(2, new Integer[]{3});
        possibleStableValencies.get("P").put(1, new Integer[]{4});
        possibleStableValencies.get("P").put(-1, new Integer[]{2, 4, 6});
        possibleStableValencies.get("P").put(-2, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get("S").put(2, new Integer[]{4});
        possibleStableValencies.get("S").put(1, new Integer[]{3, 5});
        possibleStableValencies.get("S").put(-1, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get("S").put(-2, new Integer[]{0});
        possibleStableValencies.get("Cl").put(2, new Integer[]{3, 5});
        possibleStableValencies.get("Cl").put(1, new Integer[]{2, 4, 6});
        possibleStableValencies.get("Cl").put(-1, new Integer[]{0});
        possibleStableValencies.get("K").put(1, new Integer[]{0});
        possibleStableValencies.get("K").put(-1, new Integer[]{0});
        possibleStableValencies.get("Ca").put(2, new Integer[]{0});
        possibleStableValencies.get("Ca").put(1, new Integer[]{1});
        possibleStableValencies.get("Ga").put(3, new Integer[]{0});
        possibleStableValencies.get("Ga").put(2, new Integer[]{1});
        possibleStableValencies.get("Ga").put(1, new Integer[]{0});
        possibleStableValencies.get("Ga").put(-1, new Integer[]{4});
        possibleStableValencies.get("Ga").put(-2, new Integer[]{3, 5});
        possibleStableValencies.get("Ge").put(4, new Integer[]{0});
        possibleStableValencies.get("Ge").put(1, new Integer[]{3});
        possibleStableValencies.get("Ge").put(-1, new Integer[]{3, 5});
        possibleStableValencies.get("Ge").put(-2, new Integer[]{2, 4, 6});
        possibleStableValencies.get("As").put(2, new Integer[]{3});
        possibleStableValencies.get("As").put(1, new Integer[]{4});
        possibleStableValencies.get("As").put(-1, new Integer[]{2, 4, 6});
        possibleStableValencies.get("As").put(-2, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get("As").put(-3, new Integer[]{0});
        possibleStableValencies.get("Se").put(2, new Integer[]{4});
        possibleStableValencies.get("Se").put(1, new Integer[]{3, 5});
        possibleStableValencies.get("Se").put(-1, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get("Se").put(-2, new Integer[]{0});
        possibleStableValencies.get("Br").put(2, new Integer[]{3, 5});
        possibleStableValencies.get("Br").put(1, new Integer[]{2, 4, 6});
        possibleStableValencies.get("Br").put(-1, new Integer[]{0});
        possibleStableValencies.get("Rb").put(1, new Integer[]{0});
        possibleStableValencies.get("Rb").put(-1, new Integer[]{0});
        possibleStableValencies.get("Sr").put(2, new Integer[]{0});
        possibleStableValencies.get("Sr").put(1, new Integer[]{1});
        possibleStableValencies.get("In").put(3, new Integer[]{0});
        possibleStableValencies.get("In").put(2, new Integer[]{1});
        possibleStableValencies.get("In").put(1, new Integer[]{0});
        possibleStableValencies.get("In").put(-1, new Integer[]{2, 4});
        possibleStableValencies.get("In").put(-2, new Integer[]{3, 5});
        possibleStableValencies.get("Sn").put(4, new Integer[]{0});
        possibleStableValencies.get("Sn").put(2, new Integer[]{0});
        possibleStableValencies.get("Sn").put(1, new Integer[]{3});
        possibleStableValencies.get("Sn").put(-1, new Integer[]{3, 5});
        possibleStableValencies.get("Sn").put(-2, new Integer[]{2, 4, 6});
        possibleStableValencies.get("Sb").put(3, new Integer[]{0});
        possibleStableValencies.get("Sb").put(2, new Integer[]{3});
        possibleStableValencies.get("Sb").put(1, new Integer[]{2, 4});
        possibleStableValencies.get("Sb").put(-1, new Integer[]{2, 4, 6});
        possibleStableValencies.get("Sb").put(-2, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get("Te").put(2, new Integer[]{2, 4});
        possibleStableValencies.get("Te").put(1, new Integer[]{3, 5});
        possibleStableValencies.get("Te").put(-1, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get("Te").put(-2, new Integer[]{0});
        possibleStableValencies.get("I").put(2, new Integer[]{3, 5});
        possibleStableValencies.get("I").put(1, new Integer[]{2, 4, 6});
        possibleStableValencies.get("I").put(-1, new Integer[]{0});
        possibleStableValencies.get("Cs").put(1, new Integer[]{0});
        possibleStableValencies.get("Cs").put(-1, new Integer[]{0});
        possibleStableValencies.get("Ba").put(2, new Integer[]{0});
        possibleStableValencies.get("Ba").put(1, new Integer[]{1});
        possibleStableValencies.get("Pb").put(2, new Integer[]{0});
        possibleStableValencies.get("Pb").put(1, new Integer[]{3});
        possibleStableValencies.get("Pb").put(-1, new Integer[]{3, 5});
        possibleStableValencies.get("Pb").put(-2, new Integer[]{2, 4, 6});
        possibleStableValencies.get("Bi").put(3, new Integer[]{0});
        possibleStableValencies.get("Bi").put(2, new Integer[]{3});
        possibleStableValencies.get("Bi").put(1, new Integer[]{2, 4});
        possibleStableValencies.get("Bi").put(-1, new Integer[]{2, 4, 6});
        possibleStableValencies.get("Bi").put(-2, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get("At").put(2, new Integer[]{3, 5});
        possibleStableValencies.get("At").put(1, new Integer[]{2, 4, 6});
        possibleStableValencies.get("At").put(-1, new Integer[]{0});
        possibleStableValencies.get("Fr").put(1, new Integer[]{0});
        possibleStableValencies.get("Ra").put(2, new Integer[]{0});
        possibleStableValencies.get("Ra").put(1, new Integer[]{1});
    }
}

