/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.Parse;
import uk.ac.cam.ch.wwmm.opsin.ParseRules;
import uk.ac.cam.ch.wwmm.opsin.ParseRulesResults;
import uk.ac.cam.ch.wwmm.opsin.ParseTokens;
import uk.ac.cam.ch.wwmm.opsin.ParseWord;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.ReverseParseRules;
import uk.ac.cam.ch.wwmm.opsin.TokenizationResult;
import uk.ac.cam.ch.wwmm.opsin.WordTools;
import uk.ac.cam.ch.wwmm.opsin.WordType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tokeniser {
    private final ParseRules parseRules;
    private final Pattern matchCasCollectiveIndex = Pattern.compile("([\\[\\(\\{]([1-9][0-9]?[cC][iI][, ]?)+[\\]\\)\\}])+|[1-9][0-9]?[cC][iI]", 2);
    private final Pattern matchCompoundWithPhrase = Pattern.compile("(compd\\. with|compound with|and) ", 2);

    Tokeniser(ParseRules parseRules) {
        this.parseRules = parseRules;
    }

    ParseRules getParseRules() {
        return this.parseRules;
    }

    TokenizationResult tokenize(String name, boolean allowRemovalOfWhiteSpace) throws ParsingException {
        TokenizationResult result2 = allowRemovalOfWhiteSpace ? new TokenizationResult(WordTools.removeWhiteSpaceIfBracketsAreUnbalanced(name)) : new TokenizationResult(name);
        TokenizationResult resultFromBeforeWhitespaceRemoval = null;
        while (!result2.isSuccessfullyTokenized()) {
            ParseRulesResults results = this.parseRules.getParses(result2.getUnparsedName());
            List<ParseTokens> parseTokens = results.getParseTokensList();
            result2.setWorkingName(results.getUninterpretableName());
            String parsedName = result2.getUnparsedName().substring(0, result2.getUnparsedName().length() - result2.getWorkingName().length());
            if (this.isWordParsable(parseTokens, result2)) {
                this.parseWord(result2, parseTokens, parsedName, false);
                resultFromBeforeWhitespaceRemoval = null;
                continue;
            }
            if (resultFromBeforeWhitespaceRemoval == null) {
                resultFromBeforeWhitespaceRemoval = new TokenizationResult(name);
                resultFromBeforeWhitespaceRemoval.setErrorFields(result2.getUnparsedName(), result2.getWorkingName(), results.getUnparseableName());
            }
            if (this.fixWord(result2, parsedName, allowRemovalOfWhiteSpace)) continue;
            result2.setErrorFields(resultFromBeforeWhitespaceRemoval.getUnparsedName(), resultFromBeforeWhitespaceRemoval.getUninterpretableName(), resultFromBeforeWhitespaceRemoval.getUnparsableName());
            break;
        }
        return result2;
    }

    TokenizationResult tokenizeRightToLeft(ReverseParseRules reverseParseRules, String name, boolean allowRemovalOfWhiteSpace) throws ParsingException {
        TokenizationResult result2 = new TokenizationResult(name);
        TokenizationResult resultFromBeforeWhitespaceRemoval = null;
        while (!result2.isSuccessfullyTokenized()) {
            ParseRulesResults results = reverseParseRules.getParses(result2.getUnparsedName());
            List<ParseTokens> parseTokens = results.getParseTokensList();
            result2.setWorkingName(results.getUninterpretableName());
            String parsedName = result2.getUnparsedName().substring(result2.getWorkingName().length());
            if (this.isWordParsableInReverse(parseTokens, result2)) {
                this.parseWord(result2, parseTokens, parsedName, true);
                resultFromBeforeWhitespaceRemoval = null;
                continue;
            }
            if (resultFromBeforeWhitespaceRemoval == null) {
                resultFromBeforeWhitespaceRemoval = new TokenizationResult(name);
                resultFromBeforeWhitespaceRemoval.setErrorFields(result2.getUnparsedName(), result2.getWorkingName(), results.getUnparseableName());
            }
            if (this.fixWordInReverse(result2, parsedName, allowRemovalOfWhiteSpace)) continue;
            result2.setErrorFields(resultFromBeforeWhitespaceRemoval.getUnparsedName(), resultFromBeforeWhitespaceRemoval.getUninterpretableName(), resultFromBeforeWhitespaceRemoval.getUnparsableName());
            break;
        }
        Collections.reverse(result2.getParse().getWords());
        return result2;
    }

    private boolean isWordParsableInReverse(List<ParseTokens> parseTokens, TokenizationResult result2) {
        return parseTokens.size() > 0 && (result2.isFullyInterpretable() || result2.getWorkingName().charAt(result2.getWorkingName().length() - 1) == ' ' || result2.getWorkingName().charAt(result2.getWorkingName().length() - 1) == '-');
    }

    private boolean isWordParsable(List<ParseTokens> parseTokens, TokenizationResult result2) {
        return parseTokens.size() > 0 && (result2.isFullyInterpretable() || result2.getWorkingName().charAt(0) == ' ' || result2.getWorkingName().charAt(0) == '-');
    }

    private void parseWord(TokenizationResult result2, List<ParseTokens> parseTokens, String parsedName, boolean reverse2) throws ParsingException {
        this.addParseWords(parseTokens, parsedName, result2.getParse(), reverse2);
        if (result2.isFullyInterpretable()) {
            result2.setUnparsedName(result2.getWorkingName());
        } else {
            String remainingName = result2.getWorkingName();
            remainingName = reverse2 ? (remainingName.length() > 3 && remainingName.endsWith(" - ") ? remainingName.substring(0, remainingName.length() - 3) : remainingName.substring(0, remainingName.length() - 1)) : (remainingName.length() > 3 && remainingName.startsWith(" - ") ? remainingName.substring(3) : remainingName.substring(1));
            result2.setUnparsedName(remainingName);
        }
    }

    private void addParseWords(List<ParseTokens> parseTokens, String parsedName, Parse parse, boolean reverse2) throws ParsingException {
        List<ParseWord> parseWords = WordTools.splitIntoParseWords(parseTokens, parsedName);
        if (reverse2) {
            Collections.reverse(parseWords);
        }
        for (ParseWord parseWord : parseWords) {
            parse.addWord(parseWord);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean fixWord(TokenizationResult result2, String parsedName, boolean allowRemovalOfWhiteSpace) throws ParsingException {
        Matcher m = this.matchCompoundWithPhrase.matcher(result2.getWorkingName());
        if (m.lookingAt() && this.lastParsedWordWasFullOrFunctionalTerm(result2)) {
            result2.setUnparsedName(parsedName + result2.getWorkingName().substring(m.group().length()));
            return true;
        } else if (this.matchCasCollectiveIndex.matcher(result2.getWorkingName()).matches()) {
            result2.setUnparsedName(parsedName);
            return true;
        } else {
            if (!allowRemovalOfWhiteSpace) return false;
            List<ParseWord> parsedWords = result2.getParse().getWords();
            if (this.reverseSpaceRemoval(parsedWords, result2)) return true;
            int indexOfSpace = result2.getWorkingName().indexOf(32);
            if (indexOfSpace == -1) return false;
            result2.setUnparsedName(parsedName + result2.getWorkingName().substring(0, indexOfSpace) + result2.getWorkingName().substring(indexOfSpace + 1));
        }
        return true;
    }

    private boolean lastParsedWordWasFullOrFunctionalTerm(TokenizationResult result2) throws ParsingException {
        List<ParseWord> parseWords = result2.getParse().getWords();
        if (parseWords.size() > 0) {
            List<ParseTokens> parseTokensList = parseWords.get(parseWords.size() - 1).getParseTokens();
            for (ParseTokens parseTokens : parseTokensList) {
                WordType type = OpsinTools.determineWordType(parseTokens.getAnnotations());
                if (!type.equals((Object)WordType.full) && !type.equals((Object)WordType.functionalTerm)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean fixWordInReverse(TokenizationResult result2, String parsedName, boolean allowRemovalOfWhiteSpace) {
        int indexOfSpace;
        if (allowRemovalOfWhiteSpace) {
            indexOfSpace = result2.getWorkingName().lastIndexOf(32);
            if (indexOfSpace == -1) {
                return false;
            }
        } else {
            return false;
        }
        result2.setUnparsedName(result2.getWorkingName().substring(0, indexOfSpace) + result2.getWorkingName().substring(indexOfSpace + 1) + parsedName);
        return true;
    }

    private boolean reverseSpaceRemoval(List<ParseWord> parsedWords, TokenizationResult result2) throws ParsingException {
        boolean successful = false;
        if (!parsedWords.isEmpty()) {
            ParseWord pw = parsedWords.get(parsedWords.size() - 1);
            ParseRulesResults backResults = this.parseRules.getParses(pw.getWord() + result2.getUnparsedName());
            List<ParseTokens> backParseTokens = backResults.getParseTokensList();
            String backUninterpretableName = backResults.getUninterpretableName();
            String backParsedName = pw.getWord() + result2.getUnparsedName().substring(0, result2.getUnparsedName().length() - backUninterpretableName.length());
            if (backParsedName.length() > pw.getWord().length() && backParseTokens.size() > 0 && (backUninterpretableName.equals("") || backUninterpretableName.charAt(0) == ' ' || backUninterpretableName.charAt(0) == '-')) {
                result2.getParse().removeWord(pw);
                List<ParseWord> parseWords = WordTools.splitIntoParseWords(backParseTokens, backParsedName);
                for (ParseWord parseWord : parseWords) {
                    result2.getParse().addWord(parseWord);
                }
                if (!backUninterpretableName.equals("")) {
                    result2.setUnparsedName(backUninterpretableName.substring(1));
                } else {
                    result2.setUnparsedName(backUninterpretableName);
                }
                successful = true;
            }
        }
        return successful;
    }
}

