/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import uk.ac.cam.ch.wwmm.opsin.ComponentGenerationException;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SuffixRules {
    private final HashMap<String, HashMap<String, List<Element>>> suffixApplicability;
    private final HashMap<String, Element> suffixRules;

    SuffixRules(ResourceGetter resourceGetter) throws IOException {
        this.suffixApplicability = this.generateSuffixApplicabilityMap(resourceGetter);
        this.suffixRules = this.generateSuffixRulesMap(resourceGetter);
    }

    private HashMap<String, HashMap<String, List<Element>>> generateSuffixApplicabilityMap(ResourceGetter resourceGetter) throws IOException {
        Document suffixApplicabilityDoc = resourceGetter.getXMLDocument("suffixApplicability.xml");
        HashMap<String, HashMap<String, List<Element>>> suffixApplicability = new HashMap<String, HashMap<String, List<Element>>>();
        Elements groupTypes = suffixApplicabilityDoc.getRootElement().getChildElements("groupType");
        for (int i = 0; i < groupTypes.size(); ++i) {
            Element groupType = groupTypes.get(i);
            Elements suffixes = groupType.getChildElements("suffix");
            HashMap suffixToRuleMap = new HashMap();
            for (int j = 0; j < suffixes.size(); ++j) {
                Element suffix = suffixes.get(j);
                String suffixValue = suffix.getAttributeValue("value");
                if (suffixToRuleMap.get(suffixValue) != null) {
                    ((List)suffixToRuleMap.get(suffixValue)).add(suffix);
                    continue;
                }
                ArrayList<Element> suffixList = new ArrayList<Element>();
                suffixList.add(suffix);
                suffixToRuleMap.put(suffixValue, suffixList);
            }
            suffixApplicability.put(groupType.getAttributeValue("type"), suffixToRuleMap);
        }
        return suffixApplicability;
    }

    private HashMap<String, Element> generateSuffixRulesMap(ResourceGetter resourceGetter) throws IOException {
        Document suffixRulesDoc = resourceGetter.getXMLDocument("suffixRules.xml");
        HashMap<String, Element> suffixRules = new HashMap<String, Element>();
        Elements rules = suffixRulesDoc.getRootElement().getChildElements("rule");
        for (int i = 0; i < rules.size(); ++i) {
            Element rule = rules.get(i);
            String ruleValue = rule.getAttributeValue("value");
            if (suffixRules.get(ruleValue) != null) {
                throw new RuntimeException("Suffix: " + ruleValue + " appears multiple times in suffixRules.xml");
            }
            suffixRules.put(ruleValue, rule);
        }
        return suffixRules;
    }

    Elements getSuffixRuleTags(String suffixTypeToUse, String suffixValue, String subgroupType) throws ComponentGenerationException {
        HashMap<String, List<Element>> groupToSuffixMap = this.suffixApplicability.get(suffixTypeToUse);
        if (groupToSuffixMap == null) {
            throw new ComponentGenerationException("Suffix Type: " + suffixTypeToUse + " does not have a corresponding groupType entry in suffixApplicability.xml");
        }
        List<Element> potentiallyApplicableSuffixes = groupToSuffixMap.get(suffixValue);
        if (potentiallyApplicableSuffixes == null || potentiallyApplicableSuffixes.size() == 0) {
            throw new ComponentGenerationException("Suffix: " + suffixValue + " does not apply to the group it was associated with (type: " + suffixTypeToUse + ")according to suffixApplicability.xml");
        }
        Element chosenSuffix = null;
        for (Element suffix : potentiallyApplicableSuffixes) {
            if (suffix.getAttribute("subType") != null && !suffix.getAttributeValue("subType").equals(subgroupType)) continue;
            if (chosenSuffix != null) {
                throw new ComponentGenerationException("Suffix: " + suffixValue + " appears multiple times in suffixApplicability.xml");
            }
            chosenSuffix = suffix;
        }
        if (chosenSuffix == null) {
            throw new ComponentGenerationException("Suffix: " + suffixValue + " does not apply to the group it was associated with (type: " + suffixTypeToUse + ")due to the group's subType: " + subgroupType + " according to suffixApplicability.xml");
        }
        Element rule = this.suffixRules.get(chosenSuffix.getValue());
        if (rule == null) {
            throw new ComponentGenerationException("Suffix: " + chosenSuffix.getValue() + " does not have a rule associated with it in suffixRules.xml");
        }
        return rule.getChildElements();
    }

    boolean isGroupTypeWithSpecificSuffixRules(String groupType) {
        return this.suffixApplicability.containsKey(groupType);
    }
}

