/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.Comparator;
import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SortAtomsForMainGroupElementSymbols
implements Comparator<Atom> {
    SortAtomsForMainGroupElementSymbols() {
    }

    @Override
    public int compare(Atom a, Atom b) {
        int compare = a.getElement().compareTo(b.getElement());
        if (compare != 0) {
            return compare;
        }
        int aExpectedHydrogen = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(a);
        int bExpectedHydrogen = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(b);
        if (aExpectedHydrogen > 0 && bExpectedHydrogen == 0) {
            return -1;
        }
        if (aExpectedHydrogen == 0 && bExpectedHydrogen > 0) {
            return 1;
        }
        List<String> locantsA = a.getLocants();
        List<String> locantsB = b.getLocants();
        if (locantsA.size() == 0 && locantsB.size() > 0) {
            return -1;
        }
        if (locantsA.size() > 0 && locantsB.size() == 0) {
            return 1;
        }
        return 0;
    }
}

