/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import dk.brics.automaton.RunAutomaton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import uk.ac.cam.ch.wwmm.opsin.AutomatonInitialiser;
import uk.ac.cam.ch.wwmm.opsin.OpsinRadixTrie;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;
import uk.ac.cam.ch.wwmm.opsin.Token;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

class ResourceManager {
    private final ResourceGetter resourceGetter;
    final HashMap<String, HashMap<Character, Token>> tokenDict = new HashMap();
    final HashMap<Character, Token> reSymbolTokenDict = new HashMap();
    final OpsinRadixTrie[] symbolTokenNamesDict;
    final List<RunAutomaton>[] symbolRegexAutomataDict;
    final List<Pattern>[] symbolRegexesDict;
    final RunAutomaton chemicalAutomaton;
    OpsinRadixTrie[] symbolTokenNamesDictReversed;
    List<RunAutomaton>[] symbolRegexAutomataDictReversed;
    List<Pattern>[] symbolRegexesDictReversed;
    RunAutomaton reverseChemicalAutomaton;

    ResourceManager(ResourceGetter resourceGetter) throws IOException {
        this.resourceGetter = resourceGetter;
        this.chemicalAutomaton = this.processChemicalGrammar(false);
        int grammarSymbolsSize = this.chemicalAutomaton.getCharIntervals().length;
        this.symbolTokenNamesDict = new OpsinRadixTrie[grammarSymbolsSize];
        this.symbolRegexAutomataDict = new List[grammarSymbolsSize];
        this.symbolRegexesDict = new List[grammarSymbolsSize];
        this.processTokenFiles(false);
        this.processRegexTokenFiles(false);
    }

    private void processTokenFiles(boolean reversed2) throws IOException {
        Document tokenFiles = this.resourceGetter.getXMLDocument("index.xml");
        Elements files = tokenFiles.getRootElement().getChildElements("tokenFile");
        for (int i = 0; i < files.size(); ++i) {
            List<Element> tokenLists;
            Element rootElement = this.resourceGetter.getXMLDocument(files.get(i).getValue()).getRootElement();
            if (rootElement.getLocalName().equals("tokenLists")) {
                tokenLists = XOMTools.getChildElementsWithTagName(rootElement, "tokenList");
            } else {
                tokenLists = new ArrayList<Element>();
                tokenLists.add(rootElement);
            }
            for (Element tokenList : tokenLists) {
                char symbol = tokenList.getAttributeValue("symbol").charAt(0);
                List<Element> tokenElements = XOMTools.getChildElementsWithTagName(tokenList, "token");
                int index = Arrays.binarySearch(this.chemicalAutomaton.getCharIntervals(), symbol);
                if (index < 0) {
                    throw new RuntimeException(symbol + " is associated with a tokenList of tagname " + tokenList.getAttributeValue("tagname") + " however it is not actually used in OPSIN's grammar!!!");
                }
                for (Element tokenElement : tokenElements) {
                    String t = tokenElement.getValue();
                    if (!this.tokenDict.containsKey(t)) {
                        this.tokenDict.put(t, new HashMap());
                    }
                    this.tokenDict.get(t).put(Character.valueOf(symbol), new Token(tokenElement, tokenList));
                    if (!reversed2) {
                        if (this.symbolTokenNamesDict[index] == null) {
                            this.symbolTokenNamesDict[index] = new OpsinRadixTrie();
                        }
                        this.symbolTokenNamesDict[index].addToken(t);
                        continue;
                    }
                    if (this.symbolTokenNamesDictReversed[index] == null) {
                        this.symbolTokenNamesDictReversed[index] = new OpsinRadixTrie();
                    }
                    this.symbolTokenNamesDictReversed[index].addToken(new StringBuffer(t).reverse().toString());
                }
            }
        }
    }

    private void processRegexTokenFiles(boolean reversed2) throws IOException {
        Element reTokenList = this.resourceGetter.getXMLDocument("regexTokens.xml").getRootElement();
        Elements regexEls = reTokenList.getChildElements();
        HashMap<String, String> tempRegexes = new HashMap<String, String>();
        Pattern matchRegexReplacement = Pattern.compile("%.*?%");
        for (int i = 0; i < regexEls.size(); ++i) {
            Element regexEl = regexEls.get(i);
            String re = regexEl.getAttributeValue("regex");
            Matcher m = matchRegexReplacement.matcher(re);
            StringBuilder newValueSB = new StringBuilder();
            int position = 0;
            while (m.find()) {
                newValueSB.append(re.substring(position, m.start()));
                if (tempRegexes.get(m.group()) == null) {
                    throw new RuntimeException("Regex entry for: " + m.group() + " missing! Check regexTokens.xml");
                }
                newValueSB.append((String)tempRegexes.get(m.group()));
                position = m.end();
            }
            newValueSB.append(re.substring(position));
            if (regexEl.getLocalName().equals("regex")) {
                if (regexEl.getAttribute("name") == null) {
                    throw new RuntimeException("Regex entry in regexTokenes.xml with no name. regex: " + newValueSB.toString());
                }
                tempRegexes.put(regexEl.getAttributeValue("name"), newValueSB.toString());
                continue;
            }
            Character symbol = Character.valueOf(regexEl.getAttributeValue("symbol").charAt(0));
            this.reSymbolTokenDict.put(symbol, new Token(regexEl));
            int index = Arrays.binarySearch(this.chemicalAutomaton.getCharIntervals(), symbol.charValue());
            if (index < 0) {
                throw new RuntimeException(symbol + " is associated with the regex " + newValueSB.toString() + " however it is not actually used in OPSIN's grammar!!!");
            }
            if (!reversed2) {
                if (regexEl.getAttribute("determinise") != null) {
                    if (this.symbolRegexAutomataDict[index] == null) {
                        this.symbolRegexAutomataDict[index] = new ArrayList<RunAutomaton>();
                    }
                    this.symbolRegexAutomataDict[index].add(AutomatonInitialiser.loadAutomaton(regexEl.getAttributeValue("tagname") + "_" + symbol.charValue(), newValueSB.toString(), false, false));
                    continue;
                }
                if (this.symbolRegexesDict[index] == null) {
                    this.symbolRegexesDict[index] = new ArrayList<Pattern>();
                }
                this.symbolRegexesDict[index].add(Pattern.compile(newValueSB.toString()));
                continue;
            }
            if (regexEl.getAttribute("determinise") != null) {
                if (this.symbolRegexAutomataDictReversed[index] == null) {
                    this.symbolRegexAutomataDictReversed[index] = new ArrayList<RunAutomaton>();
                }
                this.symbolRegexAutomataDictReversed[index].add(AutomatonInitialiser.loadAutomaton(regexEl.getAttributeValue("tagname") + "_" + symbol.charValue(), newValueSB.toString(), false, true));
                continue;
            }
            if (this.symbolRegexesDictReversed[index] == null) {
                this.symbolRegexesDictReversed[index] = new ArrayList<Pattern>();
            }
            this.symbolRegexesDictReversed[index].add(Pattern.compile(newValueSB.toString() + "$"));
        }
    }

    private RunAutomaton processChemicalGrammar(boolean reversed2) throws IOException {
        HashMap<String, String> regexDict = new HashMap<String, String>();
        Elements regexes = this.resourceGetter.getXMLDocument("regexes.xml").getRootElement().getChildElements("regex");
        Pattern matchRegexReplacement = Pattern.compile("%.*?%");
        for (int i = 0; i < regexes.size(); ++i) {
            String name = regexes.get(i).getAttributeValue("name");
            String value2 = regexes.get(i).getAttributeValue("value");
            Matcher m = matchRegexReplacement.matcher(value2);
            StringBuilder newValueSB = new StringBuilder();
            int position = 0;
            while (m.find()) {
                newValueSB.append(value2.substring(position, m.start()));
                if (regexDict.get(m.group()) == null) {
                    throw new RuntimeException("Regex entry for: " + m.group() + " missing! Check regexes.xml");
                }
                newValueSB.append((String)regexDict.get(m.group()));
                position = m.end();
            }
            newValueSB.append(value2.substring(position));
            if (regexDict.get(name) != null) {
                throw new RuntimeException("Regex entry: " + name + " has duplicate definitions! Check regexes.xml");
            }
            regexDict.put(name, newValueSB.toString());
        }
        String re = (String)regexDict.get("%chemical%");
        if (!reversed2) {
            return AutomatonInitialiser.loadAutomaton("chemical", re, true, false);
        }
        return AutomatonInitialiser.loadAutomaton("chemical", re, true, true);
    }

    synchronized void populatedReverseTokenMappings() throws IOException {
        if (this.reverseChemicalAutomaton == null) {
            this.reverseChemicalAutomaton = this.processChemicalGrammar(true);
        }
        int grammarSymbolsSize = this.reverseChemicalAutomaton.getCharIntervals().length;
        if (this.symbolTokenNamesDictReversed == null) {
            this.symbolTokenNamesDictReversed = new OpsinRadixTrie[grammarSymbolsSize];
            this.processTokenFiles(true);
        }
        if (this.symbolRegexAutomataDictReversed == null && this.symbolRegexesDictReversed == null) {
            this.symbolRegexAutomataDictReversed = new List[grammarSymbolsSize];
            this.symbolRegexesDictReversed = new List[grammarSymbolsSize];
            this.processRegexTokenFiles(true);
        }
    }

    Element makeTokenElement(String token2, Character symbol) throws ParsingException {
        if (this.tokenDict.get(token2) != null && this.tokenDict.get(token2).get(symbol) != null) {
            return this.tokenDict.get(token2).get(symbol).makeElement(token2);
        }
        if (this.reSymbolTokenDict.get(symbol) != null) {
            return this.reSymbolTokenDict.get(symbol).makeElement(token2);
        }
        throw new ParsingException("Parsing Error: This is a bug in the program. A token element could not be found for token: " + token2 + " using annotation symbol: " + symbol);
    }
}

