/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class ResourceGetter {
    private final String resourcePath;
    private String workingDirectory;
    private final Builder xomBuilder;

    ResourceGetter(String resourcePath) {
        XMLReader xmlReader;
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        this.resourcePath = resourcePath;
        try {
            this.workingDirectory = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            this.workingDirectory = null;
        }
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new RuntimeException("No XML Reader could be initialised!", e);
        }
        try {
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException("Your system's default XML Reader does not support disabling DTD loading! Maybe try updating your version of java?", e);
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException("Your system's default XML Reader has not recognised the DTD loading feature! Maybe try updating your version of java?", e);
        }
        this.xomBuilder = new Builder(xmlReader);
    }

    Document getXMLDocument(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Input to function was null");
        }
        try {
            File f2;
            if (this.workingDirectory != null && (f2 = this.getFile(name)) != null) {
                return this.xomBuilder.build(f2);
            }
            ClassLoader l = this.getClass().getClassLoader();
            URL url = l.getResource(this.resourcePath + name);
            if (url == null) {
                throw new IOException("URL for resource: " + this.resourcePath + name + " is invalid");
            }
            return this.xomBuilder.build(url.openStream());
        }
        catch (ValidityException e) {
            IOException ioe = new IOException("Validity exception occurred while reading the XML file with name:" + name);
            ioe.initCause(e);
            throw ioe;
        }
        catch (ParsingException e) {
            IOException ioe = new IOException("Parsing exception occurred while reading the XML file with name:" + name);
            ioe.initCause(e);
            throw ioe;
        }
    }

    private File getFile(String name) {
        File f2 = new File(this.getResDir(), name);
        if (f2.isDirectory()) {
            return null;
        }
        if (f2.exists()) {
            return f2;
        }
        return null;
    }

    private File getResDir() {
        File resourcesTop = new File(this.workingDirectory, "resources");
        return new File(resourcesTop, this.resourcePath);
    }

    String getFileContentsAsString(String name) {
        String string2;
        if (name == null) {
            throw new IllegalArgumentException("Input to function was null");
        }
        InputStreamReader is = null;
        try {
            is = new InputStreamReader(this.getInputstreamFromFileName(name), "UTF-8");
            string2 = IOUtils.toString(is);
        }
        catch (UnsupportedEncodingException e) {
            try {
                try {
                    throw new RuntimeException("Java VM is broken; UTF-8 should be supported", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            catch (IOException e2) {
                return "";
            }
        }
        IOUtils.closeQuietly(is);
        return string2;
    }

    InputStream getInputstreamFromFileName(String name) throws IOException {
        File f2;
        if (name == null) {
            throw new IllegalArgumentException("Input to function was null");
        }
        if (this.workingDirectory != null && (f2 = this.getFile(name)) != null) {
            return new FileInputStream(f2);
        }
        ClassLoader l = this.getClass().getClassLoader();
        URL url = l.getResource(this.resourcePath + name);
        if (url == null) {
            throw new IOException("URL for resource: " + this.resourcePath + name + " is invalid");
        }
        return url.openStream();
    }

    OutputStream getOutputStream(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Input to function was null");
        }
        File f2 = this.getFileForWriting(name);
        return new FileOutputStream(f2);
    }

    private File getFileForWriting(String name) throws IOException {
        File resourcesTop = new File(this.workingDirectory, "resources");
        File resDir = new File(resourcesTop, this.resourcePath);
        if (!resDir.exists() && !resDir.mkdirs()) {
            throw new IOException("Failed to generate requested directories to create: " + name);
        }
        return new File(resDir, name);
    }
}

