/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Element;
import uk.ac.cam.ch.wwmm.opsin.CASTools;
import uk.ac.cam.ch.wwmm.opsin.Combinations;
import uk.ac.cam.ch.wwmm.opsin.NameToStructureConfig;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.Parse;
import uk.ac.cam.ch.wwmm.opsin.ParseRules;
import uk.ac.cam.ch.wwmm.opsin.ParseTokens;
import uk.ac.cam.ch.wwmm.opsin.ParseWord;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;
import uk.ac.cam.ch.wwmm.opsin.ResourceManager;
import uk.ac.cam.ch.wwmm.opsin.ReverseParseRules;
import uk.ac.cam.ch.wwmm.opsin.Tokeniser;
import uk.ac.cam.ch.wwmm.opsin.TokenizationResult;
import uk.ac.cam.ch.wwmm.opsin.WordRules;
import uk.ac.cam.ch.wwmm.opsin.WordTools;
import uk.ac.cam.ch.wwmm.opsin.WordType;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Parser {
    private final Tokeniser tokeniser;
    private final WordRules wordRules;
    private final ResourceManager resourceManager;
    private final ParseRules parseRules;
    private static final Pattern matchSemiColonSpace = Pattern.compile("; ");
    private static final Pattern matchStoichiometryIndication = Pattern.compile("[ ]?[\\{\\[\\(](\\d+|\\?)([:/](\\d+|\\?))+[\\}\\]\\)]$");

    Parser() throws IOException {
        ResourceGetter resources = new ResourceGetter("uk/ac/cam/ch/wwmm/opsin/resources/");
        this.wordRules = new WordRules(resources);
        this.resourceManager = new ResourceManager(resources);
        this.parseRules = new ParseRules(this.resourceManager);
        this.tokeniser = new Tokeniser(this.parseRules);
    }

    Parser(WordRules wordRules, Tokeniser tokeniser, ResourceManager resourceManager) {
        this.wordRules = wordRules;
        this.resourceManager = resourceManager;
        this.tokeniser = tokeniser;
        this.parseRules = tokeniser.getParseRules();
    }

    List<Element> parse(NameToStructureConfig n2sConfig, String name) throws ParsingException {
        List<Parse> parses;
        boolean allowSpaceRemoval;
        TokenizationResult tokenizationResult;
        Matcher m;
        Integer[] componentRatios = null;
        if ((name.endsWith(")") || name.endsWith("]") || name.endsWith("}")) && (m = matchStoichiometryIndication.matcher(name)).find()) {
            componentRatios = Parser.processStoichometryIndication(m.group());
            name = m.replaceAll("");
        }
        Parse parse = null;
        if (name.contains(", ")) {
            try {
                tokenizationResult = this.tokeniser.tokenize(CASTools.uninvertCASName(name, this.parseRules), false);
                if (tokenizationResult.isSuccessfullyTokenized()) {
                    parse = tokenizationResult.getParse();
                }
            }
            catch (ParsingException ignored) {}
        } else if (name.contains("; ") && (tokenizationResult = this.tokeniser.tokenize(matchSemiColonSpace.matcher(name).replaceAll(" "), false)).isSuccessfullyTokenized()) {
            parse = tokenizationResult.getParse();
        }
        boolean bl = allowSpaceRemoval = parse == null;
        if (parse == null) {
            TokenizationResult tokenizationResult2 = this.tokeniser.tokenize(name, true);
            if (tokenizationResult2.isSuccessfullyTokenized()) {
                parse = tokenizationResult2.getParse();
            } else if (n2sConfig.isDetailedFailureAnalysis()) {
                this.generateExactParseFailureReason(tokenizationResult2, name);
            } else {
                throw new ParsingException(name + " is unparsable due to the following being uninterpretable: " + tokenizationResult2.getUninterpretableName() + " The following was not parseable: " + tokenizationResult2.getUnparsableName());
            }
        }
        if ((parses = this.generateParseCombinations(parse)).size() == 0) {
            throw new ParsingException("No parses could be found for " + name);
        }
        if (parses.size() > 128) {
            throw new ParsingException("Too many parses generated, the current limit is 128: " + parses.size());
        }
        ArrayList<Element> results = new ArrayList<Element>();
        for (Parse pp : parses) {
            Element moleculeEl = new Element("molecule");
            moleculeEl.addAttribute(new Attribute("name", name));
            for (ParseWord pw : pp.getWords()) {
                Element word = new Element("word");
                moleculeEl.appendChild(word);
                if (pw.getParseTokens().size() > 1) {
                    throw new ParsingException("OPSIN bug: parseWord had multiple annotations after creating addition parses step");
                }
                WordType wordType = OpsinTools.determineWordType(pw.getParseTokens().get(0).getAnnotations());
                word.addAttribute(new Attribute("type", wordType.toString()));
                if (pw.getWord().startsWith("-")) {
                    word.addAttribute(new Attribute("value", pw.getWord().substring(1)));
                } else {
                    word.addAttribute(new Attribute("value", pw.getWord()));
                }
                for (ParseTokens pt : pw.getParseTokens()) {
                    this.writeWordXML(word, pw, pt.getTokens(), WordTools.chunkAnnotations(pt.getAnnotations()));
                }
            }
            try {
                this.wordRules.groupWordsIntoWordRules(n2sConfig, moleculeEl, allowSpaceRemoval);
                if (componentRatios != null) {
                    this.applyStoichometryIndicationToWordRules(moleculeEl, componentRatios);
                }
                results.add(moleculeEl);
            }
            catch (ParsingException e) {}
        }
        if (results.size() == 0) {
            throw new ParsingException(name + " could be parsed but OPSIN was unsure of the meaning of the words. This error will occur, by default, if a name is just a substituent");
        }
        return results;
    }

    static Integer[] processStoichometryIndication(String ratioString) throws ParsingException {
        ratioString = ratioString.trim();
        String[] ratioStrings = OpsinTools.MATCH_COLON.split(ratioString = ratioString.substring(1, ratioString.length() - 1));
        if (ratioStrings.length == 1) {
            ratioStrings = OpsinTools.MATCH_SLASH.split(ratioString);
        }
        Integer[] componentRatios = new Integer[ratioStrings.length];
        for (int i = 0; i < ratioStrings.length; ++i) {
            String currentRatio = ratioStrings[i];
            if (currentRatio.contains("/")) {
                throw new ParsingException("Unexpected / in component ratio declaration");
            }
            componentRatios[i] = currentRatio.equals("?") ? Integer.valueOf(1) : Integer.valueOf(Integer.parseInt(currentRatio));
        }
        return componentRatios;
    }

    private void generateExactParseFailureReason(TokenizationResult tokenizationResult, String name) throws ParsingException {
        ReverseParseRules reverseParseRules;
        try {
            reverseParseRules = new ReverseParseRules(this.resourceManager);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load resources for parsing names from right to left!", e);
        }
        String uninterpretableLR = tokenizationResult.getUninterpretableName();
        String unparseableLR = tokenizationResult.getUnparsableName();
        TokenizationResult reverseTokenizationResult = this.tokeniser.tokenizeRightToLeft(reverseParseRules, uninterpretableLR, true);
        String uninterpretableRL = reverseTokenizationResult.getUninterpretableName();
        String unparseableRL = reverseTokenizationResult.getUnparsableName();
        int indiceToTruncateUpTo = uninterpretableLR.length() - unparseableLR.length();
        StringBuilder message = new StringBuilder();
        message.append(name);
        if (!uninterpretableRL.equals("")) {
            String uninterpretableInContext;
            message.append(" was uninterpretable due to the following section of the name: ");
            message.append(uninterpretableRL);
            if (indiceToTruncateUpTo <= unparseableRL.length() && !(uninterpretableInContext = unparseableRL.substring(indiceToTruncateUpTo)).equals("")) {
                message.append("  The following was not understandable in the context it was used: ");
                message.append(uninterpretableInContext);
            }
        } else {
            message.append(" has no tokens unknown to OPSIN but does not conform to its grammar. ");
            message.append("From left to right it is unparsable due to the following being uninterpretable:");
            message.append(uninterpretableLR);
            message.append(" The following or which was not parseable: ");
            message.append(unparseableLR);
        }
        throw new ParsingException(message.toString());
    }

    private List<Parse> generateParseCombinations(Parse parse) {
        ArrayList<Integer> parseCounts = new ArrayList<Integer>();
        for (ParseWord pw : parse.getWords()) {
            parseCounts.add(pw.getParseTokens().size());
        }
        List<List<Integer>> combinations = Combinations.makeCombinations(parseCounts);
        ArrayList<Parse> parses = new ArrayList<Parse>();
        for (List<Integer> c : combinations) {
            Parse parseCopy = parse.deepCopy();
            for (int i = 0; i < c.size(); ++i) {
                if ((Integer)parseCounts.get(i) <= 1) continue;
                ParseWord pw = parseCopy.getWord(i);
                ArrayList<ParseTokens> ptl = new ArrayList<ParseTokens>();
                ptl.add(pw.getParseTokens().get(c.get(i)));
                pw.setParseTokens(ptl);
            }
            parses.add(parseCopy);
        }
        return parses;
    }

    void writeWordXML(Element wordEl, ParseWord pw, List<String> tokens, List<List<Character>> annotations) throws ParsingException {
        int annotNumber = 0;
        int annotPos = 0;
        Element chunk = new Element("substituent");
        wordEl.appendChild(chunk);
        Element lastTokenElement = null;
        for (String token2 : tokens) {
            Element tokenElement;
            if (annotPos >= annotations.get(annotNumber).size()) {
                annotPos = 0;
                ++annotNumber;
                chunk = new Element("substituent");
                wordEl.appendChild(chunk);
                lastTokenElement = null;
            }
            if ((tokenElement = this.resourceManager.makeTokenElement(token2, annotations.get(annotNumber).get(annotPos))) != null) {
                chunk.appendChild(tokenElement);
                lastTokenElement = tokenElement;
            } else if (lastTokenElement != null && !token2.equals("")) {
                if (lastTokenElement.getAttribute("subsequentUnsemanticToken") != null) {
                    lastTokenElement.getAttribute("subsequentUnsemanticToken").setValue(lastTokenElement.getAttributeValue("subsequentUnsemanticToken") + token2);
                } else {
                    lastTokenElement.addAttribute(new Attribute("subsequentUnsemanticToken", token2));
                }
            }
            ++annotPos;
        }
        WordType wordType = WordType.valueOf(wordEl.getAttributeValue("type"));
        if (wordType == WordType.full) {
            chunk.setLocalName("root");
        } else if (wordType == WordType.functionalTerm) {
            chunk.setLocalName("functionalTerm");
        }
    }

    private void applyStoichometryIndicationToWordRules(Element moleculeEl, Integer[] componentRatios) throws ParsingException {
        List<Element> wordRules = XOMTools.getChildElementsWithTagName(moleculeEl, "wordRule");
        if (wordRules.size() != componentRatios.length) {
            throw new ParsingException("Component and stoichometry indication indication mismatch. OPSIN believes there to be " + wordRules.size() + " components but " + componentRatios.length + " ratios were given!");
        }
        for (int i = 0; i < componentRatios.length; ++i) {
            wordRules.get(i).addAttribute(new Attribute("stoichometry", String.valueOf(componentRatios[i])));
        }
    }
}

