/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.ParseWord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Parse {
    private final String name;
    private final List<ParseWord> words = new ArrayList<ParseWord>();

    Parse(String chemicalName) {
        this.name = chemicalName;
    }

    Parse deepCopy() {
        Parse p = new Parse(this.name);
        for (ParseWord pw : this.words) {
            p.words.add(pw.deepCopy());
        }
        return p;
    }

    public String toString() {
        return "[" + this.name + ", " + this.words.toString() + "]";
    }

    List<ParseWord> getWords() {
        return this.words;
    }

    boolean addWord(ParseWord word) {
        return this.words.add(word);
    }

    boolean removeWord(ParseWord word) {
        return this.words.remove(word);
    }

    ParseWord getWord(int indice) {
        return this.words.get(indice);
    }

    String getName() {
        return this.name;
    }
}

