/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.CMLFragmentBuilder;
import uk.ac.cam.ch.wwmm.opsin.ComponentGenerator;
import uk.ac.cam.ch.wwmm.opsin.ComponentProcessor;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.NameToStructureConfig;
import uk.ac.cam.ch.wwmm.opsin.NameToStructureException;
import uk.ac.cam.ch.wwmm.opsin.OpsinResult;
import uk.ac.cam.ch.wwmm.opsin.ParseRules;
import uk.ac.cam.ch.wwmm.opsin.Parser;
import uk.ac.cam.ch.wwmm.opsin.PreProcessor;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;
import uk.ac.cam.ch.wwmm.opsin.ResourceManager;
import uk.ac.cam.ch.wwmm.opsin.SMILESFragmentBuilder;
import uk.ac.cam.ch.wwmm.opsin.SortParses;
import uk.ac.cam.ch.wwmm.opsin.StreamSerializer;
import uk.ac.cam.ch.wwmm.opsin.StructureBuilder;
import uk.ac.cam.ch.wwmm.opsin.SuffixRules;
import uk.ac.cam.ch.wwmm.opsin.Tokeniser;
import uk.ac.cam.ch.wwmm.opsin.WordRules;
import uk.ac.cam.ch.wwmm.opsin.XOMFormatter;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

public class NameToStructure {
    private static final Logger LOG = Logger.getLogger(NameToStructure.class);
    private Parser parser;
    private ParseRules parseRules;
    private ComponentGenerator componentGenerator;
    private SMILESFragmentBuilder sBuilder;
    private CMLFragmentBuilder cmlBuilder;
    private StructureBuilder structureBuilder;
    private SuffixRules suffixRules;
    private static NameToStructure NTS_INSTANCE;

    public static synchronized NameToStructure getInstance() throws NameToStructureException {
        if (NTS_INSTANCE == null) {
            NTS_INSTANCE = new NameToStructure();
        }
        return NTS_INSTANCE;
    }

    private NameToStructure() throws NameToStructureException {
        LOG.info("Initialising OPSIN... ");
        try {
            ResourceGetter resourceGetter = new ResourceGetter("uk/ac/cam/ch/wwmm/opsin/resources/");
            ResourceManager resourceManager = new ResourceManager(resourceGetter);
            WordRules wordRules = new WordRules(resourceGetter);
            this.parseRules = new ParseRules(resourceManager);
            Tokeniser tokeniser = new Tokeniser(this.parseRules);
            this.parser = new Parser(wordRules, tokeniser, resourceManager);
            this.componentGenerator = new ComponentGenerator();
            this.sBuilder = new SMILESFragmentBuilder();
            this.cmlBuilder = new CMLFragmentBuilder(resourceGetter);
            this.structureBuilder = new StructureBuilder();
            this.suffixRules = new SuffixRules(resourceGetter);
        }
        catch (Exception e) {
            throw new NameToStructureException(e.getMessage(), e);
        }
        LOG.info("OPSIN initialised");
    }

    public Element parseToCML(String name) {
        OpsinResult result2 = this.parseChemicalName(name);
        Element cml = result2.getCml();
        if (cml != null && LOG.isDebugEnabled()) {
            LOG.debug(new XOMFormatter().elemToString(result2.getCml()));
        }
        return cml;
    }

    public String parseToSmiles(String name) {
        OpsinResult result2 = this.parseChemicalName(name);
        String smiles = result2.getSmiles();
        LOG.debug(smiles);
        return smiles;
    }

    public OpsinResult parseChemicalName(String name) {
        NameToStructureConfig n2sConfig = NameToStructureConfig.getDefaultConfigInstance();
        return this.parseChemicalName(name, n2sConfig);
    }

    public OpsinResult parseChemicalName(String name, NameToStructureConfig n2sConfig) {
        n2sConfig = n2sConfig.clone();
        if (name == null) {
            throw new IllegalArgumentException("String given for name was null");
        }
        String message = "";
        try {
            LOG.debug(name);
            String modifiedName = PreProcessor.preProcess(name);
            List<Element> parses = this.parser.parse(n2sConfig, modifiedName);
            Collections.sort(parses, new SortParses());
            Fragment frag = null;
            for (Element parse : parses) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(new XOMFormatter().elemToString(parse));
                    }
                    this.componentGenerator.processParse(parse);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(new XOMFormatter().elemToString(parse));
                    }
                    BuildState state = new BuildState(n2sConfig, this.sBuilder, this.cmlBuilder);
                    new ComponentProcessor(this.suffixRules, state, parse).processParse();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(new XOMFormatter().elemToString(parse));
                    }
                    frag = this.structureBuilder.buildFragment(state, parse);
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug(new XOMFormatter().elemToString(parse));
                    break;
                }
                catch (Exception e) {
                    if (message.equals("")) {
                        message = message + e.getMessage();
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(e.getMessage(), e);
                }
            }
            return new OpsinResult(frag, frag != null ? OpsinResult.OPSIN_RESULT_STATUS.SUCCESS : OpsinResult.OPSIN_RESULT_STATUS.FAILURE, message, name);
        }
        catch (Exception e) {
            message = message + e.getMessage();
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), e);
            }
            return new OpsinResult(null, OpsinResult.OPSIN_RESULT_STATUS.FAILURE, message, name);
        }
    }

    public static ParseRules getOpsinParser() throws NameToStructureException {
        NameToStructure n2s = NameToStructure.getInstance();
        return n2s.parseRules;
    }

    public static void main(String[] args) throws Exception {
        Options options = NameToStructure.buildCommandLineOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (UnrecognizedOptionException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        if (cmd.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar opsin-[version]-jar-with-dependencies.jar [options]\nOPSIN accepts new line delimited names either interactively or in batch and can output CML, SMILES or InChI/StdInChI\nFor batch use direct a new line seperated list of names to the program and direct the stdout to an output files e.g. java -jar opsin.jar -osmi < inputFile.name > outputFile.smiles", options);
            System.exit(0);
        }
        if (cmd.hasOption("v")) {
            Logger.getLogger("uk.ac.cam.ch.wwmm.opsin").setLevel(Level.DEBUG);
        }
        NameToStructure nts = NameToStructure.getInstance();
        NameToStructureConfig n2sconfig = NameToStructure.generateOpsinConfigObjectFromCmd(cmd);
        System.err.println("Run the jar using the -h flag for help. Enter a chemical name to begin:");
        String outputType = cmd.getOptionValue("o", "cml");
        if (outputType.equalsIgnoreCase("cml")) {
            NameToStructure.interactiveCmlOutput(nts, n2sconfig);
        } else if (outputType.equalsIgnoreCase("smi") || outputType.equalsIgnoreCase("smiles")) {
            NameToStructure.interactiveSmilesOutput(nts, n2sconfig);
        } else if (outputType.equalsIgnoreCase("inchi")) {
            NameToStructure.interactiveInchiOutput(nts, n2sconfig, false);
        } else if (outputType.equalsIgnoreCase("stdinchi")) {
            NameToStructure.interactiveInchiOutput(nts, n2sconfig, true);
        } else {
            System.err.println("Unrecognised output format: " + outputType);
            System.err.println("Expected output types are \"cml\", \"smi\", \"inchi\" and \"stdinchi\"");
            System.exit(1);
        }
    }

    private static Options buildCommandLineOptions() throws ParseException {
        Options options = new Options();
        OptionBuilder.withArgName("o");
        OptionBuilder.withLongOpt("output");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Sets OPSIN's output format (default cml)\nAllowed values are:\ncml for Chemical Markup Language\nsmi for SMILES\ninchi for InChI\nstdinchi for StdInChI");
        options.addOption(OptionBuilder.create("o"));
        options.addOption("h", "help", false, "Displays the allowed command line flags");
        options.addOption("v", "verbose", false, "Enables debugging");
        options.addOption("r", "allowRadicals", false, "Enables interpretation of radicals");
        options.addOption("f", "detailedFailureAnalysis", false, "Enables reverse parsing to more accurately determine why parsing failed");
        return options;
    }

    private static NameToStructureConfig generateOpsinConfigObjectFromCmd(CommandLine cmd) {
        NameToStructureConfig n2sconfig = new NameToStructureConfig();
        n2sconfig.setDetailedFailureAnalysis(cmd.hasOption("f"));
        n2sconfig.setAllowRadicals(cmd.hasOption("r"));
        return n2sconfig;
    }

    private static void interactiveCmlOutput(NameToStructure nts, NameToStructureConfig n2sconfig) throws IOException, NameToStructureException {
        BufferedReader stdinReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        StreamSerializer serializer = new StreamSerializer(System.out);
        serializer.setIndent(2);
        serializer.writeXMLDeclaration();
        Element cml = new Element("cml", "http://www.xml-cml.org/schema");
        cml.addAttribute(new Attribute("convention", "conventions:molecular"));
        cml.addNamespaceDeclaration("conventions", "http://www.xml-cml.org/convention/");
        cml.addNamespaceDeclaration("cmlDict", "http://www.xml-cml.org/dictionary/cml/");
        cml.addNamespaceDeclaration("nameDict", "http://www.xml-cml.org/dictionary/cml/name/");
        serializer.writeStartTag(cml);
        int id = 1;
        String name = stdinReader.readLine();
        while (name != null) {
            OpsinResult result2 = nts.parseChemicalName(name, n2sconfig);
            Element output2 = result2.getCml();
            if (output2 == null) {
                System.err.println(result2.getMessage());
                Element uninterpretableMolecule = new Element("molecule", "http://www.xml-cml.org/schema");
                uninterpretableMolecule.addAttribute(new Attribute("id", "m" + id++));
                Element nameEl = new Element("name", "http://www.xml-cml.org/schema");
                nameEl.appendChild(name);
                nameEl.addAttribute(new Attribute("dictRef", "nameDict:unknown"));
                uninterpretableMolecule.appendChild(nameEl);
                serializer.write(uninterpretableMolecule);
                serializer.flush();
            } else {
                Element molecule = XOMTools.getChildElementsWithTagName(output2, "molecule").get(0);
                molecule.getAttribute("id").setValue("m" + id++);
                serializer.write(molecule);
                serializer.flush();
            }
            name = stdinReader.readLine();
        }
        serializer.writeEndTag(cml);
        serializer.flush();
    }

    private static void interactiveSmilesOutput(NameToStructure nts, NameToStructureConfig n2sconfig) throws IOException, NameToStructureException {
        BufferedReader stdinReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        String name = stdinReader.readLine();
        while (name != null) {
            OpsinResult result2 = nts.parseChemicalName(name, n2sconfig);
            String output2 = result2.getSmiles();
            if (output2 == null) {
                System.err.println(result2.getMessage());
                System.out.println("");
                System.out.flush();
            } else {
                System.out.println(output2);
                System.out.flush();
            }
            name = stdinReader.readLine();
        }
    }

    private static void interactiveInchiOutput(NameToStructure nts, NameToStructureConfig n2sconfig, boolean produceStdInChI) throws Exception {
        Class<?> c;
        BufferedReader stdinReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        try {
            c = Class.forName("uk.ac.cam.ch.wwmm.opsin.NameToInchi");
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not initialise NameToInChI module. Is it on your classpath?");
            throw new RuntimeException(e);
        }
        Method m = produceStdInChI ? c.getMethod("convertResultToStdInChI", OpsinResult.class) : c.getMethod("convertResultToInChI", OpsinResult.class);
        String name = stdinReader.readLine();
        while (name != null) {
            OpsinResult result2 = nts.parseChemicalName(name, n2sconfig);
            String output2 = (String)m.invoke(null, result2);
            if (output2 == null) {
                System.err.println(result2.getMessage());
                System.out.println("");
                System.out.flush();
            } else {
                System.out.println(output2);
                System.out.flush();
            }
            name = stdinReader.readLine();
        }
    }
}

