/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Elements;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.CyclicAtomList;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.FusedRingNumberer;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FusedRingBuilder {
    private final BuildState state;
    private final List<Element> groupsInFusedRing;
    private final Element lastGroup;
    private final Fragment parentRing;
    private final Map<Integer, Fragment> fragmentInScopeForEachFusionLevel = new HashMap<Integer, Fragment>();
    private Map<Atom, Atom> atomsToRemoveToReplacementAtom = new HashMap<Atom, Atom>();

    private FusedRingBuilder(BuildState state, List<Element> groupsInFusedRing) {
        this.state = state;
        this.groupsInFusedRing = groupsInFusedRing;
        this.lastGroup = groupsInFusedRing.get(groupsInFusedRing.size() - 1);
        this.parentRing = state.xmlFragmentMap.get(this.lastGroup);
        this.fragmentInScopeForEachFusionLevel.put(0, this.parentRing);
    }

    static void processFusedRings(BuildState state, Element subOrRoot) throws StructureBuildingException {
        List<Element> groups = XOMTools.getChildElementsWithTagName(subOrRoot, "group");
        if (groups.size() < 2) {
            return;
        }
        ArrayList<Element> groupsInFusedRing = new ArrayList<Element>();
        for (int i = groups.size() - 1; i >= 0; --i) {
            Element beforeBenzo;
            Element group = groups.get(i);
            groupsInFusedRing.add(0, group);
            if (i == 0) continue;
            Element startingEl = group;
            if ((group.getValue().equals("benz") || group.getValue().equals("benzo")) && "fusionRing".equals(group.getAttributeValue("subType")) && (beforeBenzo = (Element)XOMTools.getPreviousSibling(group)) != null && beforeBenzo.getLocalName().equals("locant")) {
                startingEl = beforeBenzo;
            }
            Element possibleGroup = XOMTools.getPreviousSiblingIgnoringCertainElements(startingEl, new String[]{"multiplier", "fusion"});
            if (groups.get(i - 1).equals(possibleGroup)) continue;
            if (groupsInFusedRing.size() >= 2) {
                new FusedRingBuilder(state, groupsInFusedRing).buildFusedRing();
            }
            groupsInFusedRing.clear();
        }
        if (groupsInFusedRing.size() >= 2) {
            new FusedRingBuilder(state, groupsInFusedRing).buildFusedRing();
        }
    }

    void buildFusedRing() throws StructureBuildingException {
        int ncIndice;
        this.processRingNumberingAndIrregularities();
        this.processBenzoFusions();
        List<Element> nameComponents = this.formNameComponentList();
        nameComponents.remove(this.lastGroup);
        ArrayList<Fragment> componentFragments = new ArrayList<Fragment>();
        ArrayList<Fragment> parentFragments = new ArrayList<Fragment>();
        parentFragments.add(this.parentRing);
        int numberOfParents = 1;
        Element possibleMultiplier = (Element)XOMTools.getPreviousSibling(this.lastGroup);
        if (nameComponents.size() > 0 && possibleMultiplier != null && possibleMultiplier.getLocalName().equals("multiplier")) {
            numberOfParents = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
            possibleMultiplier.detach();
            for (int j = 1; j < numberOfParents; ++j) {
                Fragment copyOfParentRing = this.state.fragManager.copyFragment(this.parentRing);
                parentFragments.add(copyOfParentRing);
                componentFragments.add(copyOfParentRing);
            }
        }
        int fusionLevel = (nameComponents.size() - 1 - ncIndice) / 2;
        for (ncIndice = this.processMultiParentSystem(parentFragments, nameComponents, componentFragments); ncIndice >= 0; --ncIndice) {
            int j;
            Element fusion = null;
            if (nameComponents.get(ncIndice).getLocalName().equals("fusion")) {
                fusion = nameComponents.get(ncIndice--);
            }
            if (ncIndice < 0 || !nameComponents.get(ncIndice).getLocalName().equals("group")) {
                throw new StructureBuildingException("Group not found where group expected. This is probably a bug");
            }
            Fragment nextComponent = this.state.xmlFragmentMap.get(nameComponents.get(ncIndice));
            int multiplier = 1;
            Element possibleMultiplierEl = (Element)XOMTools.getPreviousSibling(nameComponents.get(ncIndice));
            if (possibleMultiplierEl != null && possibleMultiplierEl.getLocalName().equals("multiplier")) {
                multiplier = Integer.parseInt(possibleMultiplierEl.getAttributeValue("value"));
            }
            String[] fusionDescriptors = null;
            if (fusion != null) {
                String fusionDescriptorString = fusion.getValue().toLowerCase().substring(1, fusion.getValue().length() - 1);
                if (multiplier == 1) {
                    fusionDescriptors = new String[]{fusionDescriptorString};
                } else if (OpsinTools.MATCH_SEMICOLON.split(fusionDescriptorString).length > 1) {
                    fusionDescriptors = OpsinTools.MATCH_SEMICOLON.split(fusionDescriptorString);
                } else if (OpsinTools.MATCH_COLON.split(fusionDescriptorString).length > 1) {
                    fusionDescriptors = OpsinTools.MATCH_COLON.split(fusionDescriptorString);
                } else if (OpsinTools.MATCH_COMMA.split(fusionDescriptorString).length > 1) {
                    fusionDescriptors = OpsinTools.MATCH_COMMA.split(fusionDescriptorString);
                } else {
                    if (ncIndice != 0) {
                        throw new StructureBuildingException("Unexpected multiplier: " + possibleMultiplierEl.getValue() + " or incorrect fusion descriptor: " + fusionDescriptorString);
                    }
                    multiplier = 1;
                    fusionDescriptors = new String[]{fusionDescriptorString};
                }
            }
            if (multiplier > 1) {
                possibleMultiplierEl.detach();
            }
            Fragment[] fusionComponents = new Fragment[multiplier];
            for (j = 0; j < multiplier; ++j) {
                fusionComponents[j] = j > 0 ? this.state.fragManager.copyAndRelabelFragment(nextComponent, j) : nextComponent;
            }
            for (j = 0; j < multiplier; ++j) {
                Fragment component = fusionComponents[j];
                componentFragments.add(component);
                if (fusion != null) {
                    int numberOfPrimes;
                    if (OpsinTools.MATCH_COLON.split(fusionDescriptors[j]).length == 1) {
                        if (OpsinTools.MATCH_DASH.split(fusionDescriptors[j]).length == 1 && OpsinTools.MATCH_COMMA.split(fusionDescriptors[j]).length > 1 && FragmentTools.allAtomsInRingAreIdentical(component) && StringTools.countTerminalPrimes(OpsinTools.MATCH_COMMA.split(fusionDescriptors[j])[0]) != fusionLevel) {
                            numberOfPrimes = StringTools.countTerminalPrimes(OpsinTools.MATCH_COMMA.split(fusionDescriptors[j])[0]);
                            if (numberOfPrimes + 1 != fusionLevel) {
                                if (numberOfPrimes + 2 == fusionLevel) {
                                    --fusionLevel;
                                } else {
                                    throw new StructureBuildingException("Incorrect number of primes in fusion bracket: " + fusionDescriptors[j]);
                                }
                            }
                            this.relabelAccordingToFusionLevel(component, fusionLevel);
                            List<String> numericalLocantsOfParent = Arrays.asList(OpsinTools.MATCH_COMMA.split(fusionDescriptors[j]));
                            List<String> numericalLocantsOfChild = this.findPossibleNumericalLocants(component, this.determineAtomsToFuse(this.fragmentInScopeForEachFusionLevel.get(fusionLevel), numericalLocantsOfParent, null).size() - 1);
                            this.processHigherOrderFusionDescriptors(component, this.fragmentInScopeForEachFusionLevel.get(fusionLevel), numericalLocantsOfChild, numericalLocantsOfParent);
                            continue;
                        }
                        fusionLevel = 0;
                        this.relabelAccordingToFusionLevel(component, fusionLevel);
                        String fusionDescriptor = fusionDescriptors[j];
                        String[] fusionArray = this.determineNumericalAndLetterComponents(fusionDescriptor);
                        int numberOfPrimes2 = 0;
                        if (!fusionArray[1].equals("")) {
                            numberOfPrimes2 = StringTools.countTerminalPrimes(fusionArray[1]);
                            fusionDescriptor = fusionArray[0].equals("") ? fusionArray[1].replaceAll("'", "") : fusionArray[0] + "-" + fusionArray[1].replaceAll("'", "");
                            if (numberOfPrimes2 >= parentFragments.size()) {
                                throw new StructureBuildingException("Unexpected prime in fusion descriptor");
                            }
                        }
                        this.performSimpleFusion(fusionDescriptor, component, (Fragment)parentFragments.get(numberOfPrimes2));
                        continue;
                    }
                    numberOfPrimes = -j + StringTools.countTerminalPrimes(OpsinTools.MATCH_COMMA.split(fusionDescriptors[j])[0]);
                    if (numberOfPrimes != fusionLevel) {
                        if (fusionLevel == numberOfPrimes + 1) {
                            --fusionLevel;
                        } else {
                            throw new StructureBuildingException("Incorrect number of primes in fusion bracket: " + fusionDescriptors[j]);
                        }
                    }
                    this.relabelAccordingToFusionLevel(component, fusionLevel);
                    this.performHigherOrderFusion(fusionDescriptors[j], component, this.fragmentInScopeForEachFusionLevel.get(fusionLevel));
                    continue;
                }
                this.relabelAccordingToFusionLevel(component, fusionLevel);
                this.performSimpleFusion(null, component, this.fragmentInScopeForEachFusionLevel.get(fusionLevel));
            }
            ++fusionLevel;
            if (multiplier != 1) continue;
            this.fragmentInScopeForEachFusionLevel.put(fusionLevel, fusionComponents[0]);
        }
        for (Fragment ring : componentFragments) {
            this.state.fragManager.incorporateFragment(ring, this.parentRing);
        }
        this.removeMergedAtoms();
        FusedRingNumberer.numberFusedRing(this.parentRing);
        StringBuilder fusedRingName = new StringBuilder();
        for (Element element : nameComponents) {
            fusedRingName.append(element.getValue());
        }
        fusedRingName.append(this.lastGroup.getValue());
        Element fusedRingEl = this.lastGroup;
        fusedRingEl.getAttribute("value").setValue(fusedRingName.toString());
        fusedRingEl.removeAttribute(fusedRingEl.getAttribute("valType"));
        fusedRingEl.getAttribute("type").setValue("ring");
        fusedRingEl.getAttribute("subType").setValue("fusedRing");
        XOMTools.setTextChild(fusedRingEl, fusedRingName.toString());
        for (Element element : nameComponents) {
            element.detach();
        }
    }

    private void removeMergedAtoms() {
        for (Atom a : this.atomsToRemoveToReplacementAtom.keySet()) {
            this.state.fragManager.removeAtomAndAssociatedBonds(a);
        }
        this.atomsToRemoveToReplacementAtom.clear();
    }

    private List<Element> formNameComponentList() {
        ArrayList<Element> nameComponents = new ArrayList<Element>();
        Element currentEl = this.groupsInFusedRing.get(0);
        while (currentEl != this.lastGroup) {
            if (currentEl.getLocalName().equals("group") || currentEl.getLocalName().equals("fusion")) {
                nameComponents.add(currentEl);
            }
            currentEl = (Element)XOMTools.getNextSibling(currentEl);
        }
        return nameComponents;
    }

    private void processRingNumberingAndIrregularities() throws StructureBuildingException {
        for (Element group : this.groupsInFusedRing) {
            Fragment ring = this.state.xmlFragmentMap.get(group);
            if ("alkaneStem".equals(group.getAttributeValue("subType"))) {
                this.aromatiseCyclicAlkane(group);
            }
            this.processPartiallyUnsaturatedHWSystems(group, ring);
            if (group == this.lastGroup) {
                List<Atom> atomList = ring.getAtomList();
                for (Atom atom : atomList) {
                    if (atom.getAtomIsInACycle()) continue;
                    throw new StructureBuildingException("Inappropriate group used in fusion nomenclature. Only groups composed entirely of atoms in cycles may be used. i.e. not: " + group.getValue());
                }
                if (group.getAttribute("fusedRingNumbering") != null) {
                    String[] standardNumbering = OpsinTools.MATCH_SLASH.split(group.getAttributeValue("fusedRingNumbering"), -1);
                    for (int j = 0; j < standardNumbering.length; ++j) {
                        atomList.get(j).replaceLocants(standardNumbering[j]);
                    }
                } else {
                    ring.sortAtomListByLocant();
                }
                for (Atom atom : atomList) {
                    atom.clearLocants();
                }
                continue;
            }
            if (group.getAttribute("fusedRingNumbering") != null) continue;
            ring.sortAtomListByLocant();
        }
    }

    private void processPartiallyUnsaturatedHWSystems(Element group, Fragment ring) throws StructureBuildingException {
        Element unsaturator;
        List<Element> unsaturators;
        if ("hantzschWidman".equals(group.getAttributeValue("subType")) && group.getAttribute("addBond") != null && (unsaturators = XOMTools.getNextAdjacentSiblingsOfType(group, "unsaturator")).size() > 0 && (unsaturator = unsaturators.get(0)).getAttribute("locant") == null && unsaturator.getAttributeValue("value").equals("2")) {
            unsaturator.detach();
            Bond bondToUnsaturate = StructureBuildingMethods.findBondToUnSaturate(ring.getAtomList(), 2, true);
            bondToUnsaturate.getFromAtom().setSpareValency(true);
            bondToUnsaturate.getToAtom().setSpareValency(true);
        }
    }

    private void aromatiseCyclicAlkane(Element cyclicAlkaneGroup) {
        Element next2 = (Element)XOMTools.getNextSibling(cyclicAlkaneGroup);
        ArrayList<Element> unsaturators = new ArrayList<Element>();
        while (next2 != null && next2.getLocalName().equals("unsaturator")) {
            unsaturators.add(next2);
            next2 = (Element)XOMTools.getNextSibling(next2);
        }
        boolean conjugate = true;
        if (unsaturators.size() == 1) {
            int value2 = Integer.parseInt(((Element)unsaturators.get(0)).getAttributeValue("value"));
            if (value2 != 2) {
                conjugate = false;
            } else if (((Element)unsaturators.get(0)).getAttribute("locant") != null) {
                conjugate = false;
            }
        } else if (unsaturators.size() == 2) {
            int value1 = Integer.parseInt(((Element)unsaturators.get(0)).getAttributeValue("value"));
            if (value1 != 1) {
                conjugate = false;
            } else {
                int value2 = Integer.parseInt(((Element)unsaturators.get(1)).getAttributeValue("value"));
                if (value2 != 2 || ((Element)unsaturators.get(1)).getAttribute("locant") != null) {
                    conjugate = false;
                }
            }
        } else if (unsaturators.size() > 2) {
            conjugate = false;
        }
        if (conjugate) {
            for (Element unsaturator : unsaturators) {
                unsaturator.detach();
            }
            List<Atom> atomList = this.state.xmlFragmentMap.get(cyclicAlkaneGroup).getAtomList();
            for (Atom atom : atomList) {
                atom.setSpareValency(true);
            }
        }
    }

    private int processMultiParentSystem(List<Fragment> parentFragments, List<Element> nameComponents, List<Fragment> componentFragments) throws StructureBuildingException {
        int i;
        int fusionLevel = 0;
        if (i >= 0 && parentFragments.size() > 1) {
            List<Fragment> previousFusionLevelFragments = parentFragments;
            for (i = nameComponents.size() - 1; i >= 0; --i) {
                if (previousFusionLevelFragments.size() == 1) {
                    this.fragmentInScopeForEachFusionLevel.put(fusionLevel, previousFusionLevelFragments.get(0));
                    break;
                }
                Element fusion = null;
                if (!nameComponents.get(i).getLocalName().equals("fusion")) {
                    throw new StructureBuildingException("Fusion bracket not found where fusion bracket expected");
                }
                fusion = nameComponents.get(i--);
                if (i < 0 || !nameComponents.get(i).getLocalName().equals("group")) {
                    throw new StructureBuildingException("Group not found where group expected. This is probably a bug");
                }
                Fragment nextComponent = this.state.xmlFragmentMap.get(nameComponents.get(i));
                this.relabelAccordingToFusionLevel(nextComponent, fusionLevel);
                int multiplier = 1;
                Element possibleMultiplierEl = (Element)XOMTools.getPreviousSibling(nameComponents.get(i));
                if (possibleMultiplierEl != null && possibleMultiplierEl.getLocalName().equals("multiplier")) {
                    multiplier = Integer.parseInt(possibleMultiplierEl.getAttributeValue("value"));
                    possibleMultiplierEl.detach();
                }
                ArrayList<Fragment> fusionComponents = new ArrayList<Fragment>();
                for (int j = 0; j < multiplier; ++j) {
                    if (j > 0) {
                        Fragment clonedFrag = this.state.fragManager.copyFragment(nextComponent);
                        this.relabelAccordingToFusionLevel(clonedFrag, j);
                        fusionComponents.add(clonedFrag);
                        continue;
                    }
                    fusionComponents.add(nextComponent);
                }
                fusionLevel += multiplier;
                if (multiplier > 1 && multiplier != previousFusionLevelFragments.size()) {
                    throw new StructureBuildingException("Mismatch between number of components and number of parents in fused ring system");
                }
                String fusionDescriptorString = fusion.getValue().toLowerCase().substring(1, fusion.getValue().length() - 1);
                String[] fusionDescriptors = null;
                if (OpsinTools.MATCH_SEMICOLON.split(fusionDescriptorString).length > 1) {
                    fusionDescriptors = OpsinTools.MATCH_SEMICOLON.split(fusionDescriptorString);
                } else if (OpsinTools.MATCH_COLON.split(fusionDescriptorString).length > 1) {
                    fusionDescriptors = OpsinTools.MATCH_COLON.split(fusionDescriptorString);
                } else if (OpsinTools.MATCH_COMMA.split(fusionDescriptorString).length > 1) {
                    fusionDescriptors = OpsinTools.MATCH_COMMA.split(fusionDescriptorString);
                } else {
                    throw new StructureBuildingException("Invalid fusion descriptor: " + fusionDescriptorString);
                }
                if (fusionDescriptors.length != previousFusionLevelFragments.size()) {
                    throw new StructureBuildingException("Invalid fusion descriptor: " + fusionDescriptorString + "(Number of locants disagrees with number of parents)");
                }
                for (int j = 0; j < fusionDescriptors.length; ++j) {
                    boolean simpleFusion;
                    String fusionDescriptor = fusionDescriptors[j];
                    Fragment component = multiplier > 1 ? (Fragment)fusionComponents.get(j) : nextComponent;
                    Fragment parentToUse = previousFusionLevelFragments.get(j);
                    boolean bl = simpleFusion = OpsinTools.MATCH_COLON.split(fusionDescriptor).length <= 1;
                    if (simpleFusion) {
                        String[] fusionArray = this.determineNumericalAndLetterComponents(fusionDescriptor);
                        if (fusionArray[1].length() != 0) {
                            int numberOfPrimes = StringTools.countTerminalPrimes(fusionArray[1]);
                            fusionDescriptor = fusionArray[0].length() == 0 ? fusionArray[1].replaceAll("'", "") : fusionArray[0] + "-" + fusionArray[1].replaceAll("'", "");
                            if (numberOfPrimes != j) {
                                throw new StructureBuildingException("Incorrect number of primes in fusion descriptor: " + fusionDescriptor);
                            }
                        }
                        this.performSimpleFusion(fusionDescriptor, component, parentToUse);
                        continue;
                    }
                    this.performHigherOrderFusion(fusionDescriptor, component, parentToUse);
                }
                previousFusionLevelFragments = fusionComponents;
                componentFragments.addAll(fusionComponents);
            }
            if (previousFusionLevelFragments.size() != 1) {
                throw new StructureBuildingException("Invalid fused ring system. Incomplete multiparent system");
            }
        }
        return i;
    }

    private String[] determineNumericalAndLetterComponents(String fusionDescriptor) {
        String[] fusionArray = OpsinTools.MATCH_DASH.split(fusionDescriptor);
        if (fusionArray.length == 2) {
            return fusionArray;
        }
        String[] components = new String[2];
        if (fusionArray[0].contains(",")) {
            components[0] = fusionArray[0];
            components[1] = "";
        } else {
            components[0] = "";
            components[1] = fusionArray[0];
        }
        return components;
    }

    private void processBenzoFusions() throws StructureBuildingException {
        for (int i = this.groupsInFusedRing.size() - 2; i >= 0; --i) {
            Element possibleMultiplier;
            Element possibleFusionbracket;
            if (!this.groupsInFusedRing.get(i).getValue().equals("benz") && !this.groupsInFusedRing.get(i).getValue().equals("benzo") || (possibleFusionbracket = (Element)XOMTools.getNextSibling(this.groupsInFusedRing.get(i))).getLocalName().equals("fusion") || (possibleMultiplier = (Element)XOMTools.getPreviousSibling(this.groupsInFusedRing.get(i))) != null && possibleMultiplier.getLocalName().equals("multiplier") && !possibleMultiplier.getAttributeValue("type").equals("group")) continue;
            this.benzoSpecificFusion(this.groupsInFusedRing.get(i), this.groupsInFusedRing.get(i + 1));
            this.groupsInFusedRing.get(i).detach();
            this.groupsInFusedRing.remove(i);
        }
    }

    private void relabelAccordingToFusionLevel(Fragment component, int fusionLevel) {
        if (fusionLevel > 0) {
            FragmentTools.relabelNumericLocants(component.getAtomList(), StringTools.multiplyString("'", fusionLevel));
        }
    }

    private void performSimpleFusion(String fusionDescriptor, Fragment childRing, Fragment parentRing) throws StructureBuildingException {
        List<String> numericalLocantsOfChild = null;
        List<String> letterLocantsOfParent = null;
        if (fusionDescriptor != null) {
            String[] fusionArray = OpsinTools.MATCH_DASH.split(fusionDescriptor);
            if (fusionArray.length == 2) {
                numericalLocantsOfChild = Arrays.asList(OpsinTools.MATCH_COMMA.split(fusionArray[0]));
                char[] tempLetterLocantsOfParent = fusionArray[1].toCharArray();
                letterLocantsOfParent = new ArrayList<String>();
                for (char letterLocantOfParent : tempLetterLocantsOfParent) {
                    letterLocantsOfParent.add(String.valueOf(letterLocantOfParent));
                }
            } else if (fusionArray[0].contains(",")) {
                String[] numericalLocantsOfChildTemp = OpsinTools.MATCH_COMMA.split(fusionArray[0]);
                numericalLocantsOfChild = Arrays.asList(numericalLocantsOfChildTemp);
            } else {
                char[] tempLetterLocantsOfParentCharArray = fusionArray[0].toCharArray();
                letterLocantsOfParent = new ArrayList<String>();
                for (char letterLocantOfParentCharArray : tempLetterLocantsOfParentCharArray) {
                    letterLocantsOfParent.add(String.valueOf(letterLocantOfParentCharArray));
                }
            }
        }
        int edgeLength = 1;
        if (numericalLocantsOfChild != null) {
            if (numericalLocantsOfChild.size() <= 1) {
                throw new StructureBuildingException("At least two numerical locants must be provided to perform fusion!");
            }
            edgeLength = numericalLocantsOfChild.size() - 1;
        } else if (letterLocantsOfParent != null) {
            edgeLength = letterLocantsOfParent.size();
        }
        if (numericalLocantsOfChild == null) {
            numericalLocantsOfChild = this.findPossibleNumericalLocants(childRing, edgeLength);
        }
        if (letterLocantsOfParent == null) {
            letterLocantsOfParent = this.findPossibleLetterLocants(parentRing, edgeLength);
        }
        if (numericalLocantsOfChild == null || letterLocantsOfParent == null) {
            throw new StructureBuildingException("Unable to find bond to form fused ring system. Some information for forming fused ring system was only supplyed implicitly");
        }
        this.processFirstOrderFusionDescriptors(childRing, parentRing, numericalLocantsOfChild, letterLocantsOfParent);
    }

    private List<String> findPossibleLetterLocants(Fragment ring, int edgeLength) {
        List<Atom> atomlist = ring.getAtomList();
        ArrayList<String> letterLocantsOfParent = null;
        ArrayList<Atom> carbonAtoms = new ArrayList<Atom>();
        atomlist.add(0, atomlist.get(atomlist.size() - 1));
        for (int i = atomlist.size() - 1; i >= 0; --i) {
            Atom atom = atomlist.get(i);
            if (atom.getElement().equals("C")) {
                if (atom.getIncomingValency() >= 3) {
                    carbonAtoms.clear();
                    continue;
                }
                carbonAtoms.add(atom);
                if (carbonAtoms.size() != edgeLength + 1) continue;
                letterLocantsOfParent = new ArrayList<String>();
                Collections.reverse(carbonAtoms);
                atomlist.remove(0);
                for (int j = 0; j < edgeLength; ++j) {
                    letterLocantsOfParent.add(String.valueOf((char)(97 + atomlist.indexOf(carbonAtoms.get(j)))));
                }
                break;
            }
            carbonAtoms.clear();
        }
        return letterLocantsOfParent;
    }

    private List<String> findPossibleNumericalLocants(Fragment ring, int edgeLength) {
        List<Atom> atomlist = ring.getAtomList();
        ArrayList<String> numericalLocantsOfChild = null;
        ArrayList<String> carbonLocants = new ArrayList<String>();
        atomlist.add(atomlist.get(0));
        for (Atom atom : atomlist) {
            if (atom.getElement().equals("C")) {
                if (atom.getIncomingValency() >= 3) {
                    carbonLocants.clear();
                    continue;
                }
                carbonLocants.add(atom.getFirstLocant());
                if (carbonLocants.size() != edgeLength + 1) continue;
                numericalLocantsOfChild = new ArrayList<String>();
                for (String locant : carbonLocants) {
                    numericalLocantsOfChild.add(locant);
                }
                break;
            }
            carbonLocants.clear();
        }
        return numericalLocantsOfChild;
    }

    private void processFirstOrderFusionDescriptors(Fragment childRing, Fragment parentRing, List<String> numericalLocantsOfChild, List<String> letterLocantsOfParent) throws StructureBuildingException {
        List<Atom> childAtoms = this.determineAtomsToFuse(childRing, numericalLocantsOfChild, letterLocantsOfParent.size() + 1);
        if (childAtoms == null) {
            throw new StructureBuildingException("Malformed fusion bracket!");
        }
        ArrayList<Atom> parentAtoms = new ArrayList<Atom>();
        List<Atom> parentPeripheralAtomList = this.getPeripheralAtoms(parentRing.getAtomList());
        CyclicAtomList cyclicListAtomsOnSurfaceOfParent = new CyclicAtomList(parentPeripheralAtomList, letterLocantsOfParent.get(0).charAt(0) - 97);
        parentAtoms.add(cyclicListAtomsOnSurfaceOfParent.getCurrent());
        for (int i = 0; i < letterLocantsOfParent.size(); ++i) {
            parentAtoms.add(cyclicListAtomsOnSurfaceOfParent.getNext());
        }
        this.fuseRings(childAtoms, parentAtoms);
    }

    private List<Atom> getPeripheralAtoms(List<Atom> atomList) {
        List<Atom> neighbours = atomList.get(0).getAtomNeighbours();
        int indice = Integer.MAX_VALUE;
        for (Atom atom : neighbours) {
            int indexOfAtom = atomList.indexOf(atom);
            if (indexOfAtom == 1 || indexOfAtom == -1 || atomList.indexOf(atom) >= indice) continue;
            indice = indexOfAtom;
        }
        return atomList.subList(0, indice + 1);
    }

    private void performHigherOrderFusion(String fusionDescriptor, Fragment nextComponent, Fragment fusedRing) throws StructureBuildingException {
        List<String> numericalLocantsOfChild = null;
        List<String> numericalLocantsOfParent = null;
        String[] fusionArray = OpsinTools.MATCH_COLON.split(fusionDescriptor);
        if (fusionArray.length != 2) {
            throw new StructureBuildingException("Malformed fusion bracket: This is an OPSIN bug, check regexTokens.xml");
        }
        numericalLocantsOfChild = Arrays.asList(OpsinTools.MATCH_COMMA.split(fusionArray[0]));
        numericalLocantsOfParent = Arrays.asList(OpsinTools.MATCH_COMMA.split(fusionArray[1]));
        this.processHigherOrderFusionDescriptors(nextComponent, fusedRing, numericalLocantsOfChild, numericalLocantsOfParent);
    }

    private void processHigherOrderFusionDescriptors(Fragment childRing, Fragment parentRing, List<String> numericalLocantsOfChild, List<String> numericalLocantsOfParent) throws StructureBuildingException {
        List<Atom> childAtoms = this.determineAtomsToFuse(childRing, numericalLocantsOfChild, null);
        if (childAtoms == null) {
            throw new StructureBuildingException("Malformed fusion bracket!");
        }
        List<Atom> parentAtoms = this.determineAtomsToFuse(parentRing, numericalLocantsOfParent, childAtoms.size());
        if (parentAtoms == null) {
            throw new StructureBuildingException("Malformed fusion bracket!");
        }
        this.fuseRings(childAtoms, parentAtoms);
    }

    private List<Atom> determineAtomsToFuse(Fragment ring, List<String> numericalLocantsOnRing, Integer expectedNumberOfAtomsToBeUsedForFusion) throws StructureBuildingException {
        List<Atom> parentPeripheralAtomList = this.getPeripheralAtoms(ring.getAtomList());
        int indexfirst = parentPeripheralAtomList.indexOf(ring.getAtomByLocantOrThrow(numericalLocantsOnRing.get(0)));
        int indexfinal = parentPeripheralAtomList.indexOf(ring.getAtomByLocantOrThrow(numericalLocantsOnRing.get(numericalLocantsOnRing.size() - 1)));
        CyclicAtomList cyclicRingAtomList = new CyclicAtomList(parentPeripheralAtomList, indexfirst);
        ArrayList<Atom> fusionAtoms = null;
        ArrayList<Atom> potentialFusionAtomsAscending = new ArrayList<Atom>();
        potentialFusionAtomsAscending.add(cyclicRingAtomList.getCurrent());
        while (cyclicRingAtomList.getIndice() != indexfinal) {
            potentialFusionAtomsAscending.add(cyclicRingAtomList.getNext());
        }
        if (expectedNumberOfAtomsToBeUsedForFusion == null || expectedNumberOfAtomsToBeUsedForFusion.intValue() == potentialFusionAtomsAscending.size()) {
            boolean notInPotentialParentAtoms = false;
            for (int i = 1; i < numericalLocantsOnRing.size() - 1; ++i) {
                if (potentialFusionAtomsAscending.contains(ring.getAtomByLocantOrThrow(numericalLocantsOnRing.get(i)))) continue;
                notInPotentialParentAtoms = true;
            }
            if (!notInPotentialParentAtoms) {
                fusionAtoms = potentialFusionAtomsAscending;
            }
        }
        if (fusionAtoms == null || expectedNumberOfAtomsToBeUsedForFusion == null) {
            cyclicRingAtomList.setIndice(indexfirst);
            ArrayList<Atom> potentialFusionAtomsDescending = new ArrayList<Atom>();
            potentialFusionAtomsDescending.add(cyclicRingAtomList.getCurrent());
            while (cyclicRingAtomList.getIndice() != indexfinal) {
                potentialFusionAtomsDescending.add(cyclicRingAtomList.getPrevious());
            }
            if (expectedNumberOfAtomsToBeUsedForFusion == null || expectedNumberOfAtomsToBeUsedForFusion.intValue() == potentialFusionAtomsDescending.size()) {
                boolean notInPotentialParentAtoms = false;
                for (int i = 1; i < numericalLocantsOnRing.size() - 1; ++i) {
                    if (potentialFusionAtomsDescending.contains(ring.getAtomByLocantOrThrow(numericalLocantsOnRing.get(i)))) continue;
                    notInPotentialParentAtoms = true;
                }
                if (!notInPotentialParentAtoms) {
                    if (fusionAtoms != null && expectedNumberOfAtomsToBeUsedForFusion == null) {
                        if (potentialFusionAtomsDescending.size() < fusionAtoms.size()) {
                            fusionAtoms = potentialFusionAtomsDescending;
                        }
                    } else {
                        fusionAtoms = potentialFusionAtomsDescending;
                    }
                }
            }
        }
        return fusionAtoms;
    }

    private void fuseRings(List<Atom> childAtoms, List<Atom> parentAtoms) throws StructureBuildingException {
        Atom to2;
        Atom from2;
        int i;
        if (parentAtoms.size() != childAtoms.size()) {
            throw new StructureBuildingException("Problem with fusion descriptors: Parent atoms specified: " + parentAtoms.size() + " Child atoms specified: " + childAtoms.size() + " These should have been identical!");
        }
        for (i = parentAtoms.size() - 1; i >= 0; --i) {
            if (this.atomsToRemoveToReplacementAtom.get(parentAtoms.get(i)) != null) {
                parentAtoms.set(i, this.atomsToRemoveToReplacementAtom.get(parentAtoms.get(i)));
            }
            if (this.atomsToRemoveToReplacementAtom.get(childAtoms.get(i)) == null) continue;
            childAtoms.set(i, this.atomsToRemoveToReplacementAtom.get(childAtoms.get(i)));
        }
        for (i = 0; i < childAtoms.size(); ++i) {
            Atom parentAtom = parentAtoms.get(i);
            Atom childAtom = childAtoms.get(i);
            if (childAtom.hasSpareValency()) {
                parentAtom.setSpareValency(true);
            }
            if (!parentAtom.getElement().equals(childAtom.getElement())) {
                throw new StructureBuildingException("Invalid fusion descriptor: Heteroatom placement is ambigous as it is not present in both components of the fusion");
            }
            this.atomsToRemoveToReplacementAtom.put(childAtom, parentAtom);
        }
        HashSet<Bond> fusionEdgeBonds = new HashSet<Bond>();
        for (int i2 = 0; i2 < childAtoms.size() - 1; ++i2) {
            fusionEdgeBonds.add(childAtoms.get(i2).getBondToAtomOrThrow(childAtoms.get(i2 + 1)));
            fusionEdgeBonds.add(parentAtoms.get(i2).getBondToAtomOrThrow(parentAtoms.get(i2 + 1)));
        }
        HashSet<Bond> bondsToAddToParentAtoms = new HashSet<Bond>();
        for (Atom childAtom : childAtoms) {
            for (Bond b : childAtom.getBonds()) {
                if (fusionEdgeBonds.contains(b)) continue;
                bondsToAddToParentAtoms.add(b);
            }
        }
        HashSet<Bond> bondsToAddToChildAtoms = new HashSet<Bond>();
        for (Atom parentAtom : parentAtoms) {
            for (Bond b : parentAtom.getBonds()) {
                if (fusionEdgeBonds.contains(b)) continue;
                bondsToAddToChildAtoms.add(b);
            }
        }
        for (Bond bond : bondsToAddToParentAtoms) {
            from2 = bond.getFromAtom();
            int indiceInChildAtoms = childAtoms.indexOf(from2);
            if (indiceInChildAtoms != -1) {
                from2 = parentAtoms.get(indiceInChildAtoms);
            }
            if ((indiceInChildAtoms = childAtoms.indexOf(to2 = bond.getToAtom())) != -1) {
                to2 = parentAtoms.get(indiceInChildAtoms);
            }
            this.state.fragManager.createBond(from2, to2, 1);
        }
        for (Bond bond : bondsToAddToChildAtoms) {
            from2 = bond.getFromAtom();
            int indiceInParentAtoms = parentAtoms.indexOf(from2);
            if (indiceInParentAtoms != -1) {
                from2 = childAtoms.get(indiceInParentAtoms);
            }
            if ((indiceInParentAtoms = parentAtoms.indexOf(to2 = bond.getToAtom())) != -1) {
                to2 = childAtoms.get(indiceInParentAtoms);
            }
            Bond newBond = new Bond(from2, to2, 1);
            if (childAtoms.contains(from2)) {
                from2.addBond(newBond);
                continue;
            }
            to2.addBond(newBond);
        }
    }

    private void benzoSpecificFusion(Element benzoEl, Element parentEl) throws StructureBuildingException {
        Fragment benzoRing = this.state.xmlFragmentMap.get(benzoEl);
        Fragment parentRing = this.state.xmlFragmentMap.get(parentEl);
        this.performSimpleFusion(null, benzoRing, parentRing);
        this.state.fragManager.incorporateFragment(benzoRing, parentRing);
        this.removeMergedAtoms();
        FusedRingNumberer.numberFusedRing(parentRing);
        Fragment fusedRing = parentRing;
        Element locantEl = (Element)XOMTools.getPreviousSibling(benzoEl);
        if (locantEl != null && locantEl.getLocalName().equals("locant")) {
            String[] locants = OpsinTools.MATCH_COMMA.split(locantEl.getValue());
            Elements suffixes = ((Element)benzoEl.getParent()).getChildElements("suffix");
            int suffixesWithoutLocants = 0;
            for (int i = 0; i < suffixes.size(); ++i) {
                if (suffixes.get(i).getAttribute("locant") != null) continue;
                ++suffixesWithoutLocants;
            }
            if (locants.length != suffixesWithoutLocants) {
                List<Atom> atomList = fusedRing.getAtomList();
                LinkedList<Atom> heteroatoms = new LinkedList<Atom>();
                LinkedList<String> elementOfHeteroAtom = new LinkedList<String>();
                for (Atom atom : atomList) {
                    if (atom.getElement().equals("C")) continue;
                    heteroatoms.add(atom);
                    elementOfHeteroAtom.add(atom.getElement());
                }
                if (locants.length == heteroatoms.size()) {
                    for (Atom atom : heteroatoms) {
                        atom.setElement("C");
                    }
                    FragmentTools.pickUpIndicatedHydrogens(fusedRing);
                    for (int i = 0; i < heteroatoms.size(); ++i) {
                        String elementSymbol = (String)elementOfHeteroAtom.get(i);
                        fusedRing.getAtomByLocantOrThrow(locants[i]).setElement(elementSymbol);
                    }
                    locantEl.detach();
                } else if (locants.length > 1) {
                    throw new StructureBuildingException("Unable to assign all locants to benzo-fused ring or multiplier was mising");
                }
            }
        }
    }
}

