/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ComponentGenerationException;
import uk.ac.cam.ch.wwmm.opsin.ComponentProcessor;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FunctionalAtom;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.WordRule;
import uk.ac.cam.ch.wwmm.opsin.WordType;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FunctionalReplacement {
    private static final Pattern matchChalcogen = Pattern.compile("O|S|Se|Te");
    private static final Pattern matchChalcogenReplacement = Pattern.compile("thio|seleno|telluro");

    FunctionalReplacement() {
    }

    static void processAmideOrHydrazideFunctionalClassNomenclature(BuildState state, Element finalSubOrRootInWord, Element word) throws ComponentGenerationException, StructureBuildingException {
        Element parentWordRule;
        Element wordRule = OpsinTools.getParentWordRule(word);
        WordRule wr = WordRule.valueOf(wordRule.getAttributeValue("wordRule"));
        if (wr == WordRule.hydrazide) {
            FunctionalReplacement.processHydrazideFunctionalClassNomenclature(state, finalSubOrRootInWord, (Element)XOMTools.getNextSibling(word));
        } else if (wr == WordRule.amide && (parentWordRule = (Element)word.getParent()).indexOf(word) == 0) {
            List<Element> amideFullWords = XOMTools.getChildElementsWithTagNameAndAttribute(parentWordRule, "word", "type", WordType.full.toString());
            amideFullWords.remove(word);
            if (amideFullWords.size() > 0) {
                for (Element amideWord : amideFullWords) {
                    FunctionalReplacement.processAmideFunctionalClassNomenclatureFullWord(state, finalSubOrRootInWord, amideWord);
                }
            } else if (parentWordRule.getChildElements().size() == 2) {
                FunctionalReplacement.processAmideFunctionalClassNomenclatureFunctionalWord(state, finalSubOrRootInWord, (Element)XOMTools.getNextSibling(word));
            } else {
                throw new ComponentGenerationException("OPSIN bug: problem with amide word rule");
            }
        }
    }

    static boolean processPrefixFunctionalReplacementNomenclature(BuildState state, List<Element> groups, List<Element> substituents) throws StructureBuildingException, ComponentGenerationException {
        int originalNumberOfGroups = groups.size();
        for (int i = originalNumberOfGroups - 1; i >= 0; --i) {
            Element group = groups.get(i);
            String groupValue = group.getValue();
            PREFIX_REPLACEMENT_TYPE replacementType = null;
            if (matchChalcogenReplacement.matcher(groupValue).matches()) {
                replacementType = PREFIX_REPLACEMENT_TYPE.chalcogen;
            } else if ("halideOrPseudoHalide".equals(group.getAttributeValue("subType"))) {
                replacementType = PREFIX_REPLACEMENT_TYPE.halideOrPseudoHalide;
            } else if ("dedicatedFunctionalReplacementPrefix".equals(group.getAttributeValue("subType"))) {
                replacementType = PREFIX_REPLACEMENT_TYPE.dedicatedFunctionalReplacementPrefix;
            } else if (groupValue.equals("hydrazono")) {
                replacementType = PREFIX_REPLACEMENT_TYPE.hydrazono;
            } else if (groupValue.equals("peroxy")) {
                replacementType = PREFIX_REPLACEMENT_TYPE.peroxy;
            }
            if (replacementType == null) continue;
            Element substituent = (Element)group.getParent();
            Element nextSubOrBracket = (Element)XOMTools.getNextSibling(substituent);
            if (nextSubOrBracket != null && (nextSubOrBracket.getLocalName().equals("root") || nextSubOrBracket.getLocalName().equals("substituent"))) {
                int oxygenReplaced;
                Element groupToBeModified = nextSubOrBracket.getFirstChildElement("group");
                if (XOMTools.getPreviousSibling(groupToBeModified) != null) {
                    if (replacementType != PREFIX_REPLACEMENT_TYPE.dedicatedFunctionalReplacementPrefix) continue;
                    throw new ComponentGenerationException("dedicated Functional Replacement Prefix used in an inappropriate position :" + groupValue);
                }
                Element locantEl = null;
                Element multiplierEl = null;
                int numberOfAtomsToReplace = 1;
                Element possibleMultiplier = (Element)XOMTools.getPreviousSibling(group);
                if (possibleMultiplier != null) {
                    Element possibleLocant;
                    if (possibleMultiplier.getLocalName().equals("multiplier")) {
                        numberOfAtomsToReplace = Integer.valueOf(possibleMultiplier.getAttributeValue("value"));
                        possibleLocant = (Element)XOMTools.getPreviousSibling(possibleMultiplier);
                        multiplierEl = possibleMultiplier;
                    } else {
                        possibleLocant = possibleMultiplier;
                    }
                    if (possibleLocant != null && possibleLocant.getLocalName().equals("locant") && possibleLocant.getAttribute("type") == null) {
                        int numberOfLocants = OpsinTools.MATCH_COMMA.split(possibleLocant.getValue()).length;
                        if (numberOfLocants == numberOfAtomsToReplace) {
                            locantEl = possibleLocant;
                        } else if (numberOfAtomsToReplace > 1) {
                            if (replacementType != PREFIX_REPLACEMENT_TYPE.dedicatedFunctionalReplacementPrefix) continue;
                            throw new ComponentGenerationException("dedicated Functional Replacement Prefix used in an inappropriate position :" + groupValue);
                        }
                    }
                }
                if (replacementType == PREFIX_REPLACEMENT_TYPE.chalcogen) {
                    oxygenReplaced = FunctionalReplacement.performChalcogenFunctionalReplacement(state, groupToBeModified, locantEl, numberOfAtomsToReplace, group.getAttributeValue("value"));
                } else if (replacementType == PREFIX_REPLACEMENT_TYPE.peroxy) {
                    if (nextSubOrBracket.getLocalName().equals("substituent")) continue;
                    oxygenReplaced = FunctionalReplacement.performPeroxyFunctionalReplacement(state, groupToBeModified, locantEl, numberOfAtomsToReplace);
                } else if (replacementType == PREFIX_REPLACEMENT_TYPE.dedicatedFunctionalReplacementPrefix) {
                    if (!groupToBeModified.getAttributeValue("type").equals("nonCarboxylicAcid")) {
                        throw new ComponentGenerationException("dedicated Functional Replacement Prefix used in an inappropriate position :" + groupValue);
                    }
                    oxygenReplaced = FunctionalReplacement.performFunctionalReplacementOnAcid(state, groupToBeModified, locantEl, numberOfAtomsToReplace, group.getAttributeValue("value"));
                    if (oxygenReplaced == 0) {
                        throw new ComponentGenerationException("dedicated Functional Replacement Prefix used in an inappropriate position :" + groupValue);
                    }
                } else if (replacementType == PREFIX_REPLACEMENT_TYPE.hydrazono || replacementType == PREFIX_REPLACEMENT_TYPE.halideOrPseudoHalide) {
                    Fragment acidFrag = state.xmlFragmentMap.get(groupToBeModified);
                    if (!groupToBeModified.getAttributeValue("type").equals("nonCarboxylicAcid") || FunctionalReplacement.acidHasSufficientHydrogenForSubstitutionInterpretation(acidFrag, state.xmlFragmentMap.get(group).getOutAtom(0).getValency(), locantEl)) continue;
                    oxygenReplaced = FunctionalReplacement.performFunctionalReplacementOnAcid(state, groupToBeModified, locantEl, numberOfAtomsToReplace, group.getAttributeValue("value"));
                } else {
                    throw new StructureBuildingException("OPSIN bug: Unexpected prefix replacement type");
                }
                if (oxygenReplaced <= 0) continue;
                state.fragManager.removeFragment(state.xmlFragmentMap.get(group));
                substituent.removeChild(group);
                groups.remove(group);
                Elements remainingChildren = substituent.getChildElements();
                for (int j = remainingChildren.size() - 1; j >= 0; --j) {
                    Node child = substituent.getChild(j);
                    child.detach();
                    nextSubOrBracket.insertChild(child, 0);
                }
                substituents.remove(substituent);
                substituent.detach();
                if (oxygenReplaced <= 1) continue;
                multiplierEl.detach();
                continue;
            }
            if (replacementType != PREFIX_REPLACEMENT_TYPE.dedicatedFunctionalReplacementPrefix) continue;
            throw new ComponentGenerationException("dedicated Functional Replacement Prefix used in an inappropriate position :" + groupValue);
        }
        return groups.size() != originalNumberOfGroups;
    }

    static void processInfixFunctionalReplacementNomenclature(BuildState state, List<Element> suffixes, List<Fragment> suffixFragments) throws StructureBuildingException, ComponentGenerationException {
        for (int i = 0; i < suffixes.size(); ++i) {
            Element suffix = suffixes.get(i);
            if (suffix.getAttribute("infix") == null) continue;
            Fragment fragToApplyInfixTo = state.xmlFragmentMap.get(suffix);
            Element possibleAcidGroup = XOMTools.getPreviousSiblingIgnoringCertainElements(suffix, new String[]{"multiplier", "infix", "suffix"});
            if (possibleAcidGroup != null && possibleAcidGroup.getLocalName().equals("group") && (possibleAcidGroup.getAttributeValue("type").equals("nonCarboxylicAcid") || possibleAcidGroup.getAttributeValue("type").equals("chalcogenAcidStem"))) {
                fragToApplyInfixTo = state.xmlFragmentMap.get(possibleAcidGroup);
            }
            if (fragToApplyInfixTo == null) {
                throw new ComponentGenerationException("infix has erroneously been assigned to a suffix which does not correspond to a suffix fragment. suffix: " + suffix.getValue());
            }
            List<String> infixTransformations = StringTools.arrayToList(OpsinTools.MATCH_SEMICOLON.split(suffix.getAttributeValue("infix")));
            List<Atom> atomList = fragToApplyInfixTo.getAtomList();
            LinkedList<Atom> singleBondedOxygen = new LinkedList<Atom>();
            LinkedList<Atom> doubleBondedOxygen = new LinkedList<Atom>();
            FunctionalReplacement.populateTerminalSingleAndDoubleBondedOxygen(atomList, singleBondedOxygen, doubleBondedOxygen);
            int oxygenAvailable = singleBondedOxygen.size() + doubleBondedOxygen.size();
            FunctionalReplacement.disambiguateMultipliedInfixMeaning(state, suffixes, suffixFragments, suffix, fragToApplyInfixTo, infixTransformations, oxygenAvailable);
            Collections.sort(infixTransformations, new SortInfixTransformations());
            for (String infixTransformation : infixTransformations) {
                String[] transformationArray = OpsinTools.MATCH_COLON.split(infixTransformation);
                if (transformationArray.length != 2) {
                    throw new StructureBuildingException("Atom to be replaced and replacement not specified correctly in infix: " + infixTransformation);
                }
                String[] transformations = OpsinTools.MATCH_COMMA.split(transformationArray[0]);
                String replacementSMILES = transformationArray[1];
                boolean acceptDoubleBondedOxygen = false;
                boolean acceptSingleBondedOxygen = false;
                boolean nitrido = false;
                for (String transformation : transformations) {
                    if (transformation.startsWith("=")) {
                        acceptDoubleBondedOxygen = true;
                    } else if (transformation.startsWith("-")) {
                        acceptSingleBondedOxygen = true;
                    } else if (transformation.startsWith("#")) {
                        nitrido = true;
                    } else {
                        throw new StructureBuildingException("Malformed infix transformation. Expected to start with either - or =. Transformation was: " + transformation);
                    }
                    if (transformation.length() >= 2 && transformation.charAt(1) == 'O') continue;
                    throw new StructureBuildingException("Only replacement by oxygen is supported. Check infix defintions");
                }
                boolean infixAssignmentAmbiguous = false;
                if ((acceptSingleBondedOxygen || nitrido) && !acceptDoubleBondedOxygen) {
                    if (singleBondedOxygen.size() == 0) {
                        throw new StructureBuildingException("Cannot find single bonded oxygen for infix with SMILES: " + replacementSMILES + " to modify!");
                    }
                    if (singleBondedOxygen.size() != 1) {
                        infixAssignmentAmbiguous = true;
                    }
                }
                if (!acceptSingleBondedOxygen && acceptDoubleBondedOxygen | nitrido) {
                    if (doubleBondedOxygen.size() == 0) {
                        throw new StructureBuildingException("Cannot find double bonded oxygen for infix with SMILES: " + replacementSMILES + " to modify!");
                    }
                    if (doubleBondedOxygen.size() != 1) {
                        infixAssignmentAmbiguous = true;
                    }
                }
                if (acceptSingleBondedOxygen && acceptDoubleBondedOxygen) {
                    if (oxygenAvailable == 0) {
                        throw new StructureBuildingException("Cannot find oxygen for infix with SMILES: " + replacementSMILES + " to modify!");
                    }
                    if (oxygenAvailable != 1) {
                        infixAssignmentAmbiguous = true;
                    }
                }
                HashSet<Atom> ambiguousElementAtoms = new HashSet<Atom>();
                Atom atomToUse = null;
                if ((acceptDoubleBondedOxygen || nitrido) && doubleBondedOxygen.size() > 0) {
                    atomToUse = doubleBondedOxygen.removeFirst();
                } else if (acceptSingleBondedOxygen && singleBondedOxygen.size() > 0) {
                    atomToUse = singleBondedOxygen.removeFirst();
                } else {
                    throw new StructureBuildingException("Cannot find oxygen for infix with SMILES: " + replacementSMILES + " to modify!");
                }
                Fragment replacementFrag = state.fragManager.buildSMILES(replacementSMILES, "suffix", "none");
                if (replacementFrag.getOutAtoms().size() > 0) {
                    replacementFrag.removeOutAtom(0);
                }
                Atom atomThatWillReplaceOxyen = replacementFrag.getFirstAtom();
                if (replacementFrag.getAtomList().size() == 1 && matchChalcogen.matcher(atomThatWillReplaceOxyen.getElement()).matches()) {
                    atomThatWillReplaceOxyen.setCharge(atomToUse.getCharge());
                    atomThatWillReplaceOxyen.setProtonsExplicitlyAddedOrRemoved(atomToUse.getProtonsExplicitlyAddedOrRemoved());
                }
                FunctionalReplacement.removeOrMoveObsoleteFunctionalAtoms(atomToUse, replacementFrag);
                if (nitrido) {
                    atomToUse.getFirstBond().setOrder(3);
                    state.fragManager.removeAtomAndAssociatedBonds(singleBondedOxygen.removeFirst());
                }
                state.fragManager.incorporateFragment(replacementFrag, atomToUse.getFrag());
                state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToUse, atomThatWillReplaceOxyen);
                if (infixAssignmentAmbiguous) {
                    ambiguousElementAtoms.add(atomThatWillReplaceOxyen);
                    if (atomThatWillReplaceOxyen.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT) != null) {
                        ambiguousElementAtoms.addAll((Collection)atomThatWillReplaceOxyen.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT));
                    }
                }
                if (!infixAssignmentAmbiguous) continue;
                for (Atom a : doubleBondedOxygen) {
                    ambiguousElementAtoms.add(a);
                    if (a.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT) == null) continue;
                    ambiguousElementAtoms.addAll((Collection)a.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT));
                }
                for (Atom a : singleBondedOxygen) {
                    ambiguousElementAtoms.add(a);
                    if (a.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT) == null) continue;
                    ambiguousElementAtoms.addAll((Collection)a.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT));
                }
                for (Atom atom : ambiguousElementAtoms) {
                    atom.setProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT, ambiguousElementAtoms);
                }
            }
        }
    }

    private static void processHydrazideFunctionalClassNomenclature(BuildState state, Element acidContainingRoot, Element functionalWord) throws ComponentGenerationException, StructureBuildingException {
        List<Atom> oxygenAtoms;
        Fragment hydrazide;
        if (functionalWord != null && functionalWord.getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            Element functionalTerm = functionalWord.getFirstChildElement("functionalTerm");
            if (functionalTerm == null) {
                throw new ComponentGenerationException("OPSIN bug: functionalTerm word not found where one was expected for hydrazide wordRule");
            }
            Element hydrazideGroup = functionalTerm.getFirstChildElement("functionalGroup");
            hydrazide = ComponentProcessor.resolveGroup(state, hydrazideGroup);
            Element possibleMultiplier = (Element)XOMTools.getPreviousSibling(hydrazideGroup);
            int hydrazides = 1;
            if (possibleMultiplier != null) {
                if (!possibleMultiplier.getLocalName().equals("multiplier")) {
                    throw new ComponentGenerationException("OPSIN bug: non multiplier found where only a multiplier was expected in hydrazide wordRule");
                }
                hydrazides = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                possibleMultiplier.detach();
            }
            if (functionalTerm.getChildElements().size() != 1) {
                throw new ComponentGenerationException("Unexpected qualifier to hydrazide functionalTerm");
            }
            Element groupToBeModified = acidContainingRoot.getFirstChildElement("group");
            oxygenAtoms = FunctionalReplacement.findFunctionalOxygenAtomsInApplicableSuffixes(state, groupToBeModified);
            if (oxygenAtoms.size() == 0) {
                oxygenAtoms = FunctionalReplacement.findFunctionalOxygenAtomsInGroup(state, groupToBeModified);
            }
            if (oxygenAtoms.size() == 0) {
                List<Element> conjunctiveSuffixElements = XOMTools.getNextSiblingsOfType(groupToBeModified, "conjunctiveSuffixGroup");
                for (Element conjunctiveSuffixElement : conjunctiveSuffixElements) {
                    oxygenAtoms.addAll(FunctionalReplacement.findFunctionalOxygenAtomsInGroup(state, conjunctiveSuffixElement));
                }
            }
            if (hydrazides > oxygenAtoms.size()) {
                throw new ComponentGenerationException("Insufficient oxygen to replace with hydrazides in " + acidContainingRoot.getFirstChildElement("group").getValue());
            }
            Fragment acidFragment = state.xmlFragmentMap.get(groupToBeModified);
            if (acidFragment.hasLocant("2")) {
                for (Atom atom : hydrazide.getAtomList()) {
                    atom.clearLocants();
                }
            }
            state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(oxygenAtoms.get(0), hydrazide.getFirstAtom());
            FunctionalReplacement.removeAssociatedFunctionalAtom(oxygenAtoms.get(0));
            for (int i = 1; i < hydrazides; ++i) {
                Fragment clonedHydrazide = state.fragManager.copyAndRelabelFragment(hydrazide, i);
                state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(oxygenAtoms.get(i), clonedHydrazide.getFirstAtom());
                state.fragManager.incorporateFragment(clonedHydrazide, oxygenAtoms.get(i).getFrag());
                FunctionalReplacement.removeAssociatedFunctionalAtom(oxygenAtoms.get(i));
            }
        } else {
            throw new ComponentGenerationException("hydrazide word not found where expected, bug?");
        }
        state.fragManager.incorporateFragment(hydrazide, oxygenAtoms.get(0).getFrag());
    }

    private static void processAmideFunctionalClassNomenclatureFullWord(BuildState state, Element acidContainingRoot, Element amideWord) throws ComponentGenerationException, StructureBuildingException {
        Element amideGroup = StructureBuildingMethods.findRightMostGroupInBracket(amideWord);
        if (amideGroup == null) {
            throw new ComponentGenerationException("OPSIN bug: amide group not found where one was expected for amide wordRule");
        }
        Fragment amide = state.xmlFragmentMap.get(amideGroup);
        if (((Element)amideGroup.getParent()).getChildElements().size() != 1) {
            throw new ComponentGenerationException("Unexpected qualifier to amide");
        }
        Element groupToBeModified = acidContainingRoot.getFirstChildElement("group");
        List<Atom> oxygenAtoms = FunctionalReplacement.findFunctionalOxygenAtomsInApplicableSuffixes(state, groupToBeModified);
        if (oxygenAtoms.size() == 0) {
            oxygenAtoms = FunctionalReplacement.findFunctionalOxygenAtomsInGroup(state, groupToBeModified);
        }
        if (oxygenAtoms.size() == 0) {
            List<Element> conjunctiveSuffixElements = XOMTools.getNextSiblingsOfType(groupToBeModified, "conjunctiveSuffixGroup");
            for (Element conjunctiveSuffixElement : conjunctiveSuffixElements) {
                oxygenAtoms.addAll(FunctionalReplacement.findFunctionalOxygenAtomsInGroup(state, conjunctiveSuffixElement));
            }
        }
        if (oxygenAtoms.size() < 1) {
            throw new ComponentGenerationException("Insufficient oxygen to replace with amides in " + acidContainingRoot.getFirstChildElement("group").getValue());
        }
        if (amide.getAtomList().size() != 1) {
            throw new ComponentGenerationException("OPSIN bug: amide not found where expected");
        }
        Atom amideNitrogen = amide.getFirstAtom();
        amideNitrogen.neutraliseCharge();
        amideNitrogen.clearLocants();
        amide.addMappingToAtomLocantMap("N", amideNitrogen);
        state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(oxygenAtoms.get(0), amide.getFirstAtom());
        state.fragManager.incorporateFragment(amide, oxygenAtoms.get(0).getFrag());
        FunctionalReplacement.removeAssociatedFunctionalAtom(oxygenAtoms.get(0));
    }

    private static void processAmideFunctionalClassNomenclatureFunctionalWord(BuildState state, Element acidContainingRoot, Element functionalWord) throws ComponentGenerationException, StructureBuildingException {
        if (functionalWord != null && functionalWord.getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            Element functionalTerm = functionalWord.getFirstChildElement("functionalTerm");
            if (functionalTerm == null) {
                throw new ComponentGenerationException("OPSIN bug: functionalTerm word not found where one was expected for amide wordRule");
            }
            Element amideGroup = functionalTerm.getFirstChildElement("functionalGroup");
            Element possibleMultiplier = (Element)XOMTools.getPreviousSibling(amideGroup);
            int numbrOfAmidesToForm = 1;
            if (possibleMultiplier != null) {
                if (!possibleMultiplier.getLocalName().equals("multiplier")) {
                    throw new ComponentGenerationException("OPSIN bug: non multiplier found where only a multiplier was expected in amide wordRule");
                }
                numbrOfAmidesToForm = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                possibleMultiplier.detach();
            }
            if (functionalTerm.getChildElements().size() != 1) {
                throw new ComponentGenerationException("Unexpected qualifier to amide functionalTerm");
            }
            Element groupToBeModified = acidContainingRoot.getFirstChildElement("group");
            List<Atom> oxygenAtoms = FunctionalReplacement.findFunctionalOxygenAtomsInApplicableSuffixes(state, groupToBeModified);
            if (oxygenAtoms.size() == 0) {
                oxygenAtoms = FunctionalReplacement.findFunctionalOxygenAtomsInGroup(state, groupToBeModified);
            }
            if (oxygenAtoms.size() == 0) {
                List<Element> conjunctiveSuffixElements = XOMTools.getNextSiblingsOfType(groupToBeModified, "conjunctiveSuffixGroup");
                for (Element conjunctiveSuffixElement : conjunctiveSuffixElements) {
                    oxygenAtoms.addAll(FunctionalReplacement.findFunctionalOxygenAtomsInGroup(state, conjunctiveSuffixElement));
                }
            }
            if (numbrOfAmidesToForm > oxygenAtoms.size()) {
                throw new ComponentGenerationException("Insufficient oxygen to replace with nitrogen in " + acidContainingRoot.getFirstChildElement("group").getValue());
            }
            for (int i = 0; i < numbrOfAmidesToForm; ++i) {
                oxygenAtoms.get(i).setElement("N");
                FunctionalReplacement.removeAssociatedFunctionalAtom(oxygenAtoms.get(i));
            }
        } else {
            throw new ComponentGenerationException("amide word not found where expected, bug?");
        }
    }

    private static boolean acidHasSufficientHydrogenForSubstitutionInterpretation(Fragment acidFrag, int hydrogenRequiredForSubstitutionInterpretation, Element locantEl) throws StructureBuildingException {
        ArrayList<Atom> atomsThatWouldBeSubstituted = new ArrayList<Atom>();
        if (locantEl != null) {
            String[] possibleLocants;
            for (String locant : possibleLocants = OpsinTools.MATCH_COMMA.split(locantEl.getValue())) {
                Atom atomToBeSubstituted = acidFrag.getAtomByLocant(locant);
                if (atomToBeSubstituted == null) {
                    atomsThatWouldBeSubstituted.clear();
                    atomsThatWouldBeSubstituted.add(acidFrag.getDefaultInAtom());
                    break;
                }
                atomsThatWouldBeSubstituted.add(atomToBeSubstituted);
            }
        } else {
            atomsThatWouldBeSubstituted.add(acidFrag.getDefaultInAtom());
        }
        for (Atom atom : atomsThatWouldBeSubstituted) {
            if (StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(atom) >= hydrogenRequiredForSubstitutionInterpretation) continue;
            return false;
        }
        return true;
    }

    private static int performChalcogenFunctionalReplacement(BuildState state, Element groupToBeModified, Element locantEl, int numberOfAtomsToReplace, String replacementSmiles) throws StructureBuildingException {
        List<Atom> oxygenAtoms = FunctionalReplacement.findOxygenAtomsInApplicableSuffixes(state, groupToBeModified);
        if (oxygenAtoms.size() == 0) {
            oxygenAtoms = FunctionalReplacement.findOxygenAtomsInGroup(state, groupToBeModified);
        }
        if (locantEl != null) {
            List<Atom> oxygenWithAppropriateLocants = FunctionalReplacement.pickOxygensWithAppropriateLocants(locantEl, oxygenAtoms);
            if (oxygenWithAppropriateLocants.size() < numberOfAtomsToReplace) {
                numberOfAtomsToReplace = 1;
            } else {
                locantEl.detach();
                oxygenAtoms = oxygenWithAppropriateLocants;
            }
        }
        ArrayList<Atom> doubleBondedOxygen = new ArrayList<Atom>();
        ArrayList<Atom> singleBondedOxygen = new ArrayList<Atom>();
        ArrayList<Atom> ethericOxygen = new ArrayList<Atom>();
        for (Atom oxygen : oxygenAtoms) {
            int incomingValency = oxygen.getIncomingValency();
            int bondCount = oxygen.getBonds().size();
            if (bondCount == 1 && incomingValency == 2) {
                doubleBondedOxygen.add(oxygen);
                continue;
            }
            if (bondCount == 1 && incomingValency == 1) {
                singleBondedOxygen.add(oxygen);
                continue;
            }
            if (bondCount != 2 || incomingValency != 2) continue;
            ethericOxygen.add(oxygen);
        }
        LinkedList<Atom> replaceableAtoms = new LinkedList<Atom>();
        replaceableAtoms.addAll(doubleBondedOxygen);
        replaceableAtoms.addAll(singleBondedOxygen);
        replaceableAtoms.addAll(ethericOxygen);
        int totalOxygen = replaceableAtoms.size();
        if (numberOfAtomsToReplace > 1 && totalOxygen < numberOfAtomsToReplace) {
            numberOfAtomsToReplace = 1;
        }
        int atomsReplaced = 0;
        if (totalOxygen >= numberOfAtomsToReplace) {
            boolean prefixAssignmentAmbiguous = false;
            HashSet<Atom> ambiguousElementAtoms = new HashSet<Atom>();
            if (totalOxygen != numberOfAtomsToReplace) {
                prefixAssignmentAmbiguous = true;
            }
            for (Atom atomToReplace : replaceableAtoms) {
                if (atomsReplaced == numberOfAtomsToReplace) {
                    ambiguousElementAtoms.add(atomToReplace);
                    continue;
                }
                state.fragManager.replaceAtomWithSmiles(atomToReplace, replacementSmiles);
                if (prefixAssignmentAmbiguous) {
                    ambiguousElementAtoms.add(atomToReplace);
                }
                ++atomsReplaced;
            }
            if (prefixAssignmentAmbiguous) {
                for (Atom atom : ambiguousElementAtoms) {
                    atom.setProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT, ambiguousElementAtoms);
                }
            }
        }
        return atomsReplaced;
    }

    private static int performPeroxyFunctionalReplacement(BuildState state, Element groupToBeModified, Element locantEl, int numberOfAtomsToReplace) throws StructureBuildingException {
        List<Atom> oxygenAtoms = FunctionalReplacement.findFunctionalOxygenAtomsInApplicableSuffixes(state, groupToBeModified);
        if (oxygenAtoms.size() == 0) {
            oxygenAtoms = FunctionalReplacement.findEthericOxygenAtomsInGroup(state, groupToBeModified);
            oxygenAtoms.addAll(FunctionalReplacement.findFunctionalOxygenAtomsInGroup(state, groupToBeModified));
        }
        if (locantEl != null) {
            List<Atom> oxygenWithAppropriateLocants = FunctionalReplacement.pickOxygensWithAppropriateLocants(locantEl, oxygenAtoms);
            if (oxygenWithAppropriateLocants.size() < numberOfAtomsToReplace) {
                numberOfAtomsToReplace = 1;
            } else {
                locantEl.detach();
                oxygenAtoms = oxygenWithAppropriateLocants;
            }
        }
        if (numberOfAtomsToReplace > 1 && oxygenAtoms.size() < numberOfAtomsToReplace) {
            numberOfAtomsToReplace = 1;
        }
        int atomsReplaced = 0;
        if (oxygenAtoms.size() >= numberOfAtomsToReplace) {
            atomsReplaced = numberOfAtomsToReplace;
            for (int j = 0; j < numberOfAtomsToReplace; ++j) {
                Atom oxygenToReplace = oxygenAtoms.get(j);
                if (oxygenToReplace.getBonds().size() == 2) {
                    Fragment newOxygen = state.fragManager.buildSMILES("O", "suffix", "none");
                    Bond bondToRemove = oxygenToReplace.getFirstBond();
                    Atom atomToAttachTo = bondToRemove.getFromAtom() == oxygenToReplace ? bondToRemove.getToAtom() : bondToRemove.getFromAtom();
                    state.fragManager.createBond(atomToAttachTo, newOxygen.getFirstAtom(), 1);
                    state.fragManager.createBond(newOxygen.getFirstAtom(), oxygenToReplace, 1);
                    state.fragManager.removeBond(bondToRemove);
                    state.fragManager.incorporateFragment(newOxygen, state.xmlFragmentMap.get(groupToBeModified));
                    continue;
                }
                Fragment replacementFrag = state.fragManager.buildSMILES("OO", "suffix", "none");
                FunctionalReplacement.removeOrMoveObsoleteFunctionalAtoms(oxygenToReplace, replacementFrag);
                state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(oxygenToReplace, replacementFrag.getFirstAtom());
                state.fragManager.incorporateFragment(replacementFrag, state.xmlFragmentMap.get(groupToBeModified));
            }
        }
        return atomsReplaced;
    }

    private static int performFunctionalReplacementOnAcid(BuildState state, Element groupToBeModified, Element locantEl, int numberOfAtomsToReplace, String replacementSmiles) throws StructureBuildingException {
        int outValency;
        if (replacementSmiles.startsWith("-")) {
            outValency = 1;
        } else if (replacementSmiles.startsWith("=")) {
            outValency = 2;
        } else if (replacementSmiles.startsWith("#")) {
            outValency = 3;
        } else {
            throw new StructureBuildingException("OPSIN bug: Unexpected valency on fragment for prefix functional replacement");
        }
        replacementSmiles = replacementSmiles.substring(1);
        List<Atom> oxygenAtoms = FunctionalReplacement.findOxygenAtomsInApplicableSuffixes(state, groupToBeModified);
        if (oxygenAtoms.size() == 0) {
            oxygenAtoms = FunctionalReplacement.findOxygenAtomsInGroup(state, groupToBeModified);
        }
        if (locantEl != null) {
            List<Atom> oxygenWithAppropriateLocants = FunctionalReplacement.pickOxygensWithAppropriateLocants(locantEl, oxygenAtoms);
            LinkedList<Atom> singleBondedOxygen = new LinkedList<Atom>();
            LinkedList<Atom> terminalDoubleBondedOxygen = new LinkedList<Atom>();
            FunctionalReplacement.populateTerminalSingleAndDoubleBondedOxygen(oxygenWithAppropriateLocants, singleBondedOxygen, terminalDoubleBondedOxygen);
            if (outValency == 1) {
                oxygenWithAppropriateLocants.removeAll(terminalDoubleBondedOxygen);
            } else if (outValency == 2) {
                oxygenWithAppropriateLocants.removeAll(singleBondedOxygen);
            }
            if (oxygenWithAppropriateLocants.size() < numberOfAtomsToReplace) {
                numberOfAtomsToReplace = 1;
            } else {
                locantEl.detach();
                oxygenAtoms = oxygenWithAppropriateLocants;
            }
        }
        LinkedList<Atom> singleBondedOxygen = new LinkedList<Atom>();
        LinkedList<Atom> terminalDoubleBondedOxygen = new LinkedList<Atom>();
        FunctionalReplacement.populateTerminalSingleAndDoubleBondedOxygen(oxygenAtoms, singleBondedOxygen, terminalDoubleBondedOxygen);
        if (outValency == 1) {
            oxygenAtoms.removeAll(terminalDoubleBondedOxygen);
        } else if (outValency == 2) {
            oxygenAtoms.removeAll(singleBondedOxygen);
            oxygenAtoms.removeAll(terminalDoubleBondedOxygen);
            oxygenAtoms.addAll(terminalDoubleBondedOxygen);
        } else {
            if (singleBondedOxygen.size() == 0 || terminalDoubleBondedOxygen.size() == 0) {
                throw new StructureBuildingException("Both a -OH and =O are required for nitrido prefix functional replacement");
            }
            oxygenAtoms.removeAll(singleBondedOxygen);
        }
        if (numberOfAtomsToReplace > 1 && oxygenAtoms.size() < numberOfAtomsToReplace) {
            numberOfAtomsToReplace = 1;
        }
        int atomsReplaced = 0;
        if (oxygenAtoms.size() >= numberOfAtomsToReplace) {
            for (Atom atomToReplace : oxygenAtoms) {
                if (atomsReplaced == numberOfAtomsToReplace) continue;
                Fragment replacementFrag = state.fragManager.buildSMILES(replacementSmiles, atomToReplace.getFrag().getType(), "none");
                if (outValency == 3) {
                    atomToReplace.getFirstBond().setOrder(3);
                    state.fragManager.removeAtomAndAssociatedBonds(singleBondedOxygen.removeFirst());
                }
                state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToReplace, replacementFrag.getFirstAtom());
                if (outValency == 1) {
                    FunctionalReplacement.removeOrMoveObsoleteFunctionalAtoms(atomToReplace, replacementFrag);
                }
                state.fragManager.incorporateFragment(replacementFrag, atomToReplace.getFrag());
                ++atomsReplaced;
            }
        }
        return atomsReplaced;
    }

    private static void disambiguateMultipliedInfixMeaning(BuildState state, List<Element> suffixes, List<Fragment> suffixFragments, Element suffix, Fragment suffixFrag, List<String> infixTransformations, int oxygenAvailable) throws ComponentGenerationException, StructureBuildingException {
        Element possibleInfix = (Element)XOMTools.getPreviousSibling(suffix);
        if (possibleInfix.getLocalName().equals("infix")) {
            Element possibleMultiplier = (Element)XOMTools.getPreviousSibling(possibleInfix);
            if (possibleMultiplier.getLocalName().equals("multiplier")) {
                int multiplierValue = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                if (infixTransformations.size() + multiplierValue - 1 <= oxygenAvailable) {
                    for (int j = 1; j < multiplierValue; ++j) {
                        infixTransformations.add(0, infixTransformations.get(0));
                    }
                } else {
                    Element possibleLocant = (Element)XOMTools.getPreviousSibling(possibleMultiplier);
                    String[] locants = null;
                    if (possibleLocant.getLocalName().equals("locant")) {
                        locants = OpsinTools.MATCH_COMMA.split(possibleLocant.getValue());
                    }
                    if (locants != null) {
                        if (locants.length != multiplierValue) {
                            throw new ComponentGenerationException("Multiplier/locant disagreement when multiplying infixed suffix");
                        }
                        suffix.addAttribute(new Attribute("locant", locants[0]));
                    }
                    suffix.addAttribute(new Attribute("multiplied", "multiplied"));
                    for (int j = 1; j < multiplierValue; ++j) {
                        Element newSuffix = new Element(suffix);
                        Fragment newSuffixFrag = state.fragManager.copyFragment(suffixFrag);
                        state.xmlFragmentMap.put(newSuffix, newSuffixFrag);
                        suffixFragments.add(newSuffixFrag);
                        XOMTools.insertAfter(suffix, newSuffix);
                        suffixes.add(newSuffix);
                        if (locants == null) continue;
                        newSuffix.getAttribute("locant").setValue(locants[j]);
                    }
                    if (locants != null) {
                        possibleLocant.detach();
                    }
                }
                possibleMultiplier.detach();
                possibleInfix.detach();
            } else {
                throw new ComponentGenerationException("Multiplier expected in front of ambiguous infix");
            }
        }
    }

    private static void removeOrMoveObsoleteFunctionalAtoms(Atom atomToBeReplaced, Fragment replacementFrag) {
        List<Atom> replacementAtomList = replacementFrag.getAtomList();
        List<FunctionalAtom> functionalAtoms = atomToBeReplaced.getFrag().getFunctionalAtoms();
        for (int j = functionalAtoms.size() - 1; j >= 0; --j) {
            FunctionalAtom functionalAtom = functionalAtoms.get(j);
            if (!atomToBeReplaced.equals(functionalAtom.getAtom())) continue;
            atomToBeReplaced.getFrag().removeFunctionalAtom(j);
            Atom terminalAtomOfReplacementFrag = replacementAtomList.get(replacementAtomList.size() - 1);
            if ((terminalAtomOfReplacementFrag.getIncomingValency() == 1 || replacementAtomList.size() == 1) && matchChalcogen.matcher(terminalAtomOfReplacementFrag.getElement()).matches()) {
                replacementFrag.addFunctionalAtom(terminalAtomOfReplacementFrag);
                terminalAtomOfReplacementFrag.setCharge(atomToBeReplaced.getCharge());
                terminalAtomOfReplacementFrag.setProtonsExplicitlyAddedOrRemoved(atomToBeReplaced.getProtonsExplicitlyAddedOrRemoved());
            }
            atomToBeReplaced.neutraliseCharge();
        }
    }

    private static void removeAssociatedFunctionalAtom(Atom atomWithFunctionalAtom) throws ComponentGenerationException {
        List<FunctionalAtom> functionalAtoms = atomWithFunctionalAtom.getFrag().getFunctionalAtoms();
        for (int j = functionalAtoms.size() - 1; j >= 0; --j) {
            FunctionalAtom functionalAtom = functionalAtoms.get(j);
            if (!atomWithFunctionalAtom.equals(functionalAtom.getAtom())) continue;
            atomWithFunctionalAtom.getFrag().removeFunctionalAtom(j);
            return;
        }
        throw new ComponentGenerationException("OPSIN bug: Unable to find associated functionalAtom");
    }

    private static List<Atom> pickOxygensWithAppropriateLocants(Element locantEl, List<Atom> oxygenAtoms) {
        String[] possibleLocants = OpsinTools.MATCH_COMMA.split(locantEl.getValue());
        ArrayList<Atom> oxygenWithAppropriateLocants = new ArrayList<Atom>();
        block0: for (Atom atom : oxygenAtoms) {
            List<String> atomlocants = atom.getLocants();
            if (atomlocants.size() > 0) {
                for (String locantVal : possibleLocants) {
                    if (!atomlocants.contains(locantVal)) continue;
                    oxygenWithAppropriateLocants.add(atom);
                    continue block0;
                }
                continue;
            }
            Atom atomWithNumericLocant = OpsinTools.depthFirstSearchForAtomWithNumericLocant(atom);
            if (atomWithNumericLocant == null) continue;
            List<String> atomWithNumericLocantLocants = atomWithNumericLocant.getLocants();
            for (String locantVal : possibleLocants) {
                if (!atomWithNumericLocantLocants.contains(locantVal)) continue;
                oxygenWithAppropriateLocants.add(atom);
                continue block0;
            }
        }
        return oxygenWithAppropriateLocants;
    }

    private static List<Atom> findFunctionalOxygenAtomsInApplicableSuffixes(BuildState state, Element groupToBeModified) {
        List<Element> suffixElements = XOMTools.getNextSiblingsOfType(groupToBeModified, "suffix");
        ArrayList<Atom> oxygenAtoms = new ArrayList<Atom>();
        for (Element suffix : suffixElements) {
            Fragment suffixFrag = state.xmlFragmentMap.get(suffix);
            if (suffixFrag == null) continue;
            List<FunctionalAtom> functionalAtoms = suffixFrag.getFunctionalAtoms();
            for (FunctionalAtom funcA : functionalAtoms) {
                Atom a = funcA.getAtom();
                if (!a.getElement().equals("O")) continue;
                oxygenAtoms.add(funcA.getAtom());
            }
        }
        return oxygenAtoms;
    }

    private static List<Atom> findFunctionalOxygenAtomsInGroup(BuildState state, Element groupToBeModified) {
        ArrayList<Atom> oxygenAtoms = new ArrayList<Atom>();
        List<FunctionalAtom> functionalAtoms = state.xmlFragmentMap.get(groupToBeModified).getFunctionalAtoms();
        for (FunctionalAtom funcA : functionalAtoms) {
            Atom a = funcA.getAtom();
            if (!a.getElement().equals("O")) continue;
            oxygenAtoms.add(funcA.getAtom());
        }
        return oxygenAtoms;
    }

    private static List<Atom> findEthericOxygenAtomsInGroup(BuildState state, Element groupToBeModified) {
        ArrayList<Atom> oxygenAtoms = new ArrayList<Atom>();
        List<Atom> atomList = state.xmlFragmentMap.get(groupToBeModified).getAtomList();
        for (Atom a : atomList) {
            if (!a.getElement().equals("O") || a.getBonds().size() != 2 || a.getCharge() != 0 || a.getIncomingValency() != 2) continue;
            oxygenAtoms.add(a);
        }
        return oxygenAtoms;
    }

    private static List<Atom> findOxygenAtomsInApplicableSuffixes(BuildState state, Element groupToBeModified) {
        List<Element> suffixElements = XOMTools.getNextSiblingsOfType(groupToBeModified, "suffix");
        ArrayList<Atom> oxygenAtoms = new ArrayList<Atom>();
        for (Element suffix : suffixElements) {
            Fragment suffixFrag = state.xmlFragmentMap.get(suffix);
            if (suffixFrag == null || suffixFrag.getFunctionalAtoms().size() <= 0 && !groupToBeModified.getAttributeValue("type").equals("acidStem") && !suffix.getAttributeValue("value").equals("aldehyde")) continue;
            List<Atom> atomList = suffixFrag.getAtomList();
            for (Atom a : atomList) {
                if (!a.getElement().equals("O")) continue;
                oxygenAtoms.add(a);
            }
        }
        return oxygenAtoms;
    }

    private static List<Atom> findOxygenAtomsInGroup(BuildState state, Element groupToBeModified) {
        ArrayList<Atom> oxygenAtoms = new ArrayList<Atom>();
        List<Atom> atomList = state.xmlFragmentMap.get(groupToBeModified).getAtomList();
        for (Atom a : atomList) {
            if (!a.getElement().equals("O")) continue;
            oxygenAtoms.add(a);
        }
        return oxygenAtoms;
    }

    private static void populateTerminalSingleAndDoubleBondedOxygen(List<Atom> atomList, LinkedList<Atom> singleBondedOxygen, LinkedList<Atom> doubleBondedOxygen) throws StructureBuildingException {
        for (Atom a : atomList) {
            if (!a.getElement().equals("O") || a.getBonds().size() != 1) continue;
            int incomingValency = a.getIncomingValency();
            if (incomingValency == 2) {
                doubleBondedOxygen.add(a);
                continue;
            }
            if (incomingValency == 1) {
                singleBondedOxygen.add(a);
                continue;
            }
            throw new StructureBuildingException("Unexpected bond order to oxygen; excepted 1 or 2 found: " + incomingValency);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PREFIX_REPLACEMENT_TYPE {
        chalcogen,
        halideOrPseudoHalide,
        dedicatedFunctionalReplacementPrefix,
        hydrazono,
        peroxy;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortInfixTransformations
    implements Comparator<String> {
        private SortInfixTransformations() {
        }

        @Override
        public int compare(String infixTransformation1, String infixTransformation2) {
            int allowedInputs2;
            int allowedInputs1 = OpsinTools.MATCH_COMMA.split(infixTransformation1).length;
            if (allowedInputs1 < (allowedInputs2 = OpsinTools.MATCH_COMMA.split(infixTransformation2).length)) {
                return -1;
            }
            if (allowedInputs1 > allowedInputs2) {
                return 1;
            }
            return 0;
        }
    }
}

