/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.AtomProperties;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FunctionalAtom;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.SortAtomsForElementSymbols;
import uk.ac.cam.ch.wwmm.opsin.SortAtomsForMainGroupElementSymbols;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FragmentTools {
    FragmentTools() {
    }

    static void assignElementLocants(Fragment suffixableFragment, List<Fragment> suffixFragments) throws StructureBuildingException {
        HashMap<String, Integer> elementCount = new HashMap<String, Integer>();
        HashSet<Atom> atomsToIgnore = new HashSet<Atom>();
        ArrayList<Fragment> allFragments = new ArrayList<Fragment>(suffixFragments);
        allFragments.add(suffixableFragment);
        for (Fragment fragment : allFragments) {
            List<Atom> atomList = fragment.getAtomList();
            for (Atom atom : atomList) {
                List<String> elementSymbolLocants = atom.getElementSymbolLocants();
                for (String locant : elementSymbolLocants) {
                    int primeCount = 0;
                    for (int i = 0; i < locant.length(); ++i) {
                        if (locant.charAt(i) != '\'') continue;
                        ++primeCount;
                    }
                    String element = locant.substring(0, locant.length() - primeCount);
                    if (elementCount.get(element) == null || elementCount.get(element) < primeCount + 1) {
                        elementCount.put(element, primeCount + 1);
                    }
                    atomsToIgnore.add(atom);
                }
            }
        }
        HashSet<String> elementToIgnore = new HashSet<String>();
        for (String element : elementCount.keySet()) {
            elementToIgnore.add(element);
        }
        for (Fragment fragment : allFragments) {
            List<Atom> atomList = fragment.getAtomList();
            for (Atom atom : atomList) {
                if (!elementToIgnore.contains(atom.getElement())) continue;
                atomsToIgnore.add(atom);
            }
        }
        String fragType = suffixableFragment.getType();
        if (fragType.equals("nonCarboxylicAcid") || fragType.equals("chalcogenAcidStem")) {
            if (suffixFragments.size() != 0) {
                throw new StructureBuildingException("No suffix fragments were expected to be present on non carboxylic acid");
            }
            FragmentTools.processNonCarboxylicAcidLabelling(suffixableFragment, elementCount, atomsToIgnore);
        } else {
            if (suffixFragments.size() > 0) {
                FragmentTools.processSuffixLabelling(suffixFragments, elementCount, atomsToIgnore);
                if (elementCount.get("N") != null && elementCount.get("N") > 1) {
                    FragmentTools.detectAndCorrectHydrazoneDerivativeViolation(suffixFragments);
                }
            }
            FragmentTools.processMainGroupLabelling(suffixableFragment, elementCount, atomsToIgnore);
        }
    }

    private static void detectAndCorrectHydrazoneDerivativeViolation(List<Fragment> suffixFragments) {
        block0: for (Fragment suffixFrag : suffixFragments) {
            List<Atom> atomList = suffixFrag.getAtomList();
            for (Atom atom : atomList) {
                List<String> locants;
                if (!atom.getElement().equals("N") || atom.getIncomingValency() != 3 || (locants = atom.getLocants()).size() != 1 || !OpsinTools.MATCH_ELEMENT_SYMBOL_LOCANT.matcher(locants.get(0)).matches()) continue;
                List<Atom> neighbours = atom.getAtomNeighbours();
                for (Atom neighbour : neighbours) {
                    if (!neighbour.getElement().equals("N") || neighbour.getIncomingValency() != 1) continue;
                    String locantToAdd = locants.get(0);
                    atom.clearLocants();
                    neighbour.addLocant(locantToAdd);
                    continue block0;
                }
            }
        }
    }

    private static void processMainGroupLabelling(Fragment suffixableFragment, HashMap<String, Integer> elementCount, HashSet<Atom> atomsToIgnore) {
        HashSet<String> elementToIgnore = new HashSet<String>();
        for (String element : elementCount.keySet()) {
            elementToIgnore.add(element);
        }
        List<Atom> atomList = suffixableFragment.getAtomList();
        Collections.sort(atomList, new SortAtomsForMainGroupElementSymbols());
        Atom atomToAddCLabelTo = null;
        boolean seenMoreThanOneC = false;
        for (Atom atom : atomList) {
            String element;
            if (atomsToIgnore.contains(atom) || elementToIgnore.contains(element = atom.getElement())) continue;
            if (element.equals("C")) {
                if (seenMoreThanOneC) continue;
                if (atomToAddCLabelTo != null) {
                    atomToAddCLabelTo = null;
                    seenMoreThanOneC = true;
                    continue;
                }
                atomToAddCLabelTo = atom;
                continue;
            }
            if (elementCount.get(element) == null) {
                atom.addLocant(element);
                elementCount.put(element, 1);
                continue;
            }
            int count2 = elementCount.get(element);
            atom.addLocant(element + StringTools.multiplyString("'", count2));
            elementCount.put(element, count2 + 1);
        }
        if (atomToAddCLabelTo != null) {
            atomToAddCLabelTo.addLocant("C");
        }
    }

    private static void processSuffixLabelling(List<Fragment> suffixFragments, HashMap<String, Integer> elementCount, HashSet<Atom> atomsToIgnore) throws StructureBuildingException {
        LinkedList<Atom> startingAtoms = new LinkedList<Atom>();
        HashMap<Atom, Bond> atomPreviousBondMap = new HashMap<Atom, Bond>();
        HashSet<Atom> atomsVisited = new HashSet<Atom>();
        for (Fragment fragment : suffixFragments) {
            List<Atom> suffixAtomList = fragment.getAtomList();
            Atom rAtom = suffixAtomList.get(0);
            LinkedList<Atom> nextAtoms = new LinkedList<Atom>(rAtom.getAtomNeighbours());
            for (Atom nextAtom : nextAtoms) {
                atomsVisited.add(nextAtom);
                atomPreviousBondMap.put(nextAtom, rAtom.getBondToAtomOrThrow(nextAtom));
            }
            startingAtoms.addAll(nextAtoms);
        }
        Collections.sort(startingAtoms, new SortAtomsForElementSymbols(atomPreviousBondMap));
        while (startingAtoms.size() > 0) {
            FragmentTools.assignLocantsAndExploreNeighbours(elementCount, atomsToIgnore, atomsVisited, startingAtoms);
        }
    }

    private static void processNonCarboxylicAcidLabelling(Fragment suffixableFragment, HashMap<String, Integer> elementCount, HashSet<Atom> atomsToIgnore) throws StructureBuildingException {
        HashSet<Atom> atomsVisited = new HashSet<Atom>();
        List<Atom> atomList = suffixableFragment.getAtomList();
        Atom firstAtom = atomList.get(0);
        LinkedList<Atom> nextAtoms = new LinkedList<Atom>(firstAtom.getAtomNeighbours());
        HashMap<Atom, Bond> atomPreviousBondMap = new HashMap<Atom, Bond>();
        for (Atom nextAtom : nextAtoms) {
            atomPreviousBondMap.put(nextAtom, firstAtom.getBondToAtomOrThrow(nextAtom));
        }
        Collections.sort(nextAtoms, new SortAtomsForElementSymbols(atomPreviousBondMap));
        atomsVisited.add(firstAtom);
        while (nextAtoms.size() > 0) {
            FragmentTools.assignLocantsAndExploreNeighbours(elementCount, atomsToIgnore, atomsVisited, nextAtoms);
        }
        if (!atomsToIgnore.contains(firstAtom) && firstAtom.determineValency(true) > firstAtom.getIncomingValency()) {
            FragmentTools.assignLocant(firstAtom, elementCount);
        }
    }

    private static void assignLocantsAndExploreNeighbours(HashMap<String, Integer> elementCount, HashSet<Atom> atomsToIgnore, Set<Atom> atomsVisited, LinkedList<Atom> nextAtoms) throws StructureBuildingException {
        Atom atom = nextAtoms.removeFirst();
        atomsVisited.add(atom);
        if (!atomsToIgnore.contains(atom)) {
            FragmentTools.assignLocant(atom, elementCount);
        }
        List<Atom> atomNeighbours = atom.getAtomNeighbours();
        for (int i = atomNeighbours.size() - 1; i >= 0; --i) {
            if (!atomsVisited.contains(atomNeighbours.get(i))) continue;
            atomNeighbours.remove(i);
        }
        HashMap<Atom, Bond> atomPreviousBondMap = new HashMap<Atom, Bond>();
        for (Atom atomNeighbour : atomNeighbours) {
            atomPreviousBondMap.put(atomNeighbour, atom.getBondToAtomOrThrow(atomNeighbour));
        }
        Collections.sort(atomNeighbours, new SortAtomsForElementSymbols(atomPreviousBondMap));
        nextAtoms.addAll(0, atomNeighbours);
    }

    private static void assignLocant(Atom atom, HashMap<String, Integer> elementCount) {
        String element = atom.getElement();
        if (elementCount.get(element) == null) {
            atom.addLocant(element);
            elementCount.put(element, 1);
        } else {
            int count2 = elementCount.get(element);
            atom.addLocant(element + StringTools.multiplyString("'", count2));
            elementCount.put(element, count2 + 1);
        }
    }

    static void unsaturate(Atom fromAtom, int bondOrder, Fragment fragment) throws StructureBuildingException {
        Integer locant;
        Atom toAtom;
        block7: {
            toAtom = null;
            locant = null;
            try {
                String primes = "";
                String locantStr = fromAtom.getFirstLocant();
                int numberOfPrimes = StringTools.countTerminalPrimes(locantStr);
                locant = Integer.parseInt(locantStr.substring(0, locantStr.length() - numberOfPrimes));
                primes = StringTools.multiplyString("'", numberOfPrimes);
                Atom possibleToAtom = fragment.getAtomByLocant(String.valueOf(locant + 1) + primes);
                if (possibleToAtom != null && fromAtom.getBondToAtom(possibleToAtom) != null) {
                    toAtom = possibleToAtom;
                } else if (possibleToAtom == null && fromAtom.getAtomIsInACycle() && (possibleToAtom = fragment.getAtomByLocant("1" + primes)) != null && fromAtom.getBondToAtom(possibleToAtom) != null) {
                    toAtom = possibleToAtom;
                }
            }
            catch (Exception e) {
                List<Atom> atomList = fragment.getAtomList();
                int initialIndice = atomList.indexOf(fromAtom);
                if (initialIndice + 1 >= atomList.size() || fromAtom.getBondToAtom(atomList.get(initialIndice + 1)) == null) break block7;
                toAtom = atomList.get(initialIndice + 1);
            }
        }
        if (toAtom == null) {
            if (locant != null) {
                throw new StructureBuildingException("Could not find bond to unsaturate starting from the atom with locant: " + locant);
            }
            throw new StructureBuildingException("Could not find bond to unsaturate");
        }
        Bond b = fromAtom.getBondToAtomOrThrow(toAtom);
        b.setOrder(bondOrder);
    }

    static void unsaturate(Atom fromAtom, String locantTo, int bondOrder, Fragment fragment) throws StructureBuildingException {
        Atom toAtom = fragment.getAtomByLocantOrThrow(locantTo);
        Bond b = fromAtom.getBondToAtomOrThrow(toAtom);
        b.setOrder(bondOrder);
    }

    static int findKetoneAtomIndice(Fragment fragment, int atomIndice) throws StructureBuildingException {
        if (fragment.getChainLength() < 3) {
            return atomIndice;
        }
        if (atomIndice + 1 >= fragment.getAtomList().size()) {
            return 1;
        }
        return atomIndice + 1;
    }

    static void relabelFusedRingSystem(Fragment fusedring) {
        FragmentTools.relabelFusedRingSystem(fusedring.getAtomList());
    }

    static void relabelFusedRingSystem(List<Atom> atomList) {
        int locantVal = 0;
        char locantLetter = 'a';
        for (Atom atom : atomList) {
            atom.clearLocants();
        }
        for (Atom atom : atomList) {
            if (!atom.getElement().equals("C") || atom.getBonds().size() < 3) {
                locantLetter = 'a';
                atom.addLocant(Integer.toString(++locantVal));
                continue;
            }
            atom.addLocant(Integer.toString(locantVal) + locantLetter);
            locantLetter = (char)(locantLetter + '\u0001');
        }
    }

    static void relabelLocants(List<Atom> atomList, String stringToAdd) {
        for (Atom atom : atomList) {
            ArrayList<String> locants = new ArrayList<String>(atom.getLocants());
            atom.clearLocants();
            for (String locant : locants) {
                atom.addLocant(locant + stringToAdd);
            }
        }
    }

    static void relabelNumericLocants(List<Atom> atomList, String stringToAdd) {
        for (Atom atom : atomList) {
            ArrayList<String> locants = new ArrayList<String>(atom.getLocants());
            for (String locant : locants) {
                if (!OpsinTools.MATCH_NUMERIC_LOCANT.matcher(locant).matches()) continue;
                atom.removeLocant(locant);
                atom.addLocant(locant + stringToAdd);
            }
        }
    }

    static void splitOutAtomIntoValency1OutAtoms(OutAtom outAtom) {
        Fragment frag = outAtom.getAtom().getFrag();
        for (int i = 1; i < outAtom.getValency(); ++i) {
            frag.addOutAtom(outAtom.getAtom(), 1, (Boolean)outAtom.isSetExplicitly());
        }
        outAtom.setValency(1);
    }

    static Atom detectSimpleNitrogenTautomer(Atom nitrogen) {
        if (nitrogen.getElement().equals("N") && nitrogen.getAtomIsInACycle()) {
            List<Atom> neighbours = nitrogen.getAtomNeighbours();
            for (Atom neighbour : neighbours) {
                if (!neighbour.hasSpareValency()) continue;
                List<Atom> distance2Neighbours = neighbour.getAtomNeighbours();
                for (Atom distance2Neighbour : distance2Neighbours) {
                    if (!distance2Neighbour.hasSpareValency() || !distance2Neighbour.getElement().equals("N") || distance2Neighbour.getCharge() != 0) continue;
                    return distance2Neighbour;
                }
            }
        }
        return null;
    }

    static void pickUpIndicatedHydrogens(Fragment frag) {
        if (frag.getIndicatedHydrogen().size() > 0) {
            return;
        }
        List<Atom> atomList = frag.getAtomList();
        int svCount = 0;
        int dvCount = 0;
        for (Atom a : atomList) {
            svCount += a.hasSpareValency() ? 1 : 0;
            if (a.getElement().equals("O")) {
                ++dvCount;
            }
            if (a.getElement().equals("S")) {
                ++dvCount;
            }
            if (a.getElement().equals("Se")) {
                ++dvCount;
            }
            if (!a.getElement().equals("Te")) continue;
            ++dvCount;
        }
        if (svCount == atomList.size() - (1 + dvCount) && svCount > 0) {
            Atom nCandidate = null;
            for (Atom a : atomList) {
                if (!a.getAtomIsInACycle() || a.hasSpareValency()) continue;
                String element = a.getElement();
                if (element.equals("C")) {
                    frag.addIndicatedHydrogen(a);
                    a.setSpareValency(true);
                    return;
                }
                if (!element.equals("N")) continue;
                nCandidate = a;
            }
            if (nCandidate != null) {
                frag.addIndicatedHydrogen(nCandidate);
                nCandidate.setSpareValency(true);
            }
        }
    }

    static void convertHighOrderBondsToSpareValencies(Fragment frag) {
        Set<Bond> bondSet = frag.getBondSet();
        for (Bond b : bondSet) {
            if (b.getOrder() != 2) continue;
            Atom firstAtom = b.getFromAtom();
            Atom secondAtom = b.getToAtom();
            if (!firstAtom.getAtomIsInACycle() || !secondAtom.getAtomIsInACycle()) continue;
            b.setOrder(1);
            firstAtom.setSpareValency(true);
            secondAtom.setSpareValency(true);
        }
        FragmentTools.pickUpIndicatedHydrogens(frag);
    }

    static void convertSpareValenciesToDoubleBonds(Fragment frag) throws StructureBuildingException {
        List<Atom> atomCollection = frag.getAtomList();
        for (Atom a : atomCollection) {
            a.ensureSVIsConsistantWithValency(true);
        }
        block1: for (Atom a : atomCollection) {
            if (!a.hasSpareValency()) continue;
            for (Atom aa : frag.getIntraFragmentAtomNeighbours(a)) {
                if (!aa.hasSpareValency()) continue;
                continue block1;
            }
            a.setSpareValency(false);
        }
        Atom atomToReduceValencyAt = null;
        List<Atom> indicatedHydrogen = frag.getIndicatedHydrogen();
        for (int i = indicatedHydrogen.size() - 1; i >= 0; --i) {
            if (indicatedHydrogen.get(i).hasSpareValency()) continue;
            indicatedHydrogen.remove(i);
        }
        if (indicatedHydrogen.size() > 0) {
            if (indicatedHydrogen.size() > 1) {
                if (indicatedHydrogen.size() == 2) {
                    for (Atom indicatedAtom : indicatedHydrogen) {
                        if (!indicatedAtom.hasSpareValency()) continue;
                        List<Atom> neighbours = indicatedAtom.getAtomNeighbours();
                        for (Atom neighbour : neighbours) {
                            if (!neighbour.hasSpareValency()) continue;
                            List<Atom> neighbours2 = neighbour.getAtomNeighbours();
                            for (Atom secondNeighbour : neighbours2) {
                                if (secondNeighbour == indicatedAtom || !secondNeighbour.hasSpareValency() || !secondNeighbour.getElement().equals("N")) continue;
                                indicatedAtom.setSpareValency(false);
                            }
                        }
                    }
                } else {
                    for (Atom indicatedAtom : indicatedHydrogen) {
                        indicatedAtom.setSpareValency(false);
                    }
                }
            } else {
                atomToReduceValencyAt = indicatedHydrogen.get(0);
            }
        }
        int svCount = 0;
        for (Atom a : atomCollection) {
            svCount += a.hasSpareValency() ? 1 : 0;
        }
        if (svCount % 2 == 1) {
            if (atomToReduceValencyAt == null) {
                for (Atom a : atomCollection) {
                    if (!a.hasSpareValency()) continue;
                    int atomsWithSV = 0;
                    for (Atom aa : frag.getIntraFragmentAtomNeighbours(a)) {
                        if (!aa.hasSpareValency()) continue;
                        ++atomsWithSV;
                    }
                    if (atomsWithSV != true) continue;
                    atomToReduceValencyAt = a;
                    break;
                }
                if (atomToReduceValencyAt == null) {
                    block11: for (Atom a : atomCollection) {
                        List<Atom> neighbours;
                        if (!a.hasSpareValency() || (neighbours = frag.getIntraFragmentAtomNeighbours(a)).size() != 2) continue;
                        for (Atom aa : neighbours) {
                            if (frag.getIntraFragmentAtomNeighbours(aa).size() >= 3) continue;
                            continue block11;
                        }
                        atomToReduceValencyAt = a;
                        break;
                    }
                    if (atomToReduceValencyAt == null) {
                        for (Atom a : atomCollection) {
                            if (!a.hasSpareValency()) continue;
                            if (atomToReduceValencyAt == null) {
                                atomToReduceValencyAt = a;
                            }
                            if (a.getElement().equals("C")) continue;
                            atomToReduceValencyAt = a;
                            break;
                        }
                    }
                }
            }
            atomToReduceValencyAt.setSpareValency(false);
            --svCount;
        }
        while (svCount > 0) {
            boolean foundTerminalFlag = false;
            boolean foundNonBridgeHeadFlag = false;
            boolean foundBridgeHeadFlag = false;
            block15: for (Atom a : atomCollection) {
                if (!a.hasSpareValency()) continue;
                int count2 = 0;
                for (Atom aa : frag.getIntraFragmentAtomNeighbours(a)) {
                    if (!aa.hasSpareValency()) continue;
                    ++count2;
                }
                if (count2 != true) continue;
                for (Atom aa : frag.getIntraFragmentAtomNeighbours(a)) {
                    if (!aa.hasSpareValency()) continue;
                    foundTerminalFlag = true;
                    a.setSpareValency(false);
                    aa.setSpareValency(false);
                    a.getBondToAtomOrThrow(aa).addOrder(1);
                    svCount -= 2;
                    continue block15;
                }
            }
            if (foundTerminalFlag) continue;
            for (Atom a : atomCollection) {
                List<Atom> neighbours = frag.getIntraFragmentAtomNeighbours(a);
                if (a.hasSpareValency() && neighbours.size() < 3) {
                    for (Atom aa : neighbours) {
                        if (!aa.hasSpareValency()) continue;
                        foundNonBridgeHeadFlag = true;
                        a.setSpareValency(false);
                        aa.setSpareValency(false);
                        a.getBondToAtomOrThrow(aa).addOrder(1);
                        svCount -= 2;
                        break;
                    }
                }
                if (!foundNonBridgeHeadFlag) continue;
                break;
            }
            if (foundNonBridgeHeadFlag) continue;
            for (Atom a : atomCollection) {
                List<Atom> neighbours = frag.getIntraFragmentAtomNeighbours(a);
                if (a.hasSpareValency()) {
                    for (Atom aa : neighbours) {
                        if (!aa.hasSpareValency()) continue;
                        foundBridgeHeadFlag = true;
                        a.setSpareValency(false);
                        aa.setSpareValency(false);
                        a.getBondToAtomOrThrow(aa).addOrder(1);
                        svCount -= 2;
                        break;
                    }
                }
                if (!foundBridgeHeadFlag) continue;
                break;
            }
            if (foundBridgeHeadFlag) continue;
            throw new StructureBuildingException("Could not assign all higher order bonds.");
        }
    }

    static Atom getAtomByAminoAcidStyleLocant(Atom backboneAtom, String elementSymbol, String primes) throws StructureBuildingException {
        LinkedList<Atom> nextAtoms = new LinkedList<Atom>();
        HashMap<Atom, Bond> atomPreviousBondMap = new HashMap<Atom, Bond>();
        HashSet<Atom> atomsVisited = new HashSet<Atom>();
        List<Atom> neighbours = backboneAtom.getAtomNeighbours();
        block0: for (Atom neighbour : neighbours) {
            atomsVisited.add(neighbour);
            if (!neighbour.getType().equals("suffix")) {
                for (String neighbourLocant : neighbour.getLocants()) {
                    if (!OpsinTools.MATCH_NUMERIC_LOCANT.matcher(neighbourLocant).matches()) continue;
                    continue block0;
                }
            }
            nextAtoms.add(neighbour);
            atomPreviousBondMap.put(neighbour, backboneAtom.getBondToAtomOrThrow(neighbour));
        }
        Collections.sort(nextAtoms, new SortAtomsForElementSymbols(atomPreviousBondMap));
        HashMap<String, Integer> elementCount = new HashMap<String, Integer>();
        boolean hydrazoneSpecialCase = false;
        while (nextAtoms.size() > 0) {
            Atom atom = (Atom)nextAtoms.removeFirst();
            atomsVisited.add(atom);
            int primesOnPossibleAtom = 0;
            String element = atom.getElement();
            if (elementCount.get(element) == null) {
                elementCount.put(element, 1);
            } else {
                int count2;
                primesOnPossibleAtom = count2 = ((Integer)elementCount.get(element)).intValue();
                elementCount.put(element, count2 + 1);
            }
            if (hydrazoneSpecialCase) {
                if (element.equals(elementSymbol) && primes.length() == primesOnPossibleAtom - 1) {
                    return atom;
                }
                hydrazoneSpecialCase = false;
            }
            List<Atom> atomNeighbours = atom.getAtomNeighbours();
            block3: for (int i = atomNeighbours.size() - 1; i >= 0; --i) {
                Atom neighbour = atomNeighbours.get(i);
                if (atomsVisited.contains(neighbour)) {
                    atomNeighbours.remove(i);
                }
                if (neighbour.getType().equals("suffix")) continue;
                for (String neighbourLocant : neighbour.getLocants()) {
                    if (!OpsinTools.MATCH_NUMERIC_LOCANT.matcher(neighbourLocant).matches()) continue;
                    atomNeighbours.remove(i);
                    continue block3;
                }
            }
            if (atom.getElement().equals("N") && atom.getIncomingValency() == 3 && atom.getCharge() == 0 && atomNeighbours.size() == 1 && atomNeighbours.get(0).getElement().equals("N")) {
                hydrazoneSpecialCase = true;
            } else if (element.equals(elementSymbol) && primes.length() == primesOnPossibleAtom) {
                return atom;
            }
            atomPreviousBondMap = new HashMap();
            for (Atom atomNeighbour : atomNeighbours) {
                atomPreviousBondMap.put(atomNeighbour, atom.getBondToAtomOrThrow(atomNeighbour));
            }
            Collections.sort(atomNeighbours, new SortAtomsForElementSymbols(atomPreviousBondMap));
            nextAtoms.addAll(0, atomNeighbours);
        }
        if (primes.equals("") && backboneAtom.getElement().equals(elementSymbol)) {
            return backboneAtom;
        }
        return null;
    }

    static boolean isCovalent(String element1, String element2) {
        Double atom1Electrongegativity = AtomProperties.elementToPaulingElectronegativity.get(element1);
        Double atom2Electrongegativity = AtomProperties.elementToPaulingElectronegativity.get(element2);
        if (atom1Electrongegativity != null && atom2Electrongegativity != null) {
            double halfSum = (atom1Electrongegativity + atom2Electrongegativity) / 2.0;
            double difference = Math.abs(atom1Electrongegativity - atom2Electrongegativity);
            if (halfSum < 1.6) {
                return false;
            }
            if (difference < 1.39 * halfSum - 2.2) {
                return true;
            }
        }
        return false;
    }

    static boolean isCharacteristicAtom(Atom atom) {
        if (atom.getType().equals("suffix")) {
            return true;
        }
        if (atom.getProperty(Atom.ISALDEHYDE) != null && atom.getProperty(Atom.ISALDEHYDE).booleanValue()) {
            return true;
        }
        String element = atom.getElement();
        if (element.equals("O") || element.equals("S") || element.equals("Se") || element.equals("Te")) {
            boolean isFunctionalAtom = false;
            for (FunctionalAtom funcAtom : atom.getFrag().getFunctionalAtoms()) {
                if (!atom.equals(funcAtom.getAtom())) continue;
                isFunctionalAtom = true;
                break;
            }
            if (isFunctionalAtom) {
                return true;
            }
        }
        return false;
    }

    static boolean isFunctionalAtomOrAldehyde(Atom atom) {
        if (atom.getProperty(Atom.ISALDEHYDE) != null && atom.getProperty(Atom.ISALDEHYDE).booleanValue()) {
            return true;
        }
        String element = atom.getElement();
        if (element.equals("O") || element.equals("S") || element.equals("Se") || element.equals("Te")) {
            boolean isFunctionalAtom = false;
            for (FunctionalAtom funcAtom : atom.getFrag().getFunctionalAtoms()) {
                if (!atom.equals(funcAtom.getAtom())) continue;
                isFunctionalAtom = true;
                break;
            }
            if (isFunctionalAtom) {
                return true;
            }
        }
        return false;
    }

    static boolean allAtomsInRingAreIdentical(Fragment ring) {
        List<Atom> atomList = ring.getAtomList();
        Atom firstAtom = atomList.get(0);
        String element = firstAtom.getElement();
        int valency = firstAtom.getIncomingValency();
        boolean spareValency = firstAtom.hasSpareValency();
        for (Atom atom : atomList) {
            if (!atom.getElement().equals(element)) {
                return false;
            }
            if (atom.getIncomingValency() != valency) {
                return false;
            }
            if (atom.hasSpareValency() == spareValency) continue;
            return false;
        }
        return true;
    }

    static void removeTerminalAtom(BuildState state, Fragment fragment, String element, String locant) throws StructureBuildingException {
        Atom atomToRemove;
        AtomParity atomParity;
        List<Atom> applicableTerminalAtoms;
        if (locant != null) {
            Atom adjacentAtom = fragment.getAtomByLocantOrThrow(locant);
            applicableTerminalAtoms = FragmentTools.findTerminalAtoms(adjacentAtom.getAtomNeighbours(), element);
            if (applicableTerminalAtoms.isEmpty()) {
                throw new StructureBuildingException("Unable to find terminal atom of type: " + element + " at locant " + locant + " for substractive nomenclature");
            }
        } else {
            applicableTerminalAtoms = FragmentTools.findTerminalAtoms(fragment.getAtomList(), element);
            if (applicableTerminalAtoms.isEmpty()) {
                throw new StructureBuildingException("Unable to find terminal atom of type: " + element + " for substractive nomenclature");
            }
        }
        if ((atomParity = (atomToRemove = applicableTerminalAtoms.get(0)).getAtomNeighbours().get(0).getAtomParity()) != null) {
            Atom[] atomRefs4 = atomParity.getAtomRefs4();
            for (int i = 0; i < atomRefs4.length; ++i) {
                if (atomRefs4[i] != atomToRemove) continue;
                atomRefs4[i] = AtomParity.deoxyHydrogen;
                break;
            }
        }
        state.fragManager.removeAtomAndAssociatedBonds(atomToRemove);
    }

    private static List<Atom> findTerminalAtoms(List<Atom> atoms, String element) {
        ArrayList<Atom> matches2 = new ArrayList<Atom>();
        for (Atom atom : atoms) {
            if (!atom.getElement().equals(element) || atom.getIncomingValency() != 1) continue;
            matches2.add(atom);
        }
        return matches2;
    }

    static boolean notIn6MemberOrSmallerRing(Bond bond) {
        Atom fromAtom = bond.getFromAtom();
        Atom toAtom = bond.getToAtom();
        if (fromAtom.getAtomIsInACycle() && toAtom.getAtomIsInACycle()) {
            ArrayList<Atom> visitedAtoms = new ArrayList<Atom>();
            LinkedList<Atom> atomsToInvestigate = new LinkedList<Atom>();
            List<Atom> neighbours = fromAtom.getAtomNeighbours();
            neighbours.remove(toAtom);
            for (Atom neighbour : neighbours) {
                atomsToInvestigate.add(neighbour);
            }
            visitedAtoms.add(fromAtom);
            for (int i = 0; i < 5 && !atomsToInvestigate.isEmpty(); ++i) {
                LinkedList<Atom> atomsToInvestigateNext = new LinkedList<Atom>();
                while (!atomsToInvestigate.isEmpty()) {
                    Atom currentAtom = (Atom)atomsToInvestigate.removeFirst();
                    if (currentAtom == toAtom) {
                        return false;
                    }
                    visitedAtoms.add(currentAtom);
                    neighbours = currentAtom.getAtomNeighbours();
                    for (Atom neighbour : neighbours) {
                        if (visitedAtoms.contains(neighbour) || !neighbour.getAtomIsInACycle()) continue;
                        atomsToInvestigateNext.add(neighbour);
                    }
                }
                atomsToInvestigate = atomsToInvestigateNext;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SortByLocants
    implements Comparator<Atom> {
        static final Pattern locantSegmenter = Pattern.compile("(\\d+)([a-z]?)('*)");

        SortByLocants() {
        }

        @Override
        public int compare(Atom atoma, Atom atomb) {
            String locantbLetter;
            int locantbNumber;
            String locantbPrimes;
            if (atoma.getType().equals("suffix") && !atomb.getType().equals("suffix")) {
                return 1;
            }
            if (atomb.getType().equals("suffix") && !atoma.getType().equals("suffix")) {
                return -1;
            }
            String locanta = atoma.getFirstLocant();
            String locantb = atomb.getFirstLocant();
            if (locanta == null || locantb == null) {
                return 0;
            }
            Matcher m1 = locantSegmenter.matcher(locanta);
            Matcher m2 = locantSegmenter.matcher(locantb);
            if (!m1.matches() || !m2.matches()) {
                return 0;
            }
            String locantaPrimes = m1.group(3);
            if (locantaPrimes.compareTo(locantbPrimes = m2.group(3)) >= 1) {
                return 1;
            }
            if (locantbPrimes.compareTo(locantaPrimes) >= 1) {
                return -1;
            }
            int locantaNumber = Integer.parseInt(m1.group(1));
            if (locantaNumber > (locantbNumber = Integer.parseInt(m2.group(1)))) {
                return 1;
            }
            if (locantbNumber > locantaNumber) {
                return -1;
            }
            String locantaLetter = m1.group(2);
            if (locantaLetter.compareTo(locantbLetter = m2.group(2)) >= 1) {
                return 1;
            }
            if (locantbLetter.compareTo(locantaLetter) >= 1) {
                return -1;
            }
            return 0;
        }
    }
}

