/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.Fragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CycleDetector {
    CycleDetector() {
    }

    static void assignWhetherAtomsAreInCycles(Fragment frag) {
        List<Atom> atomList = frag.getAtomList();
        for (Atom atom : atomList) {
            atom.setAtomIsInACycle(false);
            atom.setProperty(Atom.VISITED, null);
        }
        for (Atom a : atomList) {
            if (a.getProperty(Atom.VISITED) != null) continue;
            CycleDetector.traverseRings(a, null, 0);
        }
    }

    private static int traverseRings(Atom currentAtom, Atom previousAtom, int depth) {
        if (currentAtom.getProperty(Atom.VISITED) != null) {
            return currentAtom.getProperty(Atom.VISITED);
        }
        currentAtom.setProperty(Atom.VISITED, depth);
        int result2 = depth + 1;
        List<Atom> neighbours = currentAtom.getAtomNeighbours();
        for (Atom neighbour : neighbours) {
            int temp;
            if (neighbour.equals(previousAtom) || (temp = CycleDetector.traverseRings(neighbour, currentAtom, depth + 1)) > depth) continue;
            result2 = Math.min(result2, temp);
        }
        if (result2 <= depth) {
            currentAtom.setAtomIsInACycle(true);
        }
        return result2;
    }

    static List<List<Atom>> getPathBetweenAtomsUsingBonds(Atom a1, Atom a2, Set<Bond> peripheryBonds) {
        ArrayList<List<Atom>> paths = new ArrayList<List<Atom>>();
        LinkedList<PathSearchState> stateStack = new LinkedList<PathSearchState>();
        stateStack.add(new PathSearchState(a1, new LinkedList<Atom>()));
        while (stateStack.size() > 0) {
            PathSearchState state = (PathSearchState)stateStack.removeLast();
            LinkedList<Atom> orderAtomsVisited = state.getOrderAtomsVisited();
            Atom nextAtom = state.getCurrentAtom();
            orderAtomsVisited.add(nextAtom);
            LinkedHashSet<Bond> neighbourBonds = new LinkedHashSet<Bond>(nextAtom.getBonds());
            neighbourBonds.retainAll(peripheryBonds);
            for (Bond neighbourBond : neighbourBonds) {
                Atom neighbour = neighbourBond.getOtherAtom(nextAtom);
                if (orderAtomsVisited.contains(neighbour)) continue;
                if (neighbour == a2) {
                    paths.add(new ArrayList(orderAtomsVisited.subList(1, orderAtomsVisited.size())));
                    continue;
                }
                stateStack.add(new PathSearchState(neighbour, new LinkedList<Atom>(orderAtomsVisited)));
            }
        }
        return paths;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathSearchState {
        final Atom currentAtom;
        final LinkedList<Atom> orderAtomsVisited;

        public PathSearchState(Atom currentAtom, LinkedList<Atom> orderAtomsVisited) {
            this.currentAtom = currentAtom;
            this.orderAtomsVisited = orderAtomsVisited;
        }

        Atom getCurrentAtom() {
            return this.currentAtom;
        }

        LinkedList<Atom> getOrderAtomsVisited() {
            return this.orderAtomsVisited;
        }
    }
}

