/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParentNode;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ComponentGenerationException;
import uk.ac.cam.ch.wwmm.opsin.CycleDetector;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.FunctionalReplacement;
import uk.ac.cam.ch.wwmm.opsin.FusedRingBuilder;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StereochemistryHandler;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.SuffixRules;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;
import uk.ac.cam.ch.wwmm.opsin.WordRule;
import uk.ac.cam.ch.wwmm.opsin.WordRulesOmittedSpaceCorrector;
import uk.ac.cam.ch.wwmm.opsin.WordType;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComponentProcessor {
    private static final Pattern matchAddedHydrogenBracket = Pattern.compile("[\\[\\(\\{]([^\\[\\(\\{]*)H[\\]\\)\\}]");
    private static final Pattern matchElementSymbolOrAminoAcidLocant = Pattern.compile("[A-Z][a-z]?'*(\\d+[a-z]?'*)?");
    private static final Pattern matchChalcogenReplacement = Pattern.compile("thio|seleno|telluro");
    private static final Pattern matchInlineSuffixesThatAreAlsoGroups = Pattern.compile("carbon|oxy|sulfen|sulfin|sulfon|selenen|selenin|selenon|telluren|tellurin|telluron");
    private static final String[] traditionalAlkanePositionNames = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta"};
    private final SuffixRules suffixRules;
    private final BuildState state;
    private final Element parse;
    private static final HashMap<String, String[]> specialHWRings = new HashMap();

    public ComponentProcessor(SuffixRules suffixRules, BuildState state, Element parse) {
        this.suffixRules = suffixRules;
        this.state = state;
        this.parse = parse;
    }

    void processParse() throws ComponentGenerationException, StructureBuildingException {
        List<Element> words = XOMTools.getDescendantElementsWithTagName(this.parse, "word");
        int wordCount = words.size();
        for (int i = wordCount - 1; i >= 0; --i) {
            List<Element> children2;
            Element word = words.get(i);
            String wordRule = OpsinTools.getParentWordRule(word).getAttributeValue("wordRule");
            this.state.currentWordRule = WordRule.valueOf(wordRule);
            if (word.getAttributeValue("type").equals(WordType.functionalTerm.toString())) continue;
            List<Element> roots = XOMTools.getDescendantElementsWithTagName(word, "root");
            if (roots.size() > 1) {
                throw new ComponentGenerationException("Multiple roots, but only 0 or 1 were expected. Found: " + roots.size());
            }
            List<Element> substituents = XOMTools.getDescendantElementsWithTagName(word, "substituent");
            ArrayList<Element> substituentsAndRoot = OpsinTools.combineElementLists(substituents, roots);
            List<Element> brackets = XOMTools.getDescendantElementsWithTagName(word, "bracket");
            ArrayList<Element> substituentsAndRootAndBrackets = OpsinTools.combineElementLists(substituentsAndRoot, brackets);
            List<Element> groups = XOMTools.getDescendantElementsWithTagName(word, "group");
            for (Element group : groups) {
                Fragment thisFrag = ComponentProcessor.resolveGroup(this.state, group);
                this.processChargeAndOxidationNumberSpecification(group, thisFrag);
                this.state.xmlFragmentMap.put(group, thisFrag);
            }
            for (int j = substituents.size() - 1; j >= 0; --j) {
                Element substituent = substituents.get(j);
                boolean removed = this.removeAndMoveToAppropriateGroupIfHydroSubstituent(substituent);
                if (!removed) {
                    removed = ComponentProcessor.removeAndMoveToAppropriateGroupIfSubstractivePrefix(substituent);
                }
                if (!removed) continue;
                substituents.remove(j);
                substituentsAndRoot.remove(substituent);
                substituentsAndRootAndBrackets.remove(substituent);
            }
            Element finalSubOrRootInWord = (Element)word.getChild(word.getChildElements().size() - 1);
            while (!finalSubOrRootInWord.getLocalName().equals("root") && !finalSubOrRootInWord.getLocalName().equals("substituent")) {
                children2 = XOMTools.getChildElementsWithTagNames(finalSubOrRootInWord, new String[]{"root", "substituent", "bracket"});
                if (children2.size() == 0) {
                    throw new ComponentGenerationException("Unable to find finalSubOrRootInWord");
                }
                finalSubOrRootInWord = children2.get(children2.size() - 1);
            }
            for (Element subOrRoot : substituentsAndRoot) {
                this.applyDLPrefixes(subOrRoot);
                this.cycliseCarbohydrates(subOrRoot);
            }
            for (Element subOrRootOrBracket : substituentsAndRootAndBrackets) {
                this.determineLocantMeaning(subOrRootOrBracket, finalSubOrRootInWord);
            }
            for (Element subOrRoot : substituentsAndRoot) {
                this.processMultipliers(subOrRoot);
                this.detectConjunctiveSuffixGroups(subOrRoot, groups);
                this.matchLocantsToDirectFeatures(subOrRoot);
                Elements groupsOfSubOrRoot = subOrRoot.getChildElements("group");
                Element lastGroupInSubOrRoot = groupsOfSubOrRoot.get(groupsOfSubOrRoot.size() - 1);
                this.preliminaryProcessSuffixes(lastGroupInSubOrRoot, XOMTools.getChildElementsWithTagName(subOrRoot, "suffix"));
            }
            FunctionalReplacement.processAmideOrHydrazideFunctionalClassNomenclature(this.state, finalSubOrRootInWord, word);
            if (FunctionalReplacement.processPrefixFunctionalReplacementNomenclature(this.state, groups, substituents)) {
                substituentsAndRoot = OpsinTools.combineElementLists(substituents, roots);
                substituentsAndRootAndBrackets = OpsinTools.combineElementLists(substituentsAndRoot, brackets);
            }
            this.handleGroupIrregularities(groups);
            for (Element subOrRoot : substituentsAndRoot) {
                this.processHW(subOrRoot);
                FusedRingBuilder.processFusedRings(this.state, subOrRoot);
                this.processFusedRingBridges(subOrRoot);
                this.assignElementSymbolLocants(subOrRoot);
                this.processRingAssemblies(subOrRoot);
                this.processPolyCyclicSpiroNomenclature(subOrRoot);
            }
            for (Element subOrRoot : substituentsAndRoot) {
                this.applyLambdaConvention(subOrRoot);
                this.handleMultiRadicals(subOrRoot);
            }
            this.addImplicitBracketsToAminoAcids(groups, brackets);
            this.findAndStructureImplictBrackets(substituents, brackets);
            for (Element subOrRoot : substituentsAndRoot) {
                this.matchLocantsToIndirectFeatures(subOrRoot);
                this.assignImplicitLocantsToDiTerminalSuffixes(subOrRoot);
                this.processConjunctiveNomenclature(subOrRoot);
                this.resolveSuffixes(subOrRoot.getFirstChildElement("group"), XOMTools.getChildElementsWithTagName(subOrRoot, "suffix"));
            }
            this.moveErroneouslyPositionedLocantsAndMultipliers(brackets);
            children2 = XOMTools.getChildElementsWithTagNames(word, new String[]{"root", "substituent", "bracket"});
            while (children2.size() == 1) {
                children2 = XOMTools.getChildElementsWithTagNames(children2.get(0), new String[]{"root", "substituent", "bracket"});
            }
            if (children2.size() > 0) {
                this.assignLocantsToMultipliedRootIfPresent(children2.get(children2.size() - 1));
            }
            this.addImplicitBracketsInCaseWhereSubstituentHasTwoLocants(substituents, brackets);
            substituentsAndRootAndBrackets = OpsinTools.combineElementLists(substituentsAndRoot, brackets);
            for (Element subBracketOrRoot : substituentsAndRootAndBrackets) {
                this.assignLocantsAndMultipliers(subBracketOrRoot);
            }
            this.processWordLevelMultiplierIfApplicable(word, wordCount);
        }
        new WordRulesOmittedSpaceCorrector(this.state, this.parse).correctOmittedSpaces();
    }

    static Fragment resolveGroup(BuildState state, Element group) throws StructureBuildingException, ComponentGenerationException {
        String groupType = group.getAttributeValue("type");
        String groupSubType = group.getAttributeValue("subType");
        String groupValue = group.getAttributeValue("value");
        String groupValType = group.getAttributeValue("valType");
        Fragment thisFrag = null;
        if (groupValType.equals("SMILES")) {
            thisFrag = group.getAttribute("labels") != null ? state.fragManager.buildSMILES(groupValue, groupType, groupSubType, group.getAttributeValue("labels")) : state.fragManager.buildSMILES(groupValue, groupType, groupSubType, "");
        } else if (groupValType.equals("dbkey")) {
            thisFrag = state.fragManager.buildCML(groupValue, groupType, groupSubType);
        } else {
            throw new StructureBuildingException("Group tag has bad or missing valType: " + group.toXML());
        }
        if (thisFrag == null) {
            throw new StructureBuildingException("null fragment returned from the following xml: " + group.toXML());
        }
        ComponentProcessor.processXyleneLikeNomenclature(state, group, thisFrag);
        FragmentTools.convertHighOrderBondsToSpareValencies(thisFrag);
        ComponentProcessor.setFragmentDefaultInAtomIfSpecified(thisFrag, group);
        ComponentProcessor.setFragmentFunctionalAtomsIfSpecified(group, thisFrag);
        ComponentProcessor.applyTraditionalAlkaneNumberingIfAppropriate(group, thisFrag);
        return thisFrag;
    }

    private static void processXyleneLikeNomenclature(BuildState state, Element group, Fragment parentFrag) throws StructureBuildingException, ComponentGenerationException {
        int i;
        int i2;
        Element previousEl;
        String[] tempArray;
        if (group.getAttribute("addGroup") != null) {
            List<String> locantValues;
            String addGroupInformation = group.getAttributeValue("addGroup");
            String[] groupsToBeAdded = OpsinTools.MATCH_SEMICOLON.split(addGroupInformation);
            ArrayList allGroupInformation = new ArrayList();
            for (String groupToBeAdded : groupsToBeAdded) {
                tempArray = OpsinTools.MATCH_SPACE.split(groupToBeAdded);
                HashMap<String, String> groupInformation = new HashMap<String, String>();
                if (tempArray.length != 2 && tempArray.length != 3) {
                    throw new ComponentGenerationException("malformed addGroup tag");
                }
                groupInformation.put("SMILES", tempArray[0]);
                if (tempArray[1].startsWith("id")) {
                    groupInformation.put("atomReferenceType", "id");
                    groupInformation.put("atomReference", tempArray[1].substring(2));
                } else if (tempArray[1].startsWith("locant")) {
                    groupInformation.put("atomReferenceType", "locant");
                    groupInformation.put("atomReference", tempArray[1].substring(6));
                } else {
                    throw new ComponentGenerationException("malformed addGroup tag");
                }
                if (tempArray.length == 3) {
                    groupInformation.put("labels", tempArray[2]);
                }
                allGroupInformation.add(groupInformation);
            }
            previousEl = (Element)XOMTools.getPreviousSibling(group);
            if (previousEl != null && previousEl.getLocalName().equals("locant") && ((locantValues = StringTools.arrayToList(OpsinTools.MATCH_COMMA.split(previousEl.getValue()))).size() == groupsToBeAdded.length || locantValues.size() + 1 == groupsToBeAdded.length) && ComponentProcessor.locantAreAcceptableForXyleneLikeNomenclatures(locantValues, group)) {
                boolean assignlocants = true;
                if (locantValues.size() != groupsToBeAdded.length) {
                    String locant;
                    HashMap groupInformation = (HashMap)allGroupInformation.get(0);
                    if (((String)groupInformation.get("atomReferenceType")).equals("locant")) {
                        locant = parentFrag.getAtomByLocantOrThrow((String)groupInformation.get("atomReference")).getFirstLocant();
                    } else if (((String)groupInformation.get("atomReferenceType")).equals("id")) {
                        locant = parentFrag.getAtomByIDOrThrow(parentFrag.getIdOfFirstAtom() + Integer.parseInt((String)groupInformation.get("atomReference")) - 1).getFirstLocant();
                    } else {
                        throw new ComponentGenerationException("malformed addGroup tag");
                    }
                    if (locant == null || !locant.equals("1")) {
                        assignlocants = false;
                    }
                }
                if (assignlocants) {
                    for (int i3 = groupsToBeAdded.length - 1; i3 >= 0; --i3) {
                        HashMap groupInformation = (HashMap)allGroupInformation.get(i3);
                        if (locantValues.size() <= 0) break;
                        groupInformation.put("atomReferenceType", "locant");
                        groupInformation.put("atomReference", locantValues.get(locantValues.size() - 1));
                        locantValues.remove(locantValues.size() - 1);
                    }
                    group.removeAttribute(group.getAttribute("frontLocantsExpected"));
                    previousEl.detach();
                }
            }
            for (i2 = 0; i2 < groupsToBeAdded.length; ++i2) {
                HashMap groupInformation = (HashMap)allGroupInformation.get(i2);
                String smilesOfGroupToBeAdded = (String)groupInformation.get("SMILES");
                Fragment newFrag = groupInformation.get("labels") != null ? state.fragManager.buildSMILES(smilesOfGroupToBeAdded, parentFrag.getType(), parentFrag.getSubType(), (String)groupInformation.get("labels")) : state.fragManager.buildSMILES(smilesOfGroupToBeAdded, parentFrag.getType(), parentFrag.getSubType(), "none");
                Atom atomOnParentFrag = null;
                if (((String)groupInformation.get("atomReferenceType")).equals("locant")) {
                    atomOnParentFrag = parentFrag.getAtomByLocantOrThrow((String)groupInformation.get("atomReference"));
                } else if (((String)groupInformation.get("atomReferenceType")).equals("id")) {
                    atomOnParentFrag = parentFrag.getAtomByIDOrThrow(parentFrag.getIdOfFirstAtom() + Integer.parseInt((String)groupInformation.get("atomReference")) - 1);
                } else {
                    throw new ComponentGenerationException("malformed addGroup tag");
                }
                if (newFrag.getOutAtoms().size() > 1) {
                    throw new ComponentGenerationException("too many outAtoms on group to be added");
                }
                if (newFrag.getOutAtoms().size() == 1) {
                    OutAtom newFragOutAtom = newFrag.getOutAtom(0);
                    newFrag.removeOutAtom(newFragOutAtom);
                    state.fragManager.incorporateFragment(newFrag, newFragOutAtom.getAtom(), parentFrag, atomOnParentFrag, newFragOutAtom.getValency());
                    continue;
                }
                Atom atomOnNewFrag = newFrag.getDefaultInAtom();
                state.fragManager.incorporateFragment(newFrag, atomOnNewFrag, parentFrag, atomOnParentFrag, 1);
            }
        }
        if (group.getAttributeValue("addHeteroAtom") != null) {
            List<String> locantValues;
            String addHeteroAtomInformation = group.getAttributeValue("addHeteroAtom");
            String[] heteroAtomsToBeAdded = OpsinTools.MATCH_SEMICOLON.split(addHeteroAtomInformation);
            ArrayList allHeteroAtomInformation = new ArrayList();
            for (String heteroAtomToBeAdded : heteroAtomsToBeAdded) {
                tempArray = OpsinTools.MATCH_SPACE.split(heteroAtomToBeAdded);
                HashMap<String, String> heteroAtomInformation = new HashMap<String, String>();
                if (tempArray.length != 2) {
                    throw new ComponentGenerationException("malformed addHeteroAtom tag");
                }
                heteroAtomInformation.put("SMILES", tempArray[0]);
                if (tempArray[1].startsWith("id")) {
                    heteroAtomInformation.put("atomReferenceType", "id");
                    heteroAtomInformation.put("atomReference", tempArray[1].substring(2));
                } else if (tempArray[1].startsWith("locant")) {
                    heteroAtomInformation.put("atomReferenceType", "locant");
                    heteroAtomInformation.put("atomReference", tempArray[1].substring(6));
                } else {
                    throw new ComponentGenerationException("malformed addHeteroAtom tag");
                }
                allHeteroAtomInformation.add(heteroAtomInformation);
            }
            previousEl = (Element)XOMTools.getPreviousSibling(group);
            if (previousEl != null && previousEl.getLocalName().equals("locant") && (locantValues = StringTools.arrayToList(OpsinTools.MATCH_COMMA.split(previousEl.getValue()))).size() == heteroAtomsToBeAdded.length && ComponentProcessor.locantAreAcceptableForXyleneLikeNomenclatures(locantValues, group)) {
                for (i = heteroAtomsToBeAdded.length - 1; i >= 0; --i) {
                    HashMap groupInformation = (HashMap)allHeteroAtomInformation.get(i);
                    groupInformation.put("atomReferenceType", "locant");
                    groupInformation.put("atomReference", locantValues.get(locantValues.size() - 1));
                    locantValues.remove(locantValues.size() - 1);
                }
                group.removeAttribute(group.getAttribute("frontLocantsExpected"));
                previousEl.detach();
            }
            for (i2 = 0; i2 < heteroAtomsToBeAdded.length; ++i2) {
                HashMap heteroAtomInformation = (HashMap)allHeteroAtomInformation.get(i2);
                Atom atomOnParentFrag = null;
                if (((String)heteroAtomInformation.get("atomReferenceType")).equals("locant")) {
                    atomOnParentFrag = parentFrag.getAtomByLocantOrThrow((String)heteroAtomInformation.get("atomReference"));
                } else if (((String)heteroAtomInformation.get("atomReferenceType")).equals("id")) {
                    atomOnParentFrag = parentFrag.getAtomByIDOrThrow(parentFrag.getIdOfFirstAtom() + Integer.parseInt((String)heteroAtomInformation.get("atomReference")) - 1);
                } else {
                    throw new ComponentGenerationException("malformed addHeteroAtom tag");
                }
                state.fragManager.replaceAtomWithSmiles(atomOnParentFrag, (String)heteroAtomInformation.get("SMILES"));
            }
        }
        if (group.getAttributeValue("addBond") != null && !"hantzschWidman".equals(group.getAttributeValue("subType"))) {
            List<String> locantValues;
            String addBondInformation = group.getAttributeValue("addBond");
            String[] bondsToBeAdded = OpsinTools.MATCH_SEMICOLON.split(addBondInformation);
            ArrayList allBondInformation = new ArrayList();
            for (String bondToBeAdded : bondsToBeAdded) {
                tempArray = OpsinTools.MATCH_SPACE.split(bondToBeAdded);
                HashMap<String, String> bondInformation = new HashMap<String, String>();
                if (tempArray.length != 2) {
                    throw new ComponentGenerationException("malformed addBond tag");
                }
                bondInformation.put("bondOrder", tempArray[0]);
                if (tempArray[1].startsWith("id")) {
                    bondInformation.put("atomReferenceType", "id");
                    bondInformation.put("atomReference", tempArray[1].substring(2));
                } else if (tempArray[1].startsWith("locant")) {
                    bondInformation.put("atomReferenceType", "locant");
                    bondInformation.put("atomReference", tempArray[1].substring(6));
                } else {
                    throw new ComponentGenerationException("malformed addBond tag");
                }
                allBondInformation.add(bondInformation);
            }
            previousEl = (Element)XOMTools.getPreviousSibling(group);
            if (previousEl != null && previousEl.getLocalName().equals("locant") && (locantValues = StringTools.arrayToList(OpsinTools.MATCH_COMMA.split(previousEl.getValue()))).size() == bondsToBeAdded.length && ComponentProcessor.locantAreAcceptableForXyleneLikeNomenclatures(locantValues, group)) {
                for (i = bondsToBeAdded.length - 1; i >= 0; --i) {
                    HashMap bondInformation = (HashMap)allBondInformation.get(i);
                    bondInformation.put("atomReferenceType", "locant");
                    bondInformation.put("atomReference", locantValues.get(locantValues.size() - 1));
                    locantValues.remove(locantValues.size() - 1);
                }
                group.removeAttribute(group.getAttribute("frontLocantsExpected"));
                previousEl.detach();
            }
            for (int i4 = 0; i4 < bondsToBeAdded.length; ++i4) {
                HashMap bondInformation = (HashMap)allBondInformation.get(i4);
                Atom atomOnParentFrag = null;
                if (((String)bondInformation.get("atomReferenceType")).equals("locant")) {
                    atomOnParentFrag = parentFrag.getAtomByLocantOrThrow((String)bondInformation.get("atomReference"));
                } else if (((String)bondInformation.get("atomReferenceType")).equals("id")) {
                    atomOnParentFrag = parentFrag.getAtomByIDOrThrow(parentFrag.getIdOfFirstAtom() + Integer.parseInt((String)bondInformation.get("atomReference")) - 1);
                } else {
                    throw new ComponentGenerationException("malformed addBond tag");
                }
                FragmentTools.unsaturate(atomOnParentFrag, Integer.parseInt((String)bondInformation.get("bondOrder")), parentFrag);
            }
        }
    }

    private static boolean locantAreAcceptableForXyleneLikeNomenclatures(List<String> locantValues, Element group) {
        if (group.getAttribute("frontLocantsExpected") == null) {
            throw new IllegalArgumentException("Group must have frontLocantsExpected to implement xylene-like nomenclature");
        }
        List<String> allowedLocants = Arrays.asList(OpsinTools.MATCH_COMMA.split(group.getAttributeValue("frontLocantsExpected")));
        for (String locant : locantValues) {
            if (allowedLocants.contains(locant)) continue;
            return false;
        }
        return true;
    }

    private static void setFragmentDefaultInAtomIfSpecified(Fragment thisFrag, Element group) throws StructureBuildingException {
        int chainLength;
        String groupSubType = group.getAttributeValue("subType");
        if (group.getAttribute("defaultInLocant") != null) {
            thisFrag.setDefaultInAtom(thisFrag.getAtomByLocantOrThrow(group.getAttributeValue("defaultInLocant")));
        } else if (group.getAttribute("defaultInID") != null) {
            thisFrag.setDefaultInAtom(thisFrag.getAtomByIDOrThrow(thisFrag.getIdOfFirstAtom() + Integer.parseInt(group.getAttributeValue("defaultInID")) - 1));
        } else if ("yes".equals(group.getAttributeValue("usableAsAJoiner")) && group.getAttribute("suffixAppliesTo") == null && (chainLength = thisFrag.getChainLength()) > 1) {
            Elements groups;
            Element previousSubstituent;
            boolean connectEndToEndWithPreviousSub = true;
            if (groupSubType.equals("alkaneStem") && (previousSubstituent = (Element)XOMTools.getPreviousSibling(group.getParent())) != null && (groups = previousSubstituent.getChildElements("group")).size() == 1 && groups.get(0).getAttributeValue("subType").equals("alkaneStem") && !groups.get(0).getAttributeValue("type").equals("ring")) {
                connectEndToEndWithPreviousSub = false;
            }
            if (connectEndToEndWithPreviousSub) {
                Element previous;
                Element parent = (Element)group.getParent();
                while (parent.getLocalName().equals("bracket")) {
                    parent = (Element)parent.getParent();
                }
                if (parent.getLocalName().equals("root") && ((previous = (Element)XOMTools.getPrevious(group)) == null || !previous.getLocalName().equals("multiplier"))) {
                    connectEndToEndWithPreviousSub = false;
                }
            }
            if (connectEndToEndWithPreviousSub) {
                group.addAttribute(new Attribute("defaultInID", Integer.toString(chainLength)));
                thisFrag.setDefaultInAtom(thisFrag.getAtomByLocantOrThrow(Integer.toString(chainLength)));
            }
        }
    }

    private static void setFragmentFunctionalAtomsIfSpecified(Element group, Fragment thisFrag) throws StructureBuildingException {
        if (group.getAttribute("functionalIDs") != null) {
            String[] functionalIDs;
            for (String functionalID : functionalIDs = OpsinTools.MATCH_COMMA.split(group.getAttributeValue("functionalIDs"))) {
                thisFrag.addFunctionalAtom(thisFrag.getAtomByIDOrThrow(thisFrag.getIdOfFirstAtom() + Integer.parseInt(functionalID) - 1));
            }
        }
    }

    private static void applyTraditionalAlkaneNumberingIfAppropriate(Element group, Fragment thisFrag) {
        block10: {
            String groupType;
            block9: {
                Atom nextAtom;
                groupType = group.getAttributeValue("type");
                if (!groupType.equals("acidStem")) break block9;
                List<Atom> atomList = thisFrag.getAtomList();
                Atom startingAtom = thisFrag.getFirstAtom();
                if (group.getAttribute("suffixAppliesTo") != null) {
                    String suffixAppliesTo = group.getAttributeValue("suffixAppliesTo");
                    String[] suffixAppliesToArr = OpsinTools.MATCH_COMMA.split(suffixAppliesTo);
                    if (suffixAppliesToArr.length != 1) {
                        return;
                    }
                    startingAtom = atomList.get(Integer.parseInt(suffixAppliesToArr[0]) - 1);
                }
                List<Atom> neighbours = startingAtom.getAtomNeighbours();
                int counter = -1;
                Atom previousAtom = startingAtom;
                for (int i = neighbours.size() - 1; i >= 0; --i) {
                    if (neighbours.get(i).getElement().equals("C")) continue;
                    neighbours.remove(i);
                }
                while (neighbours.size() == 1 && ++counter <= 5 && !(nextAtom = neighbours.get(0)).getAtomIsInACycle()) {
                    nextAtom.addLocant(traditionalAlkanePositionNames[counter]);
                    neighbours = nextAtom.getAtomNeighbours();
                    neighbours.remove(previousAtom);
                    for (int i = neighbours.size() - 1; i >= 0; --i) {
                        if (neighbours.get(i).getElement().equals("C")) continue;
                        neighbours.remove(i);
                    }
                    previousAtom = nextAtom;
                }
                break block10;
            }
            if (!groupType.equals("chain") || !"alkaneStem".equals(group.getAttributeValue("subType"))) break block10;
            List<Atom> atomList = thisFrag.getAtomList();
            if (atomList.size() == 1) {
                return;
            }
            Element possibleSuffix = (Element)XOMTools.getNextSibling(group, "suffix");
            Boolean terminalSuffixWithNoSuffixPrefixPresent = false;
            if (possibleSuffix != null && "terminal".equals(possibleSuffix.getAttributeValue("subType")) && possibleSuffix.getAttribute("suffixPrefix") == null) {
                terminalSuffixWithNoSuffixPrefixPresent = true;
            }
            for (Atom atom : atomList) {
                String firstLocant = atom.getFirstLocant();
                if (atom.getAtomIsInACycle() || firstLocant == null || firstLocant.length() != 1 || !Character.isDigit(firstLocant.charAt(0))) continue;
                int locantNumber = Integer.parseInt(firstLocant);
                if (terminalSuffixWithNoSuffixPrefixPresent.booleanValue()) {
                    if (locantNumber <= 1 || locantNumber > 7) continue;
                    atom.addLocant(traditionalAlkanePositionNames[locantNumber - 2]);
                    continue;
                }
                if (locantNumber <= 0 || locantNumber > 6) continue;
                atom.addLocant(traditionalAlkanePositionNames[locantNumber - 1]);
            }
        }
    }

    private void processChargeAndOxidationNumberSpecification(Element group, Fragment frag) {
        Element nextEl = (Element)XOMTools.getNextSibling(group);
        if (nextEl != null) {
            if (nextEl.getLocalName().equals("chargeSpecifier")) {
                frag.getFirstAtom().setCharge(Integer.parseInt(nextEl.getAttributeValue("value")));
                nextEl.detach();
            }
            if (nextEl.getLocalName().equals("oxidationNumberSpecifier")) {
                frag.getFirstAtom().setProperty(Atom.OXIDATION_NUMBER, Integer.parseInt(nextEl.getAttributeValue("value")));
                nextEl.detach();
            }
        }
    }

    private boolean removeAndMoveToAppropriateGroupIfHydroSubstituent(Element substituent) throws ComponentGenerationException {
        Elements hydroElements = substituent.getChildElements("hydro");
        if (hydroElements.size() > 0 && substituent.getChildElements("group").size() == 0) {
            Element hydroSubstituent = substituent;
            if (hydroElements.size() != 1) {
                throw new ComponentGenerationException("Unexpected number of hydro elements found in substituent");
            }
            Element hydroElement = hydroElements.get(0);
            String hydroValue = hydroElement.getValue();
            if (hydroValue.equals("hydro") || hydroValue.equals("dehydro")) {
                Element multiplier = (Element)XOMTools.getPreviousSibling(hydroElement);
                if (multiplier == null || !multiplier.getLocalName().equals("multiplier")) {
                    throw new ComponentGenerationException("Multiplier expected but not found before hydro subsituent");
                }
                if (Integer.parseInt(multiplier.getAttributeValue("value")) % 2 != 0) {
                    throw new ComponentGenerationException("Hydro/dehydro can only be added in pairs but multiplier was odd: " + multiplier.getAttributeValue("value"));
                }
            }
            Element targetRing = null;
            Node nextSubOrRootOrBracket = XOMTools.getNextSibling(hydroSubstituent);
            Element potentialRing = ((Element)nextSubOrRootOrBracket).getFirstChildElement("group");
            if (potentialRing != null && this.containsCyclicAtoms(potentialRing)) {
                Element possibleLocantInFrontOfHydro = XOMTools.getPreviousSiblingIgnoringCertainElements(hydroElement, new String[]{"multiplier"});
                if (possibleLocantInFrontOfHydro != null && possibleLocantInFrontOfHydro.getLocalName().equals("locant") && OpsinTools.MATCH_COMMA.split(possibleLocantInFrontOfHydro.getValue()).length == 1) {
                    targetRing = potentialRing;
                } else {
                    Element possibleLocantInFrontOfRing = (Element)XOMTools.getPreviousSibling(potentialRing, "locant");
                    if (possibleLocantInFrontOfRing != null) {
                        String locantValue;
                        if (potentialRing.getAttribute("frontLocantsExpected") != null) {
                            String[] expectedLocants;
                            locantValue = possibleLocantInFrontOfRing.getValue();
                            for (String expectedLocant : expectedLocants = OpsinTools.MATCH_COMMA.split(potentialRing.getAttributeValue("frontLocantsExpected"))) {
                                if (!locantValue.equals(expectedLocant)) continue;
                                targetRing = potentialRing;
                                break;
                            }
                        }
                        if (potentialRing.getAttributeValue("subType").equals("hantzschWidman")) {
                            locantValue = possibleLocantInFrontOfRing.getValue();
                            int locants = OpsinTools.MATCH_COMMA.split(locantValue).length;
                            int heteroCount = 0;
                            Element currentElem = (Element)XOMTools.getNextSibling(possibleLocantInFrontOfRing);
                            while (!currentElem.equals(potentialRing)) {
                                if (currentElem.getLocalName().equals("heteroatom")) {
                                    ++heteroCount;
                                } else if (currentElem.getLocalName().equals("multiplier")) {
                                    heteroCount += Integer.parseInt(currentElem.getAttributeValue("value")) - 1;
                                }
                                currentElem = (Element)XOMTools.getNextSibling(currentElem);
                            }
                            if (heteroCount == locants) {
                                targetRing = potentialRing;
                            }
                        }
                        if ("fusionRing".equals(potentialRing.getAttributeValue("subType")) && (potentialRing.getValue().equals("benzo") || potentialRing.getValue().equals("benz")) && !((Element)XOMTools.getNextSibling(potentialRing)).getLocalName().equals("fusion")) {
                            targetRing = potentialRing;
                        }
                    } else {
                        targetRing = potentialRing;
                    }
                }
            }
            if (targetRing == null) {
                Element nextSubOrRootOrBracketFromLast = (Element)hydroSubstituent.getParent().getChild(hydroSubstituent.getParent().getChildCount() - 1);
                while (!nextSubOrRootOrBracketFromLast.equals(hydroSubstituent)) {
                    potentialRing = nextSubOrRootOrBracketFromLast.getFirstChildElement("group");
                    if (potentialRing != null && this.containsCyclicAtoms(potentialRing)) {
                        targetRing = potentialRing;
                        break;
                    }
                    nextSubOrRootOrBracketFromLast = (Element)XOMTools.getPreviousSibling(nextSubOrRootOrBracketFromLast);
                }
            }
            if (targetRing == null) {
                throw new ComponentGenerationException("Cannot find ring for hydro substituent to apply to");
            }
            Elements children2 = hydroSubstituent.getChildElements();
            for (int i = children2.size() - 1; i >= 0; --i) {
                Element child = children2.get(i);
                if (child.getLocalName().equals("hyphen")) continue;
                child.detach();
                targetRing.getParent().insertChild(child, 0);
            }
            hydroSubstituent.detach();
            return true;
        }
        return false;
    }

    static boolean removeAndMoveToAppropriateGroupIfSubstractivePrefix(Element substituent) throws ComponentGenerationException {
        Elements subtractivePrefixes = substituent.getChildElements("subtractivePrefix");
        if (subtractivePrefixes.size() > 0) {
            Element targetGroup;
            if (subtractivePrefixes.size() != 1) {
                throw new RuntimeException("Unexpected number of suffixPrefixes found in substituent");
            }
            Element biochemicalGroup = null;
            Element standardGroup = null;
            Node nextSubOrRootOrBracket = XOMTools.getNextSibling(substituent);
            if (nextSubOrRootOrBracket == null) {
                throw new ComponentGenerationException("Unable to find group for: " + subtractivePrefixes.get(0).getValue() + " to apply to!");
            }
            Element potentialBiochemicalGroup = ((Element)nextSubOrRootOrBracket).getFirstChildElement("group");
            if (potentialBiochemicalGroup != null && ("biochemical".equals(potentialBiochemicalGroup.getAttributeValue("subType")) || "carbohydrate".equals(potentialBiochemicalGroup.getAttributeValue("subType")))) {
                biochemicalGroup = potentialBiochemicalGroup;
            }
            if (biochemicalGroup == null) {
                Element nextSubOrRootOrBracketFromLast = (Element)substituent.getParent().getChild(substituent.getParent().getChildCount() - 1);
                while (!nextSubOrRootOrBracketFromLast.equals(substituent)) {
                    Element groupToConsider = nextSubOrRootOrBracketFromLast.getFirstChildElement("group");
                    if (groupToConsider != null) {
                        if ("biochemical".equals(groupToConsider.getAttributeValue("subType")) || "carbohydrate".equals(groupToConsider.getAttributeValue("subType"))) {
                            biochemicalGroup = groupToConsider;
                            break;
                        }
                        standardGroup = groupToConsider;
                    }
                    nextSubOrRootOrBracketFromLast = (Element)XOMTools.getPreviousSibling(nextSubOrRootOrBracketFromLast);
                }
            }
            Element element = targetGroup = biochemicalGroup != null ? biochemicalGroup : standardGroup;
            if (targetGroup == null) {
                throw new ComponentGenerationException("Unable to find group for: " + subtractivePrefixes.get(0).getValue() + " to apply to!");
            }
            Elements children2 = substituent.getChildElements();
            for (int i = children2.size() - 1; i >= 0; --i) {
                Element child = children2.get(i);
                if (child.getLocalName().equals("hyphen")) continue;
                child.detach();
                targetGroup.getParent().insertChild(child, 0);
            }
            substituent.detach();
            return true;
        }
        return false;
    }

    private boolean containsCyclicAtoms(Element potentialRing) {
        Fragment potentialRingFrag = this.state.xmlFragmentMap.get(potentialRing);
        List<Atom> atomList = potentialRingFrag.getAtomList();
        for (Atom atom : atomList) {
            if (!atom.getAtomIsInACycle()) continue;
            return true;
        }
        return false;
    }

    private void determineLocantMeaning(Element subOrBracketOrRoot, Element finalSubOrRootInWord) throws StructureBuildingException, ComponentGenerationException {
        List<Element> locants = XOMTools.getChildElementsWithTagName(subOrBracketOrRoot, "locant");
        Element group = subOrBracketOrRoot.getFirstChildElement("group");
        for (Element locant : locants) {
            String[] locantValues = OpsinTools.MATCH_COMMA.split(locant.getValue());
            if (locantValues.length <= 1) continue;
            Element afterLocant = (Element)XOMTools.getNextSibling(locant);
            int structuralBracketDepth = 0;
            Element multiplierEl = null;
            while (afterLocant != null) {
                String elName = afterLocant.getLocalName();
                if (elName.equals("structuralOpenBracket")) {
                    ++structuralBracketDepth;
                } else if (elName.equals("structuralCloseBracket")) {
                    --structuralBracketDepth;
                }
                if (structuralBracketDepth != 0) {
                    afterLocant = (Element)XOMTools.getNextSibling(afterLocant);
                    continue;
                }
                if (elName.equals("locant")) break;
                if (elName.equals("multiplier")) {
                    if (locantValues.length == Integer.parseInt(afterLocant.getAttributeValue("value"))) {
                        if (afterLocant.equals(XOMTools.getNextSiblingIgnoringCertainElements(locant, new String[]{"indicatedHydrogen"}))) {
                            multiplierEl = afterLocant;
                            break;
                        }
                        Element afterMultiplier = (Element)XOMTools.getNextSibling(afterLocant);
                        if (afterMultiplier != null && (afterMultiplier.getLocalName().equals("suffix") || afterMultiplier.getLocalName().equals("infix") || afterMultiplier.getLocalName().equals("unsaturator") || afterMultiplier.getLocalName().equals("group"))) {
                            multiplierEl = afterLocant;
                            break;
                        }
                    }
                    if (afterLocant.equals(XOMTools.getNextSibling(locant))) {
                        multiplierEl = afterLocant;
                    }
                } else if (elName.equals("ringAssemblyMultiplier") && afterLocant.equals(XOMTools.getNextSibling(locant))) {
                    multiplierEl = afterLocant;
                    if (!FragmentTools.allAtomsInRingAreIdentical(this.state.xmlFragmentMap.get(group))) {
                        break;
                    }
                } else if (elName.equals("fusedRingBridge") && locantValues.length == 2 && afterLocant.equals(XOMTools.getNextSibling(locant))) break;
                afterLocant = (Element)XOMTools.getNextSibling(afterLocant);
            }
            if (multiplierEl != null) {
                if (Integer.parseInt(multiplierEl.getAttributeValue("value")) == locantValues.length) {
                    boolean locantModified = false;
                    if (locantValues[locantValues.length - 1].endsWith("'") && group != null && subOrBracketOrRoot.indexOf(group) > subOrBracketOrRoot.indexOf(locant)) {
                        if (group.getAttribute("outIDs") != null && OpsinTools.MATCH_COMMA.split(group.getAttributeValue("outIDs")).length > 1) {
                            locantModified = this.checkSpecialLocantUses(locant, locantValues, finalSubOrRootInWord);
                        } else {
                            Element afterGroup = (Element)XOMTools.getNextSibling(group);
                            int inlineSuffixCount = 0;
                            int multiplier = 1;
                            while (afterGroup != null) {
                                if (afterGroup.getLocalName().equals("multiplier")) {
                                    multiplier = Integer.parseInt(afterGroup.getAttributeValue("value"));
                                } else if (afterGroup.getLocalName().equals("suffix") && afterGroup.getAttributeValue("type").equals("inline")) {
                                    inlineSuffixCount += multiplier;
                                    multiplier = 1;
                                }
                                afterGroup = (Element)XOMTools.getNextSibling(afterGroup);
                            }
                            if (inlineSuffixCount >= 2) {
                                locantModified = this.checkSpecialLocantUses(locant, locantValues, finalSubOrRootInWord);
                            }
                        }
                    }
                    if (locantModified || XOMTools.getNextSibling(locant).equals(multiplierEl)) continue;
                    locant.detach();
                    XOMTools.insertBefore(multiplierEl, locant);
                    continue;
                }
                if (this.checkSpecialLocantUses(locant, locantValues, finalSubOrRootInWord)) continue;
                throw new ComponentGenerationException("Mismatch between locant and multiplier counts (" + Integer.toString(locantValues.length) + " and " + multiplierEl.getAttributeValue("value") + "):" + locant.toXML());
            }
            if (this.checkSpecialLocantUses(locant, locantValues, finalSubOrRootInWord)) continue;
            throw new ComponentGenerationException("Multiple locants without a multiplier: " + locant.toXML());
        }
    }

    private boolean checkSpecialLocantUses(Element locant, String[] locantValues, Element finalSubOrRootInWord) throws StructureBuildingException {
        Element finalSub;
        Element group;
        List<Element> substituents;
        int count2 = locantValues.length;
        Element currentElem = (Element)XOMTools.getNextSibling(locant);
        int heteroCount = 0;
        int multiplierValue = 1;
        while (currentElem != null && !currentElem.getLocalName().equals("group")) {
            if (currentElem.getLocalName().equals("heteroatom")) {
                heteroCount += multiplierValue;
                multiplierValue = 1;
            } else {
                if (!currentElem.getLocalName().equals("multiplier")) break;
                multiplierValue = Integer.parseInt(currentElem.getAttributeValue("value"));
            }
            currentElem = (Element)XOMTools.getNextSibling(currentElem);
        }
        if (currentElem != null && currentElem.getLocalName().equals("group")) {
            Node potentialGroupAfterBenzo;
            if (currentElem.getAttributeValue("subType").equals("hantzschWidman")) {
                if (heteroCount == count2) {
                    return true;
                }
                if (heteroCount > 1) {
                    return false;
                }
            }
            if (heteroCount == 0 && currentElem.getAttribute("outIDs") != null) {
                String[] outIDs = OpsinTools.MATCH_COMMA.split(currentElem.getAttributeValue("outIDs"), -1);
                Fragment groupFragment = this.state.xmlFragmentMap.get(currentElem);
                if (count2 == outIDs.length && groupFragment.getAtomList().size() > 1) {
                    int idOfFirstAtomInFrag = groupFragment.getIdOfFirstAtom();
                    boolean foundLocantNotPresentOnFragment = false;
                    for (int i = outIDs.length - 1; i >= 0; --i) {
                        Atom a = groupFragment.getAtomByLocant(locantValues[i]);
                        if (a == null) {
                            foundLocantNotPresentOnFragment = true;
                            break;
                        }
                        outIDs[i] = Integer.toString(a.getID() - idOfFirstAtomInFrag + 1);
                    }
                    if (!foundLocantNotPresentOnFragment) {
                        currentElem.getAttribute("outIDs").setValue(StringTools.arrayToString(outIDs, ","));
                        locant.detach();
                        return true;
                    }
                }
            } else if ((currentElem.getValue().equals("benz") || currentElem.getValue().equals("benzo")) && (potentialGroupAfterBenzo = XOMTools.getNextSibling(currentElem, "group")) != null) {
                return true;
            }
        }
        if (currentElem != null && currentElem.getLocalName().equals("polyCyclicSpiro")) {
            return true;
        }
        if (currentElem != null && count2 == 2 && currentElem.getLocalName().equals("fusedRingBridge")) {
            return true;
        }
        boolean detectedMultiplicativeNomenclature = this.detectMultiplicativeNomenclature(locant, locantValues, finalSubOrRootInWord);
        if (detectedMultiplicativeNomenclature) {
            return true;
        }
        if (currentElem != null && currentElem.getLocalName().equals("group") && count2 == 2 && "epoxyLike".equals(currentElem.getAttributeValue("subType"))) {
            return true;
        }
        Element parentElem = (Element)locant.getParent();
        if (count2 == 2 && parentElem.getLocalName().equals("bracket") && (substituents = XOMTools.getChildElementsWithTagName(parentElem, "substituent")).size() > 0 && "epoxyLike".equals((group = (finalSub = substituents.get(substituents.size() - 1)).getFirstChildElement("group")).getAttributeValue("subType"))) {
            locant.detach();
            XOMTools.insertBefore(group, locant);
            return true;
        }
        return false;
    }

    private boolean detectMultiplicativeNomenclature(Element locant, String[] locantValues, Element finalSubOrRootInWord) {
        int count2 = locantValues.length;
        Element multiplier = (Element)finalSubOrRootInWord.getChild(0);
        if (((Element)finalSubOrRootInWord.getParent()).getLocalName().equals("bracket")) {
            if (!multiplier.getLocalName().equals("multiplier")) {
                multiplier = (Element)finalSubOrRootInWord.getParent().getChild(0);
            } else {
                Element elAfterMultiplier = (Element)XOMTools.getNextSibling(multiplier);
                String elName = elAfterMultiplier.getLocalName();
                if (elName.equals("heteroatom") || elName.equals("subtractivePrefix") || elName.equals("hydro") && !elAfterMultiplier.getValue().startsWith("per") || elName.equals("fusedRingBridge")) {
                    multiplier = (Element)finalSubOrRootInWord.getParent().getChild(0);
                }
            }
        }
        ParentNode commonParent = locant.getParent().getParent();
        for (ParentNode parentOfMultiplier = multiplier.getParent(); parentOfMultiplier != null; parentOfMultiplier = parentOfMultiplier.getParent()) {
            if (!commonParent.equals(parentOfMultiplier) || !locantValues[count2 - 1].endsWith("'") || !multiplier.getLocalName().equals("multiplier") || ((Element)XOMTools.getNextSibling(multiplier)).getLocalName().equals("multiplicativeLocant") || Integer.parseInt(multiplier.getAttributeValue("value")) != count2) continue;
            locant.setLocalName("multiplicativeLocant");
            locant.detach();
            XOMTools.insertAfter(multiplier, locant);
            return true;
        }
        return false;
    }

    private void applyDLPrefixes(Element subOrRoot) throws ComponentGenerationException {
        Elements dlStereochemistryEls = subOrRoot.getChildElements("dlStereochemistry");
        for (int i = 0; i < dlStereochemistryEls.size(); ++i) {
            Element dlStereochemistry = dlStereochemistryEls.get(i);
            String dlStereochemistryValue = dlStereochemistry.getAttributeValue("value");
            Element elementToApplyTo = (Element)XOMTools.getNextSibling(dlStereochemistry);
            if (elementToApplyTo == null) {
                throw new RuntimeException("OPSIN bug: DL stereochemistry found in inappropriate position");
            }
            if ("aminoAcid".equals(elementToApplyTo.getAttributeValue("type"))) {
                Fragment aminoAcid = this.state.xmlFragmentMap.get(elementToApplyTo);
                ComponentProcessor.applyDlStereochemistryToAminoAcid(aminoAcid, dlStereochemistryValue);
            } else if ("carbohydrate".equals(elementToApplyTo.getAttributeValue("subType"))) {
                Fragment carbohydrate = this.state.xmlFragmentMap.get(elementToApplyTo);
                ComponentProcessor.applyDlStereochemistryToCarbohydrate(carbohydrate, dlStereochemistryValue);
            } else if ("carbohydrateConfigurationalPrefix".equals(elementToApplyTo.getAttributeValue("type"))) {
                ComponentProcessor.applyDlStereochemistryToCarbohydrateConfigurationalPrefix(elementToApplyTo, dlStereochemistryValue);
            } else {
                throw new RuntimeException("OPSIN bug: Unrecognised element after DL stereochemistry: " + elementToApplyTo.toXML());
            }
            dlStereochemistry.detach();
        }
    }

    static void applyDlStereochemistryToAminoAcid(Fragment aminoAcid, String dlStereochemistryValue) throws ComponentGenerationException {
        List<Atom> atomList = aminoAcid.getAtomList();
        ArrayList<Atom> atomsWithParities = new ArrayList<Atom>();
        for (Atom atom : atomList) {
            if (atom.getAtomParity() == null) continue;
            atomsWithParities.add(atom);
        }
        if (atomsWithParities.isEmpty()) {
            throw new ComponentGenerationException("D/L stereochemistry :" + dlStereochemistryValue + " found before achiral amino acid");
        }
        if (!dlStereochemistryValue.equals("l") && !dlStereochemistryValue.equals("ls")) {
            if (dlStereochemistryValue.equals("d") || dlStereochemistryValue.equals("ds")) {
                for (Atom atom : atomsWithParities) {
                    atom.getAtomParity().setParity(-atom.getAtomParity().getParity());
                }
            } else if (dlStereochemistryValue.equals("dl")) {
                for (Atom atom : atomsWithParities) {
                    atom.setAtomParity(null);
                }
            } else {
                throw new ComponentGenerationException("Unexpected value for D/L stereochemistry found before amino acid: " + dlStereochemistryValue);
            }
        }
    }

    static void applyDlStereochemistryToCarbohydrate(Fragment carbohydrate, String dlStereochemistryValue) throws ComponentGenerationException {
        List<Atom> atomList = carbohydrate.getAtomList();
        ArrayList<Atom> atomsWithParities = new ArrayList<Atom>();
        for (Atom atom : atomList) {
            if (atom.getAtomParity() == null) continue;
            atomsWithParities.add(atom);
        }
        if (atomsWithParities.isEmpty()) {
            throw new ComponentGenerationException("D/L stereochemistry :" + dlStereochemistryValue + " found before achiral carbohydrate");
        }
        if (!dlStereochemistryValue.equals("d") && !dlStereochemistryValue.equals("dg")) {
            if (dlStereochemistryValue.equals("l") || dlStereochemistryValue.equals("lg")) {
                for (Atom atom : atomsWithParities) {
                    atom.getAtomParity().setParity(-atom.getAtomParity().getParity());
                }
            } else if (dlStereochemistryValue.equals("dl")) {
                for (Atom atom : atomsWithParities) {
                    atom.setAtomParity(null);
                }
            } else {
                throw new ComponentGenerationException("Unexpected value for D/L stereochemistry found before carbohydrate: " + dlStereochemistryValue);
            }
        }
    }

    static void applyDlStereochemistryToCarbohydrateConfigurationalPrefix(Element elementToApplyTo, String dlStereochemistryValue) throws ComponentGenerationException {
        if (!dlStereochemistryValue.equals("d") && !dlStereochemistryValue.equals("dg")) {
            if (dlStereochemistryValue.equals("l") || dlStereochemistryValue.equals("lg")) {
                String[] values2 = OpsinTools.MATCH_SLASH.split(elementToApplyTo.getAttributeValue("value"), -1);
                StringBuilder sb = new StringBuilder();
                for (String value2 : values2) {
                    if (value2.equals("r")) {
                        sb.append("l");
                    } else if (value2.equals("l")) {
                        sb.append("r");
                    } else {
                        throw new RuntimeException("OPSIN Bug: Invalid carbohydrate prefix value: " + elementToApplyTo.getAttributeValue("value"));
                    }
                    sb.append("/");
                }
                String newVal = sb.toString().substring(0, sb.length() - 1);
                elementToApplyTo.getAttribute("value").setValue(newVal);
            } else if (dlStereochemistryValue.equals("dl")) {
                String[] values3 = OpsinTools.MATCH_SLASH.split(elementToApplyTo.getAttributeValue("value"));
                String newVal = "?" + StringTools.multiplyString("/?", values3.length - 1);
                elementToApplyTo.getAttribute("value").setValue(newVal);
            } else {
                throw new ComponentGenerationException("Unexpected value for D/L stereochemistry found before carbohydrate prefix: " + dlStereochemistryValue);
            }
        }
    }

    private void cycliseCarbohydrates(Element subOrRoot) throws StructureBuildingException {
        List<Element> carbohydrates = XOMTools.getChildElementsWithTagNameAndAttribute(subOrRoot, "group", "type", "carbohydrateStem");
        for (Element group : carbohydrates) {
            int locantOfCarbonyl;
            Fragment frag = this.state.xmlFragmentMap.get(group);
            Element ringSize = (Element)XOMTools.getNextSibling(group);
            if (ringSize == null || !ringSize.getLocalName().equals("carbohydrateRingSize")) {
                throw new RuntimeException("OPSIN bug: carbohydrate size indicator not found where expected");
            }
            Atom carbonylCarbon = this.getCarbonylCarbon(frag);
            if (carbonylCarbon == null) {
                throw new RuntimeException("OPSIN bug: Could not find carbonyl carbon in carbohydrate");
            }
            for (Bond b : carbonylCarbon.getBonds()) {
                if (b.getOrder() != 2) continue;
                b.setOrder(1);
                break;
            }
            try {
                locantOfCarbonyl = Integer.parseInt(carbonylCarbon.getFirstLocant());
            }
            catch (Exception e) {
                throw new RuntimeException("OPSIN bug: Could not determine locant of carbonyl carbon in carbohydrate", e);
            }
            String locantToJoinWith = String.valueOf(locantOfCarbonyl + Integer.parseInt(ringSize.getAttributeValue("value")) - 2);
            Atom atomToJoinWith = frag.getAtomByLocant("O" + locantToJoinWith);
            if (atomToJoinWith == null) {
                throw new StructureBuildingException("Carbohydrate was not an inappropriate length to form a ring of size: " + ringSize.getAttributeValue("value"));
            }
            this.state.fragManager.createBond(carbonylCarbon, atomToJoinWith, 1);
            CycleDetector.assignWhetherAtomsAreInCycles(frag);
            ringSize.detach();
            Element alphaOrBetaLocantEl = (Element)XOMTools.getPreviousSibling(group);
            if (alphaOrBetaLocantEl == null || !alphaOrBetaLocantEl.getLocalName().equals("locant")) continue;
            Atom anomericReferenceAtom = this.getAnomericReferenceAtom(frag);
            if (anomericReferenceAtom == null) {
                throw new RuntimeException("OPSIN bug: Unable to determine anomeric reference atom in: " + group.getValue());
            }
            this.applyAnomerStereochemistryIfPresent(alphaOrBetaLocantEl, carbonylCarbon, anomericReferenceAtom);
        }
    }

    private Atom getCarbonylCarbon(Fragment frag) {
        Set<Bond> bonds = frag.getBondSet();
        for (Bond bond : bonds) {
            if (bond.getOrder() != 2) continue;
            if (bond.getFromAtom().getElement().equals("C") && bond.getToAtom().getElement().equals("O")) {
                return bond.getFromAtom();
            }
            if (!bond.getFromAtom().getElement().equals("O") || !bond.getToAtom().getElement().equals("C")) continue;
            return bond.getToAtom();
        }
        return null;
    }

    private Atom getAnomericReferenceAtom(Fragment frag) {
        List<Atom> atomList = frag.getAtomList();
        int highestLocantfound = Integer.MIN_VALUE;
        Atom configurationalAtom = null;
        for (Atom a : atomList) {
            if (a.getAtomParity() == null) continue;
            try {
                String locant = a.getFirstLocant();
                int intVal = Integer.parseInt(locant);
                if (intVal <= highestLocantfound) continue;
                highestLocantfound = intVal;
                configurationalAtom = a;
            }
            catch (Exception e) {}
        }
        return configurationalAtom;
    }

    private void applyAnomerStereochemistryIfPresent(Element alphaOrBetaLocantEl, Atom anomericAtom, Atom anomericReferenceAtom) {
        String value2 = alphaOrBetaLocantEl.getValue();
        if (value2.equals("alpha") || value2.equals("beta")) {
            Atom[] referenceAtomRefs4 = this.getDeterministicAtomRefs4ForReferenceAtom(anomericReferenceAtom, anomericAtom);
            boolean flip = StereochemistryHandler.checkEquivalencyOfAtomsRefs4AndParity(referenceAtomRefs4, 1, anomericReferenceAtom.getAtomParity().getAtomRefs4(), anomericReferenceAtom.getAtomParity().getParity());
            Atom[] atomRefs4 = this.getDeterministicAtomRefs4ForAnomericAtom(anomericAtom);
            if (flip) {
                if (value2.equals("alpha")) {
                    anomericAtom.setAtomParity(atomRefs4, 1);
                } else {
                    anomericAtom.setAtomParity(atomRefs4, -1);
                }
            } else if (value2.equals("alpha")) {
                anomericAtom.setAtomParity(atomRefs4, -1);
            } else {
                anomericAtom.setAtomParity(atomRefs4, 1);
            }
            alphaOrBetaLocantEl.detach();
        } else if (value2.equals("alpha,beta") || value2.equals("beta,alpha")) {
            alphaOrBetaLocantEl.detach();
        }
    }

    private Atom[] getDeterministicAtomRefs4ForReferenceAtom(Atom referenceAtom, Atom anomericAtom) {
        List<Atom> neighbours = referenceAtom.getAtomNeighbours();
        if (neighbours.size() != 3) {
            throw new RuntimeException("OPSIN bug: Unexpected number of atoms connected to anomeric reference atom of carbohydrate");
        }
        Atom[] atomRefs4 = new Atom[4];
        for (Atom neighbour : neighbours) {
            if (neighbour.getElement().equals("O")) {
                atomRefs4[0] = neighbour;
                continue;
            }
            if (neighbour.getElement().equals("C")) {
                if (neighbour.getAtomParity() != null || neighbour.equals(anomericAtom)) {
                    atomRefs4[1] = neighbour;
                    continue;
                }
                atomRefs4[2] = neighbour;
                continue;
            }
            throw new RuntimeException("OPSIN bug: Unexpected atom element type connected to for anomeric reference atom");
        }
        atomRefs4[3] = AtomParity.hydrogen;
        for (Atom atom : atomRefs4) {
            if (atom != null) continue;
            throw new RuntimeException("OPSIN bug: Unable to determine atomRefs4 for anomeric reference atom");
        }
        return atomRefs4;
    }

    private Atom[] getDeterministicAtomRefs4ForAnomericAtom(Atom anomericAtom) {
        List<Atom> neighbours = anomericAtom.getAtomNeighbours();
        if (neighbours.size() != 3 && neighbours.size() != 4) {
            throw new RuntimeException("OPSIN bug: Unexpected number of atoms connected to anomeric atom of carbohydrate");
        }
        Atom[] atomRefs4 = new Atom[4];
        for (Atom neighbour : neighbours) {
            if (neighbour.getElement().equals("C")) {
                if (neighbour.getAtomIsInACycle()) {
                    atomRefs4[0] = neighbour;
                    continue;
                }
                atomRefs4[3] = neighbour;
                continue;
            }
            if (neighbour.getElement().equals("O")) {
                int incomingVal = neighbour.getIncomingValency();
                if (incomingVal == 1) {
                    atomRefs4[1] = neighbour;
                    continue;
                }
                if (incomingVal == 2) {
                    atomRefs4[2] = neighbour;
                    continue;
                }
                throw new RuntimeException("OPSIN bug: Unexpected valency on oxygen in carbohydrate");
            }
            throw new RuntimeException("OPSIN bug: Unexpected atom element type connected to anomeric atom of carbohydrate");
        }
        if (atomRefs4[3] == null) {
            atomRefs4[3] = AtomParity.hydrogen;
        }
        for (Atom atom : atomRefs4) {
            if (atom != null) continue;
            throw new RuntimeException("OPSIN bug: Unable to assign anomeric carbon stereochemistry on carbohydrate");
        }
        return atomRefs4;
    }

    private void processMultipliers(Element subOrRoot) {
        List<Element> multipliers = XOMTools.getChildElementsWithTagName(subOrRoot, "multiplier");
        for (Element multiplier : multipliers) {
            Element featureToMultiply;
            String nextName;
            Element possibleLocant = (Element)XOMTools.getPreviousSibling(multiplier);
            String[] locants = null;
            if (possibleLocant != null && possibleLocant.getLocalName().equals("locant")) {
                locants = OpsinTools.MATCH_COMMA.split(possibleLocant.getValue());
            }
            if (!(nextName = (featureToMultiply = (Element)XOMTools.getNextSibling(multiplier)).getLocalName()).equals("unsaturator") && !nextName.equals("suffix") && !nextName.equals("subtractivePrefix") && (!nextName.equals("heteroatom") || "group".equals(multiplier.getAttributeValue("type"))) && !nextName.equals("hydro")) continue;
            int mvalue = Integer.parseInt(multiplier.getAttributeValue("value"));
            if (mvalue > 1) {
                featureToMultiply.addAttribute(new Attribute("multiplied", "multiplied"));
            }
            for (int i = mvalue - 1; i >= 1; --i) {
                Element newElement = new Element(featureToMultiply);
                if (locants != null && locants.length == mvalue) {
                    newElement.addAttribute(new Attribute("locant", locants[i]));
                }
                XOMTools.insertAfter(featureToMultiply, newElement);
            }
            multiplier.detach();
            if (locants == null || locants.length != mvalue) continue;
            featureToMultiply.addAttribute(new Attribute("locant", locants[0]));
            possibleLocant.detach();
        }
    }

    private void detectConjunctiveSuffixGroups(Element subOrRoot, List<Element> allGroups) throws ComponentGenerationException, StructureBuildingException {
        List<Element> groups = XOMTools.getChildElementsWithTagName(subOrRoot, "group");
        if (groups.size() > 1) {
            int i;
            ArrayList<Element> conjunctiveGroups = new ArrayList<Element>();
            Element ringGroup = null;
            for (int i2 = groups.size() - 1; i2 >= 0; --i2) {
                Element group = groups.get(i2);
                if (group.getAttributeValue("type").equals("ring")) {
                    ringGroup = group;
                    break;
                }
                conjunctiveGroups.add(group);
            }
            if (conjunctiveGroups.size() == 0) {
                return;
            }
            if (ringGroup == null) {
                throw new ComponentGenerationException("OPSIN bug: unable to find ring associated with conjunctive suffix group");
            }
            if (conjunctiveGroups.size() != 1) {
                throw new ComponentGenerationException("OPSIN Bug: Two groups exactly should be present at this point when processing conjunctive nomenclature");
            }
            Element primaryConjunctiveGroup = (Element)conjunctiveGroups.get(0);
            Fragment primaryConjunctiveFrag = this.state.xmlFragmentMap.get(primaryConjunctiveGroup);
            List<Atom> atomList = primaryConjunctiveFrag.getAtomList();
            for (Atom atom : atomList) {
                atom.clearLocants();
            }
            ArrayList<Element> suffixes = new ArrayList<Element>();
            Element possibleSuffix = (Element)XOMTools.getNextSibling(primaryConjunctiveGroup);
            while (possibleSuffix != null) {
                if (possibleSuffix.getLocalName().equals("suffix")) {
                    suffixes.add(possibleSuffix);
                }
                possibleSuffix = (Element)XOMTools.getNextSibling(possibleSuffix);
            }
            this.preliminaryProcessSuffixes(primaryConjunctiveGroup, suffixes);
            this.resolveSuffixes(primaryConjunctiveGroup, suffixes);
            for (Element suffix : suffixes) {
                suffix.detach();
            }
            primaryConjunctiveGroup.setLocalName("conjunctiveSuffixGroup");
            allGroups.remove(primaryConjunctiveGroup);
            Element possibleMultiplier = (Element)XOMTools.getPreviousSibling(primaryConjunctiveGroup);
            boolean alphaIsPosition1 = atomList.get(0).getIncomingValency() < 3;
            int counter = 0;
            int n = i = alphaIsPosition1 ? 0 : 1;
            while (i < atomList.size()) {
                Atom a = atomList.get(i);
                if (counter == 0) {
                    a.addLocant("alpha");
                } else if (counter == 1) {
                    a.addLocant("beta");
                } else if (counter == 2) {
                    a.addLocant("gamma");
                } else if (counter == 3) {
                    a.addLocant("delta");
                } else if (counter == 4) {
                    a.addLocant("epsilon");
                } else if (counter == 5) {
                    a.addLocant("zeta");
                } else if (counter == 6) {
                    a.addLocant("eta");
                }
                ++counter;
                ++i;
            }
            if ("multiplier".equals(possibleMultiplier.getLocalName())) {
                int multiplier = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                for (int i3 = 1; i3 < multiplier; ++i3) {
                    Element conjunctiveSuffixGroup = new Element(primaryConjunctiveGroup);
                    Fragment newFragment = this.state.fragManager.copyAndRelabelFragment(primaryConjunctiveFrag, i3);
                    this.state.xmlFragmentMap.put(conjunctiveSuffixGroup, newFragment);
                    conjunctiveGroups.add(conjunctiveSuffixGroup);
                    XOMTools.insertAfter(primaryConjunctiveGroup, conjunctiveSuffixGroup);
                }
                Element possibleLocant = (Element)XOMTools.getPreviousSibling(possibleMultiplier);
                possibleMultiplier.detach();
                if (possibleLocant.getLocalName().equals("locant")) {
                    String[] locants = OpsinTools.MATCH_COMMA.split(possibleLocant.getValue());
                    if (locants.length != multiplier) {
                        throw new ComponentGenerationException("mismatch between number of locants and multiplier in conjunctive nomenclature routine");
                    }
                    for (int i4 = 0; i4 < locants.length; ++i4) {
                        ((Element)conjunctiveGroups.get(i4)).addAttribute(new Attribute("locant", locants[i4]));
                    }
                    possibleLocant.detach();
                }
            }
        }
    }

    private void matchLocantsToDirectFeatures(Element subOrRoot) throws ComponentGenerationException {
        List<Element> locants = XOMTools.getChildElementsWithTagName(subOrRoot, "locant");
        List<Element> groups = XOMTools.getChildElementsWithTagName(subOrRoot, "group");
        for (Element group : groups) {
            Elements deltas;
            if (!group.getAttributeValue("subType").equals("hantzschWidman")) continue;
            if (group.getAttribute("addBond") != null && (deltas = subOrRoot.getChildElements("delta")).size() == 0) {
                Element delta = new Element("delta");
                Element appropriateLocant = XOMTools.getPreviousSiblingIgnoringCertainElements(group, new String[]{"heteroatom", "multiplier"});
                if (appropriateLocant != null && appropriateLocant.getLocalName().equals("locant") && OpsinTools.MATCH_COMMA.split(appropriateLocant.getValue()).length == 1) {
                    delta.appendChild(appropriateLocant.getValue());
                    XOMTools.insertBefore(appropriateLocant, delta);
                    appropriateLocant.detach();
                    locants.remove(appropriateLocant);
                } else {
                    delta.appendChild("");
                    subOrRoot.insertChild(delta, 0);
                }
            }
            if (locants.size() <= 0) continue;
            Element locantBeforeHWSystem = null;
            ArrayList<Element> heteroAtoms = new ArrayList<Element>();
            int indexOfGroup = subOrRoot.indexOf(group);
            for (int j = indexOfGroup - 1; j >= 0; --j) {
                String elName = ((Element)subOrRoot.getChild(j)).getLocalName();
                if (elName.equals("locant")) {
                    locantBeforeHWSystem = (Element)subOrRoot.getChild(j);
                    break;
                }
                if (!elName.equals("heteroatom")) break;
                Element heteroAtom = (Element)subOrRoot.getChild(j);
                heteroAtoms.add(heteroAtom);
                if (heteroAtom.getAttribute("locant") != null) break;
            }
            Collections.reverse(heteroAtoms);
            if (locantBeforeHWSystem == null) continue;
            String[] locantValues = OpsinTools.MATCH_COMMA.split(locantBeforeHWSystem.getValue());
            if (locantValues.length == 1 && this.state.xmlFragmentMap.get(group).getAtomList().size() <= 10) {
                locants.remove(locantBeforeHWSystem);
                continue;
            }
            if (locantValues.length == heteroAtoms.size()) {
                for (int j = 0; j < locantValues.length; ++j) {
                    String locantValue = locantValues[j];
                    ((Element)heteroAtoms.get(j)).addAttribute(new Attribute("locant", locantValue));
                }
                locantBeforeHWSystem.detach();
                locants.remove(locantBeforeHWSystem);
                continue;
            }
            if (heteroAtoms.size() <= 1) continue;
            throw new ComponentGenerationException("Mismatch between number of locants and HW heteroatoms");
        }
        this.assignSingleLocantsToAdjacentFeatures(locants);
    }

    private void assignSingleLocantsToAdjacentFeatures(List<Element> locants) {
        for (Element locant : locants) {
            String[] locantValues = OpsinTools.MATCH_COMMA.split(locant.getValue());
            Element referent = (Element)XOMTools.getNextSibling(locant);
            if (referent == null || locantValues.length != 1) continue;
            String refName = referent.getLocalName();
            if (referent.getAttribute("locant") != null || referent.getAttribute("multiplied") != null || !refName.equals("unsaturator") && !refName.equals("suffix") && !refName.equals("heteroatom") && !refName.equals("conjunctiveSuffixGroup") && !refName.equals("subtractivePrefix") && (!refName.equals("hydro") || referent.getValue().startsWith("per"))) continue;
            referent.addAttribute(new Attribute("locant", locantValues[0]));
            locant.detach();
        }
    }

    private void preliminaryProcessSuffixes(Element group, List<Element> suffixes) throws ComponentGenerationException, StructureBuildingException {
        Fragment suffixableFragment = this.state.xmlFragmentMap.get(group);
        boolean imideSpecialCase = false;
        if (group.getAttribute("suffixAppliesTo") != null) {
            imideSpecialCase = this.processSuffixAppliesTo(group, suffixes, suffixableFragment);
        } else {
            for (Element suffix : suffixes) {
                if (suffix.getAttribute("additionalValue") == null) continue;
                throw new ComponentGenerationException("suffix: " + suffix.getValue() + " used on an inappropriate group");
            }
        }
        if (group.getAttribute("suffixAppliesToByDefault") != null) {
            this.applyDefaultLocantToSuffixIfPresent(group.getAttributeValue("suffixAppliesToByDefault"), group, suffixableFragment);
        }
        List<Fragment> suffixFragments = this.resolveGroupAddingSuffixes(suffixes, suffixableFragment);
        this.state.xmlSuffixMap.put(group, suffixFragments);
        boolean suffixesResolved = false;
        if (group.getAttributeValue("type").equals("chalcogenAcidStem")) {
            this.resolveSuffixes(group, suffixes);
            suffixesResolved = true;
        }
        this.processSuffixPrefixes(suffixes);
        FunctionalReplacement.processInfixFunctionalReplacementNomenclature(this.state, suffixes, suffixFragments);
        this.processRemovalOfHydroxyGroupsRules(suffixes, suffixableFragment);
        if (group.getValue().equals("oxal")) {
            this.resolveSuffixes(group, suffixes);
            group.getAttribute("type").setValue("nonCarboxylicAcid");
            suffixableFragment.setType("nonCarboxylicAcid");
            suffixesResolved = true;
        }
        if (imideSpecialCase) {
            if (suffixes.size() != 2) {
                throw new ComponentGenerationException("Expected two suffixes fragments for cyclic imide");
            }
            Atom nitrogen = null;
            for (Atom a : suffixFragments.get(0).getAtomList()) {
                if (!a.getElement().equals("N")) continue;
                nitrogen = a;
            }
            if (nitrogen == null) {
                throw new ComponentGenerationException("Nitrogen not found where nitrogen expected");
            }
            Atom carbon = suffixableFragment.getAtomByIDOrThrow(Integer.parseInt(suffixes.get(1).getAttributeValue("locantID")));
            if (!carbon.getElement().equals("C")) {
                throw new ComponentGenerationException("Carbon not found where carbon expected");
            }
            this.resolveSuffixes(group, suffixes);
            suffixesResolved = true;
            this.state.fragManager.createBond(nitrogen, carbon, 1);
        }
        if (suffixesResolved) {
            for (int i = suffixes.size() - 1; i >= 0; --i) {
                Element suffix = suffixes.remove(i);
                suffix.detach();
            }
        }
        if (group.getAttribute("numberOfFunctionalAtomsToRemove") != null) {
            int numberToRemove = Integer.parseInt(group.getAttributeValue("numberOfFunctionalAtomsToRemove"));
            if (numberToRemove > suffixableFragment.getFunctionalAtoms().size()) {
                throw new ComponentGenerationException("Too many hydrogen for the number of positions on non carboxylic acid");
            }
            for (int i = 0; i < numberToRemove; ++i) {
                Atom functionalAtom = suffixableFragment.removeFunctionalAtom(0).getAtom();
                functionalAtom.neutraliseCharge();
            }
        }
    }

    private void applyDefaultLocantToSuffixIfPresent(String attributeValue, Element group, Fragment suffixableFragment) {
        Element suffix = OpsinTools.getNextNonChargeSuffix(group);
        if (suffix != null) {
            suffix.addAttribute(new Attribute("defaultLocantID", Integer.toString(suffixableFragment.getIdOfFirstAtom() + Integer.parseInt(attributeValue) - 1)));
        }
    }

    private boolean processSuffixAppliesTo(Element group, List<Element> suffixes, Fragment suffixableFragment) throws ComponentGenerationException {
        boolean imideSpecialCase = false;
        Element suffix = OpsinTools.getNextNonChargeSuffix(group);
        if (suffix == null) {
            throw new ComponentGenerationException("No suffix where suffix was expected");
        }
        if (suffixes.size() > 1 && group.getAttributeValue("type").equals("acidStem")) {
            throw new ComponentGenerationException("More than one suffix detected on trivial polyAcid. Not believed to be allowed");
        }
        String suffixInstruction = group.getAttributeValue("suffixAppliesTo");
        String[] suffixInstructions = OpsinTools.MATCH_COMMA.split(suffixInstruction);
        boolean symmetricSuffixes = true;
        if (suffix.getAttribute("additionalValue") != null) {
            if (suffixInstructions.length < 2) {
                throw new ComponentGenerationException("suffix: " + suffix.getValue() + " used on an inappropriate group");
            }
            symmetricSuffixes = false;
            String suffixValue = suffix.getValue();
            if (suffixValue.equals("imide") || suffixValue.equals("imid") || suffixValue.equals("imido") || suffixValue.equals("imidyl") || suffixValue.equals("imidium") || suffixValue.equals("imidylium")) {
                imideSpecialCase = true;
            }
        }
        int firstIdInFragment = suffixableFragment.getIdOfFirstAtom();
        if (suffix.getAttribute("locant") == null) {
            suffix.addAttribute(new Attribute("locantID", Integer.toString(firstIdInFragment + Integer.parseInt(suffixInstructions[0]) - 1)));
        }
        for (int i = 1; i < suffixInstructions.length; ++i) {
            Element newSuffix = new Element("suffix");
            if (symmetricSuffixes) {
                newSuffix.addAttribute(new Attribute("value", suffix.getAttributeValue("value")));
                newSuffix.addAttribute(new Attribute("type", suffix.getAttributeValue("type")));
                if (suffix.getAttribute("subType") != null) {
                    newSuffix.addAttribute(new Attribute("subType", suffix.getAttributeValue("subType")));
                }
                if (suffix.getAttribute("infix") != null && suffix.getAttributeValue("infix").startsWith("=")) {
                    newSuffix.addAttribute(new Attribute("infix", suffix.getAttributeValue("infix")));
                }
            } else {
                newSuffix.addAttribute(new Attribute("value", suffix.getAttributeValue("additionalValue")));
                newSuffix.addAttribute(new Attribute("type", "root"));
            }
            newSuffix.addAttribute(new Attribute("locantID", Integer.toString(firstIdInFragment + Integer.parseInt(suffixInstructions[i]) - 1)));
            XOMTools.insertAfter(suffix, newSuffix);
            suffixes.add(newSuffix);
        }
        return imideSpecialCase;
    }

    private List<Fragment> resolveGroupAddingSuffixes(List<Element> suffixes, Fragment frag) throws StructureBuildingException, ComponentGenerationException {
        ArrayList<Fragment> suffixFragments = new ArrayList<Fragment>();
        String groupType = frag.getType();
        String subgroupType = frag.getSubType();
        String suffixTypeToUse = null;
        suffixTypeToUse = this.suffixRules.isGroupTypeWithSpecificSuffixRules(groupType) ? groupType : "standardGroup";
        for (Element suffix : suffixes) {
            String suffixValue = suffix.getAttributeValue("value");
            Atom atomLikelyToBeUsedBySuffix = null;
            if (suffix.getAttribute("locant") != null) {
                atomLikelyToBeUsedBySuffix = frag.getAtomByLocant(suffix.getAttributeValue("locant"));
            } else if (suffix.getAttribute("locantID") != null) {
                atomLikelyToBeUsedBySuffix = frag.getAtomByIDOrThrow(Integer.parseInt(suffix.getAttributeValue("locantID")));
            }
            if (atomLikelyToBeUsedBySuffix == null) {
                atomLikelyToBeUsedBySuffix = frag.getFirstAtom();
            }
            boolean cyclic = atomLikelyToBeUsedBySuffix.getAtomIsInACycle();
            Elements suffixRuleTags = this.suffixRules.getSuffixRuleTags(suffixTypeToUse, suffixValue, subgroupType);
            Fragment suffixFrag = null;
            for (int j = 0; j < suffixRuleTags.size(); ++j) {
                Element suffixRuleTag = suffixRuleTags.get(j);
                String suffixRuleTagName = suffixRuleTag.getLocalName();
                if (suffixRuleTagName.equals("addgroup")) {
                    String[] relativeIdsOfOutAtoms;
                    int atomIndice;
                    String labels = "none";
                    if (suffixRuleTag.getAttribute("labels") != null) {
                        labels = suffixRuleTag.getAttributeValue("labels");
                    }
                    suffixFrag = this.state.fragManager.buildSMILES(suffixRuleTag.getAttributeValue("SMILES"), "suffix", "suffix", labels);
                    List<Atom> atomList = suffixFrag.getAtomList();
                    if (suffixRuleTag.getAttribute("functionalIDs") != null) {
                        String[] relativeIdsOfFunctionalAtoms;
                        for (String relativeId : relativeIdsOfFunctionalAtoms = OpsinTools.MATCH_COMMA.split(suffixRuleTag.getAttributeValue("functionalIDs"))) {
                            atomIndice = Integer.parseInt(relativeId) - 1;
                            if (atomIndice >= atomList.size()) {
                                throw new StructureBuildingException("Check suffixRules.xml: Atom requested to have a functionalAtom was not within the suffix fragment");
                            }
                            suffixFrag.addFunctionalAtom(atomList.get(atomIndice));
                        }
                    }
                    if (suffixRuleTag.getAttribute("outIDs") == null) continue;
                    for (String relativeId : relativeIdsOfOutAtoms = OpsinTools.MATCH_COMMA.split(suffixRuleTag.getAttributeValue("outIDs"))) {
                        atomIndice = Integer.parseInt(relativeId) - 1;
                        if (atomIndice >= atomList.size()) {
                            throw new StructureBuildingException("Check suffixRules.xml: Atom requested to have a outAtom was not within the suffix fragment");
                        }
                        suffixFrag.addOutAtom(atomList.get(atomIndice), 1, (Boolean)true);
                    }
                    continue;
                }
                if (suffixRuleTagName.equals("addSuffixPrefixIfNonePresentAndCyclic")) {
                    if (!cyclic || suffix.getAttribute("suffixPrefix") != null) continue;
                    suffix.addAttribute(new Attribute("suffixPrefix", suffixRuleTag.getAttributeValue("SMILES")));
                    continue;
                }
                if (suffixRuleTagName.equals("addFunctionalAtomsToHydroxyGroups")) {
                    if (suffixFrag != null) {
                        throw new ComponentGenerationException("addFunctionalAtomsToHydroxyGroups is not currently compatable with the addGroup suffix rule");
                    }
                    this.addFunctionalAtomsToHydroxyGroups(atomLikelyToBeUsedBySuffix);
                    continue;
                }
                if (suffixRuleTagName.equals("chargeHydroxyGroups")) {
                    if (suffixFrag != null) {
                        throw new ComponentGenerationException("chargeHydroxyGroups is not currently compatable with the addGroup suffix rule");
                    }
                    this.chargeHydroxyGroups(atomLikelyToBeUsedBySuffix);
                    continue;
                }
                if (!suffixRuleTagName.equals("removeOneDoubleBondedOxygen")) continue;
                if (suffixFrag != null) {
                    throw new ComponentGenerationException("removeOneDoubleBondedOxygen is not currently compatable with the addGroup suffix rule");
                }
                this.removeOneDoubleBondedOxygen(atomLikelyToBeUsedBySuffix);
            }
            if (suffixFrag == null) continue;
            suffixFragments.add(suffixFrag);
            this.state.xmlFragmentMap.put(suffix, suffixFrag);
        }
        return suffixFragments;
    }

    private void processRemovalOfHydroxyGroupsRules(List<Element> suffixes, Fragment frag) throws ComponentGenerationException, StructureBuildingException {
        String groupType = frag.getType();
        String subgroupType = frag.getSubType();
        String suffixTypeToUse = null;
        suffixTypeToUse = this.suffixRules.isGroupTypeWithSpecificSuffixRules(groupType) ? groupType : "standardGroup";
        for (Element suffix : suffixes) {
            String suffixValue = suffix.getAttributeValue("value");
            Elements suffixRuleTags = this.suffixRules.getSuffixRuleTags(suffixTypeToUse, suffixValue, subgroupType);
            for (int j = 0; j < suffixRuleTags.size(); ++j) {
                Element suffixRuleTag = suffixRuleTags.get(j);
                String suffixRuleTagName = suffixRuleTag.getLocalName();
                if (suffixRuleTagName.equals("convertHydroxyGroupsToOutAtoms")) {
                    this.convertHydroxyGroupsToOutAtoms(frag);
                    continue;
                }
                if (!suffixRuleTagName.equals("convertHydroxyGroupsToPositiveCharge")) continue;
                this.convertHydroxyGroupsToPositiveCharge(frag);
            }
        }
    }

    private void addFunctionalAtomsToHydroxyGroups(Atom atom) throws StructureBuildingException {
        List<Atom> neighbours = atom.getAtomNeighbours();
        for (Atom neighbour : neighbours) {
            if (!neighbour.getElement().equals("O") || neighbour.getCharge() != 0 || neighbour.getAtomNeighbours().size() != 1 || atom.getBondToAtomOrThrow(neighbour).getOrder() != 1) continue;
            neighbour.getFrag().addFunctionalAtom(neighbour);
        }
    }

    private void chargeHydroxyGroups(Atom atom) throws StructureBuildingException {
        List<Atom> neighbours = atom.getAtomNeighbours();
        for (Atom neighbour : neighbours) {
            if (!neighbour.getElement().equals("O") || neighbour.getCharge() != 0 || neighbour.getAtomNeighbours().size() != 1 || atom.getBondToAtomOrThrow(neighbour).getOrder() != 1) continue;
            neighbour.addChargeAndProtons(-1, -1);
        }
    }

    private void removeOneDoubleBondedOxygen(Atom atom) throws StructureBuildingException {
        List<Atom> neighbours = atom.getAtomNeighbours();
        for (Atom neighbour : neighbours) {
            if (!neighbour.getElement().equals("O") || neighbour.getAtomNeighbours().size() != 1) continue;
            Bond b = atom.getBondToAtomOrThrow(neighbour);
            if (b.getOrder() == 2 && neighbour.getCharge() == 0) {
                this.state.fragManager.removeAtomAndAssociatedBonds(neighbour);
                if (atom.getLambdaConventionValency() != null) {
                    atom.setLambdaConventionValency(atom.getLambdaConventionValency() - 2);
                }
                if (atom.getMinimumValency() != null) {
                    atom.setMinimumValency(atom.getMinimumValency() - 2);
                }
                return;
            }
            if (neighbour.getCharge() != -1 || b.getOrder() != 1 || atom.getCharge() != 1 || !atom.getElement().equals("N")) continue;
            this.state.fragManager.removeAtomAndAssociatedBonds(neighbour);
            atom.neutraliseCharge();
            return;
        }
        throw new StructureBuildingException("Double bonded oxygen not found in fragment. Perhaps a suffix has been used inappropriately");
    }

    private void convertHydroxyGroupsToOutAtoms(Fragment frag) throws StructureBuildingException {
        List<Atom> atomList = frag.getAtomList();
        for (Atom atom : atomList) {
            List<Atom> neighbours;
            if (!atom.getElement().equals("O") || atom.getCharge() != 0 || (neighbours = atom.getAtomNeighbours()).size() != 1 || atom.getBondToAtomOrThrow(neighbours.get(0)).getOrder() != 1) continue;
            this.state.fragManager.removeAtomAndAssociatedBonds(atom);
            frag.addOutAtom(neighbours.get(0), 1, (Boolean)true);
        }
    }

    private void convertHydroxyGroupsToPositiveCharge(Fragment frag) throws StructureBuildingException {
        List<Atom> atomList = frag.getAtomList();
        for (Atom atom : atomList) {
            List<Atom> neighbours;
            if (!atom.getElement().equals("O") || atom.getCharge() != 0 || (neighbours = atom.getAtomNeighbours()).size() != 1 || atom.getBondToAtomOrThrow(neighbours.get(0)).getOrder() != 1) continue;
            this.state.fragManager.removeAtomAndAssociatedBonds(atom);
            neighbours.get(0).addChargeAndProtons(1, -1);
        }
    }

    private void processSuffixPrefixes(List<Element> suffixes) throws StructureBuildingException {
        for (Element suffix : suffixes) {
            if (suffix.getAttribute("suffixPrefix") == null) continue;
            Fragment suffixPrefixFrag = this.state.fragManager.buildSMILES(suffix.getAttributeValue("suffixPrefix"), "suffix", "none");
            this.addFunctionalAtomsToHydroxyGroups(suffixPrefixFrag.getFirstAtom());
            if (suffix.getValue().endsWith("ate") || suffix.getValue().endsWith("at")) {
                this.chargeHydroxyGroups(suffixPrefixFrag.getFirstAtom());
            }
            Atom firstAtomOfPrefix = suffixPrefixFrag.getFirstAtom();
            firstAtomOfPrefix.addLocant("X");
            Fragment suffixFrag = this.state.xmlFragmentMap.get(suffix);
            this.state.fragManager.incorporateFragment(suffixPrefixFrag, suffixFrag);
            Atom theR = suffixFrag.getFirstAtom();
            List<Atom> neighbours = theR.getAtomNeighbours();
            for (Atom neighbour : neighbours) {
                Bond b = theR.getBondToAtomOrThrow(neighbour);
                this.state.fragManager.removeBond(b);
                this.state.fragManager.createBond(neighbour, firstAtomOfPrefix, b.getOrder());
            }
            this.state.fragManager.createBond(firstAtomOfPrefix, theR, 1);
        }
    }

    private boolean checkLocantPresentOnPotentialRoot(Element startingElement, String locant) throws StructureBuildingException {
        List<Element> conjunctiveGroups;
        List<Fragment> suffixes;
        Fragment groupFrag;
        Element group;
        int indexOfCurrentElement;
        List<Element> siblings;
        Element parent;
        Element currentElement;
        boolean foundSibling = false;
        Stack<Element> s = new Stack<Element>();
        s.add(startingElement);
        boolean doneFirstIteration = false;
        while (s.size() > 0) {
            currentElement = (Element)s.pop();
            parent = (Element)currentElement.getParent();
            siblings = XOMTools.getChildElementsWithTagNames(parent, new String[]{"bracket", "substituent", "root"});
            indexOfCurrentElement = parent.indexOf(currentElement);
            for (Element bracketOrSub : siblings) {
                if (!doneFirstIteration && parent.indexOf(bracketOrSub) <= indexOfCurrentElement) continue;
                if (bracketOrSub.getLocalName().equals("bracket")) {
                    if (bracketOrSub.getAttribute("type") == null) continue;
                    s.push((Element)bracketOrSub.getChild(0));
                } else {
                    group = bracketOrSub.getFirstChildElement("group");
                    groupFrag = this.state.xmlFragmentMap.get(group);
                    if (groupFrag.hasLocant(locant)) {
                        return true;
                    }
                    suffixes = this.state.xmlSuffixMap.get(group);
                    if (suffixes != null) {
                        for (Fragment suffix : suffixes) {
                            if (!suffix.hasLocant(locant)) continue;
                            return true;
                        }
                    }
                    conjunctiveGroups = XOMTools.getNextSiblingsOfType(group, "conjunctiveSuffixGroup");
                    for (Element conjunctiveGroup : conjunctiveGroups) {
                        if (!this.state.xmlFragmentMap.get(conjunctiveGroup).hasLocant(locant)) continue;
                        return true;
                    }
                }
                foundSibling = true;
            }
            doneFirstIteration = true;
        }
        if (!foundSibling) {
            s = new Stack();
            s.add(startingElement);
            doneFirstIteration = false;
            while (s.size() > 0) {
                currentElement = (Element)s.pop();
                parent = (Element)currentElement.getParent();
                siblings = XOMTools.getChildElementsWithTagNames(parent, new String[]{"bracket", "substituent", "root"});
                indexOfCurrentElement = parent.indexOf(currentElement);
                for (Element bracketOrSub : siblings) {
                    if (!doneFirstIteration && parent.indexOf(bracketOrSub) <= indexOfCurrentElement) continue;
                    if (bracketOrSub.getLocalName().equals("bracket")) {
                        s.push((Element)bracketOrSub.getChild(0));
                        continue;
                    }
                    group = bracketOrSub.getFirstChildElement("group");
                    groupFrag = this.state.xmlFragmentMap.get(group);
                    if (groupFrag.hasLocant(locant)) {
                        return true;
                    }
                    suffixes = this.state.xmlSuffixMap.get(group);
                    if (suffixes != null) {
                        for (Fragment suffix : suffixes) {
                            if (!suffix.hasLocant(locant)) continue;
                            return true;
                        }
                    }
                    conjunctiveGroups = XOMTools.getNextSiblingsOfType(group, "conjunctiveSuffixGroup");
                    for (Element conjunctiveGroup : conjunctiveGroups) {
                        if (!this.state.xmlFragmentMap.get(conjunctiveGroup).hasLocant(locant)) continue;
                        return true;
                    }
                }
                doneFirstIteration = true;
            }
        }
        return false;
    }

    private void handleGroupIrregularities(List<Element> groups) throws StructureBuildingException, ComponentGenerationException {
        for (Element group : groups) {
            Element wordRule;
            String groupValue = group.getValue();
            if (groupValue.equals("porphyrin") || groupValue.equals("porphin")) {
                List<Element> hydrogenAddingEls = XOMTools.getChildElementsWithTagName((Element)group.getParent(), "indicatedHydrogen");
                boolean implicitHydrogenExplicitlySet = false;
                for (Element hydrogenAddingEl : hydrogenAddingEls) {
                    String locant = hydrogenAddingEl.getAttributeValue("locant");
                    if (locant == null || !locant.equals("21") && !locant.equals("22") && !locant.equals("23") && !locant.equals("24")) continue;
                    implicitHydrogenExplicitlySet = true;
                }
                if (implicitHydrogenExplicitlySet) continue;
                Fragment frag = this.state.xmlFragmentMap.get(group);
                frag.getAtomByLocantOrThrow("21").setSpareValency(false);
                frag.getAtomByLocantOrThrow("23").setSpareValency(false);
                continue;
            }
            if (!groupValue.equals("xanthate") && !groupValue.equals("xanthic acid") && !groupValue.equals("xanthicacid") || !(wordRule = OpsinTools.getParentWordRule(group)).getAttributeValue("wordRule").equals(WordRule.simple.toString()) || XOMTools.getDescendantElementsWithTagName(wordRule, "substituent").size() != 0) continue;
            throw new ComponentGenerationException(groupValue + " describes a class of compounds rather than a particular compound");
        }
    }

    private void processHW(Element subOrRoot) throws StructureBuildingException, ComponentGenerationException {
        List<Element> hwGroups = XOMTools.getChildElementsWithTagNameAndAttribute(subOrRoot, "group", "subType", "hantzschWidman");
        for (Element group : hwGroups) {
            Atom a;
            Matcher m;
            String elementReplacement;
            Fragment hwRing = this.state.xmlFragmentMap.get(group);
            List<Atom> atomList = hwRing.getAtomList();
            Element prev = (Element)XOMTools.getPreviousSibling(group);
            ArrayList<Element> prevs = new ArrayList<Element>();
            boolean noLocants = true;
            while (prev != null && prev.getLocalName().equals("heteroatom")) {
                prevs.add(prev);
                if (prev.getAttribute("locant") != null) {
                    noLocants = false;
                }
                prev = (Element)XOMTools.getPreviousSibling(prev);
            }
            if (atomList.size() == 6 && group.getValue().equals("an")) {
                boolean hasNitrogen = false;
                boolean hasSiorGeorSnorPb = false;
                boolean saturatedRing = true;
                for (Element heteroatom : prevs) {
                    String heteroAtomElement = heteroatom.getAttributeValue("value");
                    Matcher m2 = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(heteroAtomElement);
                    if (!m2.find()) {
                        throw new ComponentGenerationException("Failed to extract element from HW heteroatom");
                    }
                    heteroAtomElement = m2.group();
                    if (heteroAtomElement.equals("N")) {
                        hasNitrogen = true;
                    }
                    if (!heteroAtomElement.equals("Si") && !heteroAtomElement.equals("Ge") && !heteroAtomElement.equals("Sn") && !heteroAtomElement.equals("Pb")) continue;
                    hasSiorGeorSnorPb = true;
                }
                for (Atom a2 : atomList) {
                    if (!a2.hasSpareValency()) continue;
                    saturatedRing = false;
                }
                if (saturatedRing && !hasNitrogen && hasSiorGeorSnorPb) {
                    throw new ComponentGenerationException("Blocked HW system (6 member saturated ring with no nitrogen but has Si/Ge/Sn/Pb)");
                }
            }
            StringBuilder nameSB = new StringBuilder();
            Collections.reverse(prevs);
            for (Element heteroatom : prevs) {
                nameSB.append(heteroatom.getValue());
            }
            nameSB.append(group.getValue());
            String name = nameSB.toString().toLowerCase();
            if (noLocants && prevs.size() > 0 && specialHWRings.containsKey(name)) {
                String[] specialRingInformation = specialHWRings.get(name);
                String specialInstruction = specialRingInformation[0];
                if (!specialInstruction.equals("")) {
                    Element nextEl;
                    if (specialInstruction.equals("blocked")) {
                        throw new ComponentGenerationException("Blocked HW system");
                    }
                    if (specialInstruction.equals("saturated")) {
                        for (Atom a3 : hwRing.getAtomList()) {
                            a3.setSpareValency(false);
                        }
                    } else if (specialInstruction.equals("not_icacid")) {
                        if (group.getAttribute("subsequentUnsemanticToken") == null && (nextEl = (Element)XOMTools.getNextSibling(group)) != null && nextEl.getLocalName().equals("suffix") && nextEl.getAttribute("locant") == null && nextEl.getAttributeValue("value").equals("ic")) {
                            throw new ComponentGenerationException(name + nextEl.getValue() + " appears to be a generic class name, not a HW ring");
                        }
                    } else if (specialInstruction.equals("not_nothingOrOlate")) {
                        if (group.getAttribute("subsequentUnsemanticToken") == null && ((nextEl = (Element)XOMTools.getNextSibling(group)) == null || nextEl != null && nextEl.getLocalName().equals("suffix") && nextEl.getAttribute("locant") == null && nextEl.getAttributeValue("value").equals("ate"))) {
                            throw new ComponentGenerationException(name + " has the syntax for a HW ring but probably does not mean that in this context");
                        }
                    } else {
                        throw new ComponentGenerationException("OPSIN Bug: Unrecognised special HW ring instruction");
                    }
                }
                for (int j = 1; j < specialRingInformation.length; ++j) {
                    Atom a3;
                    a3 = hwRing.getAtomByLocantOrThrow(Integer.toString(j));
                    a3.setElement(specialRingInformation[j]);
                }
                for (Element p : prevs) {
                    p.detach();
                }
                prevs.clear();
            }
            HashSet<Element> elementsToRemove = new HashSet<Element>();
            for (Element heteroatom : prevs) {
                if (heteroatom.getAttribute("locant") == null) continue;
                String locant = heteroatom.getAttributeValue("locant");
                elementReplacement = heteroatom.getAttributeValue("value");
                m = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(elementReplacement);
                if (!m.find()) {
                    throw new ComponentGenerationException("Failed to extract element from HW heteroatom");
                }
                elementReplacement = m.group();
                a = hwRing.getAtomByLocantOrThrow(locant);
                a.setElement(elementReplacement);
                if (heteroatom.getAttribute("lambda") != null) {
                    a.setLambdaConventionValency(Integer.parseInt(heteroatom.getAttributeValue("lambda")));
                }
                heteroatom.detach();
                elementsToRemove.add(heteroatom);
            }
            for (Element p : elementsToRemove) {
                prevs.remove(p);
            }
            int defaultLocant = 1;
            for (Element heteroatom : prevs) {
                elementReplacement = heteroatom.getAttributeValue("value");
                m = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(elementReplacement);
                if (!m.find()) {
                    throw new ComponentGenerationException("Failed to extract element from HW heteroatom");
                }
                elementReplacement = m.group();
                while (!hwRing.getAtomByLocantOrThrow(Integer.toString(defaultLocant)).getElement().equals("C")) {
                    ++defaultLocant;
                }
                a = hwRing.getAtomByLocantOrThrow(Integer.toString(defaultLocant));
                a.setElement(elementReplacement);
                if (heteroatom.getAttribute("lambda") != null) {
                    a.setLambdaConventionValency(Integer.parseInt(heteroatom.getAttributeValue("lambda")));
                }
                heteroatom.detach();
            }
            Elements deltas = subOrRoot.getChildElements("delta");
            for (int j = 0; j < deltas.size(); ++j) {
                String locantOfDoubleBond = deltas.get(j).getValue();
                if (locantOfDoubleBond.equals("")) {
                    Element newUnsaturator = new Element("unsaturator");
                    newUnsaturator.addAttribute(new Attribute("value", "2"));
                    XOMTools.insertAfter(group, newUnsaturator);
                } else {
                    Atom firstInDoubleBond = hwRing.getAtomByLocantOrThrow(locantOfDoubleBond);
                    Atom secondInDoubleBond = hwRing.getAtomByIDOrThrow(firstInDoubleBond.getID() + 1);
                    Bond b = firstInDoubleBond.getBondToAtomOrThrow(secondInDoubleBond);
                    b.setOrder(2);
                }
                deltas.get(j).detach();
            }
            XOMTools.setTextChild(group, name);
        }
    }

    private void assignElementSymbolLocants(Element subOrRoot) throws StructureBuildingException {
        List<Element> groups = XOMTools.getChildElementsWithTagName(subOrRoot, "group");
        Element lastGroupElementInSubOrRoot = groups.get(groups.size() - 1);
        ArrayList<Fragment> suffixFragments = new ArrayList<Fragment>((Collection)this.state.xmlSuffixMap.get(lastGroupElementInSubOrRoot));
        Fragment suffixableFragment = this.state.xmlFragmentMap.get(lastGroupElementInSubOrRoot);
        List<Element> conjunctiveGroups = XOMTools.getChildElementsWithTagName(subOrRoot, "conjunctiveSuffixGroup");
        for (Element group : conjunctiveGroups) {
            suffixFragments.add(this.state.xmlFragmentMap.get(group));
        }
        FragmentTools.assignElementLocants(suffixableFragment, suffixFragments);
        for (int i = groups.size() - 2; i >= 0; --i) {
            FragmentTools.assignElementLocants(this.state.xmlFragmentMap.get(groups.get(i)), new ArrayList<Fragment>());
        }
    }

    private void processRingAssemblies(Element subOrRoot) throws ComponentGenerationException, StructureBuildingException {
        List<Element> ringAssemblyMultipliers = XOMTools.getChildElementsWithTagName(subOrRoot, "ringAssemblyMultiplier");
        for (Element multiplier : ringAssemblyMultipliers) {
            int j;
            Element elementToResolve;
            int mvalue = Integer.parseInt(multiplier.getAttributeValue("value"));
            ArrayList<List<Object>> ringJoiningLocants = new ArrayList<List<Object>>();
            Element potentialLocant = (Element)XOMTools.getPreviousSibling(multiplier);
            Element group = (Element)XOMTools.getNextSibling(multiplier, "group");
            if (potentialLocant != null && (potentialLocant.getLocalName().equals("colonSeperatedLocant") || potentialLocant.getLocalName().equals("locant"))) {
                if ("orthoMetaPara".equals(potentialLocant.getAttributeValue("type"))) {
                    String locant2 = potentialLocant.getValue();
                    String locant1 = "1";
                    ArrayList<String> locantArrayList = new ArrayList<String>();
                    locantArrayList.add("1");
                    locantArrayList.add("1'");
                    ringJoiningLocants.add(locantArrayList);
                    for (int j2 = 1; j2 < mvalue - 1; ++j2) {
                        locantArrayList = new ArrayList();
                        locantArrayList.add(locant2 + StringTools.multiplyString("'", j2));
                        locantArrayList.add(locant1 + StringTools.multiplyString("'", j2 + 1));
                        ringJoiningLocants.add(locantArrayList);
                    }
                    potentialLocant.detach();
                } else {
                    String locantText = StringTools.removeDashIfPresent(potentialLocant.getValue());
                    String[] perRingLocantArray = OpsinTools.MATCH_COLON.split(locantText);
                    if (perRingLocantArray.length != mvalue - 1) {
                        throw new ComponentGenerationException("Disagreement between number of locants(" + locantText + ") and ring assembly multiplier: " + mvalue);
                    }
                    if (perRingLocantArray.length != 1 || OpsinTools.MATCH_COMMA.split(perRingLocantArray[0]).length != 1) {
                        for (int j3 = 0; j3 < perRingLocantArray.length; ++j3) {
                            String[] locantArray = OpsinTools.MATCH_COMMA.split(perRingLocantArray[j3]);
                            if (locantArray.length != 2) {
                                throw new ComponentGenerationException("missing locant, expected 2 locants: " + perRingLocantArray[j3]);
                            }
                            ringJoiningLocants.add(Arrays.asList(locantArray));
                        }
                        potentialLocant.detach();
                    }
                }
            }
            Fragment fragmentToResolveAndDuplicate = this.state.xmlFragmentMap.get(group);
            Element nextEl = (Element)XOMTools.getNextSibling(multiplier);
            if (nextEl.getLocalName().equals("structuralOpenBracket")) {
                elementToResolve = new Element("substituent");
                Element currentEl = nextEl;
                nextEl = (Element)XOMTools.getNextSibling(currentEl);
                currentEl.detach();
                while (nextEl != null && !nextEl.getLocalName().equals("structuralCloseBracket")) {
                    currentEl = nextEl;
                    nextEl = (Element)XOMTools.getNextSibling(currentEl);
                    currentEl.detach();
                    elementToResolve.appendChild(currentEl);
                }
                if (nextEl != null) {
                    nextEl.detach();
                }
            } else {
                elementToResolve = this.determineElementsToResolveIntoRingAssembly(multiplier, ringJoiningLocants.size(), fragmentToResolveAndDuplicate.getOutAtoms().size());
            }
            List<Element> suffixes = XOMTools.getChildElementsWithTagName(elementToResolve, "suffix");
            this.resolveSuffixes(group, suffixes);
            StructureBuildingMethods.resolveLocantedFeatures(this.state, elementToResolve);
            StructureBuildingMethods.resolveUnLocantedFeatures(this.state, elementToResolve);
            group.detach();
            XOMTools.insertAfter(multiplier, group);
            int bondOrder = 1;
            if (fragmentToResolveAndDuplicate.getOutAtoms().size() > 0) {
                bondOrder = fragmentToResolveAndDuplicate.getOutAtom(0).getValency();
            }
            if (fragmentToResolveAndDuplicate.getOutAtoms().size() > 1) {
                throw new StructureBuildingException("Ring assembly fragment should have one or no OutAtoms; not more than one!");
            }
            ArrayList<Fragment> clonedFragments = new ArrayList<Fragment>();
            for (j = 1; j < mvalue; ++j) {
                clonedFragments.add(this.state.fragManager.copyAndRelabelFragment(fragmentToResolveAndDuplicate, j));
            }
            for (j = 0; j < mvalue - 1; ++j) {
                Atom atomOnLatestClone;
                Atom atomOnParent;
                Fragment clone2 = (Fragment)clonedFragments.get(j);
                if (ringJoiningLocants.size() > 0) {
                    atomOnParent = fragmentToResolveAndDuplicate.getAtomByLocantOrThrow((String)((List)ringJoiningLocants.get(j)).get(0));
                    atomOnLatestClone = clone2.getAtomByLocantOrThrow((String)((List)ringJoiningLocants.get(j)).get(1));
                } else if (fragmentToResolveAndDuplicate.getOutAtoms().size() > 0 && mvalue == 2) {
                    atomOnParent = fragmentToResolveAndDuplicate.getOutAtom(0).getAtom();
                    atomOnLatestClone = clone2.getOutAtom(0).getAtom();
                } else {
                    atomOnParent = fragmentToResolveAndDuplicate.getAtomOrNextSuitableAtomOrThrow(fragmentToResolveAndDuplicate.getDefaultInAtom(), bondOrder, true);
                    atomOnLatestClone = clone2.getAtomOrNextSuitableAtomOrThrow(clone2.getDefaultInAtom(), bondOrder, true);
                }
                if (fragmentToResolveAndDuplicate.getOutAtoms().size() > 0) {
                    fragmentToResolveAndDuplicate.removeOutAtom(0);
                }
                if (clone2.getOutAtoms().size() > 0) {
                    clone2.removeOutAtom(0);
                }
                this.state.fragManager.incorporateFragment(clone2, atomOnLatestClone, fragmentToResolveAndDuplicate, atomOnParent, bondOrder);
                fragmentToResolveAndDuplicate.setDefaultInAtom(clone2.getDefaultInAtom());
            }
            XOMTools.setTextChild(group, multiplier.getValue() + group.getValue());
            Element possibleOpenStructuralBracket = (Element)XOMTools.getPreviousSibling(multiplier);
            if (possibleOpenStructuralBracket != null && possibleOpenStructuralBracket.getLocalName().equals("structuralOpenBracket")) {
                XOMTools.getNextSibling(possibleOpenStructuralBracket, "structuralCloseBracket").detach();
                possibleOpenStructuralBracket.detach();
            }
            multiplier.detach();
        }
    }

    private Element determineElementsToResolveIntoRingAssembly(Element multiplier, int ringJoiningLocants, int outAtomCount) throws ComponentGenerationException {
        Element parent;
        Element elementToResolve = new Element("substituent");
        boolean groupFound = false;
        boolean inlineSuffixSeen = outAtomCount > 0;
        Element currentEl = (Element)XOMTools.getNextSibling(multiplier);
        while (currentEl != null) {
            Element nextEl = (Element)XOMTools.getNextSibling(currentEl);
            if (!groupFound || currentEl.getLocalName().equals("suffix") && currentEl.getAttributeValue("type").equals("charge") || currentEl.getLocalName().equals("unsaturator")) {
                currentEl.detach();
                elementToResolve.appendChild(currentEl);
            } else {
                if (!currentEl.getLocalName().equals("suffix")) break;
                this.state.xmlFragmentMap.get(currentEl);
                if (inlineSuffixSeen || !currentEl.getAttributeValue("type").equals("inline") || currentEl.getAttributeValue("multiplied") != null || currentEl.getAttribute("locant") != null && (!"2".equals(multiplier.getAttributeValue("value")) || ringJoiningLocants != 0) || this.state.xmlFragmentMap.get(currentEl) != null) break;
                inlineSuffixSeen = true;
                currentEl.detach();
                elementToResolve.appendChild(currentEl);
            }
            if (currentEl.getLocalName().equals("group")) {
                groupFound = true;
            }
            currentEl = nextEl;
        }
        if (!(parent = (Element)multiplier.getParent()).getLocalName().equals("substituent") && XOMTools.getChildElementsWithTagNameAndAttribute(parent, "suffix", "type", "inline").size() != 0) {
            throw new ComponentGenerationException("Unexpected radical adding suffix on ring assembly");
        }
        return elementToResolve;
    }

    private void processPolyCyclicSpiroNomenclature(Element subOrRoot) throws ComponentGenerationException, StructureBuildingException {
        List<Element> polyCyclicSpiros = XOMTools.getChildElementsWithTagName(subOrRoot, "polyCyclicSpiro");
        if (polyCyclicSpiros.size() > 0) {
            Element polyCyclicSpiroDescriptor = polyCyclicSpiros.get(0);
            String value2 = polyCyclicSpiroDescriptor.getAttributeValue("value");
            if (value2.equals("spiro")) {
                if (polyCyclicSpiros.size() != 1) {
                    throw new ComponentGenerationException("Nested polyspiro systems are not supported");
                }
                this.processNonIdenticalPolyCyclicSpiro(polyCyclicSpiroDescriptor);
            } else if (value2.equals("spiroOldMethod")) {
                this.processOldMethodPolyCyclicSpiro(polyCyclicSpiros);
            } else if (value2.equals("spirobi")) {
                if (polyCyclicSpiros.size() != 1) {
                    throw new ComponentGenerationException("Nested polyspiro systems are not supported");
                }
                this.processSpiroBiOrTer(polyCyclicSpiroDescriptor, 2);
            } else if (value2.equals("spiroter")) {
                if (polyCyclicSpiros.size() != 1) {
                    throw new ComponentGenerationException("Nested polyspiro systems are not supported");
                }
                this.processSpiroBiOrTer(polyCyclicSpiroDescriptor, 3);
            } else if (value2.equals("dispiroter")) {
                if (polyCyclicSpiros.size() != 1) {
                    throw new ComponentGenerationException("Nested polyspiro systems are not supported");
                }
                this.processDispiroter(polyCyclicSpiroDescriptor);
            } else {
                throw new ComponentGenerationException("Unsupported spiro system encountered");
            }
            polyCyclicSpiroDescriptor.detach();
        }
    }

    private void processNonIdenticalPolyCyclicSpiro(Element polyCyclicSpiroDescriptor) throws ComponentGenerationException, StructureBuildingException {
        Element expectedMultiplier;
        Element subOrRoot = (Element)polyCyclicSpiroDescriptor.getParent();
        List<Element> groups = XOMTools.getChildElementsWithTagName(subOrRoot, "group");
        if (groups.size() < 2) {
            throw new ComponentGenerationException("OPSIN Bug: Atleast two groups were expected in polycyclic spiro system");
        }
        Element openBracket = (Element)XOMTools.getNextSibling(polyCyclicSpiroDescriptor);
        if (!openBracket.getLocalName().equals("structuralOpenBracket")) {
            throw new ComponentGenerationException("OPSIN Bug: Open bracket not found where open bracket expeced");
        }
        List<Element> spiroBracketElements = XOMTools.getSiblingsUpToElementWithTagName(openBracket, "structuralCloseBracket");
        Element closeBracket = (Element)XOMTools.getNextSibling(spiroBracketElements.get(spiroBracketElements.size() - 1));
        if (closeBracket == null || !closeBracket.getLocalName().equals("structuralCloseBracket")) {
            throw new ComponentGenerationException("OPSIN Bug: Open bracket not found where open bracket expeced");
        }
        Element firstGroup = groups.get(0);
        ArrayList<Element> firstGroupEls = new ArrayList<Element>();
        int indexOfOpenBracket = subOrRoot.indexOf(openBracket);
        int indexOfFirstGroup = subOrRoot.indexOf(firstGroup);
        for (int i = indexOfOpenBracket + 1; i < indexOfFirstGroup; ++i) {
            firstGroupEls.add((Element)subOrRoot.getChild(i));
        }
        firstGroupEls.add(firstGroup);
        firstGroupEls.addAll(XOMTools.getNextAdjacentSiblingsOfType(firstGroup, "unsaturator"));
        this.resolveFeaturesOntoGroup(firstGroupEls);
        HashSet<Atom> spiroAtoms = new HashSet<Atom>();
        for (int i = 1; i < groups.size(); ++i) {
            Element nextGroup = groups.get(i);
            Element locant = (Element)XOMTools.getNextSibling(groups.get(i - 1), "spiroLocant");
            if (locant == null) {
                throw new ComponentGenerationException("Unable to find locantEl for polycyclic spiro system");
            }
            ArrayList<Element> nextGroupEls = new ArrayList<Element>();
            int indexOfLocant = subOrRoot.indexOf(locant);
            int indexOfNextGroup = subOrRoot.indexOf(nextGroup);
            for (int j = indexOfLocant + 1; j < indexOfNextGroup; ++j) {
                nextGroupEls.add((Element)subOrRoot.getChild(j));
            }
            nextGroupEls.add(nextGroup);
            nextGroupEls.addAll(XOMTools.getNextAdjacentSiblingsOfType(nextGroup, "unsaturator"));
            this.resolveFeaturesOntoGroup(nextGroupEls);
            String[] locants = OpsinTools.MATCH_COMMA.split(StringTools.removeDashIfPresent(locant.getValue()));
            if (locants.length != 2) {
                throw new ComponentGenerationException("Incorrect number of locants found before component of polycyclic spiro system");
            }
            for (int j = 0; j < locants.length; ++j) {
                String locantText = locants[j];
                Matcher m = matchAddedHydrogenBracket.matcher(locantText);
                if (!m.find()) continue;
                Element addedHydrogenElement = new Element("addedHydrogen");
                addedHydrogenElement.addAttribute(new Attribute("locant", m.group(1)));
                XOMTools.insertBefore(locant, addedHydrogenElement);
                locant.addAttribute(new Attribute("type", "addedHydrogenLocant"));
                locants[j] = m.replaceAll("");
            }
            locant.detach();
            Fragment nextFragment = this.state.xmlFragmentMap.get(nextGroup);
            FragmentTools.relabelNumericLocants(nextFragment.getAtomList(), StringTools.multiplyString("'", i));
            Atom atomToBeReplaced = nextFragment.getAtomByLocantOrThrow(locants[1]);
            Atom atomOnParentFrag = null;
            for (int j = 0; j < i && (atomOnParentFrag = this.state.xmlFragmentMap.get(groups.get(j)).getAtomByLocant(locants[0])) == null; ++j) {
            }
            if (atomOnParentFrag == null) {
                throw new ComponentGenerationException("Could not find the atom with locant " + locants[0] + " for use in polycyclic spiro system");
            }
            spiroAtoms.add(atomOnParentFrag);
            this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToBeReplaced, atomOnParentFrag);
            if (!atomToBeReplaced.hasSpareValency()) continue;
            atomOnParentFrag.setSpareValency(true);
        }
        if (spiroAtoms.size() > 1 && (expectedMultiplier = (Element)XOMTools.getPreviousSibling(polyCyclicSpiroDescriptor)) != null && expectedMultiplier.getLocalName().equals("multiplier") && Integer.parseInt(expectedMultiplier.getAttributeValue("value")) == spiroAtoms.size()) {
            expectedMultiplier.detach();
        }
        Element rootGroup = groups.get(groups.size() - 1);
        Fragment rootFrag = this.state.xmlFragmentMap.get(rootGroup);
        String name = rootGroup.getValue();
        for (int i = 0; i < groups.size() - 1; ++i) {
            Element group = groups.get(i);
            this.state.fragManager.incorporateFragment(this.state.xmlFragmentMap.get(group), rootFrag);
            name = group.getValue() + name;
            group.detach();
        }
        XOMTools.setTextChild(rootGroup, polyCyclicSpiroDescriptor.getValue() + name);
        openBracket.detach();
        closeBracket.detach();
    }

    private void processOldMethodPolyCyclicSpiro(List<Element> spiroElements) throws ComponentGenerationException, StructureBuildingException {
        Element firstSpiro = spiroElements.get(0);
        Element subOrRoot = (Element)firstSpiro.getParent();
        Element firstEl = (Element)subOrRoot.getChild(0);
        List<Element> elementsToResolve = XOMTools.getSiblingsUpToElementWithTagName(firstEl, "polyCyclicSpiro");
        elementsToResolve.add(0, firstEl);
        this.resolveFeaturesOntoGroup(elementsToResolve);
        for (int i = 0; i < spiroElements.size(); ++i) {
            Element currentSpiro = spiroElements.get(i);
            Element previousGroup = (Element)XOMTools.getPreviousSibling(currentSpiro, "group");
            if (previousGroup == null) {
                throw new ComponentGenerationException("OPSIN bug: unable to locate group before polycylic spiro descriptor");
            }
            Element nextGroup = (Element)XOMTools.getNextSibling(currentSpiro, "group");
            if (nextGroup == null) {
                throw new ComponentGenerationException("OPSIN bug: unable to locate group after polycylic spiro descriptor");
            }
            Fragment parentFrag = this.state.xmlFragmentMap.get(nextGroup);
            Fragment previousFrag = this.state.xmlFragmentMap.get(previousGroup);
            FragmentTools.relabelNumericLocants(parentFrag.getAtomList(), StringTools.multiplyString("'", i + 1));
            elementsToResolve = XOMTools.getSiblingsUpToElementWithTagName(currentSpiro, "polyCyclicSpiro");
            this.resolveFeaturesOntoGroup(elementsToResolve);
            String locant1 = null;
            Element possibleFirstLocant = (Element)XOMTools.getPreviousSibling(currentSpiro);
            if (possibleFirstLocant != null && possibleFirstLocant.getLocalName().equals("locant")) {
                if (OpsinTools.MATCH_COMMA.split(possibleFirstLocant.getValue()).length == 1) {
                    locant1 = possibleFirstLocant.getValue();
                    possibleFirstLocant.detach();
                } else {
                    throw new ComponentGenerationException("Malformed locant before polycyclic spiro descriptor");
                }
            }
            Atom atomToBeReplaced = locant1 != null ? previousFrag.getAtomByLocantOrThrow(locant1) : previousFrag.getAtomOrNextSuitableAtomOrThrow(previousFrag.getFirstAtom(), 2, true);
            String locant2 = null;
            Element possibleSecondLocant = (Element)XOMTools.getNextSibling(currentSpiro);
            if (possibleSecondLocant != null && possibleSecondLocant.getLocalName().equals("locant")) {
                if (OpsinTools.MATCH_COMMA.split(possibleSecondLocant.getValue()).length == 1) {
                    locant2 = possibleSecondLocant.getValue();
                    possibleSecondLocant.detach();
                } else {
                    throw new ComponentGenerationException("Malformed locant after polycyclic spiro descriptor");
                }
            }
            Atom atomOnParentFrag = locant2 != null ? parentFrag.getAtomByLocantOrThrow(locant2) : parentFrag.getAtomOrNextSuitableAtomOrThrow(parentFrag.getFirstAtom(), 2, true);
            this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToBeReplaced, atomOnParentFrag);
            if (atomToBeReplaced.hasSpareValency()) {
                atomOnParentFrag.setSpareValency(true);
            }
            if (atomToBeReplaced.getCharge() != 0 && atomOnParentFrag.getCharge() == 0) {
                atomOnParentFrag.setCharge(atomToBeReplaced.getCharge());
                atomOnParentFrag.setProtonsExplicitlyAddedOrRemoved(atomToBeReplaced.getProtonsExplicitlyAddedOrRemoved());
            }
            this.state.fragManager.incorporateFragment(previousFrag, parentFrag);
            XOMTools.setTextChild(nextGroup, previousGroup.getValue() + currentSpiro.getValue() + nextGroup.getValue());
            previousGroup.detach();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSpiroBiOrTer(Element polyCyclicSpiroDescriptor, int components) throws ComponentGenerationException, StructureBuildingException {
        String locantText;
        Element locant = (Element)XOMTools.getPreviousSibling(polyCyclicSpiroDescriptor);
        if (locant == null || !locant.getLocalName().equals("locant")) {
            if (components != 2) throw new ComponentGenerationException("Unable to find locant indicating atoms to form polycyclic spiro system!");
            locantText = "1,1'";
        } else {
            locantText = locant.getValue();
            locant.detach();
        }
        String[] locants = OpsinTools.MATCH_COMMA.split(locantText);
        if (locants.length != components) {
            throw new ComponentGenerationException("Mismatch between spiro descriptor and number of locants provided");
        }
        Element group = (Element)XOMTools.getNextSibling(polyCyclicSpiroDescriptor, "group");
        if (group == null) {
            throw new ComponentGenerationException("Cannot find group to which spirobi/ter descriptor applies");
        }
        this.determineFeaturesToResolveInSingleComponentSpiro(polyCyclicSpiroDescriptor);
        Fragment fragment = this.state.xmlFragmentMap.get(group);
        ArrayList<Fragment> clones = new ArrayList<Fragment>();
        for (int i = 1; i < components; ++i) {
            clones.add(this.state.fragManager.copyAndRelabelFragment(fragment, i));
        }
        for (Fragment clone2 : clones) {
            this.state.fragManager.incorporateFragment(clone2, fragment);
        }
        Atom atomOnOriginalFragment = fragment.getAtomByLocantOrThrow(locants[0]);
        for (int i = 1; i < components; ++i) {
            Atom atomToBeReplaced = fragment.getAtomByLocantOrThrow(locants[i]);
            this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToBeReplaced, atomOnOriginalFragment);
            if (!atomToBeReplaced.hasSpareValency()) continue;
            atomOnOriginalFragment.setSpareValency(true);
        }
        XOMTools.setTextChild(group, polyCyclicSpiroDescriptor.getValue() + group.getValue());
    }

    private void processDispiroter(Element polyCyclicSpiroDescriptor) throws StructureBuildingException, ComponentGenerationException {
        String value2 = polyCyclicSpiroDescriptor.getValue();
        value2 = value2.substring(0, value2.length() - 10);
        value2 = StringTools.removeDashIfPresent(value2);
        String[] locants = OpsinTools.MATCH_COLON.split(value2);
        Element group = (Element)XOMTools.getNextSibling(polyCyclicSpiroDescriptor, "group");
        if (group == null) {
            throw new ComponentGenerationException("Cannot find group to which dispiroter descriptor applies");
        }
        this.determineFeaturesToResolveInSingleComponentSpiro(polyCyclicSpiroDescriptor);
        Fragment fragment = this.state.xmlFragmentMap.get(group);
        ArrayList<Fragment> clones = new ArrayList<Fragment>();
        for (int i = 1; i < 3; ++i) {
            clones.add(this.state.fragManager.copyAndRelabelFragment(fragment, i));
        }
        for (Fragment clone2 : clones) {
            this.state.fragManager.incorporateFragment(clone2, fragment);
        }
        Atom atomOnLessPrimedFragment = fragment.getAtomByLocantOrThrow(OpsinTools.MATCH_COMMA.split(locants[0])[0]);
        Atom atomToBeReplaced = fragment.getAtomByLocantOrThrow(OpsinTools.MATCH_COMMA.split(locants[0])[1]);
        this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToBeReplaced, atomOnLessPrimedFragment);
        if (atomToBeReplaced.hasSpareValency()) {
            atomOnLessPrimedFragment.setSpareValency(true);
        }
        atomOnLessPrimedFragment = fragment.getAtomByLocantOrThrow(OpsinTools.MATCH_COMMA.split(locants[1])[0]);
        atomToBeReplaced = fragment.getAtomByLocantOrThrow(OpsinTools.MATCH_COMMA.split(locants[1])[1]);
        this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToBeReplaced, atomOnLessPrimedFragment);
        if (atomToBeReplaced.hasSpareValency()) {
            atomOnLessPrimedFragment.setSpareValency(true);
        }
        XOMTools.setTextChild(group, "dispiroter" + group.getValue());
    }

    private void determineFeaturesToResolveInSingleComponentSpiro(Element polyCyclicSpiroDescriptor) throws StructureBuildingException, ComponentGenerationException {
        List<Element> elementsToResolve;
        Element possibleOpenBracket = (Element)XOMTools.getNextSibling(polyCyclicSpiroDescriptor);
        if (possibleOpenBracket.getLocalName().equals("structuralOpenBracket")) {
            possibleOpenBracket.detach();
            elementsToResolve = XOMTools.getSiblingsUpToElementWithTagName(polyCyclicSpiroDescriptor, "structuralCloseBracket");
            XOMTools.getNextSibling(elementsToResolve.get(elementsToResolve.size() - 1)).detach();
        } else {
            elementsToResolve = XOMTools.getSiblingsUpToElementWithTagName(polyCyclicSpiroDescriptor, "group");
        }
        this.resolveFeaturesOntoGroup(elementsToResolve);
    }

    private void resolveFeaturesOntoGroup(List<Element> elementsToResolve) throws StructureBuildingException, ComponentGenerationException {
        if (elementsToResolve.size() == 0) {
            return;
        }
        Element substituentToResolve = new Element("substituent");
        Element parent = (Element)elementsToResolve.get(0).getParent();
        int index = parent.indexOf(elementsToResolve.get(0));
        Element group = null;
        ArrayList<Element> suffixes = new ArrayList<Element>();
        Element locant = null;
        for (Element element : elementsToResolve) {
            String elName = element.getLocalName();
            if (elName.equals("group")) {
                group = element;
            } else if (elName.equals("suffix")) {
                suffixes.add(element);
            } else if (elName.equals("locant") && group == null) {
                locant = element;
            }
            element.detach();
            substituentToResolve.appendChild(element);
        }
        if (group == null) {
            throw new ComponentGenerationException("OPSIN bug: group element should of been given to method");
        }
        if (locant != null) {
            List<Element> locantAble = this.findElementsMissingIndirectLocants(substituentToResolve, locant);
            String[] locantValues = OpsinTools.MATCH_COMMA.split(locant.getValue());
            if (locantAble.size() >= locantValues.length) {
                for (int i = 0; i < locantValues.length; ++i) {
                    String locantValue = locantValues[i];
                    locantAble.get(i).addAttribute(new Attribute("locant", locantValue));
                }
                locant.detach();
            }
        }
        if (!suffixes.isEmpty()) {
            this.resolveSuffixes(group, suffixes);
            for (Element suffix : suffixes) {
                suffix.detach();
            }
        }
        if (substituentToResolve.getChildElements().size() != 0) {
            StructureBuildingMethods.resolveLocantedFeatures(this.state, substituentToResolve);
            StructureBuildingMethods.resolveUnLocantedFeatures(this.state, substituentToResolve);
            Elements children2 = substituentToResolve.getChildElements();
            for (int i = children2.size() - 1; i >= 0; --i) {
                Element child = children2.get(i);
                child.detach();
                parent.insertChild(child, index);
            }
        }
    }

    private void processFusedRingBridges(Element subOrRoot) throws StructureBuildingException {
        List<Element> bridges = XOMTools.getChildElementsWithTagName(subOrRoot, "fusedRingBridge");
        for (Element bridge2 : bridges) {
            Fragment ringFrag = this.state.xmlFragmentMap.get(XOMTools.getNextSibling(bridge2, "group"));
            Fragment bridgeFrag = this.state.fragManager.buildSMILES(bridge2.getAttributeValue("value"), ringFrag.getType(), ringFrag.getSubType(), "none");
            List<Atom> bridgeAtomList = bridgeFrag.getAtomList();
            bridgeFrag.addOutAtom(bridgeAtomList.get(0), 1, (Boolean)true);
            bridgeFrag.addOutAtom(bridgeAtomList.get(bridgeAtomList.size() - 1), 1, (Boolean)true);
            Element possibleLocant = (Element)XOMTools.getPreviousSibling(bridge2);
            if (possibleLocant != null && possibleLocant.getLocalName().equals("locant")) {
                String[] locantArray = OpsinTools.MATCH_COMMA.split(possibleLocant.getValue());
                if (locantArray.length == 2) {
                    bridgeFrag.getOutAtom(0).setLocant(locantArray[0]);
                    bridgeFrag.getOutAtom(1).setLocant(locantArray[1]);
                    possibleLocant.detach();
                }
                StructureBuildingMethods.formEpoxide(this.state, bridgeFrag, ringFrag.getDefaultInAtom());
            } else {
                StructureBuildingMethods.formEpoxide(this.state, bridgeFrag, ringFrag.getAtomOrNextSuitableAtomOrThrow(ringFrag.getDefaultInAtom(), 1, true));
            }
            this.state.fragManager.incorporateFragment(bridgeFrag, ringFrag);
            bridge2.detach();
        }
    }

    private void applyLambdaConvention(Element subOrRoot) throws StructureBuildingException {
        List<Element> lambdaConventionEls = XOMTools.getChildElementsWithTagName(subOrRoot, "lambdaConvention");
        for (Element lambdaConventionEl : lambdaConventionEls) {
            Fragment frag = this.state.xmlFragmentMap.get(subOrRoot.getFirstChildElement("group"));
            if (lambdaConventionEl.getAttribute("locant") != null) {
                frag.getAtomByLocantOrThrow(lambdaConventionEl.getAttributeValue("locant")).setLambdaConventionValency(Integer.parseInt(lambdaConventionEl.getAttributeValue("lambda")));
            } else {
                if (frag.getAtomList().size() != 1) {
                    throw new StructureBuildingException("Ambiguous use of lambda convention. Fragment has more than 1 atom but no locant was specified for the lambda");
                }
                frag.getFirstAtom().setLambdaConventionValency(Integer.parseInt(lambdaConventionEl.getAttributeValue("lambda")));
            }
            lambdaConventionEl.detach();
        }
    }

    private void handleMultiRadicals(Element subOrRoot) throws ComponentGenerationException, StructureBuildingException {
        int totalOutAtoms;
        String[] locantValues;
        Element possibleLocant;
        int outAtomCount;
        Element beforeGroup;
        Element group = subOrRoot.getFirstChildElement("group");
        String groupValue = group.getValue();
        Fragment thisFrag = this.state.xmlFragmentMap.get(group);
        if ((groupValue.equals("methylene") || groupValue.equals("oxy") || matchChalcogenReplacement.matcher(groupValue).matches()) && (beforeGroup = (Element)XOMTools.getPreviousSibling(group)) != null && beforeGroup.getLocalName().equals("multiplier") && beforeGroup.getAttributeValue("type").equals("basic") && XOMTools.getPreviousSibling(beforeGroup) == null) {
            int multiplierVal = Integer.parseInt(beforeGroup.getAttributeValue("value"));
            if (!this.unsuitableForFormingChainMultiradical(group, beforeGroup)) {
                if (groupValue.equals("methylene")) {
                    group.getAttribute("value").setValue(StringTools.multiplyString("C", multiplierVal));
                } else if (groupValue.equals("oxy")) {
                    group.getAttribute("value").setValue(StringTools.multiplyString("O", multiplierVal));
                } else if (groupValue.equals("thio")) {
                    group.getAttribute("value").setValue(StringTools.multiplyString("S", multiplierVal));
                } else if (groupValue.equals("seleno")) {
                    group.getAttribute("value").setValue(StringTools.multiplyString("[SeH?]", multiplierVal));
                } else if (groupValue.equals("telluro")) {
                    group.getAttribute("value").setValue(StringTools.multiplyString("[TeH?]", multiplierVal));
                } else {
                    throw new ComponentGenerationException("unexpected group value");
                }
                group.getAttribute("outIDs").setValue("1," + Integer.parseInt(beforeGroup.getAttributeValue("value")));
                XOMTools.setTextChild(group, beforeGroup.getValue() + groupValue);
                beforeGroup.detach();
                if (group.getAttribute("labels") != null) {
                    group.getAttribute("labels").setValue("numeric");
                } else {
                    group.addAttribute(new Attribute("labels", "numeric"));
                }
                this.state.fragManager.removeFragment(thisFrag);
                thisFrag = ComponentProcessor.resolveGroup(this.state, group);
                this.state.xmlFragmentMap.put(group, thisFrag);
                group.removeAttribute(group.getAttribute("usableAsAJoiner"));
            }
        }
        if (group.getAttribute("outIDs") != null) {
            String[] radicalPositions = OpsinTools.MATCH_COMMA.split(group.getAttributeValue("outIDs"));
            int firstIdInFrag = thisFrag.getIdOfFirstAtom();
            for (String radicalID : radicalPositions) {
                thisFrag.addOutAtom(firstIdInFrag + Integer.parseInt(radicalID) - 1, 1, (Boolean)true);
            }
        }
        if ((outAtomCount = thisFrag.getOutAtoms().size()) >= 2) {
            if (groupValue.equals("amine")) {
                Element previousGroup = (Element)OpsinTools.getPreviousGroup(group);
                Element nextGroup = (Element)OpsinTools.getNextGroup(group);
                if (previousGroup == null || this.state.xmlFragmentMap.get(previousGroup).getOutAtoms().size() < 2 || nextGroup == null) {
                    throw new ComponentGenerationException("Invalid use of amine as a substituent!");
                }
            }
            if (this.state.currentWordRule == WordRule.polymer && outAtomCount >= 3) {
                int valency = 0;
                for (int i = 2; i < outAtomCount; ++i) {
                    OutAtom nextOutAtom = thisFrag.getOutAtom(i);
                    valency += nextOutAtom.getValency();
                    thisFrag.removeOutAtom(nextOutAtom);
                }
                thisFrag.getOutAtom(1).setValency(thisFrag.getOutAtom(1).getValency() + valency);
            }
        }
        if (outAtomCount == 2 && "epoxyLike".equals(group.getAttributeValue("subType")) && (possibleLocant = (Element)XOMTools.getPreviousSibling(group)) != null && (locantValues = OpsinTools.MATCH_COMMA.split(possibleLocant.getValue())).length == 2) {
            thisFrag.getOutAtom(0).setLocant(locantValues[0]);
            thisFrag.getOutAtom(1).setLocant(locantValues[1]);
            possibleLocant.detach();
            subOrRoot.addAttribute(new Attribute("locant", locantValues[0]));
        }
        if ((totalOutAtoms = outAtomCount + this.calculateOutAtomsToBeAddedFromInlineSuffixes(group, subOrRoot.getChildElements("suffix"))) >= 2) {
            group.addAttribute(new Attribute("isAMultiRadical", Integer.toString(totalOutAtoms)));
        }
    }

    private boolean unsuitableForFormingChainMultiradical(Element group, Element multiplierBeforeGroup) {
        Element previousGroup = (Element)OpsinTools.getPreviousGroup(group);
        if (previousGroup != null) {
            if (previousGroup.getAttribute("isAMultiRadical") != null) {
                if (previousGroup.getAttributeValue("acceptsAdditiveBonds") != null && XOMTools.getPreviousSibling(previousGroup.getParent()) != null) {
                    return false;
                }
                if (((Element)XOMTools.getPrevious(multiplierBeforeGroup)).getLocalName().equals("multiplier")) {
                    return false;
                }
                return previousGroup.getAttributeValue("isAMultiRadical").equals(multiplierBeforeGroup.getAttributeValue("value"));
            }
            if (XOMTools.getPreviousSibling(previousGroup, "multiplier") == null) {
                Fragment previousGroupFrag = this.state.xmlFragmentMap.get(previousGroup);
                int outAtomValency = 0;
                if (previousGroupFrag.getOutAtoms().size() == 1) {
                    outAtomValency = previousGroupFrag.getOutAtom(0).getValency();
                } else {
                    Element suffix = (Element)XOMTools.getNextSibling(previousGroup, "suffix");
                    if (suffix != null && suffix.getAttributeValue("value").equals("ylidene")) {
                        outAtomValency = 2;
                    }
                    if (suffix != null && suffix.getAttributeValue("value").equals("ylidyne")) {
                        outAtomValency = 3;
                    }
                }
                if (outAtomValency == Integer.parseInt(multiplierBeforeGroup.getAttributeValue("value"))) {
                    return true;
                }
            }
        }
        return false;
    }

    private int calculateOutAtomsToBeAddedFromInlineSuffixes(Element group, Elements suffixes) throws ComponentGenerationException {
        int outAtomsThatWillBeAdded = 0;
        Fragment frag = this.state.xmlFragmentMap.get(group);
        String groupType = frag.getType();
        String subgroupType = frag.getSubType();
        String suffixTypeToUse = null;
        suffixTypeToUse = this.suffixRules.isGroupTypeWithSpecificSuffixRules(groupType) ? groupType : "standardGroup";
        List<Fragment> suffixList = this.state.xmlSuffixMap.get(group);
        for (Fragment fragment : suffixList) {
            outAtomsThatWillBeAdded += fragment.getOutAtoms().size();
        }
        for (int i = 0; i < suffixes.size(); ++i) {
            Element element = suffixes.get(i);
            String suffixValue = element.getAttributeValue("value");
            Elements suffixRuleTags = this.suffixRules.getSuffixRuleTags(suffixTypeToUse, suffixValue, subgroupType);
            for (int j = 0; j < suffixRuleTags.size(); ++j) {
                Element suffixRuleTag = suffixRuleTags.get(j);
                String suffixRuleTagName = suffixRuleTag.getLocalName();
                if (!suffixRuleTagName.equals("setOutAtom")) continue;
                ++outAtomsThatWillBeAdded;
            }
        }
        return outAtomsThatWillBeAdded;
    }

    private void addImplicitBracketsToAminoAcids(List<Element> groups, List<Element> brackets) {
        for (int i = groups.size() - 1; i >= 0; --i) {
            Element group = groups.get(i);
            if (!group.getAttributeValue("type").equals("aminoAcid") || OpsinTools.getNextGroup(group) == null) continue;
            Element subOrRoot = (Element)group.getParent();
            Element previous = (Element)XOMTools.getPreviousSibling(subOrRoot);
            ArrayList<Element> previousElements = new ArrayList<Element>();
            while (previous != null && (previous.getLocalName().equals("substituent") || previous.getLocalName().equals("bracket"))) {
                previousElements.add(previous);
                previous = (Element)XOMTools.getPreviousSibling(previous);
            }
            if (previousElements.size() <= 0) continue;
            Collections.reverse(previousElements);
            Element bracket = new Element("bracket");
            bracket.addAttribute(new Attribute("type", "implicit"));
            Element parent = (Element)subOrRoot.getParent();
            int indexToInsertAt = parent.indexOf((Node)previousElements.get(0));
            for (Element element : previousElements) {
                element.detach();
                bracket.appendChild(element);
            }
            subOrRoot.detach();
            bracket.appendChild(subOrRoot);
            parent.insertChild(bracket, indexToInsertAt);
            brackets.add(bracket);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findAndStructureImplictBrackets(List<Element> substituents, List<Element> brackets) throws ComponentGenerationException, StructureBuildingException {
        for (Element substituent : substituents) {
            void var24_31;
            Element desiredGroup;
            Element possibleMultiplier;
            String currentElementName;
            int i;
            Element elementDirectlyBeforeSubstituent;
            Element firstChildElementOfElementAfterSubstituent;
            Element elementBeforeSubstituent;
            String firstElInSubName = ((Element)substituent.getChild(0)).getLocalName();
            if (firstElInSubName.equals("locant") || firstElInSubName.equals("multiplier")) continue;
            Element substituentGroup = substituent.getFirstChildElement("group");
            String theSubstituentSubType = substituentGroup.getAttributeValue("subType");
            String theSubstituentType = substituentGroup.getAttributeValue("type");
            if (substituentGroup.getAttribute("usableAsAJoiner") == null) continue;
            Fragment frag = this.state.xmlFragmentMap.get(substituentGroup);
            Element elementAftersubstituent = (Element)XOMTools.getNextSibling(substituent);
            if (elementAftersubstituent == null || !elementAftersubstituent.getLocalName().equals("substituent") && !elementAftersubstituent.getLocalName().equals("bracket") && !elementAftersubstituent.getLocalName().equals("root") || (elementBeforeSubstituent = (Element)XOMTools.getPreviousSibling(substituent)) == null || !elementBeforeSubstituent.getLocalName().equals("substituent") && !elementBeforeSubstituent.getLocalName().equals("bracket") || elementBeforeSubstituent.getLocalName().equals("bracket") && !"implicit".equals(elementBeforeSubstituent.getAttributeValue("type")) && elementAftersubstituent.getLocalName().equals("bracket") && ((firstChildElementOfElementAfterSubstituent = (Element)elementAftersubstituent.getChild(0)).getLocalName().equals("substituent") || firstChildElementOfElementAfterSubstituent.getLocalName().equals("bracket")) && !((Element)XOMTools.getPrevious(firstChildElementOfElementAfterSubstituent)).getLocalName().equals("hyphen") || (elementDirectlyBeforeSubstituent = (Element)XOMTools.getPrevious(substituent.getChild(0))).getLocalName().equals("hyphen")) continue;
            List<Element> groupElements = XOMTools.getDescendantElementsWithTagName(elementBeforeSubstituent, "group");
            Element lastGroupOfElementBeforeSub = groupElements.get(groupElements.size() - 1);
            if (lastGroupOfElementBeforeSub == null) {
                throw new ComponentGenerationException("No group where group was expected");
            }
            if (theSubstituentType.equals("chain") && theSubstituentSubType.equals("alkaneStem") && lastGroupOfElementBeforeSub.getAttributeValue("type").equals("chain") && lastGroupOfElementBeforeSub.getAttributeValue("subType").equals("alkaneStem")) {
                boolean placeInImplicitBracket = false;
                Element suffixAfterGroup = (Element)XOMTools.getNextSibling(lastGroupOfElementBeforeSub, "suffix");
                if (suffixAfterGroup != null && matchInlineSuffixesThatAreAlsoGroups.matcher(suffixAfterGroup.getValue()).matches()) {
                    placeInImplicitBracket = true;
                }
                if (!placeInImplicitBracket) {
                    Elements childrenOfElementBeforeSubstituent = elementBeforeSubstituent.getChildElements();
                    Boolean foundLocantNotReferringToChain = null;
                    for (i = 0; i < childrenOfElementBeforeSubstituent.size(); ++i) {
                        currentElementName = childrenOfElementBeforeSubstituent.get(i).getLocalName();
                        if (currentElementName.equals("locant")) {
                            String locantText = childrenOfElementBeforeSubstituent.get(i).getValue();
                            if (!frag.hasLocant(locantText)) {
                                foundLocantNotReferringToChain = true;
                                break;
                            }
                            foundLocantNotReferringToChain = false;
                            continue;
                        }
                        if (!currentElementName.equals("stereoChemistry")) break;
                    }
                    if (foundLocantNotReferringToChain != null && !foundLocantNotReferringToChain.booleanValue()) {
                        placeInImplicitBracket = true;
                    }
                }
                if (!placeInImplicitBracket) continue;
            }
            if (lastGroupOfElementBeforeSub.getAttribute("isAMultiRadical") != null && lastGroupOfElementBeforeSub.getAttribute("acceptsAdditiveBonds") == null && lastGroupOfElementBeforeSub.getAttribute("iminoLike") == null || substituentGroup.getAttribute("isAMultiRadical") != null && substituentGroup.getAttribute("acceptsAdditiveBonds") == null && substituentGroup.getAttribute("iminoLike") == null || lastGroupOfElementBeforeSub.getAttribute("iminoLike") != null && substituentGroup.getAttribute("iminoLike") != null || "perhalogeno".equals(lastGroupOfElementBeforeSub.getAttributeValue("subType"))) continue;
            ArrayList<Element> locantRelatedElements = new ArrayList<Element>();
            String[] locantValues = null;
            ArrayList<Element> stereoChemistryElements = new ArrayList<Element>();
            Elements childrenOfElementBeforeSubstituent = elementBeforeSubstituent.getChildElements();
            for (i = 0; i < childrenOfElementBeforeSubstituent.size(); ++i) {
                currentElementName = childrenOfElementBeforeSubstituent.get(i).getLocalName();
                if (currentElementName.equals("stereoChemistry")) {
                    stereoChemistryElements.add(childrenOfElementBeforeSubstituent.get(i));
                    continue;
                }
                if (!currentElementName.equals("locant") || locantValues != null) break;
                locantRelatedElements.add(childrenOfElementBeforeSubstituent.get(i));
                locantValues = OpsinTools.MATCH_COMMA.split(childrenOfElementBeforeSubstituent.get(i).getValue());
            }
            Boolean moveLocants = false;
            if (locantValues != null) {
                Element elAfterLocant = (Element)XOMTools.getNextSibling((Node)locantRelatedElements.get(0));
                for (void var24_29 : locantValues) {
                    if (elAfterLocant.getAttribute("frontLocantsExpected") != null && StringTools.arrayToList(OpsinTools.MATCH_COMMA.split(elAfterLocant.getAttributeValue("frontLocantsExpected"))).contains(var24_29) || frag.getAtomList().size() != 1 && frag.hasLocant((String)var24_29) && !matchElementSymbolOrAminoAcidLocant.matcher((CharSequence)var24_29).find()) continue;
                    if (this.checkLocantPresentOnPotentialRoot(substituent, (String)var24_29)) {
                        moveLocants = true;
                        continue;
                    }
                    if (this.findElementsMissingIndirectLocants(elementBeforeSubstituent, (Element)locantRelatedElements.get(0)).size() != 0 && this.state.xmlFragmentMap.get(lastGroupOfElementBeforeSub).hasLocant((String)var24_29) || frag.getAtomList().size() == 1 && frag.hasLocant((String)var24_29)) continue;
                    moveLocants = true;
                }
            }
            if (moveLocants.booleanValue() && locantValues != null && locantValues.length > 1) {
                Element shouldBeAMultiplierNode = (Element)XOMTools.getNextSibling((Node)locantRelatedElements.get(0));
                if (shouldBeAMultiplierNode != null && shouldBeAMultiplierNode.getLocalName().equals("multiplier")) {
                    Element shouldBeAGroupOrSubOrBracket = XOMTools.getNextSiblingIgnoringCertainElements(shouldBeAMultiplierNode, new String[]{"multiplier"});
                    if (shouldBeAGroupOrSubOrBracket != null) {
                        if (shouldBeAGroupOrSubOrBracket.getLocalName().equals("group") && shouldBeAMultiplierNode.getAttributeValue("type").equals("group") || frag.getAtomList().size() == 1 || matchInlineSuffixesThatAreAlsoGroups.matcher(substituentGroup.getValue()).matches()) {
                            locantRelatedElements.add(shouldBeAMultiplierNode);
                        } else {
                            if (!"orthoMetaPara".equals(((Element)locantRelatedElements.get(0)).getAttributeValue("type"))) continue;
                            XOMTools.setTextChild((Element)locantRelatedElements.get(0), locantValues[1]);
                        }
                    } else {
                        moveLocants = false;
                    }
                } else {
                    moveLocants = false;
                }
            }
            Element bracket = new Element("bracket");
            bracket.addAttribute(new Attribute("type", "implicit"));
            for (Element stereoChemistryElement : stereoChemistryElements) {
                stereoChemistryElement.detach();
                bracket.appendChild(stereoChemistryElement);
            }
            if (moveLocants.booleanValue()) {
                for (Element locantElement : locantRelatedElements) {
                    locantElement.detach();
                    bracket.appendChild(locantElement);
                }
            }
            if (locantRelatedElements.size() == 0 && (possibleMultiplier = childrenOfElementBeforeSubstituent.get(0)).getLocalName().equals("multiplier") && (matchInlineSuffixesThatAreAlsoGroups.matcher(substituentGroup.getValue()).matches() || possibleMultiplier.getAttributeValue("type").equals("group")) && (desiredGroup = XOMTools.getNextSiblingIgnoringCertainElements(possibleMultiplier, new String[]{"multiplier"})) != null && desiredGroup.getLocalName().equals("group")) {
                childrenOfElementBeforeSubstituent.get(0).detach();
                bracket.appendChild(childrenOfElementBeforeSubstituent.get(0));
            }
            Element parent = (Element)substituent.getParent();
            int startIndex = parent.indexOf(elementBeforeSubstituent);
            int endIndex = parent.indexOf(substituent);
            boolean bl = false;
            while (var24_31 <= endIndex - startIndex) {
                Node n = parent.getChild(startIndex);
                n.detach();
                bracket.appendChild(n);
                ++var24_31;
            }
            parent.insertChild(bracket, startIndex);
            brackets.add(bracket);
        }
    }

    private void matchLocantsToIndirectFeatures(Element subOrRoot) throws StructureBuildingException {
        List<Element> locantEls = this.findLocantsThatCouldBeIndirectLocants(subOrRoot);
        if (locantEls.size() > 0) {
            Fragment fragmentAfterLocant;
            Element parentEl;
            Element group = subOrRoot.getFirstChildElement("group");
            Element lastLocant = locantEls.get(locantEls.size() - 1);
            String[] locantValues = OpsinTools.MATCH_COMMA.split(lastLocant.getValue());
            if (locantValues.length == 1 && group.getAttribute("frontLocantsExpected") != null) {
                String[] allowedLocants;
                for (String allowedLocant : allowedLocants = OpsinTools.MATCH_COMMA.split(group.getAttributeValue("frontLocantsExpected"))) {
                    if (!locantValues[0].equals(allowedLocant)) continue;
                    Element expectedSuffix = (Element)XOMTools.getNextSibling(group);
                    if (expectedSuffix == null || !expectedSuffix.getLocalName().equals("suffix") || expectedSuffix.getAttribute("locant") != null) break;
                    expectedSuffix.addAttribute(new Attribute("locant", locantValues[0]));
                    lastLocant.detach();
                    return;
                }
            }
            boolean allowIndirectLocants = true;
            if (this.state.currentWordRule == WordRule.multiEster && !"addedHydrogenLocant".equals(lastLocant.getAttributeValue("type")) && (parentEl = (Element)subOrRoot.getParent()).getLocalName().equals("word") && parentEl.getAttributeValue("type").equals("substituent") && parentEl.getChildCount() == 1 && locantValues.length == 1 && !"orthoMetaPara".equals(lastLocant.getAttributeValue("type"))) {
                allowIndirectLocants = false;
            }
            if ((fragmentAfterLocant = this.state.xmlFragmentMap.get(group)).getAtomList().size() <= 1) {
                allowIndirectLocants = false;
            }
            if (allowIndirectLocants) {
                if (!"addedHydrogenLocant".equals(lastLocant.getAttributeValue("type")) && locantEls.size() == 1 && group.getAttribute("isAMultiRadical") == null && locantValues.length == 1 && this.checkLocantPresentOnPotentialRoot(subOrRoot, locantValues[0]) && XOMTools.getPreviousSibling(lastLocant, "locant") == null) {
                    return;
                }
                boolean assignableToIndirectFeatures = true;
                List<Element> locantAble = this.findElementsMissingIndirectLocants(subOrRoot, lastLocant);
                if (locantAble.size() < locantValues.length) {
                    assignableToIndirectFeatures = false;
                } else {
                    for (String locantValue : locantValues) {
                        if (fragmentAfterLocant.hasLocant(locantValue)) continue;
                        assignableToIndirectFeatures = false;
                    }
                }
                if (!assignableToIndirectFeatures) {
                    if (locantValues.length == 1) {
                        List<Fragment> suffixes = this.state.xmlSuffixMap.get(group);
                        if (matchElementSymbolOrAminoAcidLocant.matcher(locantValues[0]).matches()) {
                            return;
                        }
                        for (Fragment suffix : suffixes) {
                            if (!suffix.hasLocant(locantValues[0])) continue;
                            Atom dummyRAtom = suffix.getFirstAtom();
                            List<Atom> neighbours = dummyRAtom.getAtomNeighbours();
                            Bond b = null;
                            block3: for (Atom atom : neighbours) {
                                List<String> neighbourLocants = atom.getLocants();
                                for (String neighbourLocant : neighbourLocants) {
                                    if (!OpsinTools.MATCH_NUMERIC_LOCANT.matcher(neighbourLocant).matches()) continue;
                                    b = dummyRAtom.getBondToAtomOrThrow(atom);
                                    break block3;
                                }
                            }
                            if (b == null) continue;
                            this.state.fragManager.removeBond(b);
                            this.state.fragManager.createBond(dummyRAtom, suffix.getAtomByLocantOrThrow(locantValues[0]), b.getOrder());
                            lastLocant.detach();
                        }
                    }
                } else {
                    for (int i = 0; i < locantValues.length; ++i) {
                        String locantValue = locantValues[i];
                        locantAble.get(i).addAttribute(new Attribute("locant", locantValue));
                    }
                    lastLocant.detach();
                }
            }
        }
    }

    private List<Element> findLocantsThatCouldBeIndirectLocants(Element subOrRoot) {
        Elements children2 = subOrRoot.getChildElements();
        ArrayList<Element> locantEls = new ArrayList<Element>();
        for (int i = 0; i < children2.size(); ++i) {
            Element el = children2.get(i);
            if (el.getLocalName().equals("locant")) {
                Element afterLocant = (Element)XOMTools.getNextSibling(el);
                if (afterLocant != null && afterLocant.getLocalName().equals("multiplier")) continue;
                locantEls.add(el);
                continue;
            }
            if (el.getLocalName().equals("group")) break;
        }
        return locantEls;
    }

    private List<Element> findElementsMissingIndirectLocants(Element subOrRoot, Element locantEl) {
        ArrayList<Element> locantAble = new ArrayList<Element>();
        Elements childrenOfSubOrBracketOrRoot = subOrRoot.getChildElements();
        for (int j = 0; j < childrenOfSubOrBracketOrRoot.size(); ++j) {
            Element group;
            String type;
            Element el = childrenOfSubOrBracketOrRoot.get(j);
            String name = el.getLocalName();
            if (!name.equals("suffix") && !name.equals("unsaturator") && !name.equals("conjunctiveSuffixGroup") || el.getAttribute("locant") != null || el.getAttribute("locantID") != null || el.getAttribute("multiplied") != null || subOrRoot.indexOf(el) <= subOrRoot.indexOf(locantEl) || name.equals("suffix") && ((type = (group = (Element)XOMTools.getPreviousSibling(el, "group")).getAttributeValue("type")).equals("acidStem") || type.equals("nonCarboxylicAcid") || type.equals("chalcogenAcidStem"))) continue;
            locantAble.add(el);
        }
        return locantAble;
    }

    private void assignImplicitLocantsToDiTerminalSuffixes(Element subOrRoot) throws StructureBuildingException {
        int chainLength;
        Element hopefullyAChain;
        Element terminalSuffix2;
        Element terminalSuffix1 = subOrRoot.getFirstChildElement("suffix");
        if (terminalSuffix1 != null && this.isATerminalSuffix(terminalSuffix1) && XOMTools.getNextSibling(terminalSuffix1) != null && this.isATerminalSuffix(terminalSuffix2 = (Element)XOMTools.getNextSibling(terminalSuffix1)) && (hopefullyAChain = (Element)XOMTools.getPreviousSibling(terminalSuffix1, "group")) != null && hopefullyAChain.getAttributeValue("type").equals("chain") && (chainLength = this.state.xmlFragmentMap.get(hopefullyAChain).getChainLength()) >= 2) {
            terminalSuffix1.addAttribute(new Attribute("locant", "1"));
            terminalSuffix2.addAttribute(new Attribute("locant", Integer.toString(chainLength)));
        }
    }

    private boolean isATerminalSuffix(Element suffix) {
        return suffix.getLocalName().equals("suffix") && suffix.getAttribute("locant") == null && (suffix.getAttributeValue("type").equals("inline") || "terminal".equals(suffix.getAttributeValue("subType")));
    }

    private void processConjunctiveNomenclature(Element subOrRoot) throws ComponentGenerationException, StructureBuildingException {
        List<Element> conjunctiveGroups = XOMTools.getChildElementsWithTagName(subOrRoot, "conjunctiveSuffixGroup");
        if (conjunctiveGroups.size() > 0) {
            Element ringGroup = subOrRoot.getFirstChildElement("group");
            Fragment ringFrag = this.state.xmlFragmentMap.get(ringGroup);
            if (ringFrag.getOutAtoms().size() != 0) {
                throw new ComponentGenerationException("OPSIN Bug: Ring fragment should have no radicals");
            }
            ArrayList<Fragment> conjunctiveFragments = new ArrayList<Fragment>();
            for (Element group : conjunctiveGroups) {
                Fragment frag = this.state.xmlFragmentMap.get(group);
                conjunctiveFragments.add(frag);
            }
            for (int i = 0; i < conjunctiveFragments.size(); ++i) {
                Fragment conjunctiveFragment = (Fragment)conjunctiveFragments.get(i);
                if (conjunctiveGroups.get(i).getAttribute("locant") != null) {
                    this.state.fragManager.createBond(this.lastNonSuffixCarbonWithSufficientValency(conjunctiveFragment), ringFrag.getAtomByLocantOrThrow(conjunctiveGroups.get(i).getAttributeValue("locant")), 1);
                } else {
                    this.state.fragManager.createBond(this.lastNonSuffixCarbonWithSufficientValency(conjunctiveFragment), ringFrag.getAtomOrNextSuitableAtomOrThrow(ringFrag.getFirstAtom(), 1, true), 1);
                }
                this.state.fragManager.incorporateFragment(conjunctiveFragment, ringFrag);
            }
        }
    }

    private Atom lastNonSuffixCarbonWithSufficientValency(Fragment conjunctiveFragment) throws ComponentGenerationException {
        List<Atom> atomList = conjunctiveFragment.getAtomList();
        for (int i = atomList.size() - 1; i >= 0; --i) {
            Atom a = atomList.get(i);
            if (a.getType().equals("suffix") || !a.getElement().equals("C") || !ValencyChecker.checkValencyAvailableForBond(a, 1)) continue;
            return a;
        }
        throw new ComponentGenerationException("OPSIN Bug: Unable to find non suffix carbon with sufficient valency");
    }

    private void resolveSuffixes(Element group, List<Element> suffixes) throws StructureBuildingException, ComponentGenerationException {
        Fragment frag = this.state.xmlFragmentMap.get(group);
        int firstAtomID = frag.getIdOfFirstAtom();
        List<Atom> atomList = frag.getAtomList();
        int defaultAtom = 0;
        String groupType = frag.getType();
        String subgroupType = frag.getSubType();
        String suffixTypeToUse = null;
        suffixTypeToUse = this.suffixRules.isGroupTypeWithSpecificSuffixRules(groupType) ? groupType : "standardGroup";
        List<Fragment> suffixList = this.state.xmlSuffixMap.get(group);
        for (Element suffix : suffixes) {
            String suffixValue = suffix.getAttributeValue("value");
            String locant = suffix.getAttributeValue("locant");
            int idOnParentFragToUse = 0;
            if (locant != null) {
                idOnParentFragToUse = frag.getIDFromLocantOrThrow(locant);
            }
            if (idOnParentFragToUse == 0 && suffix.getAttribute("locantID") != null) {
                idOnParentFragToUse = Integer.parseInt(suffix.getAttributeValue("locantID"));
            }
            if (idOnParentFragToUse == 0 && suffix.getAttribute("defaultLocantID") != null) {
                idOnParentFragToUse = Integer.parseInt(suffix.getAttributeValue("defaultLocantID"));
            }
            if (idOnParentFragToUse == 0 && (suffixTypeToUse.equals("acidStem") || suffixTypeToUse.equals("nonCarboxylicAcid") || suffixTypeToUse.equals("chalcogenAcidStem"))) {
                idOnParentFragToUse = firstAtomID;
            }
            Fragment suffixFrag = null;
            Elements suffixRuleTags = this.suffixRules.getSuffixRuleTags(suffixTypeToUse, suffixValue, subgroupType);
            for (int j = 0; j < suffixRuleTags.size(); ++j) {
                Collection<Bond> bonds;
                Element suffixRuleTag = suffixRuleTags.get(j);
                String suffixRuleTagName = suffixRuleTag.getLocalName();
                if (defaultAtom >= atomList.size()) {
                    defaultAtom = 0;
                }
                if (suffixRuleTagName.equals("addgroup")) {
                    Atom parentfragAtom;
                    if (suffixFrag != null) continue;
                    if (suffixList.size() <= 0) {
                        throw new ComponentGenerationException("OPSIN Bug: Suffixlist should not be empty");
                    }
                    suffixFrag = suffixList.remove(0);
                    if (suffixFrag.getFirstAtom().getBonds().size() <= 0) {
                        throw new ComponentGenerationException("OPSIN Bug: Dummy atom in suffix should have at least one bond to it");
                    }
                    int bondOrderRequired = suffixFrag.getFirstAtom().getIncomingValency();
                    if (idOnParentFragToUse == 0) {
                        if (suffixRuleTag.getAttribute("ketoneLocant") != null && !atomList.get(defaultAtom).getAtomIsInACycle()) {
                            if (defaultAtom == 0) {
                                defaultAtom = FragmentTools.findKetoneAtomIndice(frag, defaultAtom);
                            }
                            idOnParentFragToUse = atomList.get(defaultAtom).getID();
                            ++defaultAtom;
                        } else {
                            idOnParentFragToUse = atomList.get(defaultAtom).getID();
                        }
                        idOnParentFragToUse = frag.getAtomOrNextSuitableAtomOrThrow(frag.getAtomByIDOrThrow(idOnParentFragToUse), bondOrderRequired, true).getID();
                        parentfragAtom = frag.getAtomByIDOrThrow(idOnParentFragToUse);
                        if (FragmentTools.isCharacteristicAtom(parentfragAtom)) {
                            throw new StructureBuildingException("No suitable atom found to attach suffix");
                        }
                    } else {
                        parentfragAtom = frag.getAtomByIDOrThrow(idOnParentFragToUse);
                    }
                    bonds = new ArrayList<Bond>(suffixFrag.getFirstAtom().getBonds());
                    for (Bond bondToSuffix : bonds) {
                        Atom suffixAtom = bondToSuffix.getToAtom().getElement().equals("R") ? bondToSuffix.getFromAtom() : bondToSuffix.getToAtom();
                        this.state.fragManager.createBond(parentfragAtom, suffixAtom, bondToSuffix.getOrder());
                        this.state.fragManager.removeBond(bondToSuffix);
                        if (parentfragAtom.getIncomingValency() <= 2 || !suffixValue.equals("aldehyde") && !suffixValue.equals("al") && !suffixValue.equals("aldoxime")) continue;
                        if ("X".equals(suffixAtom.getFirstLocant())) {
                            suffixAtom.setProperty(Atom.ISALDEHYDE, true);
                            continue;
                        }
                        parentfragAtom.setProperty(Atom.ISALDEHYDE, true);
                    }
                    continue;
                }
                if (suffixRuleTagName.equals("changecharge")) {
                    int chargeChange = Integer.parseInt(suffixRuleTag.getAttributeValue("charge"));
                    int protonChange = Integer.parseInt(suffixRuleTag.getAttributeValue("protons"));
                    if (suffix.getAttribute("suffixPrefix") == null) {
                        if (idOnParentFragToUse != 0) {
                            frag.getAtomByIDOrThrow(idOnParentFragToUse).addChargeAndProtons(chargeChange, protonChange);
                            continue;
                        }
                        this.applyUnlocantedChargeModification(atomList, chargeChange, protonChange);
                        continue;
                    }
                    if (suffixFrag == null) {
                        throw new StructureBuildingException("OPSIN bug: ordering of elements in suffixRules.xml wrong; changeCharge found before addGroup");
                    }
                    bonds = this.state.fragManager.getInterFragmentBonds(suffixFrag);
                    if (bonds.size() != 1) {
                        throw new StructureBuildingException("OPSIN bug: Wrong number of bonds between suffix and group");
                    }
                    for (Bond bond : bonds) {
                        if (bond.getFromAtom().getFrag() == suffixFrag) {
                            bond.getFromAtom().addChargeAndProtons(chargeChange, protonChange);
                            continue;
                        }
                        bond.getToAtom().addChargeAndProtons(chargeChange, protonChange);
                    }
                    continue;
                }
                if (suffixRuleTagName.equals("setOutAtom")) {
                    int outValency;
                    int n = outValency = suffixRuleTag.getAttribute("outValency") != null ? Integer.parseInt(suffixRuleTag.getAttributeValue("outValency")) : 1;
                    if (suffix.getAttribute("suffixPrefix") == null) {
                        if (idOnParentFragToUse != 0) {
                            frag.addOutAtom(idOnParentFragToUse, outValency, (Boolean)true);
                            continue;
                        }
                        frag.addOutAtom(firstAtomID, outValency, (Boolean)false);
                        continue;
                    }
                    if (suffixFrag == null) {
                        throw new StructureBuildingException("OPSIN bug: ordering of elements in suffixRules.xml wrong; setOutAtom found before addGroup");
                    }
                    Set<Bond> bonds2 = this.state.fragManager.getInterFragmentBonds(suffixFrag);
                    if (bonds2.size() != 1) {
                        throw new StructureBuildingException("OPSIN bug: Wrong number of bonds between suffix and group");
                    }
                    for (Bond bond : bonds2) {
                        if (bond.getFromAtom().getFrag() == suffixFrag) {
                            suffixFrag.addOutAtom(bond.getFromAtom(), outValency, (Boolean)true);
                            continue;
                        }
                        suffixFrag.addOutAtom(bond.getToAtom(), outValency, (Boolean)true);
                    }
                    continue;
                }
                if (suffixRuleTagName.equals("addSuffixPrefixIfNonePresentAndCyclic") || suffixRuleTagName.equals("addFunctionalAtomsToHydroxyGroups") || suffixRuleTagName.equals("chargeHydroxyGroups") || suffixRuleTagName.equals("removeOneDoubleBondedOxygen") || suffixRuleTagName.equals("convertHydroxyGroupsToOutAtoms") || suffixRuleTagName.equals("convertHydroxyGroupsToPositiveCharge")) continue;
                throw new StructureBuildingException("Unknown suffix rule:" + suffixRuleTagName);
            }
            if (suffixFrag == null) continue;
            this.state.fragManager.removeAtomAndAssociatedBonds(suffixFrag.getFirstAtom());
            HashSet<String> suffixLocants = new HashSet<String>(suffixFrag.getLocants());
            for (String suffixLocant : suffixLocants) {
                if (!Character.isDigit(suffixLocant.charAt(0)) || !frag.hasLocant(suffixLocant)) continue;
                suffixFrag.getAtomByLocant(suffixLocant).removeLocant(suffixLocant);
            }
            this.state.fragManager.incorporateFragment(suffixFrag, frag);
        }
    }

    private void applyUnlocantedChargeModification(List<Atom> atomList, int chargeChange, int protonChange) {
        Atom likelyAtom = null;
        Atom possibleHeteroatom = null;
        Atom possibleCarbonAtom = null;
        Atom possibleDiOrHigherIon = null;
        for (Atom a : atomList) {
            Integer[] stableValencies = ValencyChecker.getPossibleValencies(a.getElement(), a.getCharge() + chargeChange);
            if (stableValencies == null) continue;
            String element = a.getElement();
            int resultantExpectedValency = (a.getLambdaConventionValency() == null ? ValencyChecker.getDefaultValency(element) : a.getLambdaConventionValency()) + a.getProtonsExplicitlyAddedOrRemoved() + protonChange;
            boolean matched = false;
            for (Integer stableValency : stableValencies) {
                if (stableValency != resultantExpectedValency) continue;
                matched = true;
                break;
            }
            if (!matched || protonChange < 0 && StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(a) <= 0) continue;
            if (Math.abs(a.getCharge()) == 0) {
                if (element.equals("N")) {
                    likelyAtom = a;
                    break;
                }
                if (possibleHeteroatom == null && !element.equals("C")) {
                    possibleHeteroatom = a;
                    continue;
                }
                if (possibleCarbonAtom != null) continue;
                possibleCarbonAtom = a;
                continue;
            }
            if (possibleDiOrHigherIon != null) continue;
            possibleDiOrHigherIon = a;
        }
        if (likelyAtom == null) {
            likelyAtom = possibleHeteroatom != null ? possibleHeteroatom : (possibleCarbonAtom != null ? possibleCarbonAtom : (possibleDiOrHigherIon != null ? possibleDiOrHigherIon : atomList.get(0)));
        }
        likelyAtom.addChargeAndProtons(chargeChange, protonChange);
    }

    private void moveErroneouslyPositionedLocantsAndMultipliers(List<Element> brackets) {
        for (int i = brackets.size() - 1; i >= 0; --i) {
            Elements substituentContent;
            Element bracket = brackets.get(i);
            Elements childElements = bracket.getChildElements();
            boolean hyphenPresent = false;
            int childCount = childElements.size();
            if (childCount == 2) {
                for (int j = childCount - 1; j >= 0; --j) {
                    if (!childElements.get(j).getLocalName().equals("hyphen")) continue;
                    hyphenPresent = true;
                }
            }
            if (childCount != 1 && (!hyphenPresent || childCount != 2) || (substituentContent = childElements.get(0).getChildElements()).size() < 2) continue;
            Element locant = null;
            Element multiplier = null;
            Element possibleMultiplier = substituentContent.get(0);
            if (substituentContent.get(0).getLocalName().equals("locant")) {
                locant = substituentContent.get(0);
                possibleMultiplier = substituentContent.get(1);
            }
            if (possibleMultiplier.getLocalName().equals("multiplier")) {
                multiplier = possibleMultiplier;
            }
            if (locant != null) {
                if (multiplier != null && OpsinTools.MATCH_COMMA.split(locant.getValue()).length != Integer.parseInt(multiplier.getAttributeValue("value"))) continue;
                locant.detach();
                XOMTools.insertBefore(childElements.get(0), locant);
            }
            if (multiplier == null) continue;
            multiplier.detach();
            XOMTools.insertBefore(childElements.get(0), multiplier);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignLocantsToMultipliedRootIfPresent(Element rightMostElement) throws ComponentGenerationException, StructureBuildingException {
        Elements multipliers = rightMostElement.getChildElements("multiplier");
        if (multipliers.size() == 1) {
            Element multiplier = multipliers.get(0);
            if (XOMTools.getPrevious(multiplier) == null) {
                throw new StructureBuildingException("OPSIN bug: Unacceptable input to function");
            }
            List<Element> locants = XOMTools.getChildElementsWithTagName(rightMostElement, "multiplicativeLocant");
            if (locants.size() > 1) {
                throw new ComponentGenerationException("OPSIN bug: Only none or one multiplicative locant expected");
            }
            int multiVal = Integer.parseInt(multiplier.getAttributeValue("value"));
            if (locants.size() == 0) {
                rightMostElement.addAttribute(new Attribute("inLocants", "default"));
                return;
            } else {
                Element locantEl = locants.get(0);
                String[] locantValues = OpsinTools.MATCH_COMMA.split(locantEl.getValue());
                if (locantValues.length != multiVal) throw new ComponentGenerationException("Mismatch between number of locants and number of roots");
                rightMostElement.addAttribute(new Attribute("inLocants", locantEl.getValue()));
                locantEl.detach();
            }
            return;
        } else {
            if (!rightMostElement.getLocalName().equals("bracket")) return;
            this.assignLocantsToMultipliedRootIfPresent((Element)rightMostElement.getChild(rightMostElement.getChildCount() - 1));
        }
    }

    private void addImplicitBracketsInCaseWhereSubstituentHasTwoLocants(List<Element> substituents, List<Element> brackets) {
        for (Element substituent : substituents) {
            List<Element> locants;
            Element siblingSubstituent = (Element)XOMTools.getNextSibling(substituent);
            if (siblingSubstituent == null || !siblingSubstituent.getLocalName().equals("substituent") || (locants = this.getLocantsAtStartOfSubstituent(substituent)).size() != 2 || !this.locantsAreSingular(locants) || this.getLocantsAtStartOfSubstituent(siblingSubstituent).size() != 0) continue;
            Element bracket = new Element("bracket");
            bracket.addAttribute(new Attribute("type", "implicit"));
            Element parent = (Element)substituent.getParent();
            int indexToInsertAt = parent.indexOf(substituent);
            int elementsToMove = substituent.indexOf(locants.get(0)) + 1;
            for (int i = 0; i < elementsToMove; ++i) {
                Element locantOrStereoToMove = (Element)substituent.getChild(0);
                locantOrStereoToMove.detach();
                bracket.appendChild(locantOrStereoToMove);
            }
            substituent.detach();
            siblingSubstituent.detach();
            bracket.appendChild(substituent);
            bracket.appendChild(siblingSubstituent);
            parent.insertChild(bracket, indexToInsertAt);
            brackets.add(bracket);
        }
    }

    private List<Element> getLocantsAtStartOfSubstituent(Element substituent) {
        ArrayList<Element> locants = new ArrayList<Element>();
        Elements children2 = substituent.getChildElements();
        for (int i = 0; i < children2.size(); ++i) {
            String currentElementName = children2.get(i).getLocalName();
            if (currentElementName.equals("locant")) {
                locants.add(children2.get(i));
                continue;
            }
            if (!currentElementName.equals("stereoChemistry")) break;
        }
        return locants;
    }

    private boolean locantsAreSingular(List<Element> locants) {
        for (Element locant : locants) {
            if (OpsinTools.MATCH_COMMA.split(locant.getValue()).length <= 1) continue;
            return false;
        }
        return true;
    }

    private void assignLocantsAndMultipliers(Element subOrBracket) throws ComponentGenerationException, StructureBuildingException {
        List<Element> locants = XOMTools.getChildElementsWithTagName(subOrBracket, "locant");
        int multiplier = 1;
        List<Element> multipliers = XOMTools.getChildElementsWithTagName(subOrBracket, "multiplier");
        Element parentElem = (Element)subOrBracket.getParent();
        boolean oneBelowWordLevel = parentElem.getLocalName().equals("word");
        Element groupIfPresent = subOrBracket.getFirstChildElement("group");
        if (multipliers.size() > 0) {
            if (multipliers.size() > 1) {
                throw new ComponentGenerationException(subOrBracket.getLocalName() + " has multiple multipliers, unable to determine meaning!");
            }
            if (oneBelowWordLevel && XOMTools.getNextSibling(subOrBracket) == null && XOMTools.getPreviousSibling(subOrBracket) == null) {
                return;
            }
            multiplier = Integer.parseInt(multipliers.get(0).getAttributeValue("value"));
            subOrBracket.addAttribute(new Attribute("multiplier", multipliers.get(0).getAttributeValue("value")));
            if (groupIfPresent != null && "perhalogeno".equals(groupIfPresent.getAttributeValue("subType"))) {
                throw new StructureBuildingException(groupIfPresent.getValue() + " cannot be multiplied");
            }
        }
        if (locants.size() > 0) {
            if (multiplier == 1 && oneBelowWordLevel && XOMTools.getPreviousSibling(subOrBracket) == null && this.wordLevelLocantsAllowed(subOrBracket, locants.size())) {
                Element locant = locants.remove(0);
                if (OpsinTools.MATCH_COMMA.split(locant.getValue()).length != 1) {
                    throw new ComponentGenerationException("Multiplier and locant count failed to agree; All locants could not be assigned!");
                }
                parentElem.addAttribute(new Attribute("locant", locant.getValue()));
                locant.detach();
                if (locants.size() == 0) {
                    return;
                }
            }
            if (subOrBracket.getLocalName().equals("root")) {
                this.locantsToDebugString(locants);
                throw new ComponentGenerationException(this.locantsToDebugString(locants));
            }
            if (locants.size() != 1) {
                throw new ComponentGenerationException(this.locantsToDebugString(locants));
            }
            Element locantEl = locants.get(0);
            String[] locantValues = OpsinTools.MATCH_COMMA.split(locantEl.getValue());
            if (multiplier != locantValues.length) {
                throw new ComponentGenerationException("Multiplier and locant count failed to agree; All locants could not be assigned!");
            }
            Element parent = (Element)subOrBracket.getParent();
            if (!(parent.getLocalName().equals("word") && parent.getAttributeValue("type").equals(WordType.full.toString()) && this.state.currentWordRule.equals((Object)WordRule.carbonylDerivative))) {
                Elements children2 = parent.getChildElements();
                boolean foundSomethingToSubstitute = false;
                for (int i = parent.indexOf(subOrBracket) + 1; i < children2.size(); ++i) {
                    if (children2.get(i).getLocalName().equals("hyphen")) continue;
                    foundSomethingToSubstitute = true;
                }
                if (!foundSomethingToSubstitute) {
                    throw new ComponentGenerationException(this.locantsToDebugString(locants));
                }
            }
            if (groupIfPresent != null && "perhalogeno".equals(groupIfPresent.getAttributeValue("subType"))) {
                throw new StructureBuildingException(groupIfPresent.getValue() + " cannot be locanted");
            }
            subOrBracket.addAttribute(new Attribute("locant", locantEl.getValue()));
            locantEl.detach();
        }
    }

    private String locantsToDebugString(List<Element> locants) {
        StringBuilder message = new StringBuilder("Unable to assign all locants. ");
        message.append(locants.size() > 1 ? "These locants " : "This locant ");
        message.append(locants.size() > 1 ? "were " : "was ");
        message.append("not assigned: ");
        for (Element locant : locants) {
            message.append(locant.getValue());
            message.append(" ");
        }
        return message.toString();
    }

    private boolean wordLevelLocantsAllowed(Element subOrBracket, int numberOflocants) {
        Element wordRule;
        Elements words;
        Element ateWord;
        Element parentElem = (Element)subOrBracket.getParent();
        if (!(WordType.valueOf(parentElem.getAttributeValue("type")) != WordType.substituent || XOMTools.getNextSibling(subOrBracket) != null && numberOflocants < 2 || this.state.currentWordRule != WordRule.ester && this.state.currentWordRule != WordRule.functionalClassEster && this.state.currentWordRule != WordRule.multiEster && this.state.currentWordRule != WordRule.acetal)) {
            return true;
        }
        return (this.state.currentWordRule == WordRule.biochemicalEster || this.state.currentWordRule == WordRule.ester && (XOMTools.getNextSibling(subOrBracket) == null || numberOflocants >= 2)) && parentElem.getLocalName().equals("word") && parentElem == (ateWord = (words = (wordRule = (Element)parentElem.getParent()).getChildElements("word")).get(words.size() - 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processWordLevelMultiplierIfApplicable(Element word, int wordCount) throws StructureBuildingException, ComponentGenerationException {
        int i;
        Element subOrBracket;
        Element multiplier;
        if (word.getChildCount() != 1 || (multiplier = (subOrBracket = (Element)word.getChild(0)).getFirstChildElement("multiplier")) == null) return;
        int multiVal = Integer.parseInt(multiplier.getAttributeValue("value"));
        Elements locants = subOrBracket.getChildElements("locant");
        boolean assignLocants = false;
        boolean wordLevelLocants = this.wordLevelLocantsAllowed(subOrBracket, locants.size());
        if (locants.size() > 1) {
            throw new ComponentGenerationException("Unable to assign all locants");
        }
        String[] locantValues = null;
        if (locants.size() == 1) {
            locantValues = OpsinTools.MATCH_COMMA.split(locants.get(0).getValue());
            if (locantValues.length != multiVal) throw new ComponentGenerationException("Unable to assign all locants");
            assignLocants = true;
            locants.get(0).detach();
            if (!wordLevelLocants) throw new ComponentGenerationException(this.locantsToDebugString(OpsinTools.elementsToElementArrayList(locants)));
            word.addAttribute(new Attribute("locant", locantValues[0]));
        }
        if (multiVal == 1) {
            return;
        }
        if (multiplier.getValue().equals("non")) {
            throw new StructureBuildingException("\"non\" probably means \"not\". If a multiplier of value 9 was intended \"nona\" should be used");
        }
        ArrayList<Element> elementsNotToBeMultiplied = new ArrayList<Element>();
        for (i = subOrBracket.indexOf(multiplier) - 1; i >= 0; --i) {
            Element el = (Element)subOrBracket.getChild(i);
            el.detach();
            elementsNotToBeMultiplied.add(el);
        }
        multiplier.detach();
        if (wordCount == 1) {
            throw new StructureBuildingException("Unexpected multiplier found at start of word. Perhaps the name is trivial e.g. triphosgene");
        }
        for (i = multiVal - 1; i >= 1; --i) {
            Element clone2 = this.state.fragManager.cloneElement(this.state, word);
            if (assignLocants) {
                clone2.getAttribute("locant").setValue(locantValues[i]);
            }
            XOMTools.insertAfter(word, clone2);
        }
        for (Element el : elementsNotToBeMultiplied) {
            subOrBracket.insertChild(el, 0);
        }
    }

    static {
        specialHWRings.put("oxin", new String[]{"blocked"});
        specialHWRings.put("azin", new String[]{"blocked"});
        specialHWRings.put("selenin", new String[]{"not_icacid", "Se", "C", "C", "C", "C", "C"});
        specialHWRings.put("tellurin", new String[]{"not_icacid", "Te", "C", "C", "C", "C", "C"});
        specialHWRings.put("thiol", new String[]{"not_nothingOrOlate", "S", "C", "C", "C", "C"});
        specialHWRings.put("selenol", new String[]{"not_nothingOrOlate", "Se", "C", "C", "C", "C"});
        specialHWRings.put("tellurol", new String[]{"not_nothingOrOlate", "Te", "C", "C", "C", "C"});
        specialHWRings.put("oxazol", new String[]{"", "O", "C", "N", "C", "C"});
        specialHWRings.put("thiazol", new String[]{"", "S", "C", "N", "C", "C"});
        specialHWRings.put("selenazol", new String[]{"", "Se", "C", "N", "C", "C"});
        specialHWRings.put("tellurazol", new String[]{"", "Te", "C", "N", "C", "C"});
        specialHWRings.put("oxazolidin", new String[]{"", "O", "C", "N", "C", "C"});
        specialHWRings.put("thiazolidin", new String[]{"", "S", "C", "N", "C", "C"});
        specialHWRings.put("selenazolidin", new String[]{"", "Se", "C", "N", "C", "C"});
        specialHWRings.put("tellurazolidin", new String[]{"", "Te", "C", "N", "C", "C"});
        specialHWRings.put("oxazolin", new String[]{"", "O", "C", "N", "C", "C"});
        specialHWRings.put("thiazolin", new String[]{"", "S", "C", "N", "C", "C"});
        specialHWRings.put("selenazolin", new String[]{"", "Se", "C", "N", "C", "C"});
        specialHWRings.put("tellurazolin", new String[]{"", "Te", "C", "N", "C", "C"});
        specialHWRings.put("oxoxolan", new String[]{"", "O", "C", "O", "C", "C"});
        specialHWRings.put("oxoxan", new String[]{"", "O", "C", "C", "O", "C", "C"});
        specialHWRings.put("oxoxin", new String[]{"", "O", "C", "C", "O", "C", "C"});
        specialHWRings.put("boroxin", new String[]{"saturated", "O", "B", "O", "B", "O", "B"});
        specialHWRings.put("borazin", new String[]{"saturated", "N", "B", "N", "B", "N", "B"});
        specialHWRings.put("borthiin", new String[]{"saturated", "S", "B", "S", "B", "S", "B"});
    }
}

