/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomProperties;
import uk.ac.cam.ch.wwmm.opsin.Bond;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CipSequenceRules {
    private final Atom chiralAtom;

    CipSequenceRules(Atom chiralAtom) {
        this.chiralAtom = chiralAtom;
    }

    List<Atom> getNeighbouringAtomsInCIPOrder() {
        List<Atom> neighbours = this.chiralAtom.getAtomNeighbours();
        Collections.sort(neighbours, new SortByCIPOrder(this.chiralAtom));
        return neighbours;
    }

    List<Atom> getNeighbouringAtomsInCIPOrderIgnoringGivenNeighbour(Atom neighbourToIgnore) {
        List<Atom> neighbours = this.chiralAtom.getAtomNeighbours();
        if (!neighbours.remove(neighbourToIgnore)) {
            throw new RuntimeException("OPSIN bug: " + neighbourToIgnore.toCMLAtom().toXML() + " was not a neighbour of the given stereogenic atom");
        }
        Collections.sort(neighbours, new SortByCIPOrder(this.chiralAtom));
        return neighbours;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortByCIPOrder
    implements Comparator<Atom> {
        private final Atom chiralAtom;
        private final AtomListCIPComparator atomListCIPComparator = new AtomListCIPComparator();
        private final ListOfAtomListsCIPComparator listOfAtomListsCIPComparator = new ListOfAtomListsCIPComparator();
        private final CIPComparator cipComparator = new CIPComparator();
        private int rule = 0;

        SortByCIPOrder(Atom chiralAtom) {
            this.chiralAtom = chiralAtom;
        }

        @Override
        public int compare(Atom a, Atom b) {
            this.rule = 0;
            while (this.rule <= 2) {
                ArrayList<Atom> atomsVisted = new ArrayList<Atom>();
                atomsVisted.add(this.chiralAtom);
                AtomWithHistory aWithHistory = new AtomWithHistory(a, atomsVisted, null);
                AtomWithHistory bWithHistory = new AtomWithHistory(b, new ArrayList<Atom>(atomsVisted), null);
                int compare = this.compareByCipRules(aWithHistory, bWithHistory);
                if (compare != 0) {
                    return compare;
                }
                ArrayList<AtomWithHistory> nextAtoms1 = new ArrayList<AtomWithHistory>();
                nextAtoms1.add(aWithHistory);
                ArrayList<AtomWithHistory> nextAtoms2 = new ArrayList<AtomWithHistory>();
                nextAtoms2.add(bWithHistory);
                CipState startingState = new CipState(nextAtoms1, nextAtoms2);
                LinkedList<CipState> cipStateQueue = new LinkedList<CipState>();
                cipStateQueue.add(startingState);
                while (!cipStateQueue.isEmpty()) {
                    CipState currentState = (CipState)cipStateQueue.remove();
                    compare = this.compareAtNextLevel(currentState, cipStateQueue);
                    if (compare == 0) continue;
                    return compare;
                }
                ++this.rule;
            }
            throw new RuntimeException("Failed to assign CIP stereochemistry, this indicates a bug in OPSIN or a limitation in OPSIN's implementation of the sequence rules");
        }

        private int compareAtNextLevel(CipState cipState, Queue<CipState> queue) {
            List<List<List<AtomWithHistory>>> newNeighbours2;
            List<List<List<AtomWithHistory>>> newNeighbours1 = this.getNextLevelNeighbours(cipState.nextAtoms1);
            int compare = this.compareNeighboursByCIPpriorityRules(newNeighbours1, newNeighbours2 = this.getNextLevelNeighbours(cipState.nextAtoms2));
            if (compare != 0) {
                return compare;
            }
            List<List<List<AtomWithHistory>>> prioritisedNeighbours1 = this.formListsWithSamePriority(newNeighbours1);
            List<List<List<AtomWithHistory>>> prioritisedNeighbours2 = this.formListsWithSamePriority(newNeighbours2);
            for (int i = 1; i <= prioritisedNeighbours1.size(); ++i) {
                List<List<AtomWithHistory>> nextNeighbourLists1 = prioritisedNeighbours1.get(prioritisedNeighbours1.size() - i);
                List<List<AtomWithHistory>> nextNeighbourLists2 = prioritisedNeighbours2.get(prioritisedNeighbours2.size() - i);
                for (int j = 1; j <= nextNeighbourLists1.size(); ++j) {
                    List<AtomWithHistory> nextNeighbours1 = nextNeighbourLists1.get(nextNeighbourLists1.size() - j);
                    List<AtomWithHistory> nextNeighbours2 = nextNeighbourLists2.get(nextNeighbourLists2.size() - j);
                    CipState newCIPstate = new CipState(nextNeighbours1, nextNeighbours2);
                    queue.add(newCIPstate);
                }
            }
            return 0;
        }

        private int compareNeighboursByCIPpriorityRules(List<List<List<AtomWithHistory>>> neighbours1, List<List<List<AtomWithHistory>>> neighbours2) {
            int neighbours1Size = neighbours1.size();
            int neighbours2Size = neighbours2.size();
            int differenceInSize = neighbours1Size - neighbours2Size;
            int maxCommonSize = neighbours1Size > neighbours2Size ? neighbours2Size : neighbours1Size;
            for (int i = 1; i <= maxCommonSize; ++i) {
                int difference = this.listOfAtomListsCIPComparator.compare(neighbours1.get(neighbours1Size - i), neighbours2.get(neighbours2Size - i));
                if (difference > 0) {
                    return 1;
                }
                if (difference >= 0) continue;
                return -1;
            }
            if (differenceInSize > 0) {
                return 1;
            }
            if (differenceInSize < 0) {
                return -1;
            }
            return 0;
        }

        private List<List<List<AtomWithHistory>>> getNextLevelNeighbours(List<AtomWithHistory> nextAtoms) {
            List<List<List<AtomWithHistory>>> neighbours = this.getNextAtomsWithAppropriateGhostAtoms(nextAtoms);
            for (List<List<AtomWithHistory>> list2 : neighbours) {
                Collections.sort(list2, this.atomListCIPComparator);
            }
            Collections.sort(neighbours, this.listOfAtomListsCIPComparator);
            return neighbours;
        }

        private List<List<List<AtomWithHistory>>> formListsWithSamePriority(List<List<List<AtomWithHistory>>> neighbours) {
            LinkedList<List<List<AtomWithHistory>>> updatedNeighbours = new LinkedList<List<List<AtomWithHistory>>>();
            ArrayList<List> listsToRemove = new ArrayList<List>();
            for (List<List<AtomWithHistory>> neighbourLists : neighbours) {
                int i;
                LinkedList updatedNeighbourLists = new LinkedList();
                for (i = 0; i < neighbourLists.size(); ++i) {
                    ArrayList<List<AtomWithHistory>> neighbourListsToCombine = new ArrayList<List<AtomWithHistory>>();
                    List<AtomWithHistory> primaryAtomList = neighbourLists.get(i);
                    for (int j = i + 1; j < neighbourLists.size(); ++j) {
                        if (this.atomListCIPComparator.compare(neighbourLists.get(i), neighbourLists.get(j)) != 0) continue;
                        neighbourListsToCombine.add(neighbourLists.get(j));
                    }
                    for (List list2 : neighbourListsToCombine) {
                        listsToRemove.add(list2);
                        primaryAtomList.addAll(list2);
                    }
                }
                for (List list2 : listsToRemove) {
                    neighbourLists.remove(list2);
                }
                for (i = neighbourLists.size() - 1; i >= 0; --i) {
                    List<AtomWithHistory> neighbourList = neighbourLists.get(i);
                    Collections.sort(neighbourList, this.cipComparator);
                    AtomWithHistory lastAtom = null;
                    ArrayList<AtomWithHistory> currentAtomList = new ArrayList<AtomWithHistory>();
                    for (int j = neighbourList.size() - 1; j >= 0; --j) {
                        AtomWithHistory a = neighbourList.get(j);
                        if (lastAtom != null && this.compareByCipRules(lastAtom, a) != 0) {
                            if (!currentAtomList.isEmpty()) {
                                updatedNeighbourLists.add(0, currentAtomList);
                            }
                            currentAtomList = new ArrayList();
                            currentAtomList.add(a);
                        } else {
                            currentAtomList.add(a);
                        }
                        lastAtom = a;
                    }
                    if (currentAtomList.isEmpty()) continue;
                    updatedNeighbourLists.add(0, currentAtomList);
                }
                updatedNeighbours.add(updatedNeighbourLists);
            }
            return updatedNeighbours;
        }

        private List<List<List<AtomWithHistory>>> getNextAtomsWithAppropriateGhostAtoms(List<AtomWithHistory> atoms) {
            ArrayList<List<List<AtomWithHistory>>> allNeighbours = new ArrayList<List<List<AtomWithHistory>>>();
            int counter = 0;
            Atom lastPreviousAtom = null;
            for (int i = 0; i < atoms.size(); ++i) {
                AtomWithHistory atomWithHistory = atoms.get(i);
                Atom atom = atomWithHistory.atom;
                List<Atom> visitedAtoms = atomWithHistory.visitedAtoms;
                Atom previousAtom = visitedAtoms.get(visitedAtoms.size() - 1);
                ArrayList<Atom> visitedAtomsIncludingCurrentAtom = new ArrayList<Atom>(visitedAtoms);
                visitedAtomsIncludingCurrentAtom.add(atom);
                ArrayList<AtomWithHistory> neighboursWithHistory = new ArrayList<AtomWithHistory>();
                for (Bond b : atom.getBonds()) {
                    Atom atomBondConnectsTo = b.getOtherAtom(atom);
                    if (!atomBondConnectsTo.equals(this.chiralAtom)) {
                        for (int j = b.getOrder(); j > 1; --j) {
                            Atom ghost = new Atom(atomBondConnectsTo.getElement());
                            if (this.rule > 0) {
                                int indexOfOriginalAtom = visitedAtoms.indexOf(atomBondConnectsTo);
                                if (indexOfOriginalAtom != -1) {
                                    neighboursWithHistory.add(new AtomWithHistory(ghost, visitedAtomsIncludingCurrentAtom, indexOfOriginalAtom));
                                    continue;
                                }
                                neighboursWithHistory.add(new AtomWithHistory(ghost, visitedAtomsIncludingCurrentAtom, visitedAtoms.size() + 1));
                                continue;
                            }
                            neighboursWithHistory.add(new AtomWithHistory(ghost, visitedAtomsIncludingCurrentAtom, null));
                        }
                    }
                    if (atomBondConnectsTo.equals(previousAtom)) continue;
                    if (visitedAtoms.contains(atomBondConnectsTo)) {
                        Atom ghost = new Atom(atomBondConnectsTo.getElement());
                        if (this.rule > 0) {
                            neighboursWithHistory.add(new AtomWithHistory(ghost, visitedAtomsIncludingCurrentAtom, visitedAtoms.indexOf(atomBondConnectsTo)));
                            continue;
                        }
                        neighboursWithHistory.add(new AtomWithHistory(ghost, visitedAtomsIncludingCurrentAtom, null));
                        continue;
                    }
                    neighboursWithHistory.add(new AtomWithHistory(atomBondConnectsTo, visitedAtomsIncludingCurrentAtom, null));
                }
                Collections.sort(neighboursWithHistory, this.cipComparator);
                if (lastPreviousAtom == null) {
                    lastPreviousAtom = previousAtom;
                } else if (lastPreviousAtom != previousAtom) {
                    lastPreviousAtom = previousAtom;
                    ++counter;
                }
                if (allNeighbours.size() <= counter) {
                    allNeighbours.add(new ArrayList());
                }
                ((List)allNeighbours.get(counter)).add(neighboursWithHistory);
            }
            return allNeighbours;
        }

        private int compareByCipRules(AtomWithHistory a, AtomWithHistory b) {
            int atomicNumber2;
            int atomicNumber1 = AtomProperties.elementToAtomicNumber.get(a.atom.getElement());
            if (atomicNumber1 > (atomicNumber2 = AtomProperties.elementToAtomicNumber.get(b.atom.getElement()).intValue())) {
                return 1;
            }
            if (atomicNumber1 < atomicNumber2) {
                return -1;
            }
            if (this.rule > 0) {
                Integer indexFromRoot1 = a.indexOfOriginalFromRoot;
                Integer indexFromRoot2 = b.indexOfOriginalFromRoot;
                if (indexFromRoot1 != null && indexFromRoot2 == null) {
                    return 1;
                }
                if (indexFromRoot1 == null && indexFromRoot2 != null) {
                    return -1;
                }
                if (indexFromRoot1 != null && indexFromRoot2 != null) {
                    if (indexFromRoot1 < indexFromRoot2) {
                        return 1;
                    }
                    if (indexFromRoot1 > indexFromRoot2) {
                        return -1;
                    }
                }
                if (this.rule > 1) {
                    Integer atomicMass1 = a.atom.getIsotope();
                    Integer atomicMass2 = b.atom.getIsotope();
                    if (atomicMass1 != null && atomicMass2 == null) {
                        return 1;
                    }
                    if (atomicMass1 == null && atomicMass2 != null) {
                        return -1;
                    }
                    if (atomicMass1 != null && atomicMass2 != null) {
                        if (atomicMass1 > atomicMass2) {
                            return 1;
                        }
                        if (atomicMass1 < atomicMass2) {
                            return -1;
                        }
                    }
                }
            }
            return 0;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ListOfAtomListsCIPComparator
        implements Comparator<List<List<AtomWithHistory>>> {
            private ListOfAtomListsCIPComparator() {
            }

            @Override
            public int compare(List<List<AtomWithHistory>> a, List<List<AtomWithHistory>> b) {
                int aSize = a.size();
                int bSize = b.size();
                int differenceInSize = aSize - bSize;
                int maxCommonSize = aSize > bSize ? bSize : aSize;
                for (int i = 1; i <= maxCommonSize; ++i) {
                    List<AtomWithHistory> aprime = a.get(aSize - i);
                    List<AtomWithHistory> bprime = b.get(bSize - i);
                    int aprimeSize = aprime.size();
                    int bprimeSize = bprime.size();
                    int differenceInSizeprime = aprimeSize - bprimeSize;
                    int maxCommonSizeprime = aprimeSize > bprimeSize ? bprimeSize : aprimeSize;
                    for (int j = 1; j <= maxCommonSizeprime; ++j) {
                        int difference = SortByCIPOrder.this.compareByCipRules(aprime.get(aprimeSize - j), bprime.get(bprimeSize - j));
                        if (difference > 0) {
                            return 1;
                        }
                        if (difference >= 0) continue;
                        return -1;
                    }
                    if (differenceInSizeprime > 0) {
                        return 1;
                    }
                    if (differenceInSizeprime >= 0) continue;
                    return -1;
                }
                if (differenceInSize > 0) {
                    return 1;
                }
                if (differenceInSize < 0) {
                    return -1;
                }
                return 0;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class AtomListCIPComparator
        implements Comparator<List<AtomWithHistory>> {
            private AtomListCIPComparator() {
            }

            @Override
            public int compare(List<AtomWithHistory> a, List<AtomWithHistory> b) {
                int aSize = a.size();
                int bSize = b.size();
                int differenceInSize = aSize - bSize;
                int maxCommonSize = aSize > bSize ? bSize : aSize;
                for (int i = 1; i <= maxCommonSize; ++i) {
                    int difference = SortByCIPOrder.this.compareByCipRules(a.get(aSize - i), b.get(bSize - i));
                    if (difference > 0) {
                        return 1;
                    }
                    if (difference >= 0) continue;
                    return -1;
                }
                if (differenceInSize > 0) {
                    return 1;
                }
                if (differenceInSize < 0) {
                    return -1;
                }
                return 0;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CIPComparator
        implements Comparator<AtomWithHistory> {
            private CIPComparator() {
            }

            @Override
            public int compare(AtomWithHistory a, AtomWithHistory b) {
                return SortByCIPOrder.this.compareByCipRules(a, b);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtomWithHistory {
        final Atom atom;
        final List<Atom> visitedAtoms;
        final Integer indexOfOriginalFromRoot;

        AtomWithHistory(Atom atom, List<Atom> visitedAtoms, Integer indexOfOriginalFromRoot) {
            this.atom = atom;
            this.visitedAtoms = visitedAtoms;
            this.indexOfOriginalFromRoot = indexOfOriginalFromRoot;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CipState {
        final List<AtomWithHistory> nextAtoms1;
        final List<AtomWithHistory> nextAtoms2;

        CipState(List<AtomWithHistory> nextAtoms1, List<AtomWithHistory> nextAtoms2) {
            this.nextAtoms1 = nextAtoms1;
            this.nextAtoms2 = nextAtoms2;
        }
    }
}

